/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.encoding.impl;

import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class StorageConfigurationManager {
    private static final Log LOG = LogFactory.getLog(StorageConfigurationManager.class, Log.class);
    private Wrapper keyWrapper = ByteArrayWrapper.INSTANCE;
    private Wrapper valueWrapper = ByteArrayWrapper.INSTANCE;
    private MediaType keyStorageMediaType;
    private MediaType valueStorageMediaType;

    public Wrapper getKeyWrapper() {
        return this.keyWrapper;
    }

    public Wrapper getValueWrapper() {
        return this.valueWrapper;
    }

    public Wrapper getWrapper(boolean isKey) {
        return isKey ? this.keyWrapper : this.valueWrapper;
    }

    public void overrideWrapper(Wrapper keyWrapper, Wrapper valueWrapper) {
        this.keyWrapper = keyWrapper;
        this.valueWrapper = valueWrapper;
    }

    public MediaType getKeyStorageMediaType() {
        return this.keyStorageMediaType;
    }

    public MediaType getValueStorageMediaType() {
        return this.valueStorageMediaType;
    }

    public MediaType getStorageMediaType(boolean isKey) {
        return isKey ? this.keyStorageMediaType : this.valueStorageMediaType;
    }

    @Inject
    void injectDependencies(@ComponentName(value="org.infinispan.marshaller.user") Marshaller userMarshaller, @ComponentName(value="cacheName") String cacheName, InternalCacheRegistry icr, GlobalConfiguration gcr, Configuration configuration) {
        boolean internalCache = icr.isInternalCache(cacheName);
        boolean embeddedMode = Configurations.isEmbeddedMode(gcr);
        this.keyStorageMediaType = this.getStorageMediaType(configuration, embeddedMode, internalCache, userMarshaller, true);
        this.valueStorageMediaType = this.getStorageMediaType(configuration, embeddedMode, internalCache, userMarshaller, false);
        if (this.keyStorageMediaType.equals(MediaType.APPLICATION_UNKNOWN) || this.valueStorageMediaType.equals(MediaType.APPLICATION_UNKNOWN)) {
            LOG.unknownEncoding(cacheName);
        }
    }

    private MediaType getStorageMediaType(Configuration configuration, boolean embeddedMode, boolean internalCache, Marshaller userMarshaller, boolean isKey) {
        EncodingConfiguration encodingConfiguration = configuration.encoding();
        ContentTypeConfiguration contentTypeConfiguration = isKey ? encodingConfiguration.keyDataType() : encodingConfiguration.valueDataType();
        MediaType mediaType = userMarshaller.mediaType();
        if (contentTypeConfiguration.isMediaTypeChanged()) {
            return contentTypeConfiguration.mediaType();
        }
        if (!embeddedMode && configuration.indexing().enabled() && contentTypeConfiguration.mediaType() == null) {
            return MediaType.APPLICATION_PROTOSTREAM;
        }
        if (internalCache) {
            return MediaType.APPLICATION_OBJECT;
        }
        if (embeddedMode) {
            boolean canStoreReferences = configuration.memory().storage().canStoreReferences();
            return canStoreReferences ? MediaType.APPLICATION_OBJECT : mediaType;
        }
        return MediaType.APPLICATION_UNKNOWN;
    }

    public boolean isQueryable() {
        return this.valueStorageMediaType.match(MediaType.APPLICATION_PROTOSTREAM) || this.valueStorageMediaType.match(MediaType.APPLICATION_OBJECT);
    }
}

