/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.encoding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ProtostreamTranscoder
extends OneToManyTranscoder {
    public static final String WRAPPED_PARAM = "wrapped";
    protected static final Log logger = LogFactory.getLog(ProtostreamTranscoder.class, Log.class);
    private final SerializationContextRegistry ctxRegistry;
    private final ClassLoader classLoader;

    public ProtostreamTranscoder(SerializationContextRegistry ctxRegistry, ClassLoader classLoader) {
        super(MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON, MediaType.APPLICATION_UNKNOWN);
        this.ctxRegistry = ctxRegistry;
        this.classLoader = classLoader;
    }

    @Override
    public Object doTranscode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.match(MediaType.APPLICATION_PROTOSTREAM)) {
                if (contentType.match(MediaType.APPLICATION_JSON)) {
                    content = this.addTypeIfNeeded(content);
                    return this.fromJsonCascading(content);
                }
                if (contentType.match(MediaType.APPLICATION_UNKNOWN) || contentType.match(MediaType.APPLICATION_PROTOSTREAM)) {
                    return content;
                }
                if (contentType.match(MediaType.TEXT_PLAIN)) {
                    content = StandardConversions.convertTextToObject(content, contentType);
                }
                return this.marshall(content, destinationType);
            }
            if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                Object unmarshalled;
                Object object = unmarshalled = content instanceof byte[] ? this.unmarshall((byte[])content, contentType, destinationType) : content;
                if (unmarshalled instanceof byte[]) {
                    return unmarshalled;
                }
                ImmutableSerializationContext ctx = this.getCtxForMarshalling(unmarshalled);
                return StandardConversions.convertJavaToProtoStream(unmarshalled, MediaType.APPLICATION_OBJECT, ctx);
            }
            if (destinationType.match(MediaType.TEXT_PLAIN)) {
                Object decoded = this.unmarshallCascading((byte[])content);
                if (decoded == null) {
                    return null;
                }
                return decoded.toString().getBytes(destinationType.getCharset());
            }
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                return this.unmarshall((byte[])content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.APPLICATION_JSON)) {
                String converted = this.toJsonCascading((byte[])content);
                String convertType = destinationType.getClassType();
                return convertType == null ? (Object)StandardConversions.convertCharset(converted, contentType.getCharset(), destinationType.getCharset()) : converted;
            }
            if (destinationType.equals(MediaType.APPLICATION_UNKNOWN)) {
                if (content instanceof WrappedByteArray) {
                    return content;
                }
                ImmutableSerializationContext ctx = this.getCtxForMarshalling(content);
                return StandardConversions.convertJavaToProtoStream(content, MediaType.APPLICATION_OBJECT, ctx);
            }
            throw logger.unsupportedContent(ProtostreamTranscoder.class.getSimpleName(), content);
        }
        catch (IOException | InterruptedException e) {
            throw logger.errorTranscoding(ProtostreamTranscoder.class.getSimpleName(), e);
        }
    }

    private boolean isWrapped(MediaType mediaType) {
        Optional<String> wrappedParam = mediaType.getParameter(WRAPPED_PARAM);
        return !wrappedParam.isPresent() || !wrappedParam.get().equals("false");
    }

    private byte[] marshall(Object decoded, MediaType destinationType) throws IOException {
        ImmutableSerializationContext ctx = this.getCtxForMarshalling(decoded);
        if (this.isWrapped(destinationType)) {
            return ProtobufUtil.toWrappedByteArray(ctx, decoded);
        }
        return ProtobufUtil.toByteArray(ctx, decoded);
    }

    private Object unmarshall(byte[] bytes, MediaType contentType, MediaType destinationType) throws IOException {
        if (this.isWrapped(contentType)) {
            return this.unmarshallCascading(bytes);
        }
        String type = destinationType.getClassType();
        if (type == null) {
            throw logger.missingTypeForUnwrappedPayload();
        }
        Class destination = Util.loadClass(type, this.classLoader);
        ImmutableSerializationContext ctx = this.getCtxForMarshalling(destination);
        return ProtobufUtil.fromByteArray(ctx, bytes, destination);
    }

    private Object unmarshallCascading(byte[] bytes) throws IOException {
        try {
            return ProtobufUtil.fromWrappedByteArray(this.ctxRegistry.getUserCtx(), bytes);
        }
        catch (IllegalArgumentException e) {
            logger.debugf("Unable to unmarshall bytes with user context, attempting global context", new Object[0]);
            try {
                return ProtobufUtil.fromWrappedByteArray(this.ctxRegistry.getGlobalCtx(), bytes);
            }
            catch (IllegalArgumentException iae) {
                throw new MarshallingException(iae.getMessage());
            }
        }
    }

    private byte[] fromJsonCascading(Object content) throws IOException {
        try {
            return this.fromJson(content, this.ctxRegistry.getUserCtx());
        }
        catch (IllegalArgumentException e) {
            logger.debugf("Unable to process json with user context, attempting global context", new Object[0]);
            return this.fromJson(content, this.ctxRegistry.getGlobalCtx());
        }
    }

    private byte[] fromJson(Object content, ImmutableSerializationContext ctx) throws IOException {
        Reader reader = content instanceof byte[] ? new InputStreamReader(new ByteArrayInputStream((byte[])content)) : new StringReader(content.toString());
        return ProtobufUtil.fromCanonicalJSON(ctx, reader);
    }

    private String toJsonCascading(byte[] bytes) throws IOException {
        try {
            return ProtobufUtil.toCanonicalJSON(this.ctxRegistry.getUserCtx(), bytes);
        }
        catch (IllegalArgumentException e) {
            logger.debugf("Unable to read bytes with user context, attempting global context", new Object[0]);
            return ProtobufUtil.toCanonicalJSON(this.ctxRegistry.getGlobalCtx(), bytes);
        }
    }

    private ImmutableSerializationContext getCtxForMarshalling(Object o) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = o instanceof Class ? (Class<?>)o : o.getClass();
        if (this.isWrappedMessageClass(clazz) || this.ctxRegistry.getUserCtx().canMarshall(clazz)) {
            return this.ctxRegistry.getUserCtx();
        }
        if (this.ctxRegistry.getGlobalCtx().canMarshall(clazz)) {
            return this.ctxRegistry.getGlobalCtx();
        }
        throw logger.marshallerMissingFromUserAndGlobalContext(o.getClass().getName());
    }

    private boolean isWrappedMessageClass(Class<?> c) {
        return c.equals(String.class) || c.equals(Long.class) || c.equals(Integer.class) || c.equals(Double.class) || c.equals(Float.class) || c.equals(Boolean.class) || c.equals(byte[].class) || c.equals(Byte.class) || c.equals(Short.class) || c.equals(Character.class) || c.equals(Date.class) || c.equals(Instant.class);
    }

    private Object addTypeIfNeeded(Object content) {
        String wrapped = "{ \"_type\":\"%s\", \"_value\":\"%s\"}";
        if (content instanceof Integer || content instanceof Short) {
            return String.format(wrapped, "int32", content);
        }
        if (content instanceof Long) {
            return String.format(wrapped, "int64", content);
        }
        if (content instanceof Double) {
            return String.format(wrapped, "double", content);
        }
        if (content instanceof Float) {
            return String.format(wrapped, "float", content);
        }
        if (content instanceof Boolean) {
            return String.format(wrapped, "bool", content);
        }
        if (content instanceof String && !content.toString().contains("_type")) {
            return String.format(wrapped, "string", content);
        }
        return content;
    }
}

