/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning.irac;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.irac.IracTombstoneCleanupCommand;
import org.infinispan.commands.irac.IracTombstonePrimaryCheckCommand;
import org.infinispan.commands.irac.IracTombstoneRemoteSiteCheckCommand;
import org.infinispan.commands.irac.IracTombstoneStateResponseCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.container.versioning.irac.IracTombstoneInfo;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.util.ExponentialBackOff;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.irac.DefaultIracManager;
import org.infinispan.xsite.irac.IracExecutor;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.status.SiteState;
import org.infinispan.xsite.status.TakeOfflineManager;

@Scope(value=Scopes.NAMED_CACHE)
public class DefaultIracTombstoneManager
implements IracTombstoneManager {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final int ACTION_COUNT = Action.values().length;
    private static final BiFunction<Set<Address>, List<Address>, Set<Address>> ADD_ALL_TO_SET = (set, list) -> {
        set.addAll(list);
        return set;
    };
    private static final BinaryOperator<Set<Address>> MERGE_SETS = (set, set2) -> {
        set.addAll(set2);
        return set;
    };
    private static final BiConsumer<Void, Throwable> TRACE_ROUND_COMPLETED = (__, throwable) -> {
        if (throwable != null) {
            log.trace("[IRAC] Tombstone cleanup round failed!", (Throwable)throwable);
        } else {
            log.trace("[IRAC] Tombstone cleanup round finished!");
        }
    };
    @Inject
    DistributionManager distributionManager;
    @Inject
    RpcManager rpcManager;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    TakeOfflineManager takeOfflineManager;
    @Inject
    ComponentRef<IracManager> iracManager;
    @ComponentName(value="org.infinispan.executors.timeout")
    @Inject
    ScheduledExecutorService scheduledExecutorService;
    @Inject
    BlockingManager blockingManager;
    private final Map<Object, IracTombstoneInfo> tombstoneMap;
    private final IracExecutor iracExecutor = new IracExecutor(this::performCleanup);
    private final Collection<XSiteBackup> asyncBackups;
    private final Scheduler scheduler;
    private volatile boolean stopped = true;
    private final int batchSize;
    private final int segmentCount;

    public DefaultIracTombstoneManager(Configuration configuration) {
        this.asyncBackups = DefaultIracManager.asyncBackups(configuration);
        this.tombstoneMap = new ConcurrentHashMap<Object, IracTombstoneInfo>(configuration.sites().tombstoneMapSize());
        this.scheduler = new Scheduler(configuration.sites().tombstoneMapSize(), configuration.sites().maxTombstoneCleanupDelay());
        this.batchSize = configuration.sites().asyncBackupsStream().map(BackupConfiguration::stateTransfer).map(XSiteStateTransferConfiguration::chunkSize).reduce(1, Integer::max);
        this.segmentCount = configuration.clustering().hash().numSegments();
    }

    @Start
    public void start() {
        Transport transport = this.rpcManager.getTransport();
        transport.checkCrossSiteAvailable();
        String localSiteName = transport.localSiteName();
        this.asyncBackups.removeIf(xSiteBackup -> localSiteName.equals(xSiteBackup.getSiteName()));
        this.iracExecutor.setBackOff(ExponentialBackOff.NO_OP);
        this.iracExecutor.setExecutor(this.blockingManager.asExecutor(this.commandsFactory.getCacheName() + "-tombstone-cleanup"));
        this.stopped = false;
        this.scheduler.disabled = false;
        this.scheduler.scheduleWithCurrentDelay();
    }

    @Stop
    public void stop() {
        this.stopped = true;
        this.stopCleanupTask();
        this.tombstoneMap.clear();
    }

    public void stopCleanupTask() {
        this.scheduler.disable();
    }

    @Override
    public void storeTombstone(int segment, Object key, IracMetadata metadata) {
        IracTombstoneInfo tombstone = new IracTombstoneInfo(key, segment, metadata);
        this.tombstoneMap.put(key, tombstone);
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] Tombstone stored: %s", (Object)tombstone);
        }
    }

    @Override
    public void storeTombstoneIfAbsent(IracTombstoneInfo tombstone) {
        boolean added;
        if (tombstone == null) {
            return;
        }
        boolean bl = added = this.tombstoneMap.putIfAbsent(tombstone.getKey(), tombstone) == null;
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] Tombstone stored? %s. %s", (Object)added, (Object)tombstone);
        }
    }

    @Override
    public IracMetadata getTombstone(Object key) {
        IracTombstoneInfo tombstone = this.tombstoneMap.get(key);
        return tombstone == null ? null : tombstone.getMetadata();
    }

    @Override
    public void removeTombstone(IracTombstoneInfo tombstone) {
        if (tombstone == null) {
            return;
        }
        boolean removed = this.tombstoneMap.remove(tombstone.getKey(), tombstone);
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] Tombstone removed? %s. %s", (Object)removed, (Object)tombstone);
        }
    }

    @Override
    public void removeTombstone(Object key) {
        IracTombstoneInfo tombstone = this.tombstoneMap.remove(key);
        if (tombstone != null && log.isTraceEnabled()) {
            log.tracef("[IRAC] Tombstone removed %s", (Object)tombstone);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.tombstoneMap.isEmpty();
    }

    @Override
    public int size() {
        return this.tombstoneMap.size();
    }

    @Override
    public boolean isTaskRunning() {
        return this.scheduler.running;
    }

    @Override
    public long getCurrentDelayMillis() {
        return this.scheduler.currentDelayMillis;
    }

    @Override
    public void sendStateTo(Address requestor, IntSet segments) {
        StateTransferHelper helper = new StateTransferHelper(requestor, segments);
        Flowable.fromIterable(this.tombstoneMap.values()).filter(helper).buffer(this.batchSize).concatMapCompletableDelayError(helper).subscribe(helper);
    }

    @Override
    public void checkStaleTombstone(Collection<? extends IracTombstoneInfo> tombstones) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.tracef("[IRAC] Checking for stale tombstones from backup owner. %s", (Object)tombstones);
        }
        LocalizedCacheTopology topology = this.distributionManager.getCacheTopology();
        IntSet segments = IntSets.mutableEmptySet(this.segmentCount);
        IracTombstoneCleanupCommand cmd = this.commandsFactory.buildIracTombstoneCleanupCommand(tombstones.size());
        for (IracTombstoneInfo iracTombstoneInfo : tombstones) {
            IracTombstoneInfo data = this.tombstoneMap.get(iracTombstoneInfo.getKey());
            if (!topology.getSegmentDistribution(iracTombstoneInfo.getSegment()).isPrimary() || iracTombstoneInfo.equals(data)) continue;
            segments.add(iracTombstoneInfo.getSegment());
            cmd.add(iracTombstoneInfo);
        }
        if (cmd.isEmpty()) {
            if (trace) {
                log.trace("[IRAC] Nothing to send.");
            }
            return;
        }
        int membersSize = this.distributionManager.getCacheTopology().getMembers().size();
        Collection collection = segments.intStream().mapToObj(segment -> this.getSegmentDistribution(segment).writeOwners()).reduce(new HashSet(membersSize), ADD_ALL_TO_SET, MERGE_SETS);
        if (trace) {
            log.tracef("[IRAC] Cleaning up %d tombstones: %s", cmd.getTombstonesToRemove().size(), (Object)cmd.getTombstonesToRemove());
        }
        this.rpcManager.sendToMany(collection, cmd, DeliverOrder.NONE);
    }

    public void startCleanupTombstone() {
        this.iracExecutor.run();
    }

    public void runCleanupAndWait() {
        this.performCleanup().toCompletableFuture().join();
    }

    public boolean contains(IracTombstoneInfo tombstone) {
        return tombstone.equals(this.tombstoneMap.get(tombstone.getKey()));
    }

    private CompletionStage<Void> performCleanup() {
        if (this.stopped) {
            return CompletableFutures.completedNull();
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("[IRAC] Starting tombstone cleanup round.");
        }
        this.scheduler.onTaskStarted(this.tombstoneMap.size());
        CompletionStage<Object> stage = Flowable.fromIterable(this.tombstoneMap.values()).groupBy(this::classifyTombstone).flatMap(group -> {
            switch ((Action)((Object)((Object)group.getKey()))) {
                case REMOVE_TOMBSTONE: {
                    return this.removeAllTombstones((Flowable<IracTombstoneInfo>)group);
                }
                case NOTIFY_PRIMARY_OWNER: {
                    return this.notifyPrimaryOwner((Flowable<IracTombstoneInfo>)group);
                }
                case CHECK_REMOTE_SITE: {
                    return this.checkRemoteSite((Flowable<IracTombstoneInfo>)group);
                }
            }
            return Flowable.empty();
        }, true, ACTION_COUNT, ACTION_COUNT).lastStage(null);
        if (trace) {
            stage = stage.whenComplete(TRACE_ROUND_COMPLETED);
        }
        return stage.whenComplete(this.scheduler);
    }

    private DistributionInfo getSegmentDistribution(int segment) {
        return this.distributionManager.getCacheTopology().getSegmentDistribution(segment);
    }

    private Flowable<Void> removeAllTombstones(Flowable<IracTombstoneInfo> flowable) {
        return flowable.concatMapDelayError(tombstone -> {
            try {
                this.removeTombstone((IracTombstoneInfo)tombstone);
                return Flowable.empty();
            }
            catch (Throwable t) {
                return Flowable.error(t);
            }
        });
    }

    private Flowable<Void> notifyPrimaryOwner(Flowable<IracTombstoneInfo> flowable) {
        return flowable.groupBy(IracTombstoneInfo::getSegment).concatMapEagerDelayError(segment -> segment.buffer(this.batchSize).concatMapDelayError(tombstones -> new PrimaryOwnerCheckTask((Integer)segment.getKey(), (Collection)tombstones).check()), true, this.segmentCount, this.segmentCount);
    }

    private Flowable<Void> checkRemoteSite(Flowable<IracTombstoneInfo> flowable) {
        return flowable.buffer(this.batchSize).concatMapDelayError(tombstoneMap -> new CleanupTask((Collection)tombstoneMap).check());
    }

    private Action classifyTombstone(IracTombstoneInfo tombstone) {
        DistributionInfo info = this.getSegmentDistribution(tombstone.getSegment());
        if (!info.isWriteOwner() && !info.isReadOwner()) {
            return Action.REMOVE_TOMBSTONE;
        }
        if (!info.isPrimary()) {
            return this.iracManager.running().containsKey(tombstone.getKey()) ? Action.KEEP_TOMBSTONE : Action.NOTIFY_PRIMARY_OWNER;
        }
        return this.iracManager.running().containsKey(tombstone.getKey()) ? Action.KEEP_TOMBSTONE : Action.CHECK_REMOTE_SITE;
    }

    private static enum Action {
        KEEP_TOMBSTONE,
        REMOVE_TOMBSTONE,
        CHECK_REMOTE_SITE,
        NOTIFY_PRIMARY_OWNER;

    }

    private class PrimaryOwnerCheckTask {
        private final int segment;
        private final Collection<IracTombstoneInfo> tombstones;

        private PrimaryOwnerCheckTask(int segment, Collection<IracTombstoneInfo> tombstones) {
            this.segment = segment;
            this.tombstones = tombstones;
            assert (this.consistencyCheck());
        }

        Flowable<Void> check() {
            if (this.tombstones.isEmpty()) {
                return Flowable.empty();
            }
            IracTombstonePrimaryCheckCommand cmd = DefaultIracTombstoneManager.this.commandsFactory.buildIracTombstonePrimaryCheckCommand(this.tombstones);
            RpcOptions rpcOptions = DefaultIracTombstoneManager.this.rpcManager.getSyncRpcOptions();
            CompletionStage<Void> rsp = DefaultIracTombstoneManager.this.rpcManager.invokeCommand(DefaultIracTombstoneManager.this.getSegmentDistribution(this.segment).primary(), (ReplicableCommand)cmd, VoidResponseCollector.ignoreLeavers(), rpcOptions);
            return RxJavaInterop.voidCompletionStageToFlowable(rsp);
        }

        private boolean consistencyCheck() {
            return this.tombstones.stream().allMatch(tombstoneInfo -> tombstoneInfo.getSegment() == this.segment);
        }
    }

    private final class Scheduler
    implements BiConsumer<Void, Throwable> {
        final int targetSize;
        final long maxDelayMillis;
        int preCleanupSize;
        int previousPostCleanupSize;
        long currentDelayMillis;
        volatile boolean running;
        volatile boolean disabled;
        @GuardedBy(value="this")
        ScheduledFuture<?> future;

        private Scheduler(int targetSize, long maxDelayMillis) {
            this.targetSize = targetSize;
            this.maxDelayMillis = maxDelayMillis;
            this.currentDelayMillis = maxDelayMillis / 2L;
        }

        void onTaskStarted(int size) {
            this.running = true;
            this.preCleanupSize = size;
        }

        void onTaskCompleted(int postCleanupSize) {
            if (postCleanupSize >= this.targetSize) {
                this.currentDelayMillis = 1L;
            } else {
                double tombstoneCreationRate = (double)(this.preCleanupSize - this.previousPostCleanupSize) * 1.0 / (double)this.currentDelayMillis;
                double estimationMillis = tombstoneCreationRate <= 0.0 ? (double)this.maxDelayMillis : Math.min((double)(this.targetSize - postCleanupSize) / tombstoneCreationRate + 1.0, (double)this.maxDelayMillis);
                this.currentDelayMillis = Math.round(Math.sqrt((double)this.currentDelayMillis * estimationMillis));
            }
            this.previousPostCleanupSize = postCleanupSize;
            this.scheduleWithCurrentDelay();
        }

        synchronized void scheduleWithCurrentDelay() {
            this.running = false;
            if (DefaultIracTombstoneManager.this.stopped || this.disabled) {
                return;
            }
            if (this.future != null) {
                this.future.cancel(true);
            }
            this.future = DefaultIracTombstoneManager.this.scheduledExecutorService.schedule(DefaultIracTombstoneManager.this.iracExecutor, this.currentDelayMillis, TimeUnit.MILLISECONDS);
        }

        synchronized void disable() {
            this.disabled = true;
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }

        @Override
        public void accept(Void unused, Throwable throwable) {
            this.onTaskCompleted(DefaultIracTombstoneManager.this.tombstoneMap.size());
        }
    }

    private class StateTransferHelper
    implements Predicate<IracTombstoneInfo>,
    Function<Collection<IracTombstoneInfo>, CompletableSource>,
    CompletableObserver {
        private final Address requestor;
        private final IntSet segments;

        private StateTransferHelper(Address requestor, IntSet segments) {
            this.requestor = requestor;
            this.segments = segments;
        }

        @Override
        public boolean test(IracTombstoneInfo tombstone) {
            return this.segments.contains(tombstone.getSegment());
        }

        @Override
        public CompletableSource apply(Collection<IracTombstoneInfo> state) {
            RpcOptions rpcOptions = DefaultIracTombstoneManager.this.rpcManager.getSyncRpcOptions();
            IracTombstoneStateResponseCommand cmd = DefaultIracTombstoneManager.this.commandsFactory.buildIracTombstoneStateResponseCommand(state);
            CompletionStage<Void> rsp = DefaultIracTombstoneManager.this.rpcManager.invokeCommand(this.requestor, (ReplicableCommand)cmd, VoidResponseCollector.ignoreLeavers(), rpcOptions);
            return Completable.fromCompletionStage(rsp);
        }

        @Override
        public void onSubscribe(@NonNull Disposable d) {
        }

        @Override
        public void onComplete() {
            if (log.isDebugEnabled()) {
                log.debugf("Tombstones transferred to %s for segments %s", (Object)this.requestor, (Object)this.segments);
            }
        }

        @Override
        public void onError(@NonNull Throwable e) {
            log.failedToTransferTombstones(this.requestor, this.segments, e);
        }
    }

    private final class CleanupTask
    implements java.util.function.Function<Void, CompletionStage<Void>>,
    Runnable {
        private final Collection<IracTombstoneInfo> tombstoneToCheck;
        private final IntSet tombstoneToKeep;
        private final int id;
        private volatile boolean failedToCheck;

        private CleanupTask(Collection<IracTombstoneInfo> tombstoneToCheck) {
            this.tombstoneToCheck = tombstoneToCheck;
            this.tombstoneToKeep = IntSets.concurrentSet(tombstoneToCheck.size());
            this.failedToCheck = false;
            this.id = tombstoneToCheck.hashCode();
        }

        Flowable<Void> check() {
            if (log.isTraceEnabled()) {
                log.tracef("[cleanup-task-%d] Running cleanup task with %s tombstones to check", this.id, this.tombstoneToCheck.size());
            }
            if (this.tombstoneToCheck.isEmpty()) {
                return Flowable.empty();
            }
            List<Object> keys2 = this.tombstoneToCheck.stream().map(IracTombstoneInfo::getKey).collect(Collectors.toList());
            IracTombstoneRemoteSiteCheckCommand cmd = DefaultIracTombstoneManager.this.commandsFactory.buildIracTombstoneRemoteSiteCheckCommand(keys2);
            AggregateCompletionStage<Void> stage = CompletionStages.aggregateCompletionStage();
            for (XSiteBackup backup : DefaultIracTombstoneManager.this.asyncBackups) {
                if (DefaultIracTombstoneManager.this.takeOfflineManager.getSiteState(backup.getSiteName()) == SiteState.OFFLINE) continue;
                stage.dependsOn(DefaultIracTombstoneManager.this.rpcManager.invokeXSite(backup, cmd).thenAccept(this::mergeIntSet));
            }
            return RxJavaInterop.voidCompletionStageToFlowable(DefaultIracTombstoneManager.this.blockingManager.thenComposeBlocking(stage.freeze().exceptionally(this::onException), this, "tombstone-response"));
        }

        private void mergeIntSet(IntSet rsp) {
            if (log.isTraceEnabled()) {
                log.tracef("[cleanup-task-%d] Received response: %s", this.id, (Object)rsp);
            }
            this.tombstoneToKeep.addAll(rsp);
        }

        private Void onException(Throwable ignored) {
            if (log.isTraceEnabled()) {
                log.tracef(ignored, "[cleanup-task-%d] Received exception", this.id);
            }
            this.failedToCheck = true;
            return null;
        }

        @Override
        public CompletionStage<Void> apply(Void aVoid) {
            IracTombstoneCleanupCommand cmd = DefaultIracTombstoneManager.this.commandsFactory.buildIracTombstoneCleanupCommand(this.tombstoneToCheck.size());
            this.forEachTombstoneToRemove(cmd::add);
            if (log.isTraceEnabled()) {
                log.tracef("[cleanup-task-%d] Removing %d tombstones.", this.id, cmd.getTombstonesToRemove().size());
            }
            if (cmd.isEmpty()) {
                return CompletableFutures.completedNull();
            }
            int membersSize = DefaultIracTombstoneManager.this.distributionManager.getCacheTopology().getMembers().size();
            Collection owners = this.tombstoneToCheck.stream().mapToInt(IracTombstoneInfo::getSegment).distinct().mapToObj(segment -> DefaultIracTombstoneManager.this.getSegmentDistribution(segment).writeOwners()).reduce(new HashSet(membersSize), ADD_ALL_TO_SET, MERGE_SETS);
            return DefaultIracTombstoneManager.this.rpcManager.invokeCommand(owners, (ReplicableCommand)cmd, VoidResponseCollector.validOnly(), DefaultIracTombstoneManager.this.rpcManager.getSyncRpcOptions()).thenRun(this);
        }

        @Override
        public void run() {
            this.forEachTombstoneToRemove(DefaultIracTombstoneManager.this::removeTombstone);
        }

        void forEachTombstoneToRemove(Consumer<IracTombstoneInfo> consumer) {
            if (this.failedToCheck) {
                return;
            }
            int index = 0;
            for (IracTombstoneInfo tombstone : this.tombstoneToCheck) {
                if (this.tombstoneToKeep.contains(index++)) continue;
                consumer.accept(tombstone);
            }
        }
    }
}

