/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;

public class HashConfiguration
extends ConfigurationElement<HashConfiguration> {
    public static final AttributeDefinition<ConsistentHashFactory> CONSISTENT_HASH_FACTORY = AttributeDefinition.builder(Attribute.CONSISTENT_HASH_FACTORY, null, ConsistentHashFactory.class).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
    public static final AttributeDefinition<Integer> NUM_OWNERS = AttributeDefinition.builder(Attribute.OWNERS, Integer.valueOf(2)).immutable().build();
    public static final AttributeDefinition<Integer> NUM_SEGMENTS = AttributeDefinition.builder(Attribute.SEGMENTS, Integer.valueOf(256)).immutable().build();
    public static final AttributeDefinition<Float> CAPACITY_FACTOR = AttributeDefinition.builder(Attribute.CAPACITY_FACTOR, Float.valueOf(1.0f)).immutable().global(false).build();
    public static final AttributeDefinition<KeyPartitioner> KEY_PARTITIONER = AttributeDefinition.builder(Attribute.KEY_PARTITIONER, new HashFunctionPartitioner(NUM_SEGMENTS.getDefaultValue()), KeyPartitioner.class).copier(original -> {
        KeyPartitioner copy = (KeyPartitioner)Util.getInstance(original.getClass());
        copy.init((KeyPartitioner)original);
        return copy;
    }).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<ConsistentHashFactory> consistentHashFactory;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> numOwners;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> numSegments;
    private final org.infinispan.commons.configuration.attributes.Attribute<Float> capacityFactor;
    private final org.infinispan.commons.configuration.attributes.Attribute<KeyPartitioner> keyPartitioner;
    private final GroupsConfiguration groupsConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(HashConfiguration.class, CONSISTENT_HASH_FACTORY, NUM_OWNERS, NUM_SEGMENTS, CAPACITY_FACTOR, KEY_PARTITIONER);
    }

    HashConfiguration(AttributeSet attributes, GroupsConfiguration groupsConfiguration) {
        super(Element.HASH, attributes, new ConfigurationElement[0]);
        this.groupsConfiguration = groupsConfiguration;
        this.consistentHashFactory = attributes.attribute(CONSISTENT_HASH_FACTORY);
        this.numOwners = attributes.attribute(NUM_OWNERS);
        this.numSegments = attributes.attribute(NUM_SEGMENTS);
        this.capacityFactor = attributes.attribute(CAPACITY_FACTOR);
        this.keyPartitioner = attributes.attribute(KEY_PARTITIONER);
    }

    @Deprecated
    public ConsistentHashFactory<?> consistentHashFactory() {
        return this.consistentHashFactory.get();
    }

    public int numOwners() {
        return this.numOwners.get();
    }

    public int numSegments() {
        return this.numSegments.get();
    }

    public float capacityFactor() {
        return this.capacityFactor.get().floatValue();
    }

    public KeyPartitioner keyPartitioner() {
        return this.keyPartitioner.get();
    }

    public GroupsConfiguration groups() {
        return this.groupsConfiguration;
    }
}

