/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.EncodingConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;

public class ContentTypeConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ContentTypeConfiguration> {
    private final AttributeSet attributes;
    private final Enum<?> element;
    private MediaType parsed;

    protected ContentTypeConfigurationBuilder(Enum<?> element, EncodingConfigurationBuilder builder) {
        super(builder.getBuilder());
        this.element = element;
        this.attributes = ContentTypeConfiguration.attributeDefinitionSet();
    }

    public boolean isObjectStorage() {
        String mediaType = this.mediaType();
        return mediaType != null && MediaType.fromString(mediaType).match(MediaType.APPLICATION_OBJECT);
    }

    public boolean isProtobufStorage() {
        String mediaType = this.mediaType();
        return mediaType != null && MediaType.fromString(mediaType).match(MediaType.APPLICATION_PROTOSTREAM);
    }

    public ContentTypeConfigurationBuilder mediaType(String mediaType) {
        this.attributes.attribute(ContentTypeConfiguration.MEDIA_TYPE).set(mediaType);
        return this;
    }

    public String mediaType() {
        return this.attributes.attribute(ContentTypeConfiguration.MEDIA_TYPE).get();
    }

    @Override
    public ContentTypeConfiguration create() {
        try {
            String mediaType = this.attributes.attribute(ContentTypeConfiguration.MEDIA_TYPE).get();
            if (mediaType != null) {
                this.parsed = MediaType.fromString(mediaType);
            }
        }
        catch (EncodingException e) {
            throw new CacheConfigurationException(e);
        }
        return new ContentTypeConfiguration(this.element, this.attributes.protect(), this.parsed);
    }

    public ContentTypeConfigurationBuilder read(ContentTypeConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }
}

