/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Set;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.SecurityConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class AuthorizationConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<AuthorizationConfiguration> {
    private final AttributeSet attributes = AuthorizationConfiguration.attributeDefinitionSet();

    public AuthorizationConfigurationBuilder(SecurityConfigurationBuilder securityBuilder) {
        super(securityBuilder);
    }

    public AuthorizationConfigurationBuilder disable() {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set(false);
        return this;
    }

    public AuthorizationConfigurationBuilder enable() {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set(true);
        return this;
    }

    public AuthorizationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set(enabled);
        return this;
    }

    public AuthorizationConfigurationBuilder role(String name) {
        Set roles = this.attributes.attribute(AuthorizationConfiguration.ROLES).get();
        roles.add(name);
        this.attributes.attribute(AuthorizationConfiguration.ROLES).set(roles);
        return this;
    }

    public AuthorizationConfigurationBuilder roles(String ... names) {
        for (String name : names) {
            this.role(name);
        }
        return this;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.attributes.attribute(AuthorizationConfiguration.ENABLED).get().booleanValue() && !globalConfig.security().authorization().enabled()) {
            throw Log.CONFIG.globalSecurityAuthShouldBeEnabled();
        }
        Set cacheRoles = this.attributes.attribute(AuthorizationConfiguration.ROLES).get();
        Set<String> globalRoles = globalConfig.security().authorization().roles().keySet();
        if (!globalRoles.containsAll(cacheRoles)) {
            cacheRoles.removeAll(globalRoles);
            throw Log.CONFIG.noSuchGlobalRoles(cacheRoles);
        }
    }

    @Override
    public AuthorizationConfiguration create() {
        return new AuthorizationConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(AuthorizationConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "AuthorizationConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

