/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;

public class VersionedPrepareCommand
extends PrepareCommand {
    public static final byte COMMAND_ID = 26;
    private Map<Object, IncrementableEntryVersion> versionsSeen = null;

    public VersionedPrepareCommand() {
        super(null);
    }

    public VersionedPrepareCommand(ByteString cacheName, GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhase) {
        super(cacheName, gtx, modifications, onePhase);
    }

    public VersionedPrepareCommand(ByteString cacheName) {
        super(cacheName);
    }

    public Map<Object, IncrementableEntryVersion> getVersionsSeen() {
        return this.versionsSeen;
    }

    public void setVersionsSeen(Map<Object, IncrementableEntryVersion> versionsSeen) {
        this.versionsSeen = versionsSeen;
    }

    @Override
    public byte getCommandId() {
        return 26;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        MarshallUtil.marshallMap(this.versionsSeen, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.versionsSeen = MarshallUtil.unmarshallMap(input, HashMap::new);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "VersionedPrepareCommand {modifications=" + (this.modifications == null ? null : Arrays.asList(this.modifications)) + ", onePhaseCommit=" + this.onePhaseCommit + ", retried=" + this.retriedCommand + ", versionsSeen=" + this.versionsSeen + ", gtx=" + this.globalTx + ", cacheName='" + this.cacheName + '\'' + '}';
    }
}

