/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.test.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.context.SimpleWorkerContext;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.formats.RdfParser;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.utilities.CSFile;
import org.hl7.fhir.utilities.CSFileInputStream;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ToolsHelper {
    public static void main(String[] args2) {
        block13: {
            try {
                ToolsHelper self = new ToolsHelper();
                if (args2.length == 0) {
                    throw new FHIRException("Missing Command Parameter. Valid Commands: round, json, version, fragments, snapshot-maker");
                }
                if (args2[0].equals("round")) {
                    self.executeRoundTrip(args2);
                    break block13;
                }
                if (args2[0].equals("test")) {
                    self.executeTest(args2);
                    break block13;
                }
                if (args2[0].equals("examples")) {
                    self.executeExamples(args2);
                    break block13;
                }
                if (args2[0].equals("json")) {
                    self.executeJson(args2);
                    break block13;
                }
                if (args2[0].equals("cxml")) {
                    self.executeCanonicalXml(args2);
                    break block13;
                }
                if (args2[0].equals("version")) {
                    self.executeVersion(args2);
                    break block13;
                }
                if (args2[0].equals("fragments")) {
                    self.executeFragments(args2);
                    break block13;
                }
                if (args2[0].equals("snapshot-maker")) {
                    self.generateSnapshots(args2);
                    break block13;
                }
                throw new FHIRException("Unknown command '" + args2[0] + "'. Valid Commands: round, test, examples, json, cxml, version, fragments, snapshot-maker");
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    TextFile.stringToFile(e.toString(), (args2.length == 0 ? "tools" : args2[0]) + ".err");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void executeExamples(String[] args2) throws IOException {
        try {
            List<String> lines = FileUtils.readLines(new File(args2[1]), "UTF-8");
            String srcDir = lines.get(0);
            lines.remove(0);
            this.processExamples(srcDir, lines);
            TextFile.stringToFile("ok", Utilities.changeFileExt(args2[1], ".out"));
        }
        catch (Exception e) {
            TextFile.stringToFile(e.getMessage(), Utilities.changeFileExt(args2[1], ".out"));
        }
    }

    private void generateSnapshots(String[] args2) throws IOException, FHIRException {
        if (args2.length == 1) {
            System.out.println("tools.jar snapshot-maker [source] -defn [definitions]");
            System.out.println("");
            System.out.println("Generates a snapshot from a differential. The nominated profile must have a single struture that has a differential");
            System.out.println("");
            System.out.println("source - the profile to generate the snapshot for. Maybe a file name, or a URL reference to a server running FHIR RESTful API");
            System.out.println("definitions - filename for local copy of the validation.zip file");
        }
        String address = args2[1];
        String definitions = args2[3];
        SimpleWorkerContext context = SimpleWorkerContext.fromDefinitions(this.getDefinitions(definitions));
        throw new NotImplementedException("generating snapshots not done yet (address = " + address + ")");
    }

    private Map<String, byte[]> getDefinitions(String definitions) throws IOException, FHIRException {
        HashMap<String, byte[]> results = new HashMap<String, byte[]>();
        this.readDefinitions(results, this.loadDefinitions(definitions));
        return results;
    }

    private void readDefinitions(Map<String, byte[]> map, byte[] defn) throws IOException {
        ZipEntry ze;
        ZipInputStream zip2 = new ZipInputStream(new ByteArrayInputStream(defn));
        while ((ze = zip2.getNextEntry()) != null) {
            if (!ze.getName().endsWith(".zip") && !ze.getName().endsWith(".jar")) {
                int n;
                String name = ze.getName();
                ZipInputStream in = zip2;
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((n = ((InputStream)in).read(buf, 0, 1024)) > -1) {
                    b.write(buf, 0, n);
                }
                map.put(name, b.toByteArray());
            }
            zip2.closeEntry();
        }
        zip2.close();
    }

    private byte[] loadDefinitions(String definitions) throws FHIRException, IOException {
        byte[] defn;
        if (definitions.startsWith("https:") || definitions.startsWith("http:")) {
            defn = this.loadFromUrl(definitions);
        } else if (new File(definitions).exists()) {
            defn = this.loadFromFile(definitions);
        } else {
            throw new FHIRException("Unable to find FHIR validation Pack (source = " + definitions + ")");
        }
        return defn;
    }

    private byte[] loadFromUrl(String src) throws IOException {
        URL url = new URL(src);
        byte[] str = IOUtils.toByteArray(url.openStream());
        return str;
    }

    private byte[] loadFromFile(String src) throws IOException {
        FileInputStream in = new FileInputStream(src);
        byte[] b = new byte[in.available()];
        in.read(b);
        in.close();
        return b;
    }

    protected XmlPullParser loadXml(InputStream stream) throws XmlPullParserException, IOException {
        BufferedInputStream input = new BufferedInputStream(stream);
        XmlPullParserFactory factory2 = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory2.setNamespaceAware(true);
        XmlPullParser xpp = factory2.newPullParser();
        xpp.setInput(input, "UTF-8");
        xpp.next();
        return xpp;
    }

    protected int nextNoWhitespace(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        while (eventType == 4 && xpp.isWhitespace()) {
            eventType = xpp.next();
        }
        return eventType;
    }

    public void executeFragments(String[] args2) throws IOException {
        try {
            CSFile source2 = new CSFile(args2[1]);
            if (!source2.exists()) {
                throw new FHIRException("Source File \"" + source2.getAbsolutePath() + "\" not found");
            }
            XmlPullParser xpp = this.loadXml(new FileInputStream(source2));
            this.nextNoWhitespace(xpp);
            if (!xpp.getName().equals("tests")) {
                throw new FHIRFormatError("Unable to parse file - starts with " + xpp.getName());
            }
            xpp.next();
            this.nextNoWhitespace(xpp);
            StringBuilder s2 = new StringBuilder();
            s2.append("<results>\r\n");
            int fail = 0;
            while (xpp.getEventType() == 2 && xpp.getName().equals("test")) {
                String id = xpp.getAttributeValue(null, "id");
                String type = xpp.getAttributeValue(null, "type");
                xpp.next();
                this.nextNoWhitespace(xpp);
                xpp.next();
                this.nextNoWhitespace(xpp);
                XmlParser p = new XmlParser();
                try {
                    p.parseFragment(xpp, type);
                    s2.append("<result id=\"" + id + "\" outcome=\"ok\"/>\r\n");
                    this.nextNoWhitespace(xpp);
                }
                catch (Exception e) {
                    s2.append("<result id=\"" + id + "\" outcome=\"error\" msg=\"" + Utilities.escapeXml(e.getMessage()) + "\"/>\r\n");
                    ++fail;
                }
                while (xpp.getEventType() != 3 || !xpp.getName().equals("pre")) {
                    xpp.next();
                }
                xpp.next();
                this.nextNoWhitespace(xpp);
                xpp.next();
                this.nextNoWhitespace(xpp);
            }
            s2.append("</results>\r\n");
            TextFile.stringToFile(s2.toString(), args2[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
            TextFile.stringToFile(e.getMessage(), args2[2]);
        }
    }

    public void executeRoundTrip(String[] args2) throws IOException, FHIRException {
        JsonParser parser;
        CSFile source2 = new CSFile(args2[1]);
        CSFile dest = new CSFile(args2[2]);
        if (args2.length >= 4) {
            Utilities.copyFile(args2[1], args2[3]);
        }
        if (!source2.exists()) {
            throw new FHIRException("Source File \"" + source2.getAbsolutePath() + "\" not found");
        }
        CSFileInputStream in = new CSFileInputStream(source2);
        XmlParser p = new XmlParser();
        JsonParser pj = parser = new JsonParser();
        Resource rf = p.parse(in);
        ByteArrayOutputStream json = new ByteArrayOutputStream();
        parser.setOutputStyle(IParser.OutputStyle.PRETTY);
        parser.compose(json, rf);
        json.close();
        TextFile.stringToFile(new String(json.toByteArray()), Utilities.changeFileExt(dest.getAbsolutePath(), ".json"));
        rf = pj.parse(new ByteArrayInputStream(json.toByteArray()));
        FileOutputStream s2 = new FileOutputStream(dest);
        new XmlParser().compose((OutputStream)s2, rf, true);
        s2.close();
    }

    public String executeJson(String[] args2) throws IOException, FHIRException {
        CSFile source2 = new CSFile(args2[1]);
        CSFile dest = new CSFile(args2[2]);
        CSFile destc = new CSFile(Utilities.changeFileExt(args2[2], ".canonical.json"));
        CSFile destt = new CSFile(args2[2] + ".tmp");
        CSFile destr = new CSFile(Utilities.changeFileExt(args2[2], ".ttl"));
        if (!source2.exists()) {
            throw new FHIRException("Source File \"" + source2.getAbsolutePath() + "\" not found");
        }
        CSFileInputStream in = new CSFileInputStream(source2);
        XmlParser p = new XmlParser();
        Resource rf = p.parse(in);
        JsonParser json = new JsonParser();
        json.setOutputStyle(IParser.OutputStyle.PRETTY);
        FileOutputStream s2 = new FileOutputStream(dest);
        json.compose(s2, rf);
        s2.close();
        json.setOutputStyle(IParser.OutputStyle.CANONICAL);
        s2 = new FileOutputStream(destc);
        json.compose(s2, rf);
        s2.close();
        json.setSuppressXhtml("Snipped for Brevity");
        json.setOutputStyle(IParser.OutputStyle.PRETTY);
        s2 = new FileOutputStream(destt);
        json.compose(s2, rf);
        s2.close();
        RdfParser rdf = new RdfParser();
        s2 = new FileOutputStream(destr);
        rdf.compose(s2, rf);
        s2.close();
        return TextFile.fileToString(destt.getAbsolutePath());
    }

    public void executeCanonicalXml(String[] args2) throws FHIRException, IOException {
        CSFile source2 = new CSFile(args2[1]);
        CSFile dest = new CSFile(args2[2]);
        if (!source2.exists()) {
            throw new FHIRException("Source File \"" + source2.getAbsolutePath() + "\" not found");
        }
        CSFileInputStream in = new CSFileInputStream(source2);
        XmlParser p = new XmlParser();
        Resource rf = p.parse(in);
        XmlParser cxml = new XmlParser();
        cxml.setOutputStyle(IParser.OutputStyle.NORMAL);
        cxml.compose(new FileOutputStream(dest), rf);
    }

    private void executeVersion(String[] args2) throws IOException {
        TextFile.stringToFile("1.0:4.0.1", args2[1]);
    }

    public void processExamples(String rootDir, Collection<String> list) throws FHIRException {
        for (String n : list) {
            try {
                String filename = rootDir + n + ".xml";
                CSFileInputStream source2 = new CSFileInputStream(filename);
                FileOutputStream dest = new FileOutputStream(Utilities.changeFileExt(filename, ".canonical.xml"));
                XmlParser p = new XmlParser();
                Resource r = p.parse(source2);
                XmlParser cxml = new XmlParser();
                cxml.setOutputStyle(IParser.OutputStyle.CANONICAL);
                cxml.compose(dest, r);
                source2 = new CSFileInputStream(filename);
                dest = new FileOutputStream(Utilities.changeFileExt(filename, ".json"));
                r = p.parse(source2);
                JsonParser json = new JsonParser();
                json.setOutputStyle(IParser.OutputStyle.PRETTY);
                json.compose(dest, r);
                json = new JsonParser();
                json.setOutputStyle(IParser.OutputStyle.CANONICAL);
                dest = new FileOutputStream(Utilities.changeFileExt(filename, ".canonical.json"));
                json.compose(dest, r);
                dest = new FileOutputStream(Utilities.changeFileExt(filename, ".ttl"));
                RdfParser rdf = new RdfParser();
                rdf.compose(dest, r);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FHIRException("Error Processing " + n + ".xml: " + e.getMessage(), e);
            }
        }
    }

    public void testRoundTrip(String rootDir, String tmpDir, Collection<String> names) throws Throwable {
        try {
            System.err.println("Round trip from " + rootDir + " to " + tmpDir + ":" + Integer.toString(names.size()) + " files");
            for (String n : names) {
                System.err.print("  " + n);
                String source2 = rootDir + n + ".xml";
                String tmp = tmpDir + n.replace(File.separator, "-") + ".tmp";
                String dest = tmpDir + n.replace(File.separator, "-") + ".java.xml";
                FileInputStream in = new FileInputStream(source2);
                XmlParser xp = new XmlParser();
                Resource r = xp.parse(in);
                System.err.print(".");
                JsonParser jp = new JsonParser();
                FileOutputStream out = new FileOutputStream(tmp);
                jp.setOutputStyle(IParser.OutputStyle.PRETTY);
                jp.compose(out, r);
                out.close();
                r = null;
                System.err.print(".");
                in = new FileInputStream(tmp);
                System.err.print(",");
                r = jp.parse(in);
                System.err.print(".");
                out = new FileOutputStream(dest);
                new XmlParser().compose((OutputStream)out, r, true);
                System.err.println("!");
                out.close();
                r = null;
                System.gc();
            }
        }
        catch (Throwable e) {
            System.err.println("Error: " + e.getMessage());
            throw e;
        }
    }

    private void executeTest(String[] args2) throws Throwable {
        try {
            List<String> lines = FileUtils.readLines(new File(args2[1]), "UTF-8");
            String srcDir = lines.get(0);
            lines.remove(0);
            String dstDir = lines.get(0).trim();
            lines.remove(0);
            this.testRoundTrip(srcDir, dstDir, lines);
            TextFile.stringToFile("ok", Utilities.changeFileExt(args2[1], ".out"));
        }
        catch (Exception e) {
            TextFile.stringToFile(e.getMessage(), Utilities.changeFileExt(args2[1], ".out"));
        }
    }
}

