/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DeviceDefinition", profile="http://hl7.org/fhir/StructureDefinition/DeviceDefinition")
public class DeviceDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instance identifier", formalDefinition="Unique instance identifiers assigned to a device by the software, manufacturers, other organizations or owners. For example: handle ID.")
    protected List<Identifier> identifier;
    @Child(name="udiDeviceIdentifier", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Unique Device Identifier (UDI) Barcode string", formalDefinition="Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.")
    protected List<DeviceDefinitionUdiDeviceIdentifierComponent> udiDeviceIdentifier;
    @Child(name="manufacturer", type={StringType.class, Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of device manufacturer", formalDefinition="A name of the manufacturer.")
    protected Type manufacturer;
    @Child(name="deviceName", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A name given to the device to identify it", formalDefinition="A name given to the device to identify it.")
    protected List<DeviceDefinitionDeviceNameComponent> deviceName;
    @Child(name="modelNumber", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The model number for the device", formalDefinition="The model number for the device.")
    protected StringType modelNumber;
    @Child(name="type", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What kind of device or device system this is", formalDefinition="What kind of device or device system this is.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-kind")
    protected CodeableConcept type;
    @Child(name="specialization", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication", formalDefinition="The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication.")
    protected List<DeviceDefinitionSpecializationComponent> specialization;
    @Child(name="version", type={StringType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Available versions", formalDefinition="The available versions of the device, e.g., software versions.")
    protected List<StringType> version;
    @Child(name="safety", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Safety characteristics of the device", formalDefinition="Safety characteristics of the device.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-safety")
    protected List<CodeableConcept> safety;
    @Child(name="shelfLifeStorage", type={ProductShelfLife.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Shelf Life and storage information", formalDefinition="Shelf Life and storage information.")
    protected List<ProductShelfLife> shelfLifeStorage;
    @Child(name="physicalCharacteristics", type={ProdCharacteristic.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Dimensions, color etc.", formalDefinition="Dimensions, color etc.")
    protected ProdCharacteristic physicalCharacteristics;
    @Child(name="languageCode", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Language code for the human-readable text strings produced by the device (all supported)", formalDefinition="Language code for the human-readable text strings produced by the device (all supported).")
    protected List<CodeableConcept> languageCode;
    @Child(name="capability", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device capabilities", formalDefinition="Device capabilities.")
    protected List<DeviceDefinitionCapabilityComponent> capability;
    @Child(name="property", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties", formalDefinition="The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties.")
    protected List<DeviceDefinitionPropertyComponent> property;
    @Child(name="owner", type={Organization.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization responsible for device", formalDefinition="An organization that is responsible for the provision and ongoing maintenance of the device.")
    protected Reference owner;
    protected Organization ownerTarget;
    @Child(name="contact", type={ContactPoint.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details for human/organization for support", formalDefinition="Contact details for an organization or a particular human that is responsible for the device.")
    protected List<ContactPoint> contact;
    @Child(name="url", type={UriType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Network address to contact device", formalDefinition="A network address on which the device may be contacted directly.")
    protected UriType url;
    @Child(name="onlineInformation", type={UriType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Access to on-line information", formalDefinition="Access to on-line information about the device.")
    protected UriType onlineInformation;
    @Child(name="note", type={Annotation.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device notes and comments", formalDefinition="Descriptive information, usage information or implantation information that is not captured in an existing element.")
    protected List<Annotation> note;
    @Child(name="quantity", type={Quantity.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The quantity of the device present in the packaging (e.g. the number of devices present in a pack, or the number of devices in the same package of the medicinal product)", formalDefinition="The quantity of the device present in the packaging (e.g. the number of devices present in a pack, or the number of devices in the same package of the medicinal product).")
    protected Quantity quantity;
    @Child(name="parentDevice", type={DeviceDefinition.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The parent device it can be part of", formalDefinition="The parent device it can be part of.")
    protected Reference parentDevice;
    protected DeviceDefinition parentDeviceTarget;
    @Child(name="material", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A substance used to create the material(s) of which the device is made", formalDefinition="A substance used to create the material(s) of which the device is made.")
    protected List<DeviceDefinitionMaterialComponent> material;
    private static final long serialVersionUID = -2041532433L;
    @SearchParamDefinition(name="parent", path="DeviceDefinition.parentDevice", description="The parent DeviceDefinition resource", type="reference", target={DeviceDefinition.class})
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    public static final Include INCLUDE_PARENT = new Include("DeviceDefinition:parent").toLocked();
    @SearchParamDefinition(name="identifier", path="DeviceDefinition.identifier", description="The identifier of the component", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="type", path="DeviceDefinition.type", description="The device component type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DeviceDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<DeviceDefinitionUdiDeviceIdentifierComponent> getUdiDeviceIdentifier() {
        if (this.udiDeviceIdentifier == null) {
            this.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
        }
        return this.udiDeviceIdentifier;
    }

    public DeviceDefinition setUdiDeviceIdentifier(List<DeviceDefinitionUdiDeviceIdentifierComponent> theUdiDeviceIdentifier) {
        this.udiDeviceIdentifier = theUdiDeviceIdentifier;
        return this;
    }

    public boolean hasUdiDeviceIdentifier() {
        if (this.udiDeviceIdentifier == null) {
            return false;
        }
        for (DeviceDefinitionUdiDeviceIdentifierComponent item : this.udiDeviceIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionUdiDeviceIdentifierComponent addUdiDeviceIdentifier() {
        DeviceDefinitionUdiDeviceIdentifierComponent t = new DeviceDefinitionUdiDeviceIdentifierComponent();
        if (this.udiDeviceIdentifier == null) {
            this.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
        }
        this.udiDeviceIdentifier.add(t);
        return t;
    }

    public DeviceDefinition addUdiDeviceIdentifier(DeviceDefinitionUdiDeviceIdentifierComponent t) {
        if (t == null) {
            return this;
        }
        if (this.udiDeviceIdentifier == null) {
            this.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
        }
        this.udiDeviceIdentifier.add(t);
        return this;
    }

    public DeviceDefinitionUdiDeviceIdentifierComponent getUdiDeviceIdentifierFirstRep() {
        if (this.getUdiDeviceIdentifier().isEmpty()) {
            this.addUdiDeviceIdentifier();
        }
        return this.getUdiDeviceIdentifier().get(0);
    }

    public Type getManufacturer() {
        return this.manufacturer;
    }

    public StringType getManufacturerStringType() throws FHIRException {
        if (this.manufacturer == null) {
            this.manufacturer = new StringType();
        }
        if (!(this.manufacturer instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.manufacturer.getClass().getName() + " was encountered");
        }
        return (StringType)this.manufacturer;
    }

    public boolean hasManufacturerStringType() {
        return this != null && this.manufacturer instanceof StringType;
    }

    public Reference getManufacturerReference() throws FHIRException {
        if (this.manufacturer == null) {
            this.manufacturer = new Reference();
        }
        if (!(this.manufacturer instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.manufacturer.getClass().getName() + " was encountered");
        }
        return (Reference)this.manufacturer;
    }

    public boolean hasManufacturerReference() {
        return this != null && this.manufacturer instanceof Reference;
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public DeviceDefinition setManufacturer(Type value) {
        if (value != null && !(value instanceof StringType) && !(value instanceof Reference)) {
            throw new Error("Not the right type for DeviceDefinition.manufacturer[x]: " + value.fhirType());
        }
        this.manufacturer = value;
        return this;
    }

    public List<DeviceDefinitionDeviceNameComponent> getDeviceName() {
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDefinitionDeviceNameComponent>();
        }
        return this.deviceName;
    }

    public DeviceDefinition setDeviceName(List<DeviceDefinitionDeviceNameComponent> theDeviceName) {
        this.deviceName = theDeviceName;
        return this;
    }

    public boolean hasDeviceName() {
        if (this.deviceName == null) {
            return false;
        }
        for (DeviceDefinitionDeviceNameComponent item : this.deviceName) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionDeviceNameComponent addDeviceName() {
        DeviceDefinitionDeviceNameComponent t = new DeviceDefinitionDeviceNameComponent();
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDefinitionDeviceNameComponent>();
        }
        this.deviceName.add(t);
        return t;
    }

    public DeviceDefinition addDeviceName(DeviceDefinitionDeviceNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDefinitionDeviceNameComponent>();
        }
        this.deviceName.add(t);
        return this;
    }

    public DeviceDefinitionDeviceNameComponent getDeviceNameFirstRep() {
        if (this.getDeviceName().isEmpty()) {
            this.addDeviceName();
        }
        return this.getDeviceName().get(0);
    }

    public StringType getModelNumberElement() {
        if (this.modelNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.modelNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.modelNumber = new StringType();
            }
        }
        return this.modelNumber;
    }

    public boolean hasModelNumberElement() {
        return this.modelNumber != null && !this.modelNumber.isEmpty();
    }

    public boolean hasModelNumber() {
        return this.modelNumber != null && !this.modelNumber.isEmpty();
    }

    public DeviceDefinition setModelNumberElement(StringType value) {
        this.modelNumber = value;
        return this;
    }

    public String getModelNumber() {
        return this.modelNumber == null ? null : (String)this.modelNumber.getValue();
    }

    public DeviceDefinition setModelNumber(String value) {
        if (Utilities.noString(value)) {
            this.modelNumber = null;
        } else {
            if (this.modelNumber == null) {
                this.modelNumber = new StringType();
            }
            this.modelNumber.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DeviceDefinition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<DeviceDefinitionSpecializationComponent> getSpecialization() {
        if (this.specialization == null) {
            this.specialization = new ArrayList<DeviceDefinitionSpecializationComponent>();
        }
        return this.specialization;
    }

    public DeviceDefinition setSpecialization(List<DeviceDefinitionSpecializationComponent> theSpecialization) {
        this.specialization = theSpecialization;
        return this;
    }

    public boolean hasSpecialization() {
        if (this.specialization == null) {
            return false;
        }
        for (DeviceDefinitionSpecializationComponent item : this.specialization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionSpecializationComponent addSpecialization() {
        DeviceDefinitionSpecializationComponent t = new DeviceDefinitionSpecializationComponent();
        if (this.specialization == null) {
            this.specialization = new ArrayList<DeviceDefinitionSpecializationComponent>();
        }
        this.specialization.add(t);
        return t;
    }

    public DeviceDefinition addSpecialization(DeviceDefinitionSpecializationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.specialization == null) {
            this.specialization = new ArrayList<DeviceDefinitionSpecializationComponent>();
        }
        this.specialization.add(t);
        return this;
    }

    public DeviceDefinitionSpecializationComponent getSpecializationFirstRep() {
        if (this.getSpecialization().isEmpty()) {
            this.addSpecialization();
        }
        return this.getSpecialization().get(0);
    }

    public List<StringType> getVersion() {
        if (this.version == null) {
            this.version = new ArrayList<StringType>();
        }
        return this.version;
    }

    public DeviceDefinition setVersion(List<StringType> theVersion) {
        this.version = theVersion;
        return this;
    }

    public boolean hasVersion() {
        if (this.version == null) {
            return false;
        }
        for (StringType item : this.version) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addVersionElement() {
        StringType t = new StringType();
        if (this.version == null) {
            this.version = new ArrayList<StringType>();
        }
        this.version.add(t);
        return t;
    }

    public DeviceDefinition addVersion(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.version == null) {
            this.version = new ArrayList<StringType>();
        }
        this.version.add(t);
        return this;
    }

    public boolean hasVersion(String value) {
        if (this.version == null) {
            return false;
        }
        for (StringType v : this.version) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CodeableConcept> getSafety() {
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        return this.safety;
    }

    public DeviceDefinition setSafety(List<CodeableConcept> theSafety) {
        this.safety = theSafety;
        return this;
    }

    public boolean hasSafety() {
        if (this.safety == null) {
            return false;
        }
        for (CodeableConcept item : this.safety) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSafety() {
        CodeableConcept t = new CodeableConcept();
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        this.safety.add(t);
        return t;
    }

    public DeviceDefinition addSafety(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        this.safety.add(t);
        return this;
    }

    public CodeableConcept getSafetyFirstRep() {
        if (this.getSafety().isEmpty()) {
            this.addSafety();
        }
        return this.getSafety().get(0);
    }

    public List<ProductShelfLife> getShelfLifeStorage() {
        if (this.shelfLifeStorage == null) {
            this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
        }
        return this.shelfLifeStorage;
    }

    public DeviceDefinition setShelfLifeStorage(List<ProductShelfLife> theShelfLifeStorage) {
        this.shelfLifeStorage = theShelfLifeStorage;
        return this;
    }

    public boolean hasShelfLifeStorage() {
        if (this.shelfLifeStorage == null) {
            return false;
        }
        for (ProductShelfLife item : this.shelfLifeStorage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProductShelfLife addShelfLifeStorage() {
        ProductShelfLife t = new ProductShelfLife();
        if (this.shelfLifeStorage == null) {
            this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
        }
        this.shelfLifeStorage.add(t);
        return t;
    }

    public DeviceDefinition addShelfLifeStorage(ProductShelfLife t) {
        if (t == null) {
            return this;
        }
        if (this.shelfLifeStorage == null) {
            this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
        }
        this.shelfLifeStorage.add(t);
        return this;
    }

    public ProductShelfLife getShelfLifeStorageFirstRep() {
        if (this.getShelfLifeStorage().isEmpty()) {
            this.addShelfLifeStorage();
        }
        return this.getShelfLifeStorage().get(0);
    }

    public ProdCharacteristic getPhysicalCharacteristics() {
        if (this.physicalCharacteristics == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.physicalCharacteristics");
            }
            if (Configuration.doAutoCreate()) {
                this.physicalCharacteristics = new ProdCharacteristic();
            }
        }
        return this.physicalCharacteristics;
    }

    public boolean hasPhysicalCharacteristics() {
        return this.physicalCharacteristics != null && !this.physicalCharacteristics.isEmpty();
    }

    public DeviceDefinition setPhysicalCharacteristics(ProdCharacteristic value) {
        this.physicalCharacteristics = value;
        return this;
    }

    public List<CodeableConcept> getLanguageCode() {
        if (this.languageCode == null) {
            this.languageCode = new ArrayList<CodeableConcept>();
        }
        return this.languageCode;
    }

    public DeviceDefinition setLanguageCode(List<CodeableConcept> theLanguageCode) {
        this.languageCode = theLanguageCode;
        return this;
    }

    public boolean hasLanguageCode() {
        if (this.languageCode == null) {
            return false;
        }
        for (CodeableConcept item : this.languageCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addLanguageCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.languageCode == null) {
            this.languageCode = new ArrayList<CodeableConcept>();
        }
        this.languageCode.add(t);
        return t;
    }

    public DeviceDefinition addLanguageCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.languageCode == null) {
            this.languageCode = new ArrayList<CodeableConcept>();
        }
        this.languageCode.add(t);
        return this;
    }

    public CodeableConcept getLanguageCodeFirstRep() {
        if (this.getLanguageCode().isEmpty()) {
            this.addLanguageCode();
        }
        return this.getLanguageCode().get(0);
    }

    public List<DeviceDefinitionCapabilityComponent> getCapability() {
        if (this.capability == null) {
            this.capability = new ArrayList<DeviceDefinitionCapabilityComponent>();
        }
        return this.capability;
    }

    public DeviceDefinition setCapability(List<DeviceDefinitionCapabilityComponent> theCapability) {
        this.capability = theCapability;
        return this;
    }

    public boolean hasCapability() {
        if (this.capability == null) {
            return false;
        }
        for (DeviceDefinitionCapabilityComponent item : this.capability) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionCapabilityComponent addCapability() {
        DeviceDefinitionCapabilityComponent t = new DeviceDefinitionCapabilityComponent();
        if (this.capability == null) {
            this.capability = new ArrayList<DeviceDefinitionCapabilityComponent>();
        }
        this.capability.add(t);
        return t;
    }

    public DeviceDefinition addCapability(DeviceDefinitionCapabilityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.capability == null) {
            this.capability = new ArrayList<DeviceDefinitionCapabilityComponent>();
        }
        this.capability.add(t);
        return this;
    }

    public DeviceDefinitionCapabilityComponent getCapabilityFirstRep() {
        if (this.getCapability().isEmpty()) {
            this.addCapability();
        }
        return this.getCapability().get(0);
    }

    public List<DeviceDefinitionPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<DeviceDefinitionPropertyComponent>();
        }
        return this.property;
    }

    public DeviceDefinition setProperty(List<DeviceDefinitionPropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (DeviceDefinitionPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionPropertyComponent addProperty() {
        DeviceDefinitionPropertyComponent t = new DeviceDefinitionPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<DeviceDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public DeviceDefinition addProperty(DeviceDefinitionPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<DeviceDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public DeviceDefinitionPropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public DeviceDefinition setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public Organization getOwnerTarget() {
        if (this.ownerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.ownerTarget = new Organization();
            }
        }
        return this.ownerTarget;
    }

    public DeviceDefinition setOwnerTarget(Organization value) {
        this.ownerTarget = value;
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public DeviceDefinition setContact(List<ContactPoint> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public DeviceDefinition addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactPoint getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public DeviceDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public DeviceDefinition setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public UriType getOnlineInformationElement() {
        if (this.onlineInformation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.onlineInformation");
            }
            if (Configuration.doAutoCreate()) {
                this.onlineInformation = new UriType();
            }
        }
        return this.onlineInformation;
    }

    public boolean hasOnlineInformationElement() {
        return this.onlineInformation != null && !this.onlineInformation.isEmpty();
    }

    public boolean hasOnlineInformation() {
        return this.onlineInformation != null && !this.onlineInformation.isEmpty();
    }

    public DeviceDefinition setOnlineInformationElement(UriType value) {
        this.onlineInformation = value;
        return this;
    }

    public String getOnlineInformation() {
        return this.onlineInformation == null ? null : (String)this.onlineInformation.getValue();
    }

    public DeviceDefinition setOnlineInformation(String value) {
        if (Utilities.noString(value)) {
            this.onlineInformation = null;
        } else {
            if (this.onlineInformation == null) {
                this.onlineInformation = new UriType();
            }
            this.onlineInformation.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public DeviceDefinition setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public DeviceDefinition addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public DeviceDefinition setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public Reference getParentDevice() {
        if (this.parentDevice == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.parentDevice");
            }
            if (Configuration.doAutoCreate()) {
                this.parentDevice = new Reference();
            }
        }
        return this.parentDevice;
    }

    public boolean hasParentDevice() {
        return this.parentDevice != null && !this.parentDevice.isEmpty();
    }

    public DeviceDefinition setParentDevice(Reference value) {
        this.parentDevice = value;
        return this;
    }

    public DeviceDefinition getParentDeviceTarget() {
        if (this.parentDeviceTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.parentDevice");
            }
            if (Configuration.doAutoCreate()) {
                this.parentDeviceTarget = new DeviceDefinition();
            }
        }
        return this.parentDeviceTarget;
    }

    public DeviceDefinition setParentDeviceTarget(DeviceDefinition value) {
        this.parentDeviceTarget = value;
        return this;
    }

    public List<DeviceDefinitionMaterialComponent> getMaterial() {
        if (this.material == null) {
            this.material = new ArrayList<DeviceDefinitionMaterialComponent>();
        }
        return this.material;
    }

    public DeviceDefinition setMaterial(List<DeviceDefinitionMaterialComponent> theMaterial) {
        this.material = theMaterial;
        return this;
    }

    public boolean hasMaterial() {
        if (this.material == null) {
            return false;
        }
        for (DeviceDefinitionMaterialComponent item : this.material) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionMaterialComponent addMaterial() {
        DeviceDefinitionMaterialComponent t = new DeviceDefinitionMaterialComponent();
        if (this.material == null) {
            this.material = new ArrayList<DeviceDefinitionMaterialComponent>();
        }
        this.material.add(t);
        return t;
    }

    public DeviceDefinition addMaterial(DeviceDefinitionMaterialComponent t) {
        if (t == null) {
            return this;
        }
        if (this.material == null) {
            this.material = new ArrayList<DeviceDefinitionMaterialComponent>();
        }
        this.material.add(t);
        return this;
    }

    public DeviceDefinitionMaterialComponent getMaterialFirstRep() {
        if (this.getMaterial().isEmpty()) {
            this.addMaterial();
        }
        return this.getMaterial().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by the software, manufacturers, other organizations or owners. For example: handle ID.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("udiDeviceIdentifier", "", "Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.", 0, Integer.MAX_VALUE, this.udiDeviceIdentifier));
        children.add(new Property("manufacturer[x]", "string|Reference(Organization)", "A name of the manufacturer.", 0, 1, this.manufacturer));
        children.add(new Property("deviceName", "", "A name given to the device to identify it.", 0, Integer.MAX_VALUE, this.deviceName));
        children.add(new Property("modelNumber", "string", "The model number for the device.", 0, 1, this.modelNumber));
        children.add(new Property(SP_TYPE, "CodeableConcept", "What kind of device or device system this is.", 0, 1, this.type));
        children.add(new Property("specialization", "", "The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication.", 0, Integer.MAX_VALUE, this.specialization));
        children.add(new Property("version", "string", "The available versions of the device, e.g., software versions.", 0, Integer.MAX_VALUE, this.version));
        children.add(new Property("safety", "CodeableConcept", "Safety characteristics of the device.", 0, Integer.MAX_VALUE, this.safety));
        children.add(new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage));
        children.add(new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics));
        children.add(new Property("languageCode", "CodeableConcept", "Language code for the human-readable text strings produced by the device (all supported).", 0, Integer.MAX_VALUE, this.languageCode));
        children.add(new Property("capability", "", "Device capabilities.", 0, Integer.MAX_VALUE, this.capability));
        children.add(new Property("property", "", "The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, 1, this.owner));
        children.add(new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("url", "uri", "A network address on which the device may be contacted directly.", 0, 1, this.url));
        children.add(new Property("onlineInformation", "uri", "Access to on-line information about the device.", 0, 1, this.onlineInformation));
        children.add(new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("quantity", "Quantity", "The quantity of the device present in the packaging (e.g. the number of devices present in a pack, or the number of devices in the same package of the medicinal product).", 0, 1, this.quantity));
        children.add(new Property("parentDevice", "Reference(DeviceDefinition)", "The parent device it can be part of.", 0, 1, this.parentDevice));
        children.add(new Property("material", "", "A substance used to create the material(s) of which the device is made.", 0, Integer.MAX_VALUE, this.material));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by the software, manufacturers, other organizations or owners. For example: handle ID.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -99121287: {
                return new Property("udiDeviceIdentifier", "", "Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.", 0, Integer.MAX_VALUE, this.udiDeviceIdentifier);
            }
            case 418079503: {
                return new Property("manufacturer[x]", "string|Reference(Organization)", "A name of the manufacturer.", 0, 1, this.manufacturer);
            }
            case -1969347631: {
                return new Property("manufacturer[x]", "string|Reference(Organization)", "A name of the manufacturer.", 0, 1, this.manufacturer);
            }
            case -630681790: {
                return new Property("manufacturer[x]", "string|Reference(Organization)", "A name of the manufacturer.", 0, 1, this.manufacturer);
            }
            case 1104934522: {
                return new Property("manufacturer[x]", "string|Reference(Organization)", "A name of the manufacturer.", 0, 1, this.manufacturer);
            }
            case 780988929: {
                return new Property("deviceName", "", "A name given to the device to identify it.", 0, Integer.MAX_VALUE, this.deviceName);
            }
            case 346619858: {
                return new Property("modelNumber", "string", "The model number for the device.", 0, 1, this.modelNumber);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "What kind of device or device system this is.", 0, 1, this.type);
            }
            case 682815883: {
                return new Property("specialization", "", "The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication.", 0, Integer.MAX_VALUE, this.specialization);
            }
            case 351608024: {
                return new Property("version", "string", "The available versions of the device, e.g., software versions.", 0, Integer.MAX_VALUE, this.version);
            }
            case -909893934: {
                return new Property("safety", "CodeableConcept", "Safety characteristics of the device.", 0, Integer.MAX_VALUE, this.safety);
            }
            case 172049237: {
                return new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage);
            }
            case -1599676319: {
                return new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics);
            }
            case -2092349083: {
                return new Property("languageCode", "CodeableConcept", "Language code for the human-readable text strings produced by the device (all supported).", 0, Integer.MAX_VALUE, this.languageCode);
            }
            case -783669992: {
                return new Property("capability", "", "Device capabilities.", 0, Integer.MAX_VALUE, this.capability);
            }
            case -993141291: {
                return new Property("property", "", "The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties.", 0, Integer.MAX_VALUE, this.property);
            }
            case 106164915: {
                return new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, 1, this.owner);
            }
            case 951526432: {
                return new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 116079: {
                return new Property("url", "uri", "A network address on which the device may be contacted directly.", 0, 1, this.url);
            }
            case -788511527: {
                return new Property("onlineInformation", "uri", "Access to on-line information about the device.", 0, 1, this.onlineInformation);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1285004149: {
                return new Property("quantity", "Quantity", "The quantity of the device present in the packaging (e.g. the number of devices present in a pack, or the number of devices in the same package of the medicinal product).", 0, 1, this.quantity);
            }
            case 620260256: {
                return new Property("parentDevice", "Reference(DeviceDefinition)", "The parent device it can be part of.", 0, 1, this.parentDevice);
            }
            case 299066663: {
                return new Property("material", "", "A substance used to create the material(s) of which the device is made.", 0, Integer.MAX_VALUE, this.material);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -99121287: {
                return this.udiDeviceIdentifier == null ? new Base[]{} : this.udiDeviceIdentifier.toArray(new Base[this.udiDeviceIdentifier.size()]);
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 780988929: {
                return this.deviceName == null ? new Base[]{} : this.deviceName.toArray(new Base[this.deviceName.size()]);
            }
            case 346619858: {
                Base[] baseArray;
                if (this.modelNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.modelNumber;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case 682815883: {
                return this.specialization == null ? new Base[]{} : this.specialization.toArray(new Base[this.specialization.size()]);
            }
            case 351608024: {
                return this.version == null ? new Base[]{} : this.version.toArray(new Base[this.version.size()]);
            }
            case -909893934: {
                return this.safety == null ? new Base[]{} : this.safety.toArray(new Base[this.safety.size()]);
            }
            case 172049237: {
                return this.shelfLifeStorage == null ? new Base[]{} : this.shelfLifeStorage.toArray(new Base[this.shelfLifeStorage.size()]);
            }
            case -1599676319: {
                Base[] baseArray;
                if (this.physicalCharacteristics == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.physicalCharacteristics;
                }
                return baseArray;
            }
            case -2092349083: {
                return this.languageCode == null ? new Base[]{} : this.languageCode.toArray(new Base[this.languageCode.size()]);
            }
            case -783669992: {
                return this.capability == null ? new Base[]{} : this.capability.toArray(new Base[this.capability.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.owner;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.url;
                }
                return baseArray;
            }
            case -788511527: {
                Base[] baseArray;
                if (this.onlineInformation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.onlineInformation;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.quantity;
                }
                return baseArray;
            }
            case 620260256: {
                Base[] baseArray;
                if (this.parentDevice == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.parentDevice;
                }
                return baseArray;
            }
            case 299066663: {
                return this.material == null ? new Base[]{} : this.material.toArray(new Base[this.material.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -99121287: {
                this.getUdiDeviceIdentifier().add((DeviceDefinitionUdiDeviceIdentifierComponent)value);
                return value;
            }
            case -1969347631: {
                this.manufacturer = this.castToType(value);
                return value;
            }
            case 780988929: {
                this.getDeviceName().add((DeviceDefinitionDeviceNameComponent)value);
                return value;
            }
            case 346619858: {
                this.modelNumber = this.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case 682815883: {
                this.getSpecialization().add((DeviceDefinitionSpecializationComponent)value);
                return value;
            }
            case 351608024: {
                this.getVersion().add(this.castToString(value));
                return value;
            }
            case -909893934: {
                this.getSafety().add(this.castToCodeableConcept(value));
                return value;
            }
            case 172049237: {
                this.getShelfLifeStorage().add(this.castToProductShelfLife(value));
                return value;
            }
            case -1599676319: {
                this.physicalCharacteristics = this.castToProdCharacteristic(value);
                return value;
            }
            case -2092349083: {
                this.getLanguageCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -783669992: {
                this.getCapability().add((DeviceDefinitionCapabilityComponent)value);
                return value;
            }
            case -993141291: {
                this.getProperty().add((DeviceDefinitionPropertyComponent)value);
                return value;
            }
            case 106164915: {
                this.owner = this.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactPoint(value));
                return value;
            }
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -788511527: {
                this.onlineInformation = this.castToUri(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -1285004149: {
                this.quantity = this.castToQuantity(value);
                return value;
            }
            case 620260256: {
                this.parentDevice = this.castToReference(value);
                return value;
            }
            case 299066663: {
                this.getMaterial().add((DeviceDefinitionMaterialComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("udiDeviceIdentifier")) {
            this.getUdiDeviceIdentifier().add((DeviceDefinitionUdiDeviceIdentifierComponent)value);
        } else if (name.equals("manufacturer[x]")) {
            this.manufacturer = this.castToType(value);
        } else if (name.equals("deviceName")) {
            this.getDeviceName().add((DeviceDefinitionDeviceNameComponent)value);
        } else if (name.equals("modelNumber")) {
            this.modelNumber = this.castToString(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("specialization")) {
            this.getSpecialization().add((DeviceDefinitionSpecializationComponent)value);
        } else if (name.equals("version")) {
            this.getVersion().add(this.castToString(value));
        } else if (name.equals("safety")) {
            this.getSafety().add(this.castToCodeableConcept(value));
        } else if (name.equals("shelfLifeStorage")) {
            this.getShelfLifeStorage().add(this.castToProductShelfLife(value));
        } else if (name.equals("physicalCharacteristics")) {
            this.physicalCharacteristics = this.castToProdCharacteristic(value);
        } else if (name.equals("languageCode")) {
            this.getLanguageCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("capability")) {
            this.getCapability().add((DeviceDefinitionCapabilityComponent)value);
        } else if (name.equals("property")) {
            this.getProperty().add((DeviceDefinitionPropertyComponent)value);
        } else if (name.equals("owner")) {
            this.owner = this.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactPoint(value));
        } else if (name.equals("url")) {
            this.url = this.castToUri(value);
        } else if (name.equals("onlineInformation")) {
            this.onlineInformation = this.castToUri(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("quantity")) {
            this.quantity = this.castToQuantity(value);
        } else if (name.equals("parentDevice")) {
            this.parentDevice = this.castToReference(value);
        } else if (name.equals("material")) {
            this.getMaterial().add((DeviceDefinitionMaterialComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -99121287: {
                return this.addUdiDeviceIdentifier();
            }
            case 418079503: {
                return this.getManufacturer();
            }
            case -1969347631: {
                return this.getManufacturer();
            }
            case 780988929: {
                return this.addDeviceName();
            }
            case 346619858: {
                return this.getModelNumberElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 682815883: {
                return this.addSpecialization();
            }
            case 351608024: {
                return this.addVersionElement();
            }
            case -909893934: {
                return this.addSafety();
            }
            case 172049237: {
                return this.addShelfLifeStorage();
            }
            case -1599676319: {
                return this.getPhysicalCharacteristics();
            }
            case -2092349083: {
                return this.addLanguageCode();
            }
            case -783669992: {
                return this.addCapability();
            }
            case -993141291: {
                return this.addProperty();
            }
            case 106164915: {
                return this.getOwner();
            }
            case 951526432: {
                return this.addContact();
            }
            case 116079: {
                return this.getUrlElement();
            }
            case -788511527: {
                return this.getOnlineInformationElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case 620260256: {
                return this.getParentDevice();
            }
            case 299066663: {
                return this.addMaterial();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -99121287: {
                return new String[0];
            }
            case -1969347631: {
                return new String[]{"string", "Reference"};
            }
            case 780988929: {
                return new String[0];
            }
            case 346619858: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 682815883: {
                return new String[0];
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -909893934: {
                return new String[]{"CodeableConcept"};
            }
            case 172049237: {
                return new String[]{"ProductShelfLife"};
            }
            case -1599676319: {
                return new String[]{"ProdCharacteristic"};
            }
            case -2092349083: {
                return new String[]{"CodeableConcept"};
            }
            case -783669992: {
                return new String[0];
            }
            case -993141291: {
                return new String[0];
            }
            case 106164915: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactPoint"};
            }
            case 116079: {
                return new String[]{"uri"};
            }
            case -788511527: {
                return new String[]{"uri"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case 620260256: {
                return new String[]{"Reference"};
            }
            case 299066663: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("udiDeviceIdentifier")) {
            return this.addUdiDeviceIdentifier();
        }
        if (name.equals("manufacturerString")) {
            this.manufacturer = new StringType();
            return this.manufacturer;
        }
        if (name.equals("manufacturerReference")) {
            this.manufacturer = new Reference();
            return this.manufacturer;
        }
        if (name.equals("deviceName")) {
            return this.addDeviceName();
        }
        if (name.equals("modelNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.modelNumber");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("specialization")) {
            return this.addSpecialization();
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.version");
        }
        if (name.equals("safety")) {
            return this.addSafety();
        }
        if (name.equals("shelfLifeStorage")) {
            return this.addShelfLifeStorage();
        }
        if (name.equals("physicalCharacteristics")) {
            this.physicalCharacteristics = new ProdCharacteristic();
            return this.physicalCharacteristics;
        }
        if (name.equals("languageCode")) {
            return this.addLanguageCode();
        }
        if (name.equals("capability")) {
            return this.addCapability();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("owner")) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.url");
        }
        if (name.equals("onlineInformation")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.onlineInformation");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("parentDevice")) {
            this.parentDevice = new Reference();
            return this.parentDevice;
        }
        if (name.equals("material")) {
            return this.addMaterial();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceDefinition";
    }

    @Override
    public DeviceDefinition copy() {
        DeviceDefinition dst = new DeviceDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DeviceDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.udiDeviceIdentifier != null) {
            dst.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
            for (DeviceDefinitionUdiDeviceIdentifierComponent deviceDefinitionUdiDeviceIdentifierComponent : this.udiDeviceIdentifier) {
                dst.udiDeviceIdentifier.add(deviceDefinitionUdiDeviceIdentifierComponent.copy());
            }
        }
        Type type = dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        if (this.deviceName != null) {
            dst.deviceName = new ArrayList<DeviceDefinitionDeviceNameComponent>();
            for (DeviceDefinitionDeviceNameComponent deviceDefinitionDeviceNameComponent : this.deviceName) {
                dst.deviceName.add(deviceDefinitionDeviceNameComponent.copy());
            }
        }
        dst.modelNumber = this.modelNumber == null ? null : this.modelNumber.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.specialization != null) {
            dst.specialization = new ArrayList<DeviceDefinitionSpecializationComponent>();
            for (DeviceDefinitionSpecializationComponent deviceDefinitionSpecializationComponent : this.specialization) {
                dst.specialization.add(deviceDefinitionSpecializationComponent.copy());
            }
        }
        if (this.version != null) {
            dst.version = new ArrayList<StringType>();
            for (StringType stringType : this.version) {
                dst.version.add(stringType.copy());
            }
        }
        if (this.safety != null) {
            dst.safety = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.safety) {
                dst.safety.add(codeableConcept2.copy());
            }
        }
        if (this.shelfLifeStorage != null) {
            dst.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            for (ProductShelfLife productShelfLife : this.shelfLifeStorage) {
                dst.shelfLifeStorage.add(productShelfLife.copy());
            }
        }
        ProdCharacteristic prodCharacteristic = dst.physicalCharacteristics = this.physicalCharacteristics == null ? null : this.physicalCharacteristics.copy();
        if (this.languageCode != null) {
            dst.languageCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.languageCode) {
                dst.languageCode.add(codeableConcept3.copy());
            }
        }
        if (this.capability != null) {
            dst.capability = new ArrayList<DeviceDefinitionCapabilityComponent>();
            for (DeviceDefinitionCapabilityComponent deviceDefinitionCapabilityComponent : this.capability) {
                dst.capability.add(deviceDefinitionCapabilityComponent.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<DeviceDefinitionPropertyComponent>();
            for (DeviceDefinitionPropertyComponent deviceDefinitionPropertyComponent : this.property) {
                dst.property.add(deviceDefinitionPropertyComponent.copy());
            }
        }
        Reference reference = dst.owner = this.owner == null ? null : this.owner.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        dst.url = this.url == null ? null : this.url.copy();
        UriType uriType = dst.onlineInformation = this.onlineInformation == null ? null : this.onlineInformation.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        Reference reference2 = dst.parentDevice = this.parentDevice == null ? null : this.parentDevice.copy();
        if (this.material != null) {
            dst.material = new ArrayList<DeviceDefinitionMaterialComponent>();
            for (DeviceDefinitionMaterialComponent deviceDefinitionMaterialComponent : this.material) {
                dst.material.add(deviceDefinitionMaterialComponent.copy());
            }
        }
    }

    protected DeviceDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceDefinition)) {
            return false;
        }
        DeviceDefinition o = (DeviceDefinition)other_;
        return DeviceDefinition.compareDeep(this.identifier, o.identifier, true) && DeviceDefinition.compareDeep(this.udiDeviceIdentifier, o.udiDeviceIdentifier, true) && DeviceDefinition.compareDeep(this.manufacturer, o.manufacturer, true) && DeviceDefinition.compareDeep(this.deviceName, o.deviceName, true) && DeviceDefinition.compareDeep(this.modelNumber, o.modelNumber, true) && DeviceDefinition.compareDeep(this.type, o.type, true) && DeviceDefinition.compareDeep(this.specialization, o.specialization, true) && DeviceDefinition.compareDeep(this.version, o.version, true) && DeviceDefinition.compareDeep(this.safety, o.safety, true) && DeviceDefinition.compareDeep(this.shelfLifeStorage, o.shelfLifeStorage, true) && DeviceDefinition.compareDeep(this.physicalCharacteristics, o.physicalCharacteristics, true) && DeviceDefinition.compareDeep(this.languageCode, o.languageCode, true) && DeviceDefinition.compareDeep(this.capability, o.capability, true) && DeviceDefinition.compareDeep(this.property, o.property, true) && DeviceDefinition.compareDeep(this.owner, o.owner, true) && DeviceDefinition.compareDeep(this.contact, o.contact, true) && DeviceDefinition.compareDeep(this.url, o.url, true) && DeviceDefinition.compareDeep(this.onlineInformation, o.onlineInformation, true) && DeviceDefinition.compareDeep(this.note, o.note, true) && DeviceDefinition.compareDeep(this.quantity, o.quantity, true) && DeviceDefinition.compareDeep(this.parentDevice, o.parentDevice, true) && DeviceDefinition.compareDeep(this.material, o.material, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceDefinition)) {
            return false;
        }
        DeviceDefinition o = (DeviceDefinition)other_;
        return DeviceDefinition.compareValues(this.modelNumber, o.modelNumber, true) && DeviceDefinition.compareValues(this.version, o.version, true) && DeviceDefinition.compareValues(this.url, o.url, true) && DeviceDefinition.compareValues(this.onlineInformation, o.onlineInformation, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.udiDeviceIdentifier, this.manufacturer, this.deviceName, this.modelNumber, this.type, this.specialization, this.version, this.safety, this.shelfLifeStorage, this.physicalCharacteristics, this.languageCode, this.capability, this.property, this.owner, this.contact, this.url, this.onlineInformation, this.note, this.quantity, this.parentDevice, this.material);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceDefinition;
    }

    @Block
    public static class DeviceDefinitionMaterialComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The substance", formalDefinition="The substance.")
        protected CodeableConcept substance;
        @Child(name="alternate", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates an alternative material of the device", formalDefinition="Indicates an alternative material of the device.")
        protected BooleanType alternate;
        @Child(name="allergenicIndicator", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the substance is a known or suspected allergen", formalDefinition="Whether the substance is a known or suspected allergen.")
        protected BooleanType allergenicIndicator;
        private static final long serialVersionUID = 1232736508L;

        public DeviceDefinitionMaterialComponent() {
        }

        public DeviceDefinitionMaterialComponent(CodeableConcept substance) {
            this.substance = substance;
        }

        public CodeableConcept getSubstance() {
            if (this.substance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionMaterialComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substance = new CodeableConcept();
                }
            }
            return this.substance;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public DeviceDefinitionMaterialComponent setSubstance(CodeableConcept value) {
            this.substance = value;
            return this;
        }

        public BooleanType getAlternateElement() {
            if (this.alternate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionMaterialComponent.alternate");
                }
                if (Configuration.doAutoCreate()) {
                    this.alternate = new BooleanType();
                }
            }
            return this.alternate;
        }

        public boolean hasAlternateElement() {
            return this.alternate != null && !this.alternate.isEmpty();
        }

        public boolean hasAlternate() {
            return this.alternate != null && !this.alternate.isEmpty();
        }

        public DeviceDefinitionMaterialComponent setAlternateElement(BooleanType value) {
            this.alternate = value;
            return this;
        }

        public boolean getAlternate() {
            return this.alternate == null || this.alternate.isEmpty() ? false : (Boolean)this.alternate.getValue();
        }

        public DeviceDefinitionMaterialComponent setAlternate(boolean value) {
            if (this.alternate == null) {
                this.alternate = new BooleanType();
            }
            this.alternate.setValue((Object)value);
            return this;
        }

        public BooleanType getAllergenicIndicatorElement() {
            if (this.allergenicIndicator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionMaterialComponent.allergenicIndicator");
                }
                if (Configuration.doAutoCreate()) {
                    this.allergenicIndicator = new BooleanType();
                }
            }
            return this.allergenicIndicator;
        }

        public boolean hasAllergenicIndicatorElement() {
            return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
        }

        public boolean hasAllergenicIndicator() {
            return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
        }

        public DeviceDefinitionMaterialComponent setAllergenicIndicatorElement(BooleanType value) {
            this.allergenicIndicator = value;
            return this;
        }

        public boolean getAllergenicIndicator() {
            return this.allergenicIndicator == null || this.allergenicIndicator.isEmpty() ? false : (Boolean)this.allergenicIndicator.getValue();
        }

        public DeviceDefinitionMaterialComponent setAllergenicIndicator(boolean value) {
            if (this.allergenicIndicator == null) {
                this.allergenicIndicator = new BooleanType();
            }
            this.allergenicIndicator.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("substance", "CodeableConcept", "The substance.", 0, 1, this.substance));
            children.add(new Property("alternate", "boolean", "Indicates an alternative material of the device.", 0, 1, this.alternate));
            children.add(new Property("allergenicIndicator", "boolean", "Whether the substance is a known or suspected allergen.", 0, 1, this.allergenicIndicator));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 530040176: {
                    return new Property("substance", "CodeableConcept", "The substance.", 0, 1, this.substance);
                }
                case -1408024454: {
                    return new Property("alternate", "boolean", "Indicates an alternative material of the device.", 0, 1, this.alternate);
                }
                case 75406931: {
                    return new Property("allergenicIndicator", "boolean", "Whether the substance is a known or suspected allergen.", 0, 1, this.allergenicIndicator);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case -1408024454: {
                    Base[] baseArray;
                    if (this.alternate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.alternate;
                    }
                    return baseArray;
                }
                case 75406931: {
                    Base[] baseArray;
                    if (this.allergenicIndicator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.allergenicIndicator;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = this.castToCodeableConcept(value);
                    return value;
                }
                case -1408024454: {
                    this.alternate = this.castToBoolean(value);
                    return value;
                }
                case 75406931: {
                    this.allergenicIndicator = this.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = this.castToCodeableConcept(value);
            } else if (name.equals("alternate")) {
                this.alternate = this.castToBoolean(value);
            } else if (name.equals("allergenicIndicator")) {
                this.allergenicIndicator = this.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return this.getSubstance();
                }
                case -1408024454: {
                    return this.getAlternateElement();
                }
                case 75406931: {
                    return this.getAllergenicIndicatorElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return new String[]{"CodeableConcept"};
                }
                case -1408024454: {
                    return new String[]{"boolean"};
                }
                case 75406931: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = new CodeableConcept();
                return this.substance;
            }
            if (name.equals("alternate")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.alternate");
            }
            if (name.equals("allergenicIndicator")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.allergenicIndicator");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionMaterialComponent copy() {
            DeviceDefinitionMaterialComponent dst = new DeviceDefinitionMaterialComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionMaterialComponent dst) {
            super.copyValues(dst);
            dst.substance = this.substance == null ? null : this.substance.copy();
            dst.alternate = this.alternate == null ? null : this.alternate.copy();
            dst.allergenicIndicator = this.allergenicIndicator == null ? null : this.allergenicIndicator.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionMaterialComponent)) {
                return false;
            }
            DeviceDefinitionMaterialComponent o = (DeviceDefinitionMaterialComponent)other_;
            return DeviceDefinitionMaterialComponent.compareDeep(this.substance, o.substance, true) && DeviceDefinitionMaterialComponent.compareDeep(this.alternate, o.alternate, true) && DeviceDefinitionMaterialComponent.compareDeep(this.allergenicIndicator, o.allergenicIndicator, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionMaterialComponent)) {
                return false;
            }
            DeviceDefinitionMaterialComponent o = (DeviceDefinitionMaterialComponent)other_;
            return DeviceDefinitionMaterialComponent.compareValues(this.alternate, o.alternate, true) && DeviceDefinitionMaterialComponent.compareValues(this.allergenicIndicator, o.allergenicIndicator, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.substance, this.alternate, this.allergenicIndicator);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.material";
        }
    }

    @Block
    public static class DeviceDefinitionPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that specifies the property DeviceDefinitionPropetyCode (Extensible)", formalDefinition="Code that specifies the property DeviceDefinitionPropetyCode (Extensible).")
        protected CodeableConcept type;
        @Child(name="valueQuantity", type={Quantity.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Property value as a quantity", formalDefinition="Property value as a quantity.")
        protected List<Quantity> valueQuantity;
        @Child(name="valueCode", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Property value as a code, e.g., NTP4 (synced to NTP)", formalDefinition="Property value as a code, e.g., NTP4 (synced to NTP).")
        protected List<CodeableConcept> valueCode;
        private static final long serialVersionUID = 1512172633L;

        public DeviceDefinitionPropertyComponent() {
        }

        public DeviceDefinitionPropertyComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionPropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDefinitionPropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Quantity> getValueQuantity() {
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            return this.valueQuantity;
        }

        public DeviceDefinitionPropertyComponent setValueQuantity(List<Quantity> theValueQuantity) {
            this.valueQuantity = theValueQuantity;
            return this;
        }

        public boolean hasValueQuantity() {
            if (this.valueQuantity == null) {
                return false;
            }
            for (Quantity item : this.valueQuantity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Quantity addValueQuantity() {
            Quantity t = new Quantity();
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            this.valueQuantity.add(t);
            return t;
        }

        public DeviceDefinitionPropertyComponent addValueQuantity(Quantity t) {
            if (t == null) {
                return this;
            }
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            this.valueQuantity.add(t);
            return this;
        }

        public Quantity getValueQuantityFirstRep() {
            if (this.getValueQuantity().isEmpty()) {
                this.addValueQuantity();
            }
            return this.getValueQuantity().get(0);
        }

        public List<CodeableConcept> getValueCode() {
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeableConcept>();
            }
            return this.valueCode;
        }

        public DeviceDefinitionPropertyComponent setValueCode(List<CodeableConcept> theValueCode) {
            this.valueCode = theValueCode;
            return this;
        }

        public boolean hasValueCode() {
            if (this.valueCode == null) {
                return false;
            }
            for (CodeableConcept item : this.valueCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addValueCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeableConcept>();
            }
            this.valueCode.add(t);
            return t;
        }

        public DeviceDefinitionPropertyComponent addValueCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeableConcept>();
            }
            this.valueCode.add(t);
            return this;
        }

        public CodeableConcept getValueCodeFirstRep() {
            if (this.getValueCode().isEmpty()) {
                this.addValueCode();
            }
            return this.getValueCode().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "Code that specifies the property DeviceDefinitionPropetyCode (Extensible).", 0, 1, this.type));
            children.add(new Property("valueQuantity", "Quantity", "Property value as a quantity.", 0, Integer.MAX_VALUE, this.valueQuantity));
            children.add(new Property("valueCode", "CodeableConcept", "Property value as a code, e.g., NTP4 (synced to NTP).", 0, Integer.MAX_VALUE, this.valueCode));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "Code that specifies the property DeviceDefinitionPropetyCode (Extensible).", 0, 1, this.type);
                }
                case -2029823716: {
                    return new Property("valueQuantity", "Quantity", "Property value as a quantity.", 0, Integer.MAX_VALUE, this.valueQuantity);
                }
                case -766209282: {
                    return new Property("valueCode", "CodeableConcept", "Property value as a code, e.g., NTP4 (synced to NTP).", 0, Integer.MAX_VALUE, this.valueCode);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -2029823716: {
                    return this.valueQuantity == null ? new Base[]{} : this.valueQuantity.toArray(new Base[this.valueQuantity.size()]);
                }
                case -766209282: {
                    return this.valueCode == null ? new Base[]{} : this.valueCode.toArray(new Base[this.valueCode.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -2029823716: {
                    this.getValueQuantity().add(this.castToQuantity(value));
                    return value;
                }
                case -766209282: {
                    this.getValueCode().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("valueQuantity")) {
                this.getValueQuantity().add(this.castToQuantity(value));
            } else if (name.equals("valueCode")) {
                this.getValueCode().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -2029823716: {
                    return this.addValueQuantity();
                }
                case -766209282: {
                    return this.addValueCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -2029823716: {
                    return new String[]{"Quantity"};
                }
                case -766209282: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueQuantity")) {
                return this.addValueQuantity();
            }
            if (name.equals("valueCode")) {
                return this.addValueCode();
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionPropertyComponent copy() {
            DeviceDefinitionPropertyComponent dst = new DeviceDefinitionPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionPropertyComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.valueQuantity != null) {
                dst.valueQuantity = new ArrayList<Quantity>();
                for (Quantity quantity : this.valueQuantity) {
                    dst.valueQuantity.add(quantity.copy());
                }
            }
            if (this.valueCode != null) {
                dst.valueCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.valueCode) {
                    dst.valueCode.add(codeableConcept2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionPropertyComponent)) {
                return false;
            }
            DeviceDefinitionPropertyComponent o = (DeviceDefinitionPropertyComponent)other_;
            return DeviceDefinitionPropertyComponent.compareDeep(this.type, o.type, true) && DeviceDefinitionPropertyComponent.compareDeep(this.valueQuantity, o.valueQuantity, true) && DeviceDefinitionPropertyComponent.compareDeep(this.valueCode, o.valueCode, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionPropertyComponent)) {
                return false;
            }
            DeviceDefinitionPropertyComponent o = (DeviceDefinitionPropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.valueQuantity, this.valueCode);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.property";
        }
    }

    @Block
    public static class DeviceDefinitionCapabilityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of capability", formalDefinition="Type of capability.")
        protected CodeableConcept type;
        @Child(name="description", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Description of capability", formalDefinition="Description of capability.")
        protected List<CodeableConcept> description;
        private static final long serialVersionUID = -192945344L;

        public DeviceDefinitionCapabilityComponent() {
        }

        public DeviceDefinitionCapabilityComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionCapabilityComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDefinitionCapabilityComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getDescription() {
            if (this.description == null) {
                this.description = new ArrayList<CodeableConcept>();
            }
            return this.description;
        }

        public DeviceDefinitionCapabilityComponent setDescription(List<CodeableConcept> theDescription) {
            this.description = theDescription;
            return this;
        }

        public boolean hasDescription() {
            if (this.description == null) {
                return false;
            }
            for (CodeableConcept item : this.description) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addDescription() {
            CodeableConcept t = new CodeableConcept();
            if (this.description == null) {
                this.description = new ArrayList<CodeableConcept>();
            }
            this.description.add(t);
            return t;
        }

        public DeviceDefinitionCapabilityComponent addDescription(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.description == null) {
                this.description = new ArrayList<CodeableConcept>();
            }
            this.description.add(t);
            return this;
        }

        public CodeableConcept getDescriptionFirstRep() {
            if (this.getDescription().isEmpty()) {
                this.addDescription();
            }
            return this.getDescription().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "Type of capability.", 0, 1, this.type));
            children.add(new Property("description", "CodeableConcept", "Description of capability.", 0, Integer.MAX_VALUE, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "Type of capability.", 0, 1, this.type);
                }
                case -1724546052: {
                    return new Property("description", "CodeableConcept", "Description of capability.", 0, Integer.MAX_VALUE, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    return this.description == null ? new Base[]{} : this.description.toArray(new Base[this.description.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.getDescription().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("description")) {
                this.getDescription().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1724546052: {
                    return this.addDescription();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("description")) {
                return this.addDescription();
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionCapabilityComponent copy() {
            DeviceDefinitionCapabilityComponent dst = new DeviceDefinitionCapabilityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionCapabilityComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.description != null) {
                dst.description = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.description) {
                    dst.description.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionCapabilityComponent)) {
                return false;
            }
            DeviceDefinitionCapabilityComponent o = (DeviceDefinitionCapabilityComponent)other_;
            return DeviceDefinitionCapabilityComponent.compareDeep(this.type, o.type, true) && DeviceDefinitionCapabilityComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionCapabilityComponent)) {
                return false;
            }
            DeviceDefinitionCapabilityComponent o = (DeviceDefinitionCapabilityComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.description);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.capability";
        }
    }

    @Block
    public static class DeviceDefinitionSpecializationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="systemType", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The standard that is used to operate and communicate", formalDefinition="The standard that is used to operate and communicate.")
        protected StringType systemType;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The version of the standard that is used to operate and communicate", formalDefinition="The version of the standard that is used to operate and communicate.")
        protected StringType version;
        private static final long serialVersionUID = -249304393L;

        public DeviceDefinitionSpecializationComponent() {
        }

        public DeviceDefinitionSpecializationComponent(StringType systemType) {
            this.systemType = systemType;
        }

        public StringType getSystemTypeElement() {
            if (this.systemType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionSpecializationComponent.systemType");
                }
                if (Configuration.doAutoCreate()) {
                    this.systemType = new StringType();
                }
            }
            return this.systemType;
        }

        public boolean hasSystemTypeElement() {
            return this.systemType != null && !this.systemType.isEmpty();
        }

        public boolean hasSystemType() {
            return this.systemType != null && !this.systemType.isEmpty();
        }

        public DeviceDefinitionSpecializationComponent setSystemTypeElement(StringType value) {
            this.systemType = value;
            return this;
        }

        public String getSystemType() {
            return this.systemType == null ? null : (String)this.systemType.getValue();
        }

        public DeviceDefinitionSpecializationComponent setSystemType(String value) {
            if (this.systemType == null) {
                this.systemType = new StringType();
            }
            this.systemType.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionSpecializationComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public DeviceDefinitionSpecializationComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public DeviceDefinitionSpecializationComponent setVersion(String value) {
            if (Utilities.noString(value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("systemType", "string", "The standard that is used to operate and communicate.", 0, 1, this.systemType));
            children.add(new Property("version", "string", "The version of the standard that is used to operate and communicate.", 0, 1, this.version));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 642893321: {
                    return new Property("systemType", "string", "The standard that is used to operate and communicate.", 0, 1, this.systemType);
                }
                case 351608024: {
                    return new Property("version", "string", "The version of the standard that is used to operate and communicate.", 0, 1, this.version);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    Base[] baseArray;
                    if (this.systemType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.systemType;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    this.systemType = this.castToString(value);
                    return value;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("systemType")) {
                this.systemType = this.castToString(value);
            } else if (name.equals("version")) {
                this.version = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    return this.getSystemTypeElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    return new String[]{"string"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("systemType")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.systemType");
            }
            if (name.equals("version")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.version");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionSpecializationComponent copy() {
            DeviceDefinitionSpecializationComponent dst = new DeviceDefinitionSpecializationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionSpecializationComponent dst) {
            super.copyValues(dst);
            dst.systemType = this.systemType == null ? null : this.systemType.copy();
            dst.version = this.version == null ? null : this.version.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionSpecializationComponent)) {
                return false;
            }
            DeviceDefinitionSpecializationComponent o = (DeviceDefinitionSpecializationComponent)other_;
            return DeviceDefinitionSpecializationComponent.compareDeep(this.systemType, o.systemType, true) && DeviceDefinitionSpecializationComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionSpecializationComponent)) {
                return false;
            }
            DeviceDefinitionSpecializationComponent o = (DeviceDefinitionSpecializationComponent)other_;
            return DeviceDefinitionSpecializationComponent.compareValues(this.systemType, o.systemType, true) && DeviceDefinitionSpecializationComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.systemType, this.version);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.specialization";
        }
    }

    @Block
    public static class DeviceDefinitionDeviceNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The name of the device", formalDefinition="The name of the device.")
        protected StringType name;
        @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="udi-label-name | user-friendly-name | patient-reported-name | manufacturer-name | model-name | other", formalDefinition="The type of deviceName.\nUDILabelName | UserFriendlyName | PatientReportedName | ManufactureDeviceName | ModelName.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-nametype")
        protected Enumeration<DeviceNameType> type;
        private static final long serialVersionUID = 918983440L;

        public DeviceDefinitionDeviceNameComponent() {
        }

        public DeviceDefinitionDeviceNameComponent(StringType name, Enumeration<DeviceNameType> type) {
            this.name = name;
            this.type = type;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionDeviceNameComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public DeviceDefinitionDeviceNameComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public DeviceDefinitionDeviceNameComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Enumeration<DeviceNameType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionDeviceNameComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<DeviceNameType>(new DeviceNameTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDefinitionDeviceNameComponent setTypeElement(Enumeration<DeviceNameType> value) {
            this.type = value;
            return this;
        }

        public DeviceNameType getType() {
            return this.type == null ? null : (DeviceNameType)((Object)this.type.getValue());
        }

        public DeviceDefinitionDeviceNameComponent setType(DeviceNameType value) {
            if (this.type == null) {
                this.type = new Enumeration<DeviceNameType>(new DeviceNameTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "The name of the device.", 0, 1, this.name));
            children.add(new Property(DeviceDefinition.SP_TYPE, "code", "The type of deviceName.\nUDILabelName | UserFriendlyName | PatientReportedName | ManufactureDeviceName | ModelName.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "The name of the device.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property(DeviceDefinition.SP_TYPE, "code", "The type of deviceName.\nUDILabelName | UserFriendlyName | PatientReportedName | ManufactureDeviceName | ModelName.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new DeviceNameTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals(DeviceDefinition.SP_TYPE)) {
                value = new DeviceNameTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.name");
            }
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.type");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionDeviceNameComponent copy() {
            DeviceDefinitionDeviceNameComponent dst = new DeviceDefinitionDeviceNameComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionDeviceNameComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionDeviceNameComponent)) {
                return false;
            }
            DeviceDefinitionDeviceNameComponent o = (DeviceDefinitionDeviceNameComponent)other_;
            return DeviceDefinitionDeviceNameComponent.compareDeep(this.name, o.name, true) && DeviceDefinitionDeviceNameComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionDeviceNameComponent)) {
                return false;
            }
            DeviceDefinitionDeviceNameComponent o = (DeviceDefinitionDeviceNameComponent)other_;
            return DeviceDefinitionDeviceNameComponent.compareValues(this.name, o.name, true) && DeviceDefinitionDeviceNameComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.name, this.type);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.deviceName";
        }
    }

    @Block
    public static class DeviceDefinitionUdiDeviceIdentifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="deviceIdentifier", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The identifier that is to be associated with every Device that references this DeviceDefintiion for the issuer and jurisdication porvided in the DeviceDefinition.udiDeviceIdentifier", formalDefinition="The identifier that is to be associated with every Device that references this DeviceDefintiion for the issuer and jurisdication porvided in the DeviceDefinition.udiDeviceIdentifier.")
        protected StringType deviceIdentifier;
        @Child(name="issuer", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The organization that assigns the identifier algorithm", formalDefinition="The organization that assigns the identifier algorithm.")
        protected UriType issuer;
        @Child(name="jurisdiction", type={UriType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The jurisdiction to which the deviceIdentifier applies", formalDefinition="The jurisdiction to which the deviceIdentifier applies.")
        protected UriType jurisdiction;
        private static final long serialVersionUID = -1577319218L;

        public DeviceDefinitionUdiDeviceIdentifierComponent() {
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent(StringType deviceIdentifier, UriType issuer, UriType jurisdiction) {
            this.deviceIdentifier = deviceIdentifier;
            this.issuer = issuer;
            this.jurisdiction = jurisdiction;
        }

        public StringType getDeviceIdentifierElement() {
            if (this.deviceIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionUdiDeviceIdentifierComponent.deviceIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.deviceIdentifier = new StringType();
                }
            }
            return this.deviceIdentifier;
        }

        public boolean hasDeviceIdentifierElement() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public boolean hasDeviceIdentifier() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setDeviceIdentifierElement(StringType value) {
            this.deviceIdentifier = value;
            return this;
        }

        public String getDeviceIdentifier() {
            return this.deviceIdentifier == null ? null : (String)this.deviceIdentifier.getValue();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setDeviceIdentifier(String value) {
            if (this.deviceIdentifier == null) {
                this.deviceIdentifier = new StringType();
            }
            this.deviceIdentifier.setValue(value);
            return this;
        }

        public UriType getIssuerElement() {
            if (this.issuer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionUdiDeviceIdentifierComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuer = new UriType();
                }
            }
            return this.issuer;
        }

        public boolean hasIssuerElement() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public boolean hasIssuer() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setIssuerElement(UriType value) {
            this.issuer = value;
            return this;
        }

        public String getIssuer() {
            return this.issuer == null ? null : (String)this.issuer.getValue();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setIssuer(String value) {
            if (this.issuer == null) {
                this.issuer = new UriType();
            }
            this.issuer.setValue(value);
            return this;
        }

        public UriType getJurisdictionElement() {
            if (this.jurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionUdiDeviceIdentifierComponent.jurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.jurisdiction = new UriType();
                }
            }
            return this.jurisdiction;
        }

        public boolean hasJurisdictionElement() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public boolean hasJurisdiction() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setJurisdictionElement(UriType value) {
            this.jurisdiction = value;
            return this;
        }

        public String getJurisdiction() {
            return this.jurisdiction == null ? null : (String)this.jurisdiction.getValue();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setJurisdiction(String value) {
            if (this.jurisdiction == null) {
                this.jurisdiction = new UriType();
            }
            this.jurisdiction.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("deviceIdentifier", "string", "The identifier that is to be associated with every Device that references this DeviceDefintiion for the issuer and jurisdication porvided in the DeviceDefinition.udiDeviceIdentifier.", 0, 1, this.deviceIdentifier));
            children.add(new Property("issuer", "uri", "The organization that assigns the identifier algorithm.", 0, 1, this.issuer));
            children.add(new Property("jurisdiction", "uri", "The jurisdiction to which the deviceIdentifier applies.", 0, 1, this.jurisdiction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1322005407: {
                    return new Property("deviceIdentifier", "string", "The identifier that is to be associated with every Device that references this DeviceDefintiion for the issuer and jurisdication porvided in the DeviceDefinition.udiDeviceIdentifier.", 0, 1, this.deviceIdentifier);
                }
                case -1179159879: {
                    return new Property("issuer", "uri", "The organization that assigns the identifier algorithm.", 0, 1, this.issuer);
                }
                case -507075711: {
                    return new Property("jurisdiction", "uri", "The jurisdiction to which the deviceIdentifier applies.", 0, 1, this.jurisdiction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    Base[] baseArray;
                    if (this.deviceIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.deviceIdentifier;
                    }
                    return baseArray;
                }
                case -1179159879: {
                    Base[] baseArray;
                    if (this.issuer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.issuer;
                    }
                    return baseArray;
                }
                case -507075711: {
                    Base[] baseArray;
                    if (this.jurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.jurisdiction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    this.deviceIdentifier = this.castToString(value);
                    return value;
                }
                case -1179159879: {
                    this.issuer = this.castToUri(value);
                    return value;
                }
                case -507075711: {
                    this.jurisdiction = this.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                this.deviceIdentifier = this.castToString(value);
            } else if (name.equals("issuer")) {
                this.issuer = this.castToUri(value);
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = this.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    return this.getDeviceIdentifierElement();
                }
                case -1179159879: {
                    return this.getIssuerElement();
                }
                case -507075711: {
                    return this.getJurisdictionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    return new String[]{"string"};
                }
                case -1179159879: {
                    return new String[]{"uri"};
                }
                case -507075711: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.deviceIdentifier");
            }
            if (name.equals("issuer")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.issuer");
            }
            if (name.equals("jurisdiction")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.jurisdiction");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionUdiDeviceIdentifierComponent copy() {
            DeviceDefinitionUdiDeviceIdentifierComponent dst = new DeviceDefinitionUdiDeviceIdentifierComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionUdiDeviceIdentifierComponent dst) {
            super.copyValues(dst);
            dst.deviceIdentifier = this.deviceIdentifier == null ? null : this.deviceIdentifier.copy();
            dst.issuer = this.issuer == null ? null : this.issuer.copy();
            dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionUdiDeviceIdentifierComponent)) {
                return false;
            }
            DeviceDefinitionUdiDeviceIdentifierComponent o = (DeviceDefinitionUdiDeviceIdentifierComponent)other_;
            return DeviceDefinitionUdiDeviceIdentifierComponent.compareDeep(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceDefinitionUdiDeviceIdentifierComponent.compareDeep(this.issuer, o.issuer, true) && DeviceDefinitionUdiDeviceIdentifierComponent.compareDeep(this.jurisdiction, o.jurisdiction, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionUdiDeviceIdentifierComponent)) {
                return false;
            }
            DeviceDefinitionUdiDeviceIdentifierComponent o = (DeviceDefinitionUdiDeviceIdentifierComponent)other_;
            return DeviceDefinitionUdiDeviceIdentifierComponent.compareValues(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceDefinitionUdiDeviceIdentifierComponent.compareValues(this.issuer, o.issuer, true) && DeviceDefinitionUdiDeviceIdentifierComponent.compareValues(this.jurisdiction, o.jurisdiction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.deviceIdentifier, this.issuer, this.jurisdiction);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.udiDeviceIdentifier";
        }
    }

    public static class DeviceNameTypeEnumFactory
    implements EnumFactory<DeviceNameType> {
        @Override
        public DeviceNameType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("udi-label-name".equals(codeString)) {
                return DeviceNameType.UDILABELNAME;
            }
            if ("user-friendly-name".equals(codeString)) {
                return DeviceNameType.USERFRIENDLYNAME;
            }
            if ("patient-reported-name".equals(codeString)) {
                return DeviceNameType.PATIENTREPORTEDNAME;
            }
            if ("manufacturer-name".equals(codeString)) {
                return DeviceNameType.MANUFACTURERNAME;
            }
            if ("model-name".equals(codeString)) {
                return DeviceNameType.MODELNAME;
            }
            if ("other".equals(codeString)) {
                return DeviceNameType.OTHER;
            }
            throw new IllegalArgumentException("Unknown DeviceNameType code '" + codeString + "'");
        }

        public Enumeration<DeviceNameType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceNameType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("udi-label-name".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.UDILABELNAME);
            }
            if ("user-friendly-name".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.USERFRIENDLYNAME);
            }
            if ("patient-reported-name".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.PATIENTREPORTEDNAME);
            }
            if ("manufacturer-name".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.MANUFACTURERNAME);
            }
            if ("model-name".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.MODELNAME);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<DeviceNameType>(this, DeviceNameType.OTHER);
            }
            throw new FHIRException("Unknown DeviceNameType code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceNameType code) {
            if (code == DeviceNameType.UDILABELNAME) {
                return "udi-label-name";
            }
            if (code == DeviceNameType.USERFRIENDLYNAME) {
                return "user-friendly-name";
            }
            if (code == DeviceNameType.PATIENTREPORTEDNAME) {
                return "patient-reported-name";
            }
            if (code == DeviceNameType.MANUFACTURERNAME) {
                return "manufacturer-name";
            }
            if (code == DeviceNameType.MODELNAME) {
                return "model-name";
            }
            if (code == DeviceNameType.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceNameType code) {
            return code.getSystem();
        }
    }

    public static enum DeviceNameType {
        UDILABELNAME,
        USERFRIENDLYNAME,
        PATIENTREPORTEDNAME,
        MANUFACTURERNAME,
        MODELNAME,
        OTHER,
        NULL;


        public static DeviceNameType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("udi-label-name".equals(codeString)) {
                return UDILABELNAME;
            }
            if ("user-friendly-name".equals(codeString)) {
                return USERFRIENDLYNAME;
            }
            if ("patient-reported-name".equals(codeString)) {
                return PATIENTREPORTEDNAME;
            }
            if ("manufacturer-name".equals(codeString)) {
                return MANUFACTURERNAME;
            }
            if ("model-name".equals(codeString)) {
                return MODELNAME;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceNameType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case UDILABELNAME: {
                    return "udi-label-name";
                }
                case USERFRIENDLYNAME: {
                    return "user-friendly-name";
                }
                case PATIENTREPORTEDNAME: {
                    return "patient-reported-name";
                }
                case MANUFACTURERNAME: {
                    return "manufacturer-name";
                }
                case MODELNAME: {
                    return "model-name";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case UDILABELNAME: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case USERFRIENDLYNAME: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case PATIENTREPORTEDNAME: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case MANUFACTURERNAME: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case MODELNAME: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/device-nametype";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case UDILABELNAME: {
                    return "UDI Label name.";
                }
                case USERFRIENDLYNAME: {
                    return "User Friendly name.";
                }
                case PATIENTREPORTEDNAME: {
                    return "Patient Reported name.";
                }
                case MANUFACTURERNAME: {
                    return "Manufacturer name.";
                }
                case MODELNAME: {
                    return "Model name.";
                }
                case OTHER: {
                    return "other.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case UDILABELNAME: {
                    return "UDI Label name";
                }
                case USERFRIENDLYNAME: {
                    return "User Friendly name";
                }
                case PATIENTREPORTEDNAME: {
                    return "Patient Reported name";
                }
                case MANUFACTURERNAME: {
                    return "Manufacturer name";
                }
                case MODELNAME: {
                    return "Model name";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

