/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.io.Reader;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDetectionUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(XmlDetectionUtil.class);
    private static Boolean ourStaxPresent;

    public static boolean isStaxPresent() {
        Boolean retVal = ourStaxPresent;
        if (retVal == null) {
            try {
                Class.forName("javax.xml.stream.events.XMLEvent");
                Class<?> xmlUtilClazz = Class.forName("ca.uhn.fhir.util.XmlUtil");
                xmlUtilClazz.getMethod("createXmlReader", Reader.class).invoke(xmlUtilClazz, new StringReader(""));
                ourStaxPresent = Boolean.TRUE;
                retVal = Boolean.TRUE;
            }
            catch (Throwable t) {
                ourLog.info("StAX not detected on classpath, XML processing will be disabled");
                ourStaxPresent = Boolean.FALSE;
                retVal = Boolean.FALSE;
            }
        }
        return retVal;
    }
}

