/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.tls;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.tls.KeyStoreInfo;
import ca.uhn.fhir.tls.PathType;
import ca.uhn.fhir.tls.StoreInfo;
import ca.uhn.fhir.tls.TlsAuthentication;
import ca.uhn.fhir.tls.TrustStoreInfo;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;

public class TlsAuthenticationSvc {
    private TlsAuthenticationSvc() {
    }

    public static SSLContext createSslContext(@Nonnull TlsAuthentication theTlsAuthentication) {
        Validate.notNull(theTlsAuthentication, "theTlsAuthentication cannot be null", new Object[0]);
        try {
            SSLContextBuilder contextBuilder = SSLContexts.custom();
            if (theTlsAuthentication.getKeyStoreInfo().isPresent()) {
                KeyStoreInfo keyStoreInfo = theTlsAuthentication.getKeyStoreInfo().get();
                PrivateKeyStrategy privateKeyStrategy = null;
                if (StringUtils.isNotBlank(keyStoreInfo.getAlias())) {
                    privateKeyStrategy = (aliases, socket) -> keyStoreInfo.getAlias();
                }
                KeyStore keyStore = TlsAuthenticationSvc.createKeyStore(keyStoreInfo);
                contextBuilder.loadKeyMaterial(keyStore, keyStoreInfo.getKeyPass(), privateKeyStrategy);
            }
            if (theTlsAuthentication.getTrustStoreInfo().isPresent()) {
                TrustStoreInfo trustStoreInfo = theTlsAuthentication.getTrustStoreInfo().get();
                KeyStore trustStore = TlsAuthenticationSvc.createKeyStore(trustStoreInfo);
                contextBuilder.loadTrustMaterial(trustStore, TrustSelfSignedStrategy.INSTANCE);
            }
            return contextBuilder.build();
        }
        catch (Exception e) {
            throw new TlsAuthenticationException(Msg.code(2102) + "Failed to create SSLContext", e);
        }
    }

    public static KeyStore createKeyStore(StoreInfo theStoreInfo) {
        try {
            KeyStore keyStore = KeyStore.getInstance(theStoreInfo.getType().toString());
            if (PathType.RESOURCE.equals((Object)theStoreInfo.getPathType())) {
                try (InputStream inputStream2 = TlsAuthenticationSvc.class.getResourceAsStream(theStoreInfo.getFilePath());){
                    TlsAuthenticationSvc.validateKeyStoreExists(inputStream2);
                    keyStore.load(inputStream2, theStoreInfo.getStorePass());
                }
            }
            if (PathType.FILE.equals((Object)theStoreInfo.getPathType())) {
                try (FileInputStream inputStream3 = new FileInputStream(theStoreInfo.getFilePath());){
                    TlsAuthenticationSvc.validateKeyStoreExists(inputStream3);
                    keyStore.load(inputStream3, theStoreInfo.getStorePass());
                }
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new TlsAuthenticationException(Msg.code(2103) + "Failed to create KeyStore", e);
        }
    }

    public static void validateKeyStoreExists(InputStream theInputStream) {
        if (theInputStream == null) {
            throw new TlsAuthenticationException(Msg.code(2116) + "Keystore does not exists");
        }
    }

    public static X509TrustManager createTrustManager(Optional<TrustStoreInfo> theTrustStoreInfo) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (theTrustStoreInfo.isEmpty()) {
                trustManagerFactory.init((KeyStore)null);
            } else {
                TrustStoreInfo trustStoreInfo = theTrustStoreInfo.get();
                KeyStore trustStore = TlsAuthenticationSvc.createKeyStore(trustStoreInfo);
                trustManagerFactory.init(trustStore);
            }
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManager;
            }
            throw new TlsAuthenticationException(Msg.code(2104) + "Could not find X509TrustManager");
        }
        catch (Exception e) {
            throw new TlsAuthenticationException(Msg.code(2105) + "Failed to create X509TrustManager");
        }
    }

    public static HostnameVerifier createHostnameVerifier(Optional<TrustStoreInfo> theTrustStoreInfo) {
        return theTrustStoreInfo.isPresent() ? new DefaultHostnameVerifier() : new NoopHostnameVerifier();
    }

    public static class TlsAuthenticationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TlsAuthenticationException(String theMessage, Throwable theCause) {
            super(theMessage, theCause);
        }

        public TlsAuthenticationException(String theMessage) {
            super(theMessage);
        }
    }
}

