/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.BaseOutcomeReturningMethodBindingWithResourceParam;
import ca.uhn.fhir.rest.client.method.HttpPutClientInvocation;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class UpdateMethodBinding
extends BaseOutcomeReturningMethodBindingWithResourceParam {
    private Integer myIdParameterIndex;

    public UpdateMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, Update.class, theProvider);
        this.myIdParameterIndex = ParameterUtil.findIdParameterIndex(theMethod, this.getContext());
    }

    @Override
    protected BaseHttpClientInvocation createClientInvocation(Object[] theArgs, IBaseResource theResource) {
        IIdType idDt = (IIdType)theArgs[this.myIdParameterIndex];
        if (idDt == null) {
            throw new NullPointerException(Msg.code(1447) + "ID can not be null");
        }
        FhirContext context = this.getContext();
        HttpPutClientInvocation retVal = MethodUtil.createUpdateInvocation(theResource, null, idDt, context);
        for (int idx = 0; idx < theArgs.length; ++idx) {
            IParameter nextParam = this.getParameters().get(idx);
            nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
        }
        return retVal;
    }

    @Override
    protected String getMatchingOperation() {
        return null;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.UPDATE;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.PUT);
    }

    @Override
    protected void validateResourceIdAndUrlIdForNonConditionalOperation(IBaseResource theResource, String theResourceId, String theUrlId, String theMatchUrl) {
        if (StringUtils.isBlank(theMatchUrl)) {
            if (StringUtils.isBlank(theUrlId)) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBindingWithResourceParam.class, "noIdInUrlForUpdate", new Object[0]);
                throw new InvalidRequestException(Msg.code(1448) + msg);
            }
            if (StringUtils.isBlank(theResourceId)) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBindingWithResourceParam.class, "noIdInBodyForUpdate", new Object[0]);
                throw new InvalidRequestException(Msg.code(1449) + msg);
            }
            if (!theResourceId.equals(theUrlId)) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBindingWithResourceParam.class, "incorrectIdForUpdate", theResourceId, theUrlId);
                throw new InvalidRequestException(Msg.code(1450) + msg);
            }
        } else {
            theResource.setId((IIdType)null);
        }
    }
}

