/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.client.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class HistoryMethodBinding
extends BaseResourceReturningMethodBinding {
    private final Integer myIdParamIndex;
    private String myResourceName;
    private final RestOperationTypeEnum myResourceOperationType;

    public HistoryMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(HistoryMethodBinding.toReturnType(theMethod, theProvider), theMethod, theContext, theProvider);
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex(theMethod, this.getContext());
        History historyAnnotation = theMethod.getAnnotation(History.class);
        Class<? extends IBaseResource> type = historyAnnotation.type();
        this.myResourceOperationType = Modifier.isInterface(type.getModifiers()) ? RestOperationTypeEnum.HISTORY_SYSTEM : (this.myIdParamIndex != null ? RestOperationTypeEnum.HISTORY_INSTANCE : RestOperationTypeEnum.HISTORY_TYPE);
        this.myResourceName = type != IBaseResource.class && type != IResource.class ? theContext.getResourceType(type) : null;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return this.myResourceOperationType;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.HISTORY;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        IIdType id = null;
        String resourceName = this.myResourceName;
        if (this.myIdParamIndex != null && ((id = (IIdType)theArgs[this.myIdParamIndex]) == null || StringUtils.isBlank(id.getValue()))) {
            throw new NullPointerException(Msg.code(1441) + "ID can not be null");
        }
        String historyId = id != null ? id.getIdPart() : null;
        HttpGetClientInvocation retVal = HistoryMethodBinding.createHistoryInvocation(this.getContext(), resourceName, historyId, null, null, null);
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], retVal.getParameters(), null);
            }
        }
        return retVal;
    }

    public static HttpGetClientInvocation createHistoryInvocation(FhirContext theContext, String theResourceName, String theId, IPrimitiveType<Date> theSince, Integer theLimit, DateRangeParam theAt) {
        StringBuilder b = new StringBuilder();
        if (theResourceName != null) {
            b.append(theResourceName);
            if (StringUtils.isNotBlank(theId)) {
                b.append('/');
                b.append(theId);
            }
        }
        if (b.length() > 0) {
            b.append('/');
        }
        b.append("_history");
        boolean haveParam = false;
        if (theSince != null && !theSince.isEmpty()) {
            haveParam = true;
            b.append('?').append("_since").append('=').append(theSince.getValueAsString());
        }
        if (theLimit != null) {
            b.append(haveParam ? (char)'&' : '?');
            haveParam = true;
            b.append("_count").append('=').append(theLimit);
        }
        if (theAt != null) {
            for (DateParam next : theAt.getValuesAsQueryTokens()) {
                b.append(haveParam ? (char)'&' : '?');
                haveParam = true;
                b.append("_at");
                b.append("=");
                b.append(next.getValueAsQueryToken(theContext));
            }
        }
        HttpGetClientInvocation retVal = new HttpGetClientInvocation(theContext, b.toString());
        return retVal;
    }

    private static Class<? extends IBaseResource> toReturnType(Method theMethod, Object theProvider) {
        History historyAnnotation = theMethod.getAnnotation(History.class);
        Class<? extends IBaseResource> type = historyAnnotation.type();
        if (type != IBaseResource.class && type != IResource.class) {
            return type;
        }
        return null;
    }
}

