/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.impl;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.exceptions.FhirClientConnectionException;
import ca.uhn.fhir.rest.client.exceptions.FhirClientInappropriateForServerException;
import ca.uhn.fhir.rest.client.impl.ClientInvocationHandlerFactory;
import ca.uhn.fhir.rest.client.impl.GenericClient;
import ca.uhn.fhir.rest.client.method.BaseMethodBinding;
import ca.uhn.fhir.util.FhirTerser;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestfulClientFactory
implements IRestfulClientFactory {
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulClientFactory.class);
    private final Set<String> myValidatedServerBaseUrls = Collections.synchronizedSet(new HashSet());
    private int myConnectionRequestTimeout = 10000;
    private int myConnectTimeout = 10000;
    private FhirContext myContext;
    private final Map<Class<? extends IRestfulClient>, ClientInvocationHandlerFactory> myInvocationHandlers = new HashMap<Class<? extends IRestfulClient>, ClientInvocationHandlerFactory>();
    private ServerValidationModeEnum myServerValidationMode = DEFAULT_SERVER_VALIDATION_MODE;
    private int mySocketTimeout = 10000;
    private String myProxyUsername;
    private String myProxyPassword;
    private int myPoolMaxTotal = 20;
    private int myPoolMaxPerRoute = 20;

    public RestfulClientFactory() {
    }

    public RestfulClientFactory(FhirContext theFhirContext) {
        this.myContext = theFhirContext;
    }

    @Override
    public synchronized int getConnectionRequestTimeout() {
        return this.myConnectionRequestTimeout;
    }

    @Override
    public synchronized int getConnectTimeout() {
        return this.myConnectTimeout;
    }

    protected synchronized String getProxyUsername() {
        return this.myProxyUsername;
    }

    protected synchronized String getProxyPassword() {
        return this.myProxyPassword;
    }

    @Override
    public synchronized void setProxyCredentials(String theUsername, String thePassword) {
        this.myProxyUsername = theUsername;
        this.myProxyPassword = thePassword;
    }

    @Override
    public synchronized ServerValidationModeEnum getServerValidationMode() {
        return this.myServerValidationMode;
    }

    @Override
    public synchronized int getSocketTimeout() {
        return this.mySocketTimeout;
    }

    @Override
    public synchronized int getPoolMaxTotal() {
        return this.myPoolMaxTotal;
    }

    @Override
    public synchronized int getPoolMaxPerRoute() {
        return this.myPoolMaxPerRoute;
    }

    private <T extends IRestfulClient> T instantiateProxy(Class<T> theClientType, InvocationHandler theInvocationHandler) {
        return (T)((IRestfulClient)Proxy.newProxyInstance(theClientType.getClassLoader(), new Class[]{theClientType}, theInvocationHandler));
    }

    @Override
    public synchronized <T extends IRestfulClient> T newClient(Class<T> theClientType, String theServerBase) {
        this.validateConfigured();
        if (!theClientType.isInterface()) {
            throw new ConfigurationException(Msg.code(1354) + theClientType.getCanonicalName() + " is not an interface");
        }
        ClientInvocationHandlerFactory invocationHandler = this.myInvocationHandlers.get(theClientType);
        if (invocationHandler == null) {
            IHttpClient httpClient = this.getHttpClient(theServerBase);
            invocationHandler = new ClientInvocationHandlerFactory(httpClient, this.myContext, theServerBase, theClientType);
            for (Method nextMethod : theClientType.getMethods()) {
                BaseMethodBinding<?> binding = BaseMethodBinding.bindMethod(nextMethod, this.myContext, null);
                invocationHandler.addBinding(nextMethod, binding);
            }
            this.myInvocationHandlers.put(theClientType, invocationHandler);
        }
        return this.instantiateProxy(theClientType, invocationHandler.newInvocationHandler(this));
    }

    protected void validateConfigured() {
        if (this.getFhirContext() == null) {
            throw new IllegalStateException(Msg.code(1355) + this.getClass().getSimpleName() + " does not have FhirContext defined. This must be set via " + this.getClass().getSimpleName() + "#setFhirContext(FhirContext)");
        }
    }

    @Override
    public synchronized IGenericClient newGenericClient(String theServerBase) {
        this.validateConfigured();
        IHttpClient httpClient = this.getHttpClient(theServerBase);
        return new GenericClient(this.myContext, httpClient, theServerBase, this);
    }

    private String normalizeBaseUrlForMap(String theServerBase) {
        Object serverBase = theServerBase;
        if (!((String)serverBase).endsWith("/")) {
            serverBase = (String)serverBase + "/";
        }
        return serverBase;
    }

    @Override
    public synchronized void setConnectionRequestTimeout(int theConnectionRequestTimeout) {
        this.myConnectionRequestTimeout = theConnectionRequestTimeout;
        this.resetHttpClient();
    }

    @Override
    public synchronized void setConnectTimeout(int theConnectTimeout) {
        this.myConnectTimeout = theConnectTimeout;
        this.resetHttpClient();
    }

    public void setFhirContext(FhirContext theContext) {
        if (this.myContext != null && this.myContext != theContext) {
            throw new IllegalStateException(Msg.code(1356) + "RestfulClientFactory instance is already associated with one FhirContext. RestfulClientFactory instances can not be shared.");
        }
        this.myContext = theContext;
    }

    public FhirContext getFhirContext() {
        return this.myContext;
    }

    @Override
    public synchronized void setServerValidationMode(ServerValidationModeEnum theServerValidationMode) {
        Validate.notNull(theServerValidationMode, "theServerValidationMode may not be null", new Object[0]);
        this.myServerValidationMode = theServerValidationMode;
    }

    @Override
    public synchronized void setSocketTimeout(int theSocketTimeout) {
        this.mySocketTimeout = theSocketTimeout;
        this.resetHttpClient();
    }

    @Override
    public synchronized void setPoolMaxTotal(int thePoolMaxTotal) {
        this.myPoolMaxTotal = thePoolMaxTotal;
        this.resetHttpClient();
    }

    @Override
    public synchronized void setPoolMaxPerRoute(int thePoolMaxPerRoute) {
        this.myPoolMaxPerRoute = thePoolMaxPerRoute;
        this.resetHttpClient();
    }

    @Override
    @Deprecated
    public synchronized ServerValidationModeEnum getServerValidationModeEnum() {
        return this.getServerValidationMode();
    }

    @Override
    @Deprecated
    public synchronized void setServerValidationModeEnum(ServerValidationModeEnum theServerValidationMode) {
        this.setServerValidationMode(theServerValidationMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateServerBaseIfConfiguredToDoSo(String theServerBase, IHttpClient theHttpClient, IRestfulClient theClient) {
        String serverBase = this.normalizeBaseUrlForMap(theServerBase);
        switch (this.getServerValidationMode()) {
            case NEVER: {
                break;
            }
            case ONCE: {
                if (this.myValidatedServerBaseUrls.contains(serverBase)) break;
                Set<String> set = this.myValidatedServerBaseUrls;
                synchronized (set) {
                    if (!this.myValidatedServerBaseUrls.contains(serverBase)) {
                        this.myValidatedServerBaseUrls.add(serverBase);
                        this.validateServerBase(serverBase, theHttpClient, theClient);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateServerBase(String theServerBase, IHttpClient theHttpClient, IRestfulClient theClient) {
        FhirVersionEnum contextFhirVersion;
        IBaseResource conformance;
        block25: {
            GenericClient client = new GenericClient(this.myContext, theHttpClient, theServerBase, this);
            client.setInterceptorService(theClient.getInterceptorService());
            client.setEncoding(theClient.getEncoding());
            client.setDontValidateConformance(true);
            try {
                Class implementingClass;
                String capabilityStatementResourceName = "CapabilityStatement";
                if (this.myContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                    capabilityStatementResourceName = "Conformance";
                }
                try {
                    implementingClass = this.myContext.getResourceDefinition(capabilityStatementResourceName).getImplementingClass();
                }
                catch (DataFormatException e) {
                    if (!this.myContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                        capabilityStatementResourceName = "Conformance";
                        implementingClass = this.myContext.getResourceDefinition(capabilityStatementResourceName).getImplementingClass();
                    }
                    throw e;
                }
                try {
                    conformance = (IBaseResource)client.fetchConformance().ofType(implementingClass).execute();
                }
                catch (FhirClientConnectionException e) {
                    if (!this.myContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3) && e.getCause() instanceof DataFormatException) {
                        capabilityStatementResourceName = "CapabilityStatement";
                        implementingClass = this.myContext.getResourceDefinition(capabilityStatementResourceName).getImplementingClass();
                        conformance = (IBaseResource)client.fetchConformance().ofType(implementingClass).execute();
                        break block25;
                    }
                    throw e;
                }
            }
            catch (FhirClientConnectionException e) {
                String msg = this.myContext.getLocalizer().getMessage(RestfulClientFactory.class, "failedToRetrieveConformance", theServerBase + "metadata");
                throw new FhirClientConnectionException(Msg.code(1357) + msg, (Throwable)e);
            }
        }
        FhirTerser t = this.myContext.newTerser();
        String serverFhirVersionString = null;
        Object value = t.getSingleValueOrNull(conformance, "fhirVersion");
        if (value instanceof IPrimitiveType) {
            serverFhirVersionString = ((IPrimitiveType)value).getValueAsString();
        }
        FhirVersionEnum serverFhirVersionEnum = null;
        if (StringUtils.isBlank(serverFhirVersionString)) {
            ourLog.debug("Server conformance statement does not indicate the FHIR version");
        } else if (serverFhirVersionString.equals(FhirVersionEnum.DSTU2.getFhirVersionString())) {
            serverFhirVersionEnum = FhirVersionEnum.DSTU2;
        } else if (serverFhirVersionString.equals(FhirVersionEnum.DSTU2_1.getFhirVersionString())) {
            serverFhirVersionEnum = FhirVersionEnum.DSTU2_1;
        } else if (serverFhirVersionString.equals(FhirVersionEnum.DSTU3.getFhirVersionString())) {
            serverFhirVersionEnum = FhirVersionEnum.DSTU3;
        } else if (serverFhirVersionString.equals(FhirVersionEnum.R4.getFhirVersionString())) {
            serverFhirVersionEnum = FhirVersionEnum.R4;
        } else {
            ourLog.debug("Server conformance statement indicates unknown FHIR version: {}", (Object)serverFhirVersionString);
        }
        if (serverFhirVersionEnum != null && !(contextFhirVersion = this.myContext.getVersion().getVersion()).isEquivalentTo(serverFhirVersionEnum)) {
            throw new FhirClientInappropriateForServerException(Msg.code(1358) + this.myContext.getLocalizer().getMessage(RestfulClientFactory.class, "wrongVersionInConformance", new Object[]{theServerBase + "metadata", serverFhirVersionString, serverFhirVersionEnum, contextFhirVersion}));
        }
        String serverBase = this.normalizeBaseUrlForMap(theServerBase);
        if (this.myValidatedServerBaseUrls.contains(serverBase)) {
            return;
        }
        Set<String> set = this.myValidatedServerBaseUrls;
        synchronized (set) {
            this.myValidatedServerBaseUrls.add(serverBase);
        }
    }

    protected abstract IHttpClient getHttpClient(String var1);

    protected abstract void resetHttpClient();
}

