/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.i18n.Msg;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Include
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean myImmutable;
    private boolean myIterate;
    private String myValue;
    private String myParamType;
    private String myParamName;
    private String myParamTargetType;

    public Include(String theValue) {
        this(theValue, false);
    }

    public Include(String theValue, boolean theIterate) {
        this(theValue, theIterate, false);
    }

    public Include(String theValue, boolean theIterate, boolean theImmutable) {
        this.setValue(theValue);
        this.myIterate = theIterate;
        this.myImmutable = theImmutable;
    }

    public Include asNonRecursive() {
        return new Include(this.myValue, false);
    }

    public Include asRecursive() {
        return new Include(this.myValue, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Include other = (Include)obj;
        if (this.myIterate != other.myIterate) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    public String getParamType() {
        return this.myParamType;
    }

    public String getParamName() {
        return this.myParamName;
    }

    public String getParamTargetType() {
        return this.myParamTargetType;
    }

    public String getValue() {
        return this.myValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myIterate ? 1231 : 1237);
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean isLocked() {
        return this.myImmutable;
    }

    public boolean isRecurse() {
        return this.myIterate;
    }

    public Include setRecurse(boolean theRecurse) {
        this.myIterate = theRecurse;
        return this;
    }

    public void setValue(String theValue) {
        String paramTargetType;
        String paramName;
        String paramType;
        if (this.myImmutable) {
            throw new IllegalStateException(Msg.code(1888) + "Can not change the value of this include");
        }
        String value = StringUtils.defaultString(theValue);
        int firstColon = value.indexOf(58);
        if (firstColon == -1 || firstColon == value.length() - 1) {
            paramType = null;
            paramName = null;
            paramTargetType = null;
        } else {
            paramType = value.substring(0, firstColon);
            int secondColon = value.indexOf(58, firstColon + 1);
            if (secondColon == -1) {
                paramName = value.substring(firstColon + 1);
                paramTargetType = null;
            } else {
                paramName = value.substring(firstColon + 1, secondColon);
                paramTargetType = value.substring(secondColon + 1);
            }
        }
        this.myParamType = paramType;
        this.myParamName = paramName;
        this.myParamTargetType = paramTargetType;
        this.myValue = theValue;
    }

    public Include toLocked() {
        Include retVal = new Include(this.myValue, this.myIterate, true);
        return retVal;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.append("value", this.myValue);
        builder.append("iterate", this.myIterate);
        return builder.toString();
    }

    public Include withType(String theResourceType) {
        StringBuilder b = new StringBuilder();
        String paramType = this.getParamType();
        String paramName = this.getParamName();
        if (StringUtils.isBlank(paramType) || StringUtils.isBlank(paramName)) {
            throw new IllegalStateException(Msg.code(1889) + "This include does not contain a value in the format [ResourceType]:[paramName]");
        }
        b.append(paramType);
        b.append(":");
        b.append(paramName);
        if (StringUtils.isNotBlank(theResourceType)) {
            b.append(':');
            b.append(theResourceType);
        }
        Include retVal = new Include(b.toString(), this.myIterate, this.myImmutable);
        return retVal;
    }
}

