/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology.translate;

import au.csiro.pathling.fhir.ParametersUtils;
import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.fhirpath.encoding.ImmutableCoding;
import au.csiro.pathling.terminology.TerminologyOperation;
import au.csiro.pathling.terminology.TerminologyParameters;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.caching.CacheableListCollector;
import au.csiro.pathling.terminology.translate.TranslateParameters;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.codesystems.ConceptMapEquivalence;

public class TranslateExecutor
implements TerminologyOperation<Parameters, ArrayList<TerminologyService.Translation>> {
    @Nonnull
    private final TerminologyClient terminologyClient;
    @Nonnull
    private final TranslateParameters parameters;

    public TranslateExecutor(@Nonnull TerminologyClient terminologyClient, @Nonnull TranslateParameters parameters) {
        this.terminologyClient = terminologyClient;
        this.parameters = parameters;
    }

    @Override
    @Nonnull
    public Optional<ArrayList<TerminologyService.Translation>> validate() {
        ImmutableCoding coding = this.parameters.getCoding();
        if (Objects.isNull(coding.getSystem()) || Objects.isNull(coding.getCode())) {
            return Optional.of(new ArrayList());
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildRequest() {
        String conceptMapUrl = this.parameters.getConceptMapUrl();
        ImmutableCoding coding = this.parameters.getCoding();
        boolean reverse = this.parameters.isReverse();
        String target = this.parameters.getTarget();
        return this.terminologyClient.buildTranslate(TerminologyParameters.required(UriType::new, conceptMapUrl), TerminologyParameters.required(UriType::new, coding.getSystem()), TerminologyParameters.optional(StringType::new, coding.getVersion()), TerminologyParameters.required(CodeType::new, coding.getCode()), new BooleanType(reverse), TerminologyParameters.optional(UriType::new, target));
    }

    @Override
    @Nonnull
    public ArrayList<TerminologyService.Translation> extractResult(@Nonnull Parameters response) {
        return TranslateExecutor.toTranslations(response);
    }

    @Override
    @Nonnull
    public ArrayList<TerminologyService.Translation> invalidRequestFallback() {
        return new ArrayList<TerminologyService.Translation>();
    }

    @Nonnull
    private static ArrayList<TerminologyService.Translation> toTranslations(@Nonnull Parameters parameters) {
        return (ArrayList)ParametersUtils.toMatchParts(parameters).map(tp -> TerminologyService.Translation.of(ConceptMapEquivalence.fromCode(tp.getEquivalence().getCode()), tp.getConcept())).collect(new CacheableListCollector());
    }
}

