/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.sql.udf;

import au.csiro.pathling.encoders.datatypes.DecimalCustomCoder;
import au.csiro.pathling.errors.InvalidUserInputError;
import au.csiro.pathling.fhirpath.encoding.CodingEncoding;
import au.csiro.pathling.sql.udf.SqlFunction;
import au.csiro.pathling.sql.udf.SqlFunction2;
import au.csiro.pathling.sql.udf.TerminologyUdfHelpers;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.TerminologyServiceFactory;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUdf
implements SqlFunction,
SqlFunction2<Row, String, Object[]> {
    private static final Logger log = LoggerFactory.getLogger(PropertyUdf.class);
    private static final long serialVersionUID = 7605853352299165569L;
    private static final String FUNCTION_BASE_NAME = "property";
    @Nonnull
    public static final Set<Enumerations.FHIRDefinedType> ALLOWED_FHIR_TYPES = ImmutableSet.of(Enumerations.FHIRDefinedType.STRING, Enumerations.FHIRDefinedType.CODE, Enumerations.FHIRDefinedType.INTEGER, Enumerations.FHIRDefinedType.BOOLEAN, Enumerations.FHIRDefinedType.DECIMAL, Enumerations.FHIRDefinedType.DATETIME, new Enumerations.FHIRDefinedType[]{Enumerations.FHIRDefinedType.CODING});
    @Nonnull
    private final Enumerations.FHIRDefinedType propertyType;
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;
    public static final Enumerations.FHIRDefinedType DEFAULT_PROPERTY_TYPE = Enumerations.FHIRDefinedType.STRING;

    private PropertyUdf(@Nonnull TerminologyServiceFactory terminologyServiceFactory, @Nonnull Enumerations.FHIRDefinedType propertyType) {
        if (!ALLOWED_FHIR_TYPES.contains((Object)propertyType)) {
            throw new IllegalArgumentException("PropertyUDF does not support type: " + propertyType);
        }
        this.propertyType = propertyType;
        this.terminologyServiceFactory = terminologyServiceFactory;
    }

    @Override
    public String getName() {
        return PropertyUdf.getNameForType(this.propertyType);
    }

    @Nonnull
    private DataType geElementType() {
        switch (this.propertyType) {
            case STRING: 
            case CODE: 
            case DATETIME: {
                return DataTypes.StringType;
            }
            case INTEGER: {
                return DataTypes.IntegerType;
            }
            case BOOLEAN: {
                return DataTypes.BooleanType;
            }
            case DECIMAL: {
                return DecimalCustomCoder.decimalType();
            }
            case CODING: {
                return CodingEncoding.codingStructType();
            }
        }
        throw new IllegalArgumentException("Cannot map FhirType: " + this.propertyType);
    }

    @Nonnull
    private static Object toObjectValue(@Nonnull Type value) {
        if (value instanceof DateTimeType) {
            return value.primitiveValue();
        }
        return value instanceof PrimitiveType ? ((PrimitiveType)value).getValue() : value;
    }

    @Override
    public DataType getReturnType() {
        return DataTypes.createArrayType((DataType)this.geElementType());
    }

    @Nullable
    protected Object[] doCall(@Nullable Coding coding, @Nullable String propertyCode) {
        if (propertyCode == null || !TerminologyUdfHelpers.isValidCoding(coding)) {
            return null;
        }
        TerminologyService terminologyService = this.terminologyServiceFactory.build();
        List<TerminologyService.PropertyOrDesignation> result = terminologyService.lookup(Objects.requireNonNull(coding), propertyCode);
        return result.stream().filter(s2 -> s2 instanceof TerminologyService.Property).map(s2 -> (TerminologyService.Property)s2).filter(p -> propertyCode.equals(p.getCode())).map(TerminologyService.Property::getValue).filter(v -> this.propertyType.toCode().equals(v.fhirType())).map(PropertyUdf::toObjectValue).toArray(Object[]::new);
    }

    @Nullable
    private Object[] encodeArray(@Nullable Object[] objectRows) {
        if (Objects.nonNull(objectRows) && Enumerations.FHIRDefinedType.CODING.equals((Object)this.propertyType)) {
            return Stream.of(objectRows).map(Coding.class::cast).map(CodingEncoding::encode).toArray(Row[]::new);
        }
        return objectRows;
    }

    @Nullable
    public Object[] call(@Nullable Row codingRow, @Nullable String propertyCode) {
        return this.encodeArray(this.doCall(Objects.nonNull(codingRow) ? CodingEncoding.decode(codingRow) : null, propertyCode));
    }

    @Nonnull
    public static PropertyUdf forType(@Nonnull TerminologyServiceFactory terminologyServiceFactory, @Nonnull Enumerations.FHIRDefinedType propertyType) {
        return new PropertyUdf(terminologyServiceFactory, propertyType);
    }

    @Nonnull
    public static PropertyUdf forClass(@Nonnull TerminologyServiceFactory terminologyServiceFactory, @Nonnull Class<? extends Type> propertyClass) {
        Enumerations.FHIRDefinedType propertyType = Enumerations.FHIRDefinedType.fromCode(propertyClass.getAnnotation(DatatypeDef.class).name());
        return PropertyUdf.forType(terminologyServiceFactory, propertyType);
    }

    @Nonnull
    public static String getNameForType(Enumerations.FHIRDefinedType propertyType) {
        if (!ALLOWED_FHIR_TYPES.contains((Object)propertyType)) {
            throw new InvalidUserInputError(String.format("Type: '%s' is not supported for 'property' udf", propertyType.toCode()));
        }
        return String.format("%s_%s", FUNCTION_BASE_NAME, propertyType.getDisplay());
    }

    @Nonnull
    public static List<PropertyUdf> createAll(@Nonnull TerminologyServiceFactory terminologyServiceFactory) {
        return ALLOWED_FHIR_TYPES.stream().map(t -> PropertyUdf.forType(terminologyServiceFactory, t)).collect(Collectors.toUnmodifiableList());
    }
}

