/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhir;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.PropertyUtils;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;

public final class ParametersUtils {
    public static final String PROPERTY_PART_NAME = "property";
    public static final String DESIGNATION_PART_NAME = "designation";

    private ParametersUtils() {
    }

    private static void setProperty(@Nonnull Object bean, @Nonnull String name, @Nullable Object value) {
        block6: {
            try {
                PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
                if (descriptor == null) break block6;
                Object currentValue = descriptor.getReadMethod().invoke(bean, new Object[0]);
                if (currentValue == null) {
                    if (List.class.isAssignableFrom(descriptor.getPropertyType())) {
                        ArrayList<Object> newList = new ArrayList<Object>();
                        newList.add(value);
                        descriptor.getWriteMethod().invoke(bean, newList);
                    } else {
                        descriptor.getWriteMethod().invoke(bean, value);
                    }
                    break block6;
                }
                if (List.class.isAssignableFrom(descriptor.getPropertyType())) {
                    ((List)currentValue).add(value);
                    break block6;
                }
                throw new IllegalStateException("Overwriting value of singular property: " + name);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Nonnull
    public static <T> T partsToBean(@Nonnull Parameters.ParametersParameterComponent component, @Nonnull Supplier<T> supplier) {
        T result = supplier.get();
        for (Parameters.ParametersParameterComponent p : component.getPart()) {
            if (p.hasValue()) {
                ParametersUtils.setProperty(result, p.getName(), p.getValue());
                continue;
            }
            if (!p.hasPart()) continue;
            ParametersUtils.setProperty(result, p.getName(), ParametersUtils.partsToBean(p, supplier));
        }
        return result;
    }

    public static boolean toBooleanResult(@Nonnull Parameters parameters) {
        return parameters.getParameterBool("result");
    }

    @Nonnull
    public static ConceptSubsumptionOutcome toSubsumptionOutcome(@Nonnull Parameters parameters) {
        return ConceptSubsumptionOutcome.fromCode(parameters.getParameter("outcome").primitiveValue());
    }

    @Nonnull
    private static MatchPart componentToMatchPart(@Nonnull Parameters.ParametersParameterComponent component) {
        return ParametersUtils.partsToBean(component, MatchPart::new);
    }

    @Nonnull
    public static Stream<MatchPart> toMatchParts(@Nonnull Parameters parameters) {
        return ParametersUtils.toBooleanResult(parameters) ? parameters.getParameter().stream().filter(pc -> "match".equals(pc.getName())).map(ParametersUtils::componentToMatchPart) : Stream.empty();
    }

    @Nullable
    private static PropertyPart toProperty(@Nonnull Parameters.ParametersParameterComponent component) {
        if (!component.hasPart()) {
            return new PropertyPart(new CodeType(component.getName()), component.getValue(), null);
        }
        if (PROPERTY_PART_NAME.equals(component.getName())) {
            return ParametersUtils.partsToBean(component, PropertyPart::new);
        }
        return null;
    }

    @Nonnull
    public static Stream<PropertyPart> toProperties(@Nonnull Parameters parameters) {
        return parameters.getParameter().stream().map(ParametersUtils::toProperty).filter(Objects::nonNull);
    }

    @Nonnull
    public static Stream<DesignationPart> toDesignations(@Nonnull Parameters parameters) {
        return parameters.getParameter().stream().filter(c -> c.hasPart() && DESIGNATION_PART_NAME.equals(c.getName())).map(c -> ParametersUtils.partsToBean(c, DesignationPart::new));
    }

    public static class DesignationPart {
        @Nullable
        CodeType language;
        @Nullable
        Coding use;
        @Nonnull
        StringType value;

        @Nullable
        public CodeType getLanguage() {
            return this.language;
        }

        @Nullable
        public Coding getUse() {
            return this.use;
        }

        @Nonnull
        public StringType getValue() {
            return this.value;
        }

        public void setLanguage(@Nullable CodeType language) {
            this.language = language;
        }

        public void setUse(@Nullable Coding use) {
            this.use = use;
        }

        public void setValue(@Nonnull StringType value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DesignationPart)) {
                return false;
            }
            DesignationPart other = (DesignationPart)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CodeType this$language = this.getLanguage();
            CodeType other$language = other.getLanguage();
            if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
                return false;
            }
            Coding this$use = this.getUse();
            Coding other$use = other.getUse();
            if (this$use == null ? other$use != null : !this$use.equals(other$use)) {
                return false;
            }
            StringType this$value = this.getValue();
            StringType other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DesignationPart;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CodeType $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : ((Object)$language).hashCode());
            Coding $use = this.getUse();
            result = result * 59 + ($use == null ? 43 : $use.hashCode());
            StringType $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        public String toString() {
            return "ParametersUtils.DesignationPart(language=" + this.getLanguage() + ", use=" + this.getUse() + ", value=" + this.getValue() + ")";
        }

        public DesignationPart() {
        }

        public DesignationPart(@Nullable CodeType language, @Nullable Coding use, @Nonnull StringType value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.language = language;
            this.use = use;
            this.value = value;
        }
    }

    public static class PropertyPart {
        @Nonnull
        CodeType code;
        @Nullable
        Type value;
        @Nullable
        List<PropertyPart> subproperty;

        @Nonnull
        public CodeType getCode() {
            return this.code;
        }

        @Nullable
        public Type getValue() {
            return this.value;
        }

        @Nullable
        public List<PropertyPart> getSubproperty() {
            return this.subproperty;
        }

        public void setCode(@Nonnull CodeType code) {
            if (code == null) {
                throw new NullPointerException("code is marked non-null but is null");
            }
            this.code = code;
        }

        public void setValue(@Nullable Type value) {
            this.value = value;
        }

        public void setSubproperty(@Nullable List<PropertyPart> subproperty) {
            this.subproperty = subproperty;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyPart)) {
                return false;
            }
            PropertyPart other = (PropertyPart)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CodeType this$code = this.getCode();
            CodeType other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            Type this$value = this.getValue();
            Type other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            List<PropertyPart> this$subproperty = this.getSubproperty();
            List<PropertyPart> other$subproperty = other.getSubproperty();
            return !(this$subproperty == null ? other$subproperty != null : !((Object)this$subproperty).equals(other$subproperty));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertyPart;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CodeType $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            Type $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            List<PropertyPart> $subproperty = this.getSubproperty();
            result = result * 59 + ($subproperty == null ? 43 : ((Object)$subproperty).hashCode());
            return result;
        }

        public String toString() {
            return "ParametersUtils.PropertyPart(code=" + this.getCode() + ", value=" + this.getValue() + ", subproperty=" + this.getSubproperty() + ")";
        }

        public PropertyPart() {
        }

        public PropertyPart(@Nonnull CodeType code, @Nullable Type value, @Nullable List<PropertyPart> subproperty) {
            if (code == null) {
                throw new NullPointerException("code is marked non-null but is null");
            }
            this.code = code;
            this.value = value;
            this.subproperty = subproperty;
        }
    }

    public static class MatchPart {
        @Nonnull
        private Coding concept;
        @Nonnull
        private CodeType equivalence;

        @Nonnull
        public Coding getConcept() {
            return this.concept;
        }

        @Nonnull
        public CodeType getEquivalence() {
            return this.equivalence;
        }

        public void setConcept(@Nonnull Coding concept) {
            if (concept == null) {
                throw new NullPointerException("concept is marked non-null but is null");
            }
            this.concept = concept;
        }

        public void setEquivalence(@Nonnull CodeType equivalence) {
            if (equivalence == null) {
                throw new NullPointerException("equivalence is marked non-null but is null");
            }
            this.equivalence = equivalence;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchPart)) {
                return false;
            }
            MatchPart other = (MatchPart)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Coding this$concept = this.getConcept();
            Coding other$concept = other.getConcept();
            if (this$concept == null ? other$concept != null : !this$concept.equals(other$concept)) {
                return false;
            }
            CodeType this$equivalence = this.getEquivalence();
            CodeType other$equivalence = other.getEquivalence();
            return !(this$equivalence == null ? other$equivalence != null : !this$equivalence.equals(other$equivalence));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MatchPart;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Coding $concept = this.getConcept();
            result = result * 59 + ($concept == null ? 43 : $concept.hashCode());
            CodeType $equivalence = this.getEquivalence();
            result = result * 59 + ($equivalence == null ? 43 : ((Object)$equivalence).hashCode());
            return result;
        }

        public String toString() {
            return "ParametersUtils.MatchPart(concept=" + this.getConcept() + ", equivalence=" + this.getEquivalence() + ")";
        }
    }
}

