/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.encoders;

import au.csiro.pathling.encoders.EncoderBuilder;
import au.csiro.pathling.encoders.datatypes.DataTypeMappings;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import scala.collection.JavaConverters;

public class FhirEncoders {
    private static final Map<EncodersKey, FhirEncoders> ENCODERS = new HashMap<EncodersKey, FhirEncoders>();
    private static final Map<FhirVersionEnum, DataTypeMappings> DATA_TYPE_MAPPINGS = new HashMap<FhirVersionEnum, DataTypeMappings>();
    private static final Map<FhirVersionEnum, FhirContext> FHIR_CONTEXTS = new HashMap<FhirVersionEnum, FhirContext>();
    private final FhirContext context;
    private final DataTypeMappings mappings;
    private final Map<Integer, ExpressionEncoder<?>> encoderCache = new HashMap();
    private final int maxNestingLevel;
    private final Set<String> openTypes;
    private final boolean enableExtensions;

    public FhirEncoders(FhirContext context, DataTypeMappings mappings, int maxNestingLevel, Set<String> openTypes, boolean enableExtensions) {
        this.context = context;
        this.mappings = mappings;
        this.maxNestingLevel = maxNestingLevel;
        this.openTypes = openTypes;
        this.enableExtensions = enableExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FhirContext contextFor(FhirVersionEnum fhirVersion) {
        Map<FhirVersionEnum, FhirContext> map = FHIR_CONTEXTS;
        synchronized (map) {
            FhirContext context = FHIR_CONTEXTS.get((Object)fhirVersion);
            if (context == null) {
                context = new FhirContext(fhirVersion);
                FHIR_CONTEXTS.put(fhirVersion, context);
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DataTypeMappings mappingsFor(FhirVersionEnum fhirVersion) {
        Map<FhirVersionEnum, DataTypeMappings> map = DATA_TYPE_MAPPINGS;
        synchronized (map) {
            DataTypeMappings mappings = DATA_TYPE_MAPPINGS.get((Object)fhirVersion);
            if (mappings == null) {
                if (fhirVersion != FhirVersionEnum.R4) {
                    throw new IllegalArgumentException("Unsupported FHIR version: " + fhirVersion);
                }
                String dataTypesClassName = "au.csiro.pathling.encoders.datatypes.R4DataTypeMappings";
                try {
                    mappings = (DataTypeMappings)Class.forName(dataTypesClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    DATA_TYPE_MAPPINGS.put(fhirVersion, mappings);
                }
                catch (Exception createClassException) {
                    throw new IllegalStateException("Unable to create the data mappings " + dataTypesClassName + ". This is typically because the HAPI FHIR dependencies for the underlying data model are note present. Make sure the  hapi-fhir-structures-* and hapi-fhir-validation-resources-*  jars for the desired FHIR version are available on the class path.", createClassException);
                }
            }
            return mappings;
        }
    }

    public static Builder forR4() {
        return FhirEncoders.forVersion(FhirVersionEnum.R4);
    }

    public static Builder forVersion(FhirVersionEnum fhirVersion) {
        return new Builder(fhirVersion);
    }

    public final <T extends IBaseResource> ExpressionEncoder<T> of(String resourceName) {
        RuntimeResourceDefinition definition = this.context.getResourceDefinition(resourceName);
        return this.of(definition.getImplementingClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends IBaseResource> ExpressionEncoder<T> of(Class<T> type) {
        RuntimeResourceDefinition definition = this.context.getResourceDefinition(type);
        int key = type.getName().hashCode();
        Map<Integer, ExpressionEncoder<?>> map = this.encoderCache;
        synchronized (map) {
            return this.encoderCache.computeIfAbsent(key, k -> EncoderBuilder.of(definition, this.context, this.mappings, this.maxNestingLevel, (scala.collection.immutable.Set<String>)JavaConverters.asScalaSet(this.openTypes).toSet(), this.enableExtensions));
        }
    }

    public FhirVersionEnum getFhirVersion() {
        return this.context.getVersion().getVersion();
    }

    public static class Builder {
        private static final boolean DEFAULT_ENABLE_EXTENSIONS = false;
        private static final int DEFAULT_MAX_NESTING_LEVEL = 0;
        private final FhirVersionEnum fhirVersion;
        private int maxNestingLevel;
        private Set<String> openTypes;
        private boolean enableExtensions;

        Builder(FhirVersionEnum fhirVersion) {
            this.fhirVersion = fhirVersion;
            this.maxNestingLevel = 0;
            this.openTypes = Collections.emptySet();
            this.enableExtensions = false;
        }

        public Builder withMaxNestingLevel(int maxNestingLevel) {
            this.maxNestingLevel = maxNestingLevel;
            return this;
        }

        public Builder withOpenTypes(Set<String> openTypes) {
            this.openTypes = openTypes;
            return this;
        }

        public Builder withExtensionsEnabled(boolean enable) {
            this.enableExtensions = enable;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FhirEncoders getOrCreate() {
            EncodersKey key = new EncodersKey(this.fhirVersion, this.maxNestingLevel, this.openTypes, this.enableExtensions);
            Map<EncodersKey, FhirEncoders> map = ENCODERS;
            synchronized (map) {
                FhirEncoders encoders = ENCODERS.get(key);
                if (encoders == null) {
                    FhirContext context = FhirEncoders.contextFor(this.fhirVersion);
                    DataTypeMappings mappings = FhirEncoders.mappingsFor(this.fhirVersion);
                    encoders = new FhirEncoders(context, mappings, this.maxNestingLevel, this.openTypes, this.enableExtensions);
                    ENCODERS.put(key, encoders);
                }
                return encoders;
            }
        }
    }

    private static final class EncodersKey {
        private final FhirVersionEnum fhirVersion;
        private final int maxNestingLevel;
        private final Set<String> openTypes;
        private final boolean enableExtensions;

        public EncodersKey(FhirVersionEnum fhirVersion, int maxNestingLevel, Set<String> openTypes, boolean enableExtensions) {
            this.fhirVersion = fhirVersion;
            this.maxNestingLevel = maxNestingLevel;
            this.openTypes = openTypes;
            this.enableExtensions = enableExtensions;
        }

        public FhirVersionEnum getFhirVersion() {
            return this.fhirVersion;
        }

        public int getMaxNestingLevel() {
            return this.maxNestingLevel;
        }

        public Set<String> getOpenTypes() {
            return this.openTypes;
        }

        public boolean isEnableExtensions() {
            return this.enableExtensions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EncodersKey)) {
                return false;
            }
            EncodersKey other = (EncodersKey)o;
            if (this.getMaxNestingLevel() != other.getMaxNestingLevel()) {
                return false;
            }
            if (this.isEnableExtensions() != other.isEnableExtensions()) {
                return false;
            }
            FhirVersionEnum this$fhirVersion = this.getFhirVersion();
            FhirVersionEnum other$fhirVersion = other.getFhirVersion();
            if (this$fhirVersion == null ? other$fhirVersion != null : !((Object)((Object)this$fhirVersion)).equals((Object)other$fhirVersion)) {
                return false;
            }
            Set<String> this$openTypes = this.getOpenTypes();
            Set<String> other$openTypes = other.getOpenTypes();
            return !(this$openTypes == null ? other$openTypes != null : !((Object)this$openTypes).equals(other$openTypes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxNestingLevel();
            result = result * 59 + (this.isEnableExtensions() ? 79 : 97);
            FhirVersionEnum $fhirVersion = this.getFhirVersion();
            result = result * 59 + ($fhirVersion == null ? 43 : ((Object)((Object)$fhirVersion)).hashCode());
            Set<String> $openTypes = this.getOpenTypes();
            result = result * 59 + ($openTypes == null ? 43 : ((Object)$openTypes).hashCode());
            return result;
        }

        public String toString() {
            return "FhirEncoders.EncodersKey(fhirVersion=" + this.getFhirVersion() + ", maxNestingLevel=" + this.getMaxNestingLevel() + ", openTypes=" + this.getOpenTypes() + ", enableExtensions=" + this.isEnableExtensions() + ")";
        }
    }
}

