# EstateEdgePy Library  

-----

![Python Versions](https://img.shields.io/badge/python-3.12|3.13|3.14-blue) 
![Latest Release](https://img.shields.io/badge/Release-v0.1.0-blue.svg)


## Introduction

`EstateEdgePy` is a powerful and user-friendly Python package designed to enhance data analysis.

## Features


## Get Started on Windows/MacOS/Linux Terminal

-------

You can use `Poetry` or any dependency manager or use the general `pip install` command to install `datadock`.

### Using pip command to install `EstateEdgePy`

```commandline
pip install EstateEdgePy
```

### Using Poetry to install `EstateEdgePy`


1. Open your terminal and install poetry _[if you do not have poetry]_ using `pip`.
    
    ```commandline
   pip install poetry
   ```
   or Install poetry using `pipx`.
    
    ```commandline 
   pipx install poetry
    ```
   or Install using `curl`

   ```commandline
   curl -sSL https://install.python-poetry.org | python3 -
   ```

2. Create a project using poetry command. This will create a `pyproject.TOML` in your project.
Follow the instructions to finish creating your project

    ```commandline
    poetry new project_name
    ```

3. Change directory to your project

   ```commandline
   cd project_name
   ```

4. Run the poetry command to add `EstateEdgePy`: 

    ```commandline
   poetry add EstateEdgePy
   ```


## Use EstateEdgePy with Jupyter

----------

1. Open notebook in your project and install `datadock` using `pip` command.
    
    ```bash
   !pip install EstateEdgePy
   ```

----------------------------------


## How to use the latest version of `EstateEdgePy` in your terminal.

   ```commandline
   pip install --upgrade EstateEdgePy
   ```

or

   ```commandline
   pip install EstateEdgePy==<latest version number here>   
   ```

----------

## Do you have any issue or want to contribute to `EstateEdgePy` library?

If you have any issue or contribution, please write an issue with this link: https://github.com/DataDock-AI/issues
