      SUBROUTINE WRTMC(KFILDO,KFILX,ID,RECORD,NSIZE,
     1                 NREPLA,NCHECK,KEYREC,LSTRD,
     2                 NOPREC,MASTER,NW,L3264B,IER) 
C 
C        SEPTEMBER 2012  ENGLE   MDL MOS-2000, ADAPTED FROM WRTM
C        
C        PURPOSE 
C            TO WRITE A STATION CALL LETTER RECORD TO THE MOS-2000
C            EXTERNAL DIRECT ACCESS FILE SYSTEM.  KEY RECORDS ARE
C            READ/WRITTEN AS NECESSARY. CALLED BY WRTDLMC. 
C
C            NOTE: HERE RECORD IS DEFINED TO A CHARACTER. A MISSING
C            VALUE FOR RECORD( ) IN THIS SUBROUTINE IS ' '.
C 
C        DATA SET USE 
C            KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (OUTPUT) 
C            KFILX  - UNIT NUMBER FOR MOS-2000 FILE.  (INPUT-OUTPUT) 
C 
C        VARIABLES 
C 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT) 
C               KFILX = UNIT NUMBER FOR MOS-2000 FILE.  (INPUT) 
C               CFILE = THE NAME OF THE FILE TO OPEN.  (CHARACTER*1024)
C                       (INPUT)
C               ID(J) = THE 4 MOS IDS OF THE RECORD TO WRITE (J=1,4).
C                       (INPUT)
C           RECORD(J) = THE CHARACTER(LEN=L3264B/8) ARRAY TO STATION
C                       CALL LETTERS DATA INTO (J=1,NSIZE).  (OUTPUT)
C               NSIZE = THE NUMBER OF WORDS OF DATA IN RECORD( ).
C                       (INPUT)
C              NREPLA = RECORD REPLACEMENT FLAG. 
C                       0 = NOT REPLACING RECORD. 
C                       1 = REPLACING, ERROR IF RECORD NOT FOUND TO 
C                           REPLACE. 
C                       2 = REPLACING, WRITE NEW RECORD IF RECORD NOT 
C                           FOUND TO REPLACE.
C                      (INPUT)
C              NCHECK = IDENTIFICATION CHECKING FLAG. 
C                       0 = DON'T CHECK FOR DUPLICATES.
C                       1 = CHECK FOR DUPLICATES, ERROR IF FOUND.
C                       (INPUT)
C         KEYREC(J,L) = HOLDS THE KEY RECORD HAVING UP TO 
C                       NW ENTRIES (L=1,NW).  THE WORDS ARE:
C                       1-4 = THE 4 MOS-2000 IDS.
C                         5 = THE NUMBER OF DATA WORDS IN THE RECORD.
C                         6 =  THE BEGINNING RECORD NUMBER OF THE DATA 
C                              RECORD IN THE FILE * 1000 +
C                              THE NUMBER OF PHYSICAL RECORDS IN THE LOGICAL
C                              RECORD.
C                       (INPUT-OUTPUT)
C            LSTRD(J) = THE RECORD NUMBER OF THE KEY RECORD LAST USED 
C                       (J=1) AND THE NUMBER OF THE ENTRY IN THE KEY
C                       RECORD LAST USED (J=2).  (INPUT-OUTPUT)
C           NOPREC(J) = 6 WORDS (J=1,6) USED BY THE FILE SYSTEM.  WORDS
C                       3, 5, AND 6 ARE WRITTEN AS PART OF THE KEY RECORD.
C                       THE WORDS ARE:
C                       1 = IS THE KEY RECORD IN KEYREC( , , )?  IF NOT,
C                           THIS VALUE IS ZERO.  OTHERWISE, LOCATION 
C                           IN KEYREC( , ,N) OF THE KEY RECORD, RANGE OF
C                           1 TO MAXOPN.
C                       2 = LOCATION OF THIS KEY RECORD IN THE FILE.
C                       3 = NUMBER OF SLOTS FILLED IN THIS KEY.
C                       4 = INDICATES WHETHER (1) OR NOT (0) THE KEY
C                           RECORD HAS BEEN MODIFIED AND NEEDS TO BE
C                           WRITTEN.  ZERO INITIALLY.
C                       5 = NUMBER OF PHYSICAL RECORDS IT TAKES TO HOLD
C                           THIS LOGICAL KEY RECORD.  THIS IS FILLED BY
C                           WRKEYM.
C                       6 = THE RECORD NUMBER OF THE NEXT KEY RECORD IN
C                           THE FILE.  EQUALS 99999999 WHEN THIS IS THE
C                           LAST KEY RECORD IN THE FILE.
C                       (INPUT-OUTPUT)
C           MASTER(J) = 6 WORDS (J=1,6) OF THE MASTER KEY RECORD PLUS
C                       AN EXTRA WORD (J=7) INDICATING WHETHER (1) OR
C                       NOT (0) THIS MASTER KEY RECORD NEED BE WRITTEN
C                       WHEN CLOSING THE FILE.  THE WORDS ARE: 
C                       1 = RESERVED.  SET TO ZERO.
C                       2 = NUMBER OF INTEGER WORDS IN ID FOR EACH
C                           RECORD.  THIS IS 4 UNLESS CHANGES ARE
C                           MADE TO THE SOFTWARE.
C                       3 = THE NUMBER OF WORDS IN A PHYSICAL RECORD.
C                           THIS APPLIES TO A 32-BIT OR A 64-BIT 
C                           MACHINE.
C                       4 = NUMBER OF KEY RECORDS STORED IN THE FILE
C                           TO WHICH THIS MASTER KEY REFERS.
C                           INITIALLY = 1.
C                       5 = MAXIMUM NUMBER OF KEYS IN A KEY RECORD 
C                           FOR THIS FILE.
C                       6 = LOCATION OF WHERE THE FIRST PHYSICAL RECORD
C                           OF THE LAST LOGICAL KEY RECORD OF THE FILE
C                           IS LOCATED.
C                       7 = THIS MASTER KEY RECORD HAS (1) HAS NOT (0)
C                           BEEN MODIFIED.
C                       (INPUT-OUTPUT)
C                  NW = THE MAXIMUM NUMBER OF ENTRIES IN ANY KEY RECORD
C                       BEING USED IN THIS RUN.  (INPUT)
C                 IER = STATUS CODE.
C                         0 = GOOD RETURN.
C                       156 = REPLACING RECORD, AND NO MATCH FOUND.
C                       157 = NOT REPLACING RECORD, BUT MATCH FOUND.
C                       OTHER VALUES POSSIBLE FROM CALLED ROUTINES.
C                       (OUTPUT)
C 
C        NONSYSTEM SUBROUTINES CALLED 
C            RDKEYM, WRKEYM, WRDATMC
C 
CINTEL
      CHARACTER(LEN=L3264B/8), DIMENSION(NSIZE) :: RECORD 
C      DIMENSION ID(4),RECORD(NSIZE) 
      DIMENSION ID(4) 
CINTEL
      DIMENSION KEYREC(6,NW),LSTRD(2),NOPREC(6),MASTER(7) 
C
      IER=0
C 
      LOCREP=NREPLA
C        LOCREP IS A LOCAL COPY OF NREPLA WHICH MAY BE CHANGED.
      LOCCHK=NCHECK
C        LOCCHK IS A LOCAL COPY OF NCHECK WHICH MAY BE CHANGED.
      IF(LOCREP.EQ.0.AND.LOCCHK.EQ.0)GO TO 140 
C 
C        REPLACEMENT OR CHECKING TO BE DONE. 
C 
      NUMREC=MASTER(4) 
      IF(NUMREC.EQ.0.AND.LOCREP.EQ.1)GO TO 145 
C        CAN'T REPLACE A RECORD IF NONE EXISTS. 
C        LOCREP = 1 INDICATES TREAT AS ERROR IF CAN'T REPLACE.
      IF(NUMREC.EQ.0)GO TO 140 
C        CAN'T FIND A DUPLICATE IF NO RECORD EXISTS.
C        MUST CHECK RECORD ID'S EITHER BECAUSE A RECORD IS BEING REPLACED 
C        OR BECAUSE DUPLICATION IS BEING GUARDED AGAINST. 
C 
C        FLOPN HAS PROVIDED A MASTER KEY RECORD IN MASTER( ) AND A 
C        KEY RECORD IN KEYREC( , ). 
C        LOOK AT ID'S IN KEY RECORD IN KEYREC( , ). 
C        THESE ARRAYS ARE NO LONGER 3-DIMENSIONAL IN WRTM. 
C 
      DO 118 L=1,NOPREC(3) 
C 
      DO 115 J=1,4 
      IF(KEYREC(J,L).NE.ID(J))GO TO 118 
 115  CONTINUE 
C 
C        FOUND ID'S WANTED IN KEY RECORD AT LOCATION L.
C 
      GO TO 170 
C 
 118  CONTINUE 
C
C        IF KEY RECORDS ARE TO BE READ IN, MUST WRITE BACK THE KEY RECORD 
C        IN KEYREC( , ) IF IT HAS BEEN CHANGED.  SAVE RECORD NUMBER OF KEY 
C        RECORD CHECKED. 
      KRECIN=NOPREC(2) 
      IF(MASTER(4).EQ.1)GO TO 140 
C        IF ONLY ONE KEY RECORD EXISTS, IT HAS ALREADY BEEN CHECKED ABOVE. 
      IF(NOPREC(4).EQ.0)GO TO 120 
C        RECORD WRITTEN ONLY IF IT HAS BEEN CHANGED. 
      CALL WRKEYM(KFILDO,KFILX,NOPREC,KEYREC,MASTER(5)*6,
     1            MASTER(3),'WRKEY1',IER)
      IF(IER.NE.0)GO TO 900
C        IF IER NE 0, A DIAGNOSTIC WILL HAVE BEEN WRITTEN IN WRKEYM.
C
      MASTER(6)=MAX(MASTER(6),NOPREC(2))
C        MASTER(6) IS THE LOCATION OF THE LAST KEY IN THE FILE.
C 
C        ID'S WANTED ARE NOT IN KEYREC( , ).  MUST READ (OTHER) KEY 
C        RECORDS. 
C 
 120  DO 130  M=1,MASTER(4) 
C        THERE IS AT LEAST ONE RECORD THERE.  RECORD AT LOCATION
C        KRECIN HAS ALREADY BEEN CHECKED.
      IF(M.EQ.1)JREC=2
C        FIRST KEY RECORD IS RECORD NO. 2.
      IF(M.NE.1)JREC=NOPREC(6)
C        KEY RECORDS ARE READ IN SEQUENCE.  LOCATION OF NEXT 
C        KEY RECORD IS IN NOPREC(6) OF CURRENT ONE.  
      IF(M.EQ.1.AND.JREC.EQ.KRECIN)GO TO 130
C        WHEN THE ONE ALREADY CHECKED IS THE FIRST ONE, IT DOESN'T
C        HAVE TO BE READ AGAIN.  IF IT'S NOT THE FIRST ONE, IT HAS TO
C        BE READ TO GET ADDRESS OF NEXT ONE.
      CALL RDKEYM(KFILDO,KFILX,JREC,NOPREC,KEYREC,MASTER(5)*6,NW,
     1            MASTER(3),'RDKEY1',IER) 
      IF(IER.NE.0)GO TO 900
C        IF IER NE 0, A DIAGNOSTIC WILL HAVE BEEN WRITTEN IN RDKEYM.
C
      NOPREC(2)=JREC 
      NOPREC(4)=0 
      LSTRD(1)=JREC
      IF(JREC.EQ.KRECIN)GO TO 130
C        HAVE TO READ THE KEY RECORD TO GET THE LOCATION OF THE NEXT
C        ONE, BUT DON'T HAVE TO CHECK THE ID'S, SINCE THIS RECORD
C        HAS ALREADY BEEN CHECKED. 
C 
      DO 128 L=1,NOPREC(3) 
      DO 125 J=1,4 
      IF(KEYREC(J,L).NE.ID(J))GO TO 128 
 125  CONTINUE 
C 
C        FOUND ID'S WANTED IN KEY RECORD AT LOCATION L.
C
      GO TO 170 
C 
 128  CONTINUE 
C 
 130  CONTINUE 
C 
C        DIDN'T FIND RECORD IN FILE, DIDN'T LOOK, OR NONE EXISTS. 
C        (L NOT DEFINED.)  ALSO ENTERS HERE IF REPLACEMENT RECORD
C        IS TO BE WRITTEN IN NEW SLOT BECAUSE OF LACK OF ROOM IN
C        OLD SLOT.
C 
 140  NREC=NOPREC(3)+1 
C        NREC IS THE SLOT TO FILL IN KEYREC( , ), PROVIDED IT ISN'T 
C        FULL.  IF LOCREP EQ 1, PROGRAM STOPS AND AN EMPTY SLOT IS 
C        NOT CREATED. 
      IF(LOCREP.NE.1)GO TO 150 
C        REPLACMENT TO BE DONE AND NO MATCH FOUND.  ERROR INDICATED.
 145  WRITE(KFILDO,146)ID,KFILX
 146  FORMAT(/,' ****REPLACING RECORD WITH ID =',1X,I9.9,2I10.9,I11.3,
     1         ' IN WRTMC ON UNIT NO.',I3,' BUT RECORD NOT FOUND.',/,
     2         '     RECORD WILL NOT BE WRITTEN.')
      IER=156 
      GO TO 900 
C 
C        MUST WRITE RECORD INTO NEW SLOT (NOT REPLACING).
C
 150  IF(NREC.LE.MASTER(5))GO TO 160 
C        KEY RECORD IS FULL.  MUST WRITE IT IF IT HAS BEEN UPDATED, AND 
C        START ANOTHER. 
      N1=KEYREC(6,NOPREC(3))
      N2=N1/1000
      N3=N1-N2*1000
      JREC=N2+N3
      NOPREC(6)=JREC
C        NOPREC(6) IS LOCATION OF NEXT KEY RECORD.
C        KEY RECORD NEEDS TO BE WRITTEN.
      CALL WRKEYM(KFILDO,KFILX,NOPREC,KEYREC,MASTER(5)*6,
     1            MASTER(3),'WRKEY2',IER) 
      IF(IER.NE.0)GO TO 900
C        IF IER NE 0, A DIAGNOSTIC WILL HAVE BEEN WRITTEN IN WRKEYM.
C
      MASTER(6)=MAX(MASTER(6),NOPREC(2))
C        MASTER(6) IS THE LOCATION OF THE LAST KEY IN THE FILE.
 151  IF(NOPREC(2).EQ.MASTER(6))GO TO 153 
C        THERE ARE MORE KEY RECORDS.  READ THE LAST ONE. 
      CALL RDKEYM(KFILDO,KFILX,MASTER(6),NOPREC,KEYREC,MASTER(5)*6,NW,
     1            MASTER(3),'RDKEY2',IER) 
      IF(IER.NE.0)GO TO 900
C        IF IER NE 0, A DIAGNOSTIC WILL HAVE BEEN WRITTEN IN RDKEYM.
C
      NOPREC(2)=MASTER(6) 
      LSTRD(1)=MASTER(6) 
C        MAY STILL HAVE TO START A NEW KEY RECORD. 
      GO TO 140 
C 
 153  NOPREC(2)=JREC 
C        NOPREC(2) IS THE RECORD NUMBER FOR STARTING THE NEW KEY.
      NOPREC(6)=99999999
C        NOPREC(6) = 99999999 INDICATES THIS IS THE LAST KEY RECORD.
C        NOTE IT WAS SET CORRECTLY ABOVE BEFORE WRITING THE LAST KEY.
C
      DO 155 L=1,MASTER(5) 
      DO 154 J=1,6 
      KEYREC(J,L)=0 
 154  CONTINUE 
 155  CONTINUE 
C 
      NREC=1 
C        NREC IS NOW THE SLOT TO FILL IN KEYREC( , ). 
      MASTER(4)=MASTER(4)+1 
C        MASTER(4) SET TO INDICATE THE INCREASE IN NUMBER OF KEY 
C        RECORDS IN THIS FILE.  THIS NEW KEY RECORD WILL BE WRITTEN 
C        UPON CLOSING, OR WHEN FULL. 
      MASTER(7)=1 
C        MASTER(7) SET TO INDICATE THE MASTER KEY RECORD MUST 
C        BE WRITTEN WHEN FILE IS CLOSED. 
C 
 160  DO 162 J=1,4 
      KEYREC(J,NREC)=ID(J) 
 162  CONTINUE 
C 
      NOPREC(3)=NREC 
C        NOPREC(3) IS THE NUMBER OF FILLED SLOTS IN THE KEY RECORD. 
      NOPREC(4)=1 
C        NOPREC(4) SET TO INDICATE KEY RECORD HAS BEEN CHANGED. 
      KEYREC(5,NREC)=NSIZE 
C        KEYREC(5,NREC) SET TO THE NUMBER OF DATA WORDS IN THE RECORD. 
      IF(NREC.EQ.1)GO TO 165
C        THIS IS NOT THE FIRST RECORD IN THE KEY.
      N1=KEYREC(6,NREC-1)
      GO TO 168
 165  IF(NOPREC(2).EQ.2)N1=(((MASTER(5)*6+MASTER(3)-1)/
     1                     (MASTER(3)))+2)*1000
C        THIS IS THE FIRST KEY AND THE FIRST RECORD IN IT.  THE ACTUAL
C        RECORD NUMBER DEPENDS ON THE KEY SIZE = MASTER(5)*6 AND THE
C        PHYSICAL RECORD SIZE = MASTER(3).
      IF(NOPREC(2).NE.2)N1=(NOPREC(2)+NOPREC(5))*1000
C        THIS IS NOT THE FIRST KEY, BUT THE FIRST RECORD IN IT.
C        USE ADDRESS FROM KEY PLUS KEY SIZE.  WILL NEVER BE USING THIS
C        EMPTY KEY WITHOUT READING THE ONE BEFORE IT, UNLESS IT IS
C        THE FIRST ONE.
 168  N2=N1/1000
C        N2 = RECORD NUMBER OF DATA.
      N3=N1-N2*1000
C        N3 = NUMBER OF PHYSICAL RECORDS OF DATA IN THE RECORD
      KEYREC(6,NREC)=(N2+N3)*1000
C        AT THIS POINT, KEYREC(6,NREC) CONTAINS ONLY THE RECORD
C        NUMBER * 1000, AND NOT THE NUMBER OF PHYSICAL RECORDS
C        IN THE LOGICAL RECORD.
      CALL WRDATMC(KFILDO,KFILX,KEYREC(6,NREC),RECORD,NSIZE,
     1             MASTER(3),'WRWRD1',L3264B,IER) 
C        KEYREC(6,NREC) IS UPDATED IN WRDATA TO CONTAIN THE NUMBER
C        OF PHYSICAL RECORDS.
      IF(IER.NE.0)GO TO 900
C        IF IER NE 0, A DIAGNOSTIC WILL HAVE BEEN WRITTEN IN WRDATM.
C
      LSTRD(1)=NOPREC(2) 
      LSTRD(2)=NOPREC(3) 
      GO TO 900 
C 
C        FOUND THE ID'S LOOKED FOR.  REPLACE THE RECORD (LOCREP NE 0)
C        OR RETURN WITH ERROR CODE IER = 157 (LOCREP EQ 0).
C        (L IS DEFINED HERE.) 
C 
 170  IF(LOCREP.NE.0)GO TO 175 
      WRITE(KFILDO,171)KFILX,ID
 171  FORMAT(/,' ****NOT REPLACING RECORD, BUT DUPLICATE FOUND',
     1         ' IN WRTMC ON UNIT NO.',I3,', ID =',1X,I9.9,
     2         2I10.9,I11.3)
      IER=157 
      GO TO 900 
C
C        REPLACEMENT TO BE DONE.  WILL NEW RECORD FIT INTO OLD SPACE?
C        NOTE THAT ONCE A RECORD IS WRITTEN, THE NUMBER OF PHYSICAL
C        RECORDS IS RESERVED EVEN IF THE RECORD IS REPLACED WITH
C        ONE OF A SMALLER SIZE.
C
 175  NOW=MOD(KEYREC(6,L),1000)
      NEED=(NSIZE+MASTER(3)-1)/MASTER(3)
C        NOW AND NEED ARE IN TERMS OF THE NUMBER OF PHYSICAL RECORDS.
CD     WRITE(KFILDO,1750)KEYREC(5,L),MASTER(3),NSIZE,NOW,NEED
CD1750 FORMAT(/' WRTMC AT 175, KEYREC(5,L),MASTER(3),NSIZE,NOW,NEED',5I6)
      IF(NEED.LE.NOW)GO TO 185
C
C        NEW RECORD WON'T FIT.  ZERO OUT CURRENT ONE AND WRITE A
C        NEW ONE BY MODIFYING LOCREP AND LOCCHK. 
C
      WRITE(KFILDO,176)ID,KFILX
 176  FORMAT(/,' ****REPLACING RECORD WITH ID =',1X,I9.9,2I10.9,I11.3,
     1         ' IN WRTMC ON UNIT NO.',I3,' BUT NOT ENOUGH ROOM IN OLD',
     2         ' RECORD.',/,'     NOT NECESSARILY AN ERROR.',
     3         '  RECORD WILL BE WRITTEN.  PROCEEDING.')
C
      DO 177 J=1,5
C        DON'T ZERO THE RECORD NUMBER IN KEYREC(6,L).
      KEYREC(J,L)=0
 177  CONTINUE
C
      LOCREP=0
      LOCCHK=0
C        NOTE THAT ONLY ONE DUPLICATE IS LOOKED FOR.
      GO TO 140
C
 185  KEYREC(5,L)=NSIZE 
C        KEYREC(5,L) SET TO THE NUMBER OF DATA WORDS IN THE RECORD. 
      NOPREC(4)=1 
C        NOPREC(4) SET TO INDICATE KEY RECORD MAY HAVE BEEN CHANGED. 
      CALL WRDATMC(KFILDO,KFILX,KEYREC(6,L),RECORD,NSIZE,
     1             MASTER(3),'WRWRD2',L3264B,IER) 
C        KEYREC(6,L) IS UPDATED IN WRDATA TO CONTAIN THE NUMBER
C        OF PHYSICAL RECORDS.
      IF(IER.NE.0)GO TO 900
C        IF IER NE 0, A DIAGNOSTIC WILL HAVE BEEN WRITTEN IN WRDATM.
C
      LSTRD(1)=NOPREC(2) 
      LSTRD(2)=L 
C
 900  RETURN 
      END 
