      SUBROUTINE MCIJLL(KFILDO,XI,YJ,XMESHL,XLAT,
     1                  XLATLL,XLONLL,ALAT,ALON)
C
C        MAY      2002   GLAHN   TDL   MOS-2000
C        JULY     2002   GLAHN   ADDED DIAGNOSTIC PRINT 100
C
C        PURPOSE
C            CONVERTS THE COORDINATES OF A LOCATION ON EARTH GIVEN
C            IN A GRID COORDINATE SYSTEM OVERLAID ON A MERCATOR
C            PROJECTION TRUE AT A GIVEN N LATITUDE TO 
C            LATITUDE/LONGITUDE.  MCIJLL IS THE REVERSE OF MCLLIJ.
C            BASED ON NMC W3FB12 WITH SLIGHT MODIFICATION OF INPUT
C            AND OUTPUT.  LONGITUDES IN THIS ROUTINE ARE INPUT AS 
C            (POSITIVE) W AND MESH LENGTH IS IN M.  CODE IS BASED
C            ON NCEP'S ROUTINE W3FB09 WHICH IS WRITTEN FOR EAST
C            LONGITUDE INPUT.  ORIGINAL AUTHOR WAS STACKPOLE 11/25/88.
C            FORMULAE AND NOTATION LOOSELY BASED ON HOKE, HAYES,
C            AND RENNINGER'S "MAP PROJECTIONS AND GRID SYSTEMS...",
C            MARCH 1981, AFGWC/TN-79/003.
C
C
C        DATA SET USE
C            KFILDO - UNIT NUMBER OF OUTPUT (PRINT) FILE.  (OUTPUT)
C
C        VARIABLES
C            INPUT
C              KFILDO = UNIT NUMBER OF OUTPUT (PRINT) FILE.
C                  XI = IX (LEFT TO RIGHT) GRIDPOINT FOR WHICH THE
C                       LATITUDE AND LONGITUDE ARE WANTED.
C                  YJ = JY (BOTTON TO TOP) GRIDPOINT FOR WHICH THE
C                       LATITUDE AND LONGITUDE ARE WANTED.
C              XMESHL = MESH LENGTH IN METERS AT XLAT DEGREES N 
C                       LATITUDE.
C                XLAT = NORTH LATITUDE IN DEGREES AT WHICH XMESHL
C                       APPLIES.  ALSO, THE LATITUDE WHERE THE MAP CUTS
C                       THE EARTH.  DO NOT USE NEGATIVE.
C              XLATLL = NORTH LATITUDE OF LOWER LEFT (1,1) CORNER
C                       POINT OF THE GRID.
C              XLONLL = WEST LONGITUDE OF LOWER LEFT (1,1) CORNER
C                       POINT OF THE GRID.  DO NOT USE NEGATIVE.
C
C            OUTPUT
C                ALAT = NORTH LATITUDE IN DEGREES OF THE POINT
C                       CORRESPONDING TO XI, YJ.
C                ALON = WEST LONGITUDE IN DEGREES OF THE POINT
C                       CORRESPONDING TO XI, YJ.
C
C            INTERNAL
C                  PI = PI.  (SET BY PARAMETER)
C               RERTH = RADIUS OF THE EARTH IN METERS.  (SET BY
C                       PARAMETER)
C              RADPDG = NUMBER OF RADIANS PER DEGREE.  (SET BY
C                       PARAMETER)
C              DEGPRA = DEGREES PER RADIAN.  (SET BY PARAMETER)
C        1         2         3         4         5         6         7 X
C
C        NONSYSTEM SUBROUTINES CALLED
C            NONE.
C
      PARAMETER (PI=3.14159,
     1           RERTH=6371200.,
     2           RADPDG=PI/180.,
     3           DEGPRA=180./PI)
C
      IF(XMESHL.LE.0..OR.XLAT.LT.0..OR.XLONLL.LT.0.)THEN
         WRITE(KFILDO,100)XMESHL,XLAT,XLONLL
 100     FORMAT(/' ****PROBLEM WITH EITHER'/
     1           '     XMESHL =',F12.4,','/
     2           '     XLAT   =',F12.4,', OR'/
     3           '     XLONLL =',F12.4,'.'/
     4           '     STOP IN MCIJLL AT 100.')
         STOP 100
      ENDIF
C
C        PRELIMINARY VARIABLES AND REDEFINITIONS
C
      CLAIN = COS(RADPDG*XLAT)
      DELLON = XMESHL/(RERTH*CLAIN)
C
C        GET DISTANCE FROM EQUATOR TO ORIGIN XLATLL
C
      DJEO = 0.
      IF(XLATLL.NE.0.)
     1  DJEO = (ALOG(TAN(0.5*((XLATLL+90.0)*RADPDG))))/DELLON
C
C        NOW THE LAT AND LON
C
      ALAT = 2.0*ATAN(EXP(DELLON*(DJEO + YJ-1.)))*DEGPRA - 90.0
      ALON = XLONLL-(XI-1.) * DELLON *DEGPRA 
C        THE SIGN OF THE SECOND TERM WAS CHANGED FROM + TO - TO 
C        ACCOUNT FOR INPUT IN WEST RATHER THAN EAST LONGITUE.
C
CD     WRITE(KFILDO,199)XI,YJ,XMESHL,XLAT,
CD    1                 XLATLL,XLONLL,ALAT,ALON
CD199  FORMAT(/' IN LLIJLL--XI,YJ,XMESHL,XLAT,',
CD    1                 'XLATLL,XLONLL,ALAT,ALON'/
CD    2                 8F10.1)

      RETURN
      END
