      SUBROUTINE CKSYSEND(KFILDO,CPRINT,ISYSEND,IER)
C
C        MAY       2012 ENGLE        MDL   MOS-2000 CREATED
C        DECEMBER  2012 ENGLE        MDL   FIXED WRITE STATEMENT AT 100;
C                                          CENDIAN NOW PRINTS CORRECTLY;
C                                          CLEANED UP COMMENTS.
C
C        PURPOSE
C            TO CHECK THE ENDIAN OF THE SYSTEM.
C
C        DATA SET USE
C           KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE. (OUTPUT)
C
C        VARIABLES
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT)
C              CPRINT = CONTROL WHETHER INFORMATION IS PRINTED TO
C                       KFILDO. PRINT WILL OCCUR WHEN
C                       CPRINT(1:5)='PRINT'.  (INPUT)
C             ISYSEND = HOLD THE VALUE THAT REPRESENTS THE SYSTEM
C                       ENDIAN. (OUTPUT)
C                        -1 = SYSTEM IS LITLE-ENDIAN.
C                         1 = SYSTEM IS BIG-ENDIAN.
C                 IER = STATUS RETURN.  (OUTPUT)
C                         0 =  GOOD RETURN
C                       999 =  COULD NOT DETERMINE SYSTEM ENDIAN.
C             A,B,C,D = HOLDS THE ASCII CHARACTER CODE EQUIVALENT
C                       TO THEIR RESPECTIVE UPPER-CASE VARIABLE NAME. (INTERNAL)
C               IABCD = HOLDS THE "BYTE" ADDITION OF VARIABLES
C                       A,B,C,D.  (INTERNAL)
C               CABCD = CHARACTER REPRESENTATION OF IABCD.  (INTERNAL)
C             CENDIAN = CHARACTER USED FOR PRINTING THE ENDIANNESS OF
C                       THE SYSTEM. (INTERNAL)
C
C        NONSYSTEM SUBROUTINES CALLED
C           NONE
C
      IMPLICIT NONE
C
C        I/O VARIABLES
C
      INTEGER :: KFILDO,ISYSEND,IER
      CHARACTER(LEN=10) :: CPRINT
C
C        INTERNAL VARIABLES
C
      INTEGER, PARAMETER :: A=65
      INTEGER, PARAMETER :: B=66
      INTEGER, PARAMETER :: C=67
      INTEGER, PARAMETER :: D=68
      INTEGER(KIND=4) :: IABCD
      CHARACTER(LEN=4) :: CABCD
      CHARACTER(LEN=13) :: CENDIAN
C
      IER=0
C
C        PERFORM ADDITION OF VARIABLES A,B,C,D IN A MANNER THAT PLACES
C        THE VALUE OF EACH VARIABLE IN A SPECIFIC BYTE OF IABCD. BY THE
C        FORMULA, THE VALUE OF A IS PLACED IN THE LEAST SIGNIFICANT BYTE
C        AND D IS IN THE MOST SIGNIFICANT BYTE.
C
      IABCD=A+B*256+C*(256**2)+D*(256**3)
C
C        USE TRANSFER FUNCTION TO PERFORM A BITWISE REPRESENTATION COPY
C        OF IABCD INTO CABCD.
C
      CABCD=TRANSFER(IABCD,CABCD)
C
C        TEST THE CHARACTER VARIABLE CABCD.  THE ENDIAN OF THE SYSTEM
C        WILL DETERMINE THE BYTE ORDER IN WHICH THE TRANSFER FUNCTION
C        COPIED THE CONTENTS OF IABCD TO CABCD.
C
      IF(CABCD.EQ.'ABCD')THEN
C            COME HERE IF THE SYSTEM IS LITTLE-ENDIAN.
        ISYSEND=-1
        CENDIAN='LITTLE-ENDIAN'
      ELSEIF(CABCD.EQ.'DCBA')THEN
C            COME HERE IF THE SYSTEM IS BIG-ENDIAN.
        ISYSEND=1
        CENDIAN='BIG-ENDIAN'
      ELSE
C            COME HERE IF THE SYSTEM ENDIAN CANNOT BE DETERMINED.
        IER=999
 110    FORMAT(/' ****ERROR DETERMINING SYSTEM ENDIAN. THIS IS A ',
     1          'FATAL ERROR.  PROGRAM WILL STOP.')
        STOP 999
      ENDIF
C
      IF(CPRINT(1:5).EQ.'PRINT') WRITE(KFILDO,100)CENDIAN,ISYSEND
 100  FORMAT(/' SYSTEM IS ',A,'. ISYSEND = ',I2)
C
      RETURN
      END SUBROUTINE CKSYSEND
