/**
 * The width of the grid we're filling
 */
export declare const GRID_WIDTH = 24;
/**
 * A single dashboard widget.
 *
 * @stability stable
 */
export interface IWidget {
    /**
     * The amount of horizontal grid units the widget will take up.
     *
     * @stability stable
     */
    readonly width: number;
    /**
     * The amount of vertical grid units the widget will take up.
     *
     * @stability stable
     */
    readonly height: number;
    /**
     * Place the widget at a given position.
     *
     * @stability stable
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     *
     * @stability stable
     */
    toJson(): any[];
}
/**
 * A real CloudWatch widget that has its own fixed size and remembers its position.
 *
 * This is in contrast to other widgets which exist for layout purposes.
 *
 * @stability stable
 */
export declare abstract class ConcreteWidget implements IWidget {
    /**
     * The amount of horizontal grid units the widget will take up.
     *
     * @stability stable
     */
    readonly width: number;
    /**
     * The amount of vertical grid units the widget will take up.
     *
     * @stability stable
     */
    readonly height: number;
    /**
     * @stability stable
     */
    protected x?: number;
    /**
     * @stability stable
     */
    protected y?: number;
    /**
     * @stability stable
     */
    constructor(width: number, height: number);
    /**
     * Place the widget at a given position.
     *
     * @stability stable
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     *
     * @stability stable
     */
    abstract toJson(): any[];
}
