// Copyright (c) Mito
import React from 'react';
import DriveIcon from '../../icons/DriveIcon';
/*
    At the top of the file browser, users can select
    pieces of the path.
*/
function FileBrowserPathSelector(props) {
    var _a;
    /*
        Updates the selected path to go back up some number
        of folders to a given index.
    */
    const updateSelectedPath = (i) => {
        if (props.pathParts === undefined) {
            return;
        }
        const subPathParts = props.pathParts.slice(0, i + 1);
        props.setCurrPathParts(subPathParts);
    };
    return (React.createElement("div", { className: 'file-browser-path-selector' }, (_a = props.pathParts) === null || _a === void 0 ? void 0 : _a.map((pathPart, i) => {
        return (React.createElement(React.Fragment, { key: i },
            React.createElement("div", { className: 'file-browser-path-part', key: i, onClick: () => { updateSelectedPath(i); } }, i === 0 ? React.createElement(DriveIcon, null) : pathPart),
            React.createElement("div", { className: 'file-browser-path-seperator' }, ">")));
    })));
}
export default FileBrowserPathSelector;
//# sourceMappingURL=FileBrowserPathSelector.js.map