// Copyright (c) Mito
import React, { useEffect, useRef } from 'react';
import { getLastModifiedString } from '../../../utils/time';
import { ensureInView } from '../../elements/Dropdown';
import BackArrowIcon from '../../icons/BackArrowIcon';
import CSVFileIcon from '../../icons/CSVFileIcon';
import DirectoryIcon from '../../icons/DirectoryIcon';
import FileIcon from '../../icons/FileIcon';
import Col from '../../layout/Col';
import Row from '../../layout/Row';
import { getInvalidFileError } from './importUtils';
/*
    An file or folder that is displayed by the file browser
*/
function FileBrowserElement(props) {
    const elementRef = useRef(null);
    // Check if this element being displayed is the selected element in the
    // file browser!
    const isSelected = props.index === props.importState.selectedElementIndex;
    // If the element becomes selected, we make sure it is visible in the div
    useEffect(() => {
        var _a;
        const element = elementRef.current;
        const parent = (_a = elementRef.current) === null || _a === void 0 ? void 0 : _a.parentElement;
        if (isSelected && element && parent) {
            ensureInView(parent, elementRef.current, 0);
        }
    }, [isSelected]);
    const invalidFileError = getInvalidFileError(props.element, props.excelImportEnabled);
    return (React.createElement("div", { 
        // We make this text unselectable, as we want users to be able to double click
        ref: elementRef, className: 'file-browser-element p-5px text-unselectable', title: props.element.name, style: { background: isSelected ? '#D5C0FF' : '' }, onClick: (e) => {
            // If the user is double clicking, then we don't select or
            // unselect the element
            if (e.detail > 1) {
                return;
            }
            /*
                If the element is selected, we unselect it. Otherwise,
                we select it.
            */
            if (isSelected) {
                props.setImportState(prevImportState => {
                    return Object.assign(Object.assign({}, prevImportState), { selectedElementIndex: -1 });
                });
            }
            else {
                props.setImportState(prevImportState => {
                    return Object.assign(Object.assign({}, prevImportState), { selectedElementIndex: props.index });
                });
            }
        }, onDoubleClick: () => {
            if (props.element.isParentDirectory) {
                const newPathParts = [...props.importState.pathContents.path_parts];
                newPathParts.pop();
                props.setCurrPathParts(newPathParts);
            }
            else if (props.element.isDirectory) {
                const newPathParts = props.importState.pathContents.path_parts || [];
                newPathParts.push(props.element.name);
                props.setCurrPathParts(newPathParts);
            }
            else {
                void props.importElement(props.element);
            }
        } },
        React.createElement(Row, { suppressTopBottomMargin: true, justify: 'space-between' },
            React.createElement(Col, { span: 17, offsetRight: 1 },
                React.createElement("div", { className: 'flexbox-row' },
                    React.createElement("div", { className: 'mr-5px mt-2px' },
                        props.element.isDirectory && props.element.isParentDirectory && React.createElement(BackArrowIcon, { width: '14px' }),
                        props.element.isDirectory && !props.element.isParentDirectory && React.createElement(DirectoryIcon, null),
                        !props.element.isDirectory && invalidFileError === undefined && React.createElement(CSVFileIcon, null),
                        !props.element.isDirectory && invalidFileError !== undefined && React.createElement(FileIcon, null)),
                    React.createElement("div", null, props.element.name))),
            React.createElement(Col, { span: 6 },
                React.createElement("p", { className: 'text-align-right' }, props.element.lastModified !== 0 && getLastModifiedString(props.element.lastModified)))),
        isSelected && invalidFileError !== undefined &&
            React.createElement("div", { className: 'pl-5px pr-5px' },
                React.createElement("span", null,
                    " ",
                    invalidFileError,
                    " "))));
}
export default FileBrowserElement;
//# sourceMappingURL=FileBrowserElement.js.map