// Copyright (c) Saga Inc.
import React from 'react';
import LabelAndColor from '../../../pro/graph/LabelAndColor';
import DropdownItem from '../../elements/DropdownItem';
import Input from '../../elements/Input';
import Select from '../../elements/Select';
import Toggle from '../../elements/Toggle';
import Col from '../../layout/Col';
import CollapsibleSection from '../../layout/CollapsibleSection';
import Row from '../../layout/Row';
export var AxisType;
(function (AxisType) {
    AxisType["DEFAULT"] = "default";
    AxisType["LINEAR"] = "linear";
    AxisType["LOG"] = "log";
    AxisType["CATEGORY"] = "category";
    AxisType["DATE"] = "date";
})(AxisType || (AxisType = {}));
/*
    Contains all of the options for styling graphs,
    like setting the title and axis labels
*/
function GraphStyleTab(props) {
    var _a;
    const graphCreationParams = props.graphParams.graphCreation;
    const graphStylingParams = props.graphParams.graphStyling;
    return (React.createElement("div", { className: 'graph-sidebar-toolbar-content' },
        React.createElement(CollapsibleSection, { title: 'Titles' },
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Graph Title")),
                React.createElement(Input, { value: graphStylingParams.title.title || '', placeholder: "Default Graph Title", onChange: (e) => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            // We set it to undefined so that the backend knows we're not trying to set a custom axis label 
                            const newTitle = e.target.value !== '' ? e.target.value : undefined;
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { title: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.title), { title: newTitle }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "X Axis Title")),
                React.createElement(Input, { value: graphStylingParams.xaxis.title || '', placeholder: "Default X Axis", onChange: (e) => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            // We set it to undefined so that the backend knows we're not trying to set a custom axis label 
                            const newTitle = e.target.value !== '' ? e.target.value : undefined;
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { title: newTitle }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Y Axis Title")),
                React.createElement(Input, { value: graphStylingParams.yaxis.title || '', placeholder: "Default Y Axis", onChange: (e) => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            const newTitle = e.target.value !== '' ? e.target.value : undefined;
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { yaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.yaxis), { title: newTitle }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Display Title")),
                React.createElement(Toggle, { value: graphStylingParams.title.visible, onChange: () => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { title: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.title), { visible: !graphParamsCopy.graphStyling.title.visible }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Display X Axis Title")),
                React.createElement(Toggle, { value: graphStylingParams.xaxis.visible, onChange: () => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { visible: !graphParamsCopy.graphStyling.xaxis.visible }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Display Y Axis Title")),
                React.createElement(Toggle, { value: graphStylingParams.yaxis.visible, onChange: () => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { yaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.yaxis), { visible: !graphParamsCopy.graphStyling.yaxis.visible }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } }))),
        React.createElement(CollapsibleSection, { title: 'Axis Transformations' },
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "X Axis Transform")),
                React.createElement(Select, { value: props.graphParams.graphStyling.xaxis.type || 'default', onChange: (xAxisType) => {
                        const newXAxisType = xAxisType !== AxisType.DEFAULT ? xAxisType : undefined;
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { type: newXAxisType }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    }, width: 'small', dropdownWidth: 'medium' },
                    React.createElement(DropdownItem, { title: AxisType.DEFAULT }),
                    React.createElement(DropdownItem, { title: AxisType.LINEAR }),
                    React.createElement(DropdownItem, { title: AxisType.LOG }),
                    React.createElement(DropdownItem, { title: AxisType.DATE }),
                    React.createElement(DropdownItem, { title: AxisType.CATEGORY }))),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Y Axis Transform")),
                React.createElement(Select, { value: props.graphParams.graphStyling.yaxis.type || 'default', onChange: (yAxisType) => {
                        const newYAxisType = yAxisType !== AxisType.DEFAULT ? yAxisType : undefined;
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { yaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.yaxis), { type: newYAxisType }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    }, width: 'small', dropdownWidth: 'medium' },
                    React.createElement(DropdownItem, { title: AxisType.DEFAULT }),
                    React.createElement(DropdownItem, { title: AxisType.LINEAR }),
                    React.createElement(DropdownItem, { title: AxisType.LOG }),
                    React.createElement(DropdownItem, { title: AxisType.DATE }),
                    React.createElement(DropdownItem, { title: AxisType.CATEGORY })))),
        React.createElement(CollapsibleSection, { title: 'Legend', proSection: true, isPro: props.userProfile.isPro },
            !props.userProfile.isPro &&
                React.createElement(Row, { justify: 'space-between', align: 'center' },
                    React.createElement("p", { className: 'text-body-1' },
                        "Want to customize the legend? ",
                        React.createElement("a", { href: 'https://trymito.io/plans', target: '_blank', rel: "noreferrer" },
                            React.createElement("span", { className: 'text-body-1-link' }, "Upgrade to Mito Pro.")))),
            props.userProfile.isPro &&
                React.createElement(React.Fragment, null,
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'Title of legend' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Display Legend")),
                        React.createElement(Toggle, { value: graphStylingParams.showlegend, onChange: () => {
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { showlegend: !graphParamsCopy.graphStyling.showlegend }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })),
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'Display the legend vertically or horizontally' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Orientation")),
                        React.createElement(Select, { value: graphStylingParams.legend.orientation === 'v' ? 'vertical' : 'horiztonal', width: 'medium', onChange: (newOrientation) => {
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { legend: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.legend), { orientation: newOrientation }) }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } },
                            React.createElement(DropdownItem, { title: 'vertical', id: 'v' }),
                            React.createElement(DropdownItem, { title: 'horizontal', id: 'h' }))),
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'Title of legend' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Legend title")),
                        React.createElement(Input, { value: ((_a = graphStylingParams.legend.title) === null || _a === void 0 ? void 0 : _a.text) ? graphStylingParams.legend.title.text : '', width: 'medium', placeholder: 'Legend title', onChange: (e) => {
                                const newLegendTitle = e.target.value;
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { legend: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.legend), { title: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.legend.title), { text: newLegendTitle }) }) }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })),
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'The x position of the legend' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "X position (-2 to 3)")),
                        React.createElement(Input, { value: graphStylingParams.legend.x ? graphStylingParams.legend.x.toString() : '', type: 'number', width: 'small', 
                            // Set default according the https://plotly.com/python/reference/layout/#layout-legend-x
                            placeholder: graphStylingParams.legend.orientation === 'v' ? '1.02' : '0.00', onChange: (e) => {
                                const newX = e.target.value === '' ? undefined : e.target.value;
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { legend: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.legend), { x: newX }) }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })),
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'The y position of the legend' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Y position (-2 to 3)")),
                        React.createElement(Input, { value: graphStylingParams.legend.y ? graphStylingParams.legend.y.toString() : '', type: 'number', width: 'small', 
                            // Set default according the https://plotly.com/python/reference/layout/#layout-legend-y
                            placeholder: graphStylingParams.legend.orientation === 'v' ? '1.00' : graphStylingParams.xaxis.rangeslider.visible ? '1.10' : "-0.10", onChange: (e) => {
                                const newY = e.target.value === '' ? undefined : e.target.value;
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { legend: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.legend), { y: newY }) }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })))),
        React.createElement(CollapsibleSection, { title: 'Grid Lines', proSection: true, isPro: props.userProfile.isPro },
            !props.userProfile.isPro &&
                React.createElement(Row, { justify: 'space-between', align: 'center' },
                    React.createElement("p", { className: 'text-body-1' },
                        "Want to customize the grid lines? ",
                        React.createElement("a", { href: 'https://trymito.io/plans', target: '_blank', rel: "noreferrer" },
                            React.createElement("span", { className: 'text-body-1-link' }, "Upgrade to Mito Pro.")))),
            props.userProfile.isPro &&
                React.createElement(React.Fragment, null,
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'Turn on/off vertical grid lines' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Show vertical grid")),
                        React.createElement(Toggle, { value: graphStylingParams.xaxis.showgrid, onChange: () => {
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { showgrid: !graphParamsCopy.graphStyling.xaxis.showgrid }) }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })),
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'Turn on/off horiztonal grid lines' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Show horizontal grid")),
                        React.createElement(Toggle, { value: graphStylingParams.yaxis.showgrid, onChange: () => {
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { yaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.yaxis), { showgrid: !graphParamsCopy.graphStyling.yaxis.showgrid }) }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })),
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'The width of the vertical grid lines' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Vertical grid width")),
                        React.createElement(Input, { value: graphStylingParams.xaxis.gridwidth ? graphStylingParams.xaxis.gridwidth.toString() : '', type: 'number', width: 'small', placeholder: '1', onChange: (e) => {
                                const newHoriztonalGridWidth = e.target.value === '' ? undefined : e.target.value;
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { gridwidth: newHoriztonalGridWidth }) }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })),
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'The width of the horizontal grid lines' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Horizontal grid width")),
                        React.createElement(Input, { value: graphStylingParams.yaxis.gridwidth ? graphStylingParams.yaxis.gridwidth.toString() : '', type: 'number', width: 'small', placeholder: '1', onChange: (e) => {
                                const newHoriztonalGridWidth = e.target.value === '' ? undefined : e.target.value;
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { yaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.yaxis), { gridwidth: newHoriztonalGridWidth }) }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })))),
        React.createElement(CollapsibleSection, { title: 'Colors', proSection: true, isPro: props.userProfile.isPro },
            !props.userProfile.isPro &&
                React.createElement(Row, { justify: 'space-between', align: 'center' },
                    React.createElement("p", { className: 'text-body-1' },
                        "Want to set the colors of your graph? ",
                        React.createElement("a", { href: 'https://trymito.io/plans', target: '_blank', rel: "noreferrer" },
                            React.createElement("span", { className: 'text-body-1-link' }, "Upgrade to Mito Pro.")))),
            props.userProfile.isPro &&
                React.createElement(React.Fragment, null,
                    React.createElement(LabelAndColor, { label: 'Plot Background Color', color: graphStylingParams.plot_bgcolor, onChange: (newColor) => {
                            props.setGraphParams(prevGraphParams => {
                                const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { plot_bgcolor: newColor }) });
                            });
                            props.setGraphUpdatedNumber(old => old + 1);
                        } }),
                    React.createElement(LabelAndColor, { label: 'Paper Background Color', color: graphStylingParams.paper_bgcolor, onChange: (newColor) => {
                            props.setGraphParams(prevGraphParams => {
                                const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { paper_bgcolor: newColor }) });
                            });
                            props.setGraphUpdatedNumber(old => old + 1);
                        } }),
                    React.createElement(LabelAndColor, { label: 'Title color', color: graphStylingParams.title.title_font_color, onChange: (newColor) => {
                            props.setGraphParams(prevGraphParams => {
                                const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { title: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.title), { title_font_color: newColor }) }) });
                            });
                            props.setGraphUpdatedNumber(old => old + 1);
                        } }),
                    React.createElement(LabelAndColor, { label: 'X axis title color', color: graphStylingParams.xaxis.title_font_color, onChange: (newColor) => {
                            props.setGraphParams(prevGraphParams => {
                                const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { title_font_color: newColor }) }) });
                            });
                            props.setGraphUpdatedNumber(old => old + 1);
                        } }),
                    React.createElement(LabelAndColor, { label: 'Y axis title color', color: graphStylingParams.yaxis.title_font_color, onChange: (newColor) => {
                            props.setGraphParams(prevGraphParams => {
                                const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { yaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.yaxis), { title_font_color: newColor }) }) });
                            });
                            props.setGraphUpdatedNumber(old => old + 1);
                        } }))),
        React.createElement(CollapsibleSection, { title: 'Facet Styling', proSection: true, isPro: props.userProfile.isPro },
            !props.userProfile.isPro &&
                React.createElement(Row, { justify: 'space-between', align: 'center' },
                    React.createElement("p", { className: 'text-body-1' },
                        "Want to style facet plots? ",
                        React.createElement("a", { href: 'https://trymito.io/plans', target: '_blank', rel: "noreferrer" },
                            React.createElement("span", { className: 'text-body-1-link' }, "Upgrade to Mito Pro.")))),
            props.userProfile.isPro &&
                React.createElement(React.Fragment, null,
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'The number of plots to display per row. Has no effect when facet row is used.' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Number of cols (int)")),
                        React.createElement(Input, { value: graphCreationParams.facet_col_wrap ? graphCreationParams.facet_col_wrap.toString() : '', type: 'number', width: 'small', placeholder: 'num cols', onChange: (e) => {
                                const newNumCols = e.target.value === '' ? undefined : e.target.value;
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphCreation: Object.assign(Object.assign({}, graphParamsCopy.graphCreation), { facet_col_wrap: newNumCols }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })),
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'The spacing between columns of facet plots. Set as a fraction of plotting area.' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Column spacing (0 to 1)")),
                        React.createElement(Input, { value: graphCreationParams.facet_col_spacing ? graphCreationParams.facet_col_spacing.toString() : '', type: 'number', width: 'small', placeholder: '.03', onChange: (e) => {
                                const newColSpacing = e.target.value === '' ? undefined : e.target.value;
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphCreation: Object.assign(Object.assign({}, graphParamsCopy.graphCreation), { facet_col_spacing: newColSpacing }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })),
                    React.createElement(Row, { justify: 'space-between', align: 'center', title: 'The spacing between rows of facet plots. Set as a fraction of plotting area.' },
                        React.createElement(Col, null,
                            React.createElement("p", null, "Row spacing (0 to 1)")),
                        React.createElement(Input, { value: graphCreationParams.facet_row_spacing ? graphCreationParams.facet_row_spacing.toString() : '', type: 'number', width: 'small', placeholder: '.07', onChange: (e) => {
                                const newColSpacing = e.target.value === '' ? undefined : e.target.value;
                                props.setGraphParams(prevGraphParams => {
                                    const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                    return Object.assign(Object.assign({}, graphParamsCopy), { graphCreation: Object.assign(Object.assign({}, graphParamsCopy.graphCreation), { facet_row_spacing: newColSpacing }) });
                                });
                                props.setGraphUpdatedNumber(old => old + 1);
                            } })))),
        React.createElement(CollapsibleSection, { title: 'Range slider' },
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Display range slider")),
                React.createElement(Toggle, { value: graphStylingParams.xaxis.rangeslider.visible, onChange: () => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { rangeslider: {
                                            visible: !graphParamsCopy.graphStyling.xaxis.rangeslider.visible
                                        } }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })))));
}
export default GraphStyleTab;
//# sourceMappingURL=GraphStyleTab.js.map