// Copyright (c) Mito
import React from 'react';
import '../../../css/elements/TextArea.css';
import { classNames } from '../../utils/classNames';
/**
 * The TextArea component is a rectangular text input that takes allows
 * for multiple lines of text.
 */
const TextArea = (props) => {
    // Create better default values to handle optional params 
    const autoFocus = props.autoFocus === true;
    const required = props.required === true;
    const height = props.height || 'block';
    const width = props.width || 'block';
    const widthClass = `element-width-${width}`;
    const heightClass = `element-height-${height}`;
    return (React.createElement("textarea", { className: classNames('text-area', 'text-body-2', widthClass, heightClass, props.className), onChange: props.onChange, autoFocus: autoFocus, required: required, placeholder: props.placeholder }, props.value));
};
export default TextArea;
//# sourceMappingURL=TextArea.js.map