# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.2

import enum
import sys
import types
import typing
import uuid

import winsdk._winrt as _winrt

try:
    import winsdk.windows.foundation
except Exception:
    pass

try:
    import winsdk.windows.foundation.collections
except Exception:
    pass

try:
    import winsdk.windows.security.cryptography.core
except Exception:
    pass

try:
    import winsdk.windows.storage.streams
except Exception:
    pass

class SmartCardActivationPolicyChangeResult(enum.IntEnum):
    DENIED = 0
    ALLOWED = 1

class SmartCardAppletIdGroupActivationPolicy(enum.IntEnum):
    DISABLED = 0
    FOREGROUND_OVERRIDE = 1
    ENABLED = 2

class SmartCardAutomaticResponseStatus(enum.IntEnum):
    NONE = 0
    SUCCESS = 1
    UNKNOWN_ERROR = 2

class SmartCardCryptogramAlgorithm(enum.IntEnum):
    NONE = 0
    CBC_MAC = 1
    CVC3_UMD = 2
    DECIMALIZED_MSD = 3
    CVC3_M_D = 4
    SHA1 = 5
    SIGNED_DYNAMIC_APPLICATION_DATA = 6
    RSA_PKCS1 = 7
    SHA256_HMAC = 8

class SmartCardCryptogramGeneratorOperationStatus(enum.IntEnum):
    SUCCESS = 0
    AUTHORIZATION_FAILED = 1
    AUTHORIZATION_CANCELED = 2
    AUTHORIZATION_REQUIRED = 3
    CRYPTOGRAM_MATERIAL_PACKAGE_STORAGE_KEY_EXISTS = 4
    NO_CRYPTOGRAM_MATERIAL_PACKAGE_STORAGE_KEY = 5
    NO_CRYPTOGRAM_MATERIAL_PACKAGE = 6
    UNSUPPORTED_CRYPTOGRAM_MATERIAL_PACKAGE = 7
    UNKNOWN_CRYPTOGRAM_MATERIAL_NAME = 8
    INVALID_CRYPTOGRAM_MATERIAL_USAGE = 9
    APDU_RESPONSE_NOT_SENT = 10
    OTHER_ERROR = 11
    VALIDATION_FAILED = 12
    NOT_SUPPORTED = 13

class SmartCardCryptogramMaterialPackageConfirmationResponseFormat(enum.IntEnum):
    NONE = 0
    VISA_HMAC = 1

class SmartCardCryptogramMaterialPackageFormat(enum.IntEnum):
    NONE = 0
    JWE_RSA_PKI = 1

class SmartCardCryptogramMaterialProtectionMethod(enum.IntEnum):
    NONE = 0
    WHITE_BOXING = 1

class SmartCardCryptogramMaterialType(enum.IntEnum):
    NONE = 0
    STATIC_DATA_AUTHENTICATION = 1
    TRIPLE_DES112 = 2
    AES = 3
    RSA_PKCS1 = 4

class SmartCardCryptogramPlacementOptions(enum.IntFlag):
    NONE = 0
    UNITS_ARE_IN_NIBBLES = 0x1
    CHAIN_OUTPUT = 0x2

class SmartCardCryptogramStorageKeyAlgorithm(enum.IntEnum):
    NONE = 0
    RSA2048 = 1

class SmartCardCryptogramStorageKeyCapabilities(enum.IntFlag):
    NONE = 0
    HARDWARE_PROTECTION = 0x1
    UNLOCK_PROMPT = 0x2

class SmartCardCryptographicKeyAttestationStatus(enum.IntEnum):
    NO_ATTESTATION = 0
    SOFTWARE_KEY_WITHOUT_TPM = 1
    SOFTWARE_KEY_WITH_TPM = 2
    TPM_KEY_UNKNOWN_ATTESTATION_STATUS = 3
    TPM_KEY_WITHOUT_ATTESTATION_CAPABILITY = 4
    TPM_KEY_WITH_TEMPORARY_ATTESTATION_FAILURE = 5
    TPM_KEY_WITH_LONG_TERM_ATTESTATION_FAILURE = 6
    TPM_KEY_WITH_ATTESTATION = 7

class SmartCardEmulationCategory(enum.IntEnum):
    OTHER = 0
    PAYMENT = 1

class SmartCardEmulationType(enum.IntEnum):
    HOST = 0
    UICC = 1
    EMBEDDED_S_E = 2

class SmartCardEmulatorConnectionDeactivatedReason(enum.IntEnum):
    CONNECTION_LOST = 0
    CONNECTION_REDIRECTED = 1

class SmartCardEmulatorConnectionSource(enum.IntEnum):
    UNKNOWN = 0
    NFC_READER = 1

class SmartCardEmulatorEnablementPolicy(enum.IntEnum):
    NEVER = 0
    ALWAYS = 1
    SCREEN_ON = 2
    SCREEN_UNLOCKED = 3

class SmartCardLaunchBehavior(enum.IntEnum):
    DEFAULT = 0
    ABOVE_LOCK = 1

class SmartCardPinCharacterPolicyOption(enum.IntEnum):
    ALLOW = 0
    REQUIRE_AT_LEAST_ONE = 1
    DISALLOW = 2

class SmartCardReaderKind(enum.IntEnum):
    ANY = 0
    GENERIC = 1
    TPM = 2
    NFC = 3
    UICC = 4
    EMBEDDED_S_E = 5

class SmartCardReaderStatus(enum.IntEnum):
    DISCONNECTED = 0
    READY = 1
    EXCLUSIVE = 2

class SmartCardStatus(enum.IntEnum):
    DISCONNECTED = 0
    READY = 1
    SHARED = 2
    EXCLUSIVE = 3
    UNRESPONSIVE = 4

class SmartCardTriggerType(enum.IntEnum):
    EMULATOR_TRANSACTION = 0
    EMULATOR_NEAR_FIELD_ENTRY = 1
    EMULATOR_NEAR_FIELD_EXIT = 2
    EMULATOR_HOST_APPLICATION_ACTIVATED = 3
    EMULATOR_APPLET_ID_GROUP_REGISTRATION_CHANGED = 4
    READER_CARD_ADDED = 5

class SmartCardUnlockPromptingBehavior(enum.IntEnum):
    ALLOW_UNLOCK_PROMPT = 0
    REQUIRE_UNLOCK_PROMPT = 1
    PREVENT_UNLOCK_PROMPT = 2

class CardAddedEventArgs(_winrt.Object):
    smart_card: SmartCard
    @staticmethod
    def _from(obj: _winrt.Object) -> CardAddedEventArgs: ...

class CardRemovedEventArgs(_winrt.Object):
    smart_card: SmartCard
    @staticmethod
    def _from(obj: _winrt.Object) -> CardRemovedEventArgs: ...

class KnownSmartCardAppletIds(_winrt.Object):
    payment_system_environment: winsdk.windows.storage.streams.IBuffer
    proximity_payment_system_environment: winsdk.windows.storage.streams.IBuffer
    @staticmethod
    def _from(obj: _winrt.Object) -> KnownSmartCardAppletIds: ...

class SmartCard(_winrt.Object):
    reader: SmartCardReader
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCard: ...
    @typing.overload
    def connect_async(self) -> winsdk.windows.foundation.IAsyncOperation[SmartCardConnection]: ...
    @typing.overload
    def get_answer_to_reset_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    @typing.overload
    def get_status_async(self) -> winsdk.windows.foundation.IAsyncOperation[SmartCardStatus]: ...

class SmartCardAppletIdGroup(_winrt.Object):
    smart_card_emulation_type: SmartCardEmulationType
    smart_card_emulation_category: SmartCardEmulationCategory
    display_name: str
    automatic_enablement: _winrt.Boolean
    applet_ids: winsdk.windows.foundation.collections.IVector[winsdk.windows.storage.streams.IBuffer]
    secure_user_authentication_required: _winrt.Boolean
    logo: winsdk.windows.storage.streams.IRandomAccessStreamReference
    description: str
    properties: winsdk.windows.foundation.collections.ValueSet
    max_applet_ids: _winrt.UInt16
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardAppletIdGroup: ...
    @typing.overload
    def __init__(self, display_name: str, applet_ids: winsdk.windows.foundation.collections.IVector[winsdk.windows.storage.streams.IBuffer], emulation_category: SmartCardEmulationCategory, emulation_type: SmartCardEmulationType) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...

class SmartCardAppletIdGroupRegistration(_winrt.Object):
    activation_policy: SmartCardAppletIdGroupActivationPolicy
    applet_id_group: SmartCardAppletIdGroup
    id: uuid.UUID
    smart_card_reader_id: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardAppletIdGroupRegistration: ...
    @typing.overload
    def request_activation_policy_change_async(self, policy: SmartCardAppletIdGroupActivationPolicy) -> winsdk.windows.foundation.IAsyncOperation[SmartCardActivationPolicyChangeResult]: ...
    @typing.overload
    def set_automatic_response_apdus_async(self, apdus: typing.Iterable[SmartCardAutomaticResponseApdu]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def set_properties_async(self, props: winsdk.windows.foundation.collections.ValueSet) -> winsdk.windows.foundation.IAsyncAction: ...

class SmartCardAutomaticResponseApdu(_winrt.Object):
    should_match_length: _winrt.Boolean
    response_apdu: winsdk.windows.storage.streams.IBuffer
    command_apdu_bit_mask: winsdk.windows.storage.streams.IBuffer
    command_apdu: winsdk.windows.storage.streams.IBuffer
    applet_id: winsdk.windows.storage.streams.IBuffer
    output_state: typing.Optional[_winrt.UInt32]
    input_state: typing.Optional[_winrt.UInt32]
    allow_when_cryptogram_generator_not_prepared: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardAutomaticResponseApdu: ...
    @typing.overload
    def __init__(self, command_apdu: winsdk.windows.storage.streams.IBuffer, response_apdu: winsdk.windows.storage.streams.IBuffer) -> None: ...

class SmartCardChallengeContext(winsdk.windows.foundation.IClosable, _winrt.Object):
    challenge: winsdk.windows.storage.streams.IBuffer
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardChallengeContext: ...
    @typing.overload
    def change_administrative_key_async(self, response: winsdk.windows.storage.streams.IBuffer, new_administrative_key: winsdk.windows.storage.streams.IBuffer) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def provision_async(self, response: winsdk.windows.storage.streams.IBuffer, format_card: _winrt.Boolean) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def provision_async(self, response: winsdk.windows.storage.streams.IBuffer, format_card: _winrt.Boolean, new_card_id: uuid.UUID) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def verify_response_async(self, response: winsdk.windows.storage.streams.IBuffer) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...

class SmartCardConnection(winsdk.windows.foundation.IClosable, _winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardConnection: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def transmit_async(self, command: winsdk.windows.storage.streams.IBuffer) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...

class SmartCardCryptogramGenerator(_winrt.Object):
    supported_cryptogram_algorithms: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramAlgorithm]
    supported_cryptogram_material_package_confirmation_response_formats: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramMaterialPackageConfirmationResponseFormat]
    supported_cryptogram_material_package_formats: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramMaterialPackageFormat]
    supported_cryptogram_material_types: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramMaterialType]
    supported_smart_card_cryptogram_storage_key_capabilities: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramStorageKeyCapabilities]
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardCryptogramGenerator: ...
    @typing.overload
    def create_cryptogram_material_storage_key_async(self, prompting_behavior: SmartCardUnlockPromptingBehavior, storage_key_name: str, algorithm: SmartCardCryptogramStorageKeyAlgorithm, capabilities: SmartCardCryptogramStorageKeyCapabilities) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGeneratorOperationStatus]: ...
    @typing.overload
    def delete_cryptogram_material_package_async(self, material_package_name: str) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGeneratorOperationStatus]: ...
    @typing.overload
    def delete_cryptogram_material_storage_key_async(self, storage_key_name: str) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGeneratorOperationStatus]: ...
    @typing.overload
    def get_all_cryptogram_material_characteristics_async(self, prompting_behavior: SmartCardUnlockPromptingBehavior, material_package_name: str) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult]: ...
    @typing.overload
    def get_all_cryptogram_material_package_characteristics_async(self) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult]: ...
    @typing.overload
    def get_all_cryptogram_material_package_characteristics_async(self, storage_key_name: str) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult]: ...
    @typing.overload
    def get_all_cryptogram_storage_key_characteristics_async(self) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult]: ...
    @typing.overload
    @staticmethod
    def get_smart_card_cryptogram_generator_async() -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGenerator]: ...
    @typing.overload
    def import_cryptogram_material_package_async(self, format: SmartCardCryptogramMaterialPackageFormat, storage_key_name: str, material_package_name: str, cryptogram_material_package: winsdk.windows.storage.streams.IBuffer) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGeneratorOperationStatus]: ...
    @typing.overload
    @staticmethod
    def is_supported() -> _winrt.Boolean: ...
    @typing.overload
    def request_cryptogram_material_storage_key_info_async(self, prompting_behavior: SmartCardUnlockPromptingBehavior, storage_key_name: str, format: winsdk.windows.security.cryptography.core.CryptographicPublicKeyBlobType) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramStorageKeyInfo]: ...
    @typing.overload
    def request_unlock_cryptogram_material_for_use_async(self, prompting_behavior: SmartCardUnlockPromptingBehavior) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGeneratorOperationStatus]: ...
    @typing.overload
    def try_prove_possession_of_cryptogram_material_package_async(self, prompting_behavior: SmartCardUnlockPromptingBehavior, response_format: SmartCardCryptogramMaterialPackageConfirmationResponseFormat, material_package_name: str, material_name: str, challenge: winsdk.windows.storage.streams.IBuffer) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramMaterialPossessionProof]: ...
    @typing.overload
    def validate_request_apdu_async(self, prompting_behavior: SmartCardUnlockPromptingBehavior, apdu_to_validate: winsdk.windows.storage.streams.IBuffer, cryptogram_placement_steps: typing.Iterable[SmartCardCryptogramPlacementStep]) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGeneratorOperationStatus]: ...

class SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult(_winrt.Object):
    characteristics: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramMaterialCharacteristics]
    operation_status: SmartCardCryptogramGeneratorOperationStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardCryptogramGetAllCryptogramMaterialCharacteristicsResult: ...
    @typing.overload
    def __init__(self) -> None: ...

class SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult(_winrt.Object):
    characteristics: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramMaterialPackageCharacteristics]
    operation_status: SmartCardCryptogramGeneratorOperationStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardCryptogramGetAllCryptogramMaterialPackageCharacteristicsResult: ...
    @typing.overload
    def __init__(self) -> None: ...

class SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult(_winrt.Object):
    characteristics: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramStorageKeyCharacteristics]
    operation_status: SmartCardCryptogramGeneratorOperationStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardCryptogramGetAllCryptogramStorageKeyCharacteristicsResult: ...
    @typing.overload
    def __init__(self) -> None: ...

class SmartCardCryptogramMaterialCharacteristics(_winrt.Object):
    allowed_algorithms: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramAlgorithm]
    allowed_proof_of_possession_algorithms: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramMaterialPackageConfirmationResponseFormat]
    allowed_validations: winsdk.windows.foundation.collections.IVectorView[SmartCardCryptogramAlgorithm]
    material_length: _winrt.Int32
    material_name: str
    material_type: SmartCardCryptogramMaterialType
    protection_method: SmartCardCryptogramMaterialProtectionMethod
    protection_version: _winrt.Int32
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardCryptogramMaterialCharacteristics: ...
    @typing.overload
    def __init__(self) -> None: ...

class SmartCardCryptogramMaterialPackageCharacteristics(_winrt.Object):
    date_imported: winsdk.windows.foundation.DateTime
    package_format: SmartCardCryptogramMaterialPackageFormat
    package_name: str
    storage_key_name: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardCryptogramMaterialPackageCharacteristics: ...
    @typing.overload
    def __init__(self) -> None: ...

class SmartCardCryptogramMaterialPossessionProof(_winrt.Object):
    operation_status: SmartCardCryptogramGeneratorOperationStatus
    proof: winsdk.windows.storage.streams.IBuffer
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardCryptogramMaterialPossessionProof: ...

class SmartCardCryptogramPlacementStep(_winrt.Object):
    template_offset: _winrt.Int32
    source_data: winsdk.windows.storage.streams.IBuffer
    cryptogram_placement_options: SmartCardCryptogramPlacementOptions
    cryptogram_offset: _winrt.Int32
    cryptogram_material_package_name: str
    cryptogram_material_name: str
    cryptogram_length: _winrt.Int32
    chained_output_step: SmartCardCryptogramPlacementStep
    algorithm: SmartCardCryptogramAlgorithm
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardCryptogramPlacementStep: ...
    @typing.overload
    def __init__(self) -> None: ...

class SmartCardCryptogramStorageKeyCharacteristics(_winrt.Object):
    algorithm: SmartCardCryptogramStorageKeyAlgorithm
    capabilities: SmartCardCryptogramStorageKeyCapabilities
    date_created: winsdk.windows.foundation.DateTime
    storage_key_name: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardCryptogramStorageKeyCharacteristics: ...
    @typing.overload
    def __init__(self) -> None: ...

class SmartCardCryptogramStorageKeyInfo(_winrt.Object):
    attestation: winsdk.windows.storage.streams.IBuffer
    attestation_certificate_chain: winsdk.windows.storage.streams.IBuffer
    attestation_status: SmartCardCryptographicKeyAttestationStatus
    capabilities: SmartCardCryptogramStorageKeyCapabilities
    operation_status: SmartCardCryptogramGeneratorOperationStatus
    public_key: winsdk.windows.storage.streams.IBuffer
    public_key_blob_type: winsdk.windows.security.cryptography.core.CryptographicPublicKeyBlobType
    operational_requirements: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardCryptogramStorageKeyInfo: ...

class SmartCardEmulator(_winrt.Object):
    enablement_policy: SmartCardEmulatorEnablementPolicy
    max_applet_id_group_registrations: _winrt.UInt16
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardEmulator: ...
    @typing.overload
    @staticmethod
    def get_applet_id_group_registrations_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[SmartCardAppletIdGroupRegistration]]: ...
    @typing.overload
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[SmartCardEmulator]: ...
    @typing.overload
    def is_host_card_emulation_supported(self) -> _winrt.Boolean: ...
    @typing.overload
    @staticmethod
    def is_supported() -> _winrt.Boolean: ...
    @typing.overload
    @staticmethod
    def register_applet_id_group_async(applet_id_group: SmartCardAppletIdGroup) -> winsdk.windows.foundation.IAsyncOperation[SmartCardAppletIdGroupRegistration]: ...
    @typing.overload
    def start(self) -> None: ...
    @typing.overload
    @staticmethod
    def unregister_applet_id_group_async(registration: SmartCardAppletIdGroupRegistration) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def add_apdu_received(self, value: winsdk.windows.foundation.TypedEventHandler[SmartCardEmulator, SmartCardEmulatorApduReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_apdu_received(self, value: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_connection_deactivated(self, value: winsdk.windows.foundation.TypedEventHandler[SmartCardEmulator, SmartCardEmulatorConnectionDeactivatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_connection_deactivated(self, value: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class SmartCardEmulatorApduReceivedEventArgs(_winrt.Object):
    automatic_response_status: SmartCardAutomaticResponseStatus
    command_apdu: winsdk.windows.storage.streams.IBuffer
    connection_properties: SmartCardEmulatorConnectionProperties
    state: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardEmulatorApduReceivedEventArgs: ...
    @typing.overload
    def try_respond_async(self, response_apdu: winsdk.windows.storage.streams.IBuffer) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_respond_async(self, response_apdu: winsdk.windows.storage.streams.IBuffer, next_state: typing.Optional[_winrt.UInt32]) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_respond_with_cryptograms_async(self, response_template: winsdk.windows.storage.streams.IBuffer, cryptogram_placement_steps: typing.Iterable[SmartCardCryptogramPlacementStep]) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGeneratorOperationStatus]: ...
    @typing.overload
    def try_respond_with_cryptograms_async(self, response_template: winsdk.windows.storage.streams.IBuffer, cryptogram_placement_steps: typing.Iterable[SmartCardCryptogramPlacementStep], next_state: typing.Optional[_winrt.UInt32]) -> winsdk.windows.foundation.IAsyncOperation[SmartCardCryptogramGeneratorOperationStatus]: ...

class SmartCardEmulatorConnectionDeactivatedEventArgs(_winrt.Object):
    connection_properties: SmartCardEmulatorConnectionProperties
    reason: SmartCardEmulatorConnectionDeactivatedReason
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardEmulatorConnectionDeactivatedEventArgs: ...

class SmartCardEmulatorConnectionProperties(_winrt.Object):
    id: uuid.UUID
    source: SmartCardEmulatorConnectionSource
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardEmulatorConnectionProperties: ...

class SmartCardPinPolicy(_winrt.Object):
    uppercase_letters: SmartCardPinCharacterPolicyOption
    special_characters: SmartCardPinCharacterPolicyOption
    min_length: _winrt.UInt32
    max_length: _winrt.UInt32
    lowercase_letters: SmartCardPinCharacterPolicyOption
    digits: SmartCardPinCharacterPolicyOption
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardPinPolicy: ...
    @typing.overload
    def __init__(self) -> None: ...

class SmartCardPinResetDeferral(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardPinResetDeferral: ...
    @typing.overload
    def complete(self) -> None: ...

class SmartCardPinResetRequest(_winrt.Object):
    challenge: winsdk.windows.storage.streams.IBuffer
    deadline: winsdk.windows.foundation.DateTime
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardPinResetRequest: ...
    @typing.overload
    def get_deferral(self) -> SmartCardPinResetDeferral: ...
    @typing.overload
    def set_response(self, response: winsdk.windows.storage.streams.IBuffer) -> None: ...

class SmartCardProvisioning(_winrt.Object):
    smart_card: SmartCard
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardProvisioning: ...
    @typing.overload
    @staticmethod
    def from_smart_card_async(card: SmartCard) -> winsdk.windows.foundation.IAsyncOperation[SmartCardProvisioning]: ...
    @typing.overload
    def get_authority_key_container_name_async(self) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    def get_challenge_context_async(self) -> winsdk.windows.foundation.IAsyncOperation[SmartCardChallengeContext]: ...
    @typing.overload
    def get_id_async(self) -> winsdk.windows.foundation.IAsyncOperation[uuid.UUID]: ...
    @typing.overload
    def get_name_async(self) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    @staticmethod
    def request_attested_virtual_smart_card_creation_async(friendly_name: str, administrative_key: winsdk.windows.storage.streams.IBuffer, pin_policy: SmartCardPinPolicy) -> winsdk.windows.foundation.IAsyncOperation[SmartCardProvisioning]: ...
    @typing.overload
    @staticmethod
    def request_attested_virtual_smart_card_creation_async(friendly_name: str, administrative_key: winsdk.windows.storage.streams.IBuffer, pin_policy: SmartCardPinPolicy, card_id: uuid.UUID) -> winsdk.windows.foundation.IAsyncOperation[SmartCardProvisioning]: ...
    @typing.overload
    def request_pin_change_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def request_pin_reset_async(self, handler: SmartCardPinResetHandler) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    @staticmethod
    def request_virtual_smart_card_creation_async(friendly_name: str, administrative_key: winsdk.windows.storage.streams.IBuffer, pin_policy: SmartCardPinPolicy) -> winsdk.windows.foundation.IAsyncOperation[SmartCardProvisioning]: ...
    @typing.overload
    @staticmethod
    def request_virtual_smart_card_creation_async(friendly_name: str, administrative_key: winsdk.windows.storage.streams.IBuffer, pin_policy: SmartCardPinPolicy, card_id: uuid.UUID) -> winsdk.windows.foundation.IAsyncOperation[SmartCardProvisioning]: ...
    @typing.overload
    @staticmethod
    def request_virtual_smart_card_deletion_async(card: SmartCard) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...

class SmartCardReader(_winrt.Object):
    device_id: str
    kind: SmartCardReaderKind
    name: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardReader: ...
    @typing.overload
    def find_all_cards_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[SmartCard]]: ...
    @typing.overload
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[SmartCardReader]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(kind: SmartCardReaderKind) -> str: ...
    @typing.overload
    def get_status_async(self) -> winsdk.windows.foundation.IAsyncOperation[SmartCardReaderStatus]: ...
    @typing.overload
    def add_card_added(self, handler: winsdk.windows.foundation.TypedEventHandler[SmartCardReader, CardAddedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_card_added(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_card_removed(self, handler: winsdk.windows.foundation.TypedEventHandler[SmartCardReader, CardRemovedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_card_removed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class SmartCardTriggerDetails(_winrt.Object):
    source_applet_id: winsdk.windows.storage.streams.IBuffer
    trigger_data: winsdk.windows.storage.streams.IBuffer
    trigger_type: SmartCardTriggerType
    emulator: SmartCardEmulator
    smart_card: SmartCard
    @staticmethod
    def _from(obj: _winrt.Object) -> SmartCardTriggerDetails: ...
    @typing.overload
    def try_launch_current_app_async(self, arguments: str) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_launch_current_app_async(self, arguments: str, behavior: SmartCardLaunchBehavior) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...

SmartCardPinResetHandler = typing.Callable[[SmartCardProvisioning, SmartCardPinResetRequest], None]

