# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.2

import enum
import sys
import types
import typing
import uuid

import winsdk._winrt as _winrt

try:
    import winsdk.windows.foundation
except Exception:
    pass

try:
    import winsdk.windows.foundation.collections
except Exception:
    pass

try:
    import winsdk.windows.graphics.imaging
except Exception:
    pass

try:
    import winsdk.windows.storage
except Exception:
    pass

try:
    import winsdk.windows.storage.streams
except Exception:
    pass

class BarcodeScannerStatus(enum.IntEnum):
    ONLINE = 0
    OFF = 1
    OFFLINE = 2
    OFF_OR_OFFLINE = 3
    EXTENDED = 4

class BarcodeSymbologyDecodeLengthKind(enum.IntEnum):
    ANY_LENGTH = 0
    DISCRETE = 1
    RANGE = 2

class CashDrawerStatusKind(enum.IntEnum):
    ONLINE = 0
    OFF = 1
    OFFLINE = 2
    OFF_OR_OFFLINE = 3
    EXTENDED = 4

class LineDisplayCursorType(enum.IntEnum):
    NONE = 0
    BLOCK = 1
    HALF_BLOCK = 2
    UNDERLINE = 3
    REVERSE = 4
    OTHER = 5

class LineDisplayDescriptorState(enum.IntEnum):
    OFF = 0
    ON = 1
    BLINK = 2

class LineDisplayHorizontalAlignment(enum.IntEnum):
    LEFT = 0
    CENTER = 1
    RIGHT = 2

class LineDisplayMarqueeFormat(enum.IntEnum):
    NONE = 0
    WALK = 1
    PLACE = 2

class LineDisplayPowerStatus(enum.IntEnum):
    UNKNOWN = 0
    ONLINE = 1
    OFF = 2
    OFFLINE = 3
    OFF_OR_OFFLINE = 4

class LineDisplayScrollDirection(enum.IntEnum):
    UP = 0
    DOWN = 1
    LEFT = 2
    RIGHT = 3

class LineDisplayTextAttribute(enum.IntEnum):
    NORMAL = 0
    BLINK = 1
    REVERSE = 2
    REVERSE_BLINK = 3

class LineDisplayTextAttributeGranularity(enum.IntEnum):
    NOT_SUPPORTED = 0
    ENTIRE_DISPLAY = 1
    PER_CHARACTER = 2

class LineDisplayVerticalAlignment(enum.IntEnum):
    TOP = 0
    CENTER = 1
    BOTTOM = 2

class MagneticStripeReaderAuthenticationLevel(enum.IntEnum):
    NOT_SUPPORTED = 0
    OPTIONAL = 1
    REQUIRED = 2

class MagneticStripeReaderAuthenticationProtocol(enum.IntEnum):
    NONE = 0
    CHALLENGE_RESPONSE = 1

class MagneticStripeReaderErrorReportingType(enum.IntEnum):
    CARD_LEVEL = 0
    TRACK_LEVEL = 1

class MagneticStripeReaderStatus(enum.IntEnum):
    UNAUTHENTICATED = 0
    AUTHENTICATED = 1
    EXTENDED = 2

class MagneticStripeReaderTrackErrorType(enum.IntEnum):
    NONE = 0
    START_SENTINEL_ERROR = 1
    END_SENTINEL_ERROR = 2
    PARITY_ERROR = 3
    LRC_ERROR = 4
    UNKNOWN = -1

class MagneticStripeReaderTrackIds(enum.IntEnum):
    NONE = 0
    TRACK1 = 1
    TRACK2 = 2
    TRACK3 = 4
    TRACK4 = 8

class PosConnectionTypes(enum.IntFlag):
    LOCAL = 0x1
    I_P = 0x2
    BLUETOOTH = 0x4
    ALL = 0xffffffff

class PosPrinterAlignment(enum.IntEnum):
    LEFT = 0
    CENTER = 1
    RIGHT = 2

class PosPrinterBarcodeTextPosition(enum.IntEnum):
    NONE = 0
    ABOVE = 1
    BELOW = 2

class PosPrinterCartridgeSensors(enum.IntFlag):
    NONE = 0
    REMOVED = 0x1
    EMPTY = 0x2
    HEAD_CLEANING = 0x4
    NEAR_END = 0x8

class PosPrinterColorCapabilities(enum.IntFlag):
    NONE = 0
    PRIMARY = 0x1
    CUSTOM1 = 0x2
    CUSTOM2 = 0x4
    CUSTOM3 = 0x8
    CUSTOM4 = 0x10
    CUSTOM5 = 0x20
    CUSTOM6 = 0x40
    CYAN = 0x80
    MAGENTA = 0x100
    YELLOW = 0x200
    FULL = 0x400

class PosPrinterColorCartridge(enum.IntEnum):
    UNKNOWN = 0
    PRIMARY = 1
    CUSTOM1 = 2
    CUSTOM2 = 3
    CUSTOM3 = 4
    CUSTOM4 = 5
    CUSTOM5 = 6
    CUSTOM6 = 7
    CYAN = 8
    MAGENTA = 9
    YELLOW = 10

class PosPrinterLineDirection(enum.IntEnum):
    HORIZONTAL = 0
    VERTICAL = 1

class PosPrinterLineStyle(enum.IntEnum):
    SINGLE_SOLID = 0
    DOUBLE_SOLID = 1
    BROKEN = 2
    CHAIN = 3

class PosPrinterMapMode(enum.IntEnum):
    DOTS = 0
    TWIPS = 1
    ENGLISH = 2
    METRIC = 3

class PosPrinterMarkFeedCapabilities(enum.IntFlag):
    NONE = 0
    TO_TAKE_UP = 0x1
    TO_CUTTER = 0x2
    TO_CURRENT_TOP_OF_FORM = 0x4
    TO_NEXT_TOP_OF_FORM = 0x8

class PosPrinterMarkFeedKind(enum.IntEnum):
    TO_TAKE_UP = 0
    TO_CUTTER = 1
    TO_CURRENT_TOP_OF_FORM = 2
    TO_NEXT_TOP_OF_FORM = 3

class PosPrinterPrintSide(enum.IntEnum):
    UNKNOWN = 0
    SIDE1 = 1
    SIDE2 = 2

class PosPrinterRotation(enum.IntEnum):
    NORMAL = 0
    RIGHT90 = 1
    LEFT90 = 2
    ROTATE180 = 3

class PosPrinterRuledLineCapabilities(enum.IntFlag):
    NONE = 0
    HORIZONTAL = 0x1
    VERTICAL = 0x2

class PosPrinterStatusKind(enum.IntEnum):
    ONLINE = 0
    OFF = 1
    OFFLINE = 2
    OFF_OR_OFFLINE = 3
    EXTENDED = 4

class UnifiedPosErrorReason(enum.IntEnum):
    UNKNOWN_ERROR_REASON = 0
    NO_SERVICE = 1
    DISABLED = 2
    ILLEGAL = 3
    NO_HARDWARE = 4
    CLOSED = 5
    OFFLINE = 6
    FAILURE = 7
    TIMEOUT = 8
    BUSY = 9
    EXTENDED = 10

class UnifiedPosErrorSeverity(enum.IntEnum):
    UNKNOWN_ERROR_SEVERITY = 0
    WARNING = 1
    RECOVERABLE = 2
    UNRECOVERABLE = 3
    ASSISTANCE_REQUIRED = 4
    FATAL = 5

class UnifiedPosHealthCheckLevel(enum.IntEnum):
    UNKNOWN_HEALTH_CHECK_LEVEL = 0
    P_O_S_INTERNAL = 1
    EXTERNAL = 2
    INTERACTIVE = 3

class UnifiedPosPowerReportingType(enum.IntEnum):
    UNKNOWN_POWER_REPORTING_TYPE = 0
    STANDARD = 1
    ADVANCED = 2

class SizeUInt32:
    width: _winrt.UInt32
    height: _winrt.UInt32
    def __init__(self, width: _winrt.UInt32, height: _winrt.UInt32) -> None: ...

class BarcodeScanner(winsdk.windows.foundation.IClosable, _winrt.Object):
    capabilities: BarcodeScannerCapabilities
    device_id: str
    video_device_id: str
    @staticmethod
    def _from(obj: _winrt.Object) -> BarcodeScanner: ...
    @typing.overload
    def check_health_async(self, level: UnifiedPosHealthCheckLevel) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    def claim_scanner_async(self) -> winsdk.windows.foundation.IAsyncOperation[ClaimedBarcodeScanner]: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[BarcodeScanner]: ...
    @typing.overload
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[BarcodeScanner]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...
    @typing.overload
    def get_supported_profiles(self) -> winsdk.windows.foundation.collections.IVectorView[str]: ...
    @typing.overload
    def get_supported_symbologies_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]]: ...
    @typing.overload
    def is_profile_supported(self, profile: str) -> _winrt.Boolean: ...
    @typing.overload
    def is_symbology_supported_async(self, barcode_symbology: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def retrieve_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    @typing.overload
    def add_status_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[BarcodeScanner, BarcodeScannerStatusUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_status_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class BarcodeScannerCapabilities(_winrt.Object):
    is_image_preview_supported: _winrt.Boolean
    is_statistics_reporting_supported: _winrt.Boolean
    is_statistics_updating_supported: _winrt.Boolean
    power_reporting_type: UnifiedPosPowerReportingType
    is_software_trigger_supported: _winrt.Boolean
    is_video_preview_supported: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> BarcodeScannerCapabilities: ...

class BarcodeScannerDataReceivedEventArgs(_winrt.Object):
    report: BarcodeScannerReport
    @staticmethod
    def _from(obj: _winrt.Object) -> BarcodeScannerDataReceivedEventArgs: ...

class BarcodeScannerErrorOccurredEventArgs(_winrt.Object):
    error_data: UnifiedPosErrorData
    is_retriable: _winrt.Boolean
    partial_input_data: BarcodeScannerReport
    @staticmethod
    def _from(obj: _winrt.Object) -> BarcodeScannerErrorOccurredEventArgs: ...

class BarcodeScannerImagePreviewReceivedEventArgs(_winrt.Object):
    preview: winsdk.windows.storage.streams.IRandomAccessStreamWithContentType
    @staticmethod
    def _from(obj: _winrt.Object) -> BarcodeScannerImagePreviewReceivedEventArgs: ...

class BarcodeScannerReport(_winrt.Object):
    scan_data: winsdk.windows.storage.streams.IBuffer
    scan_data_label: winsdk.windows.storage.streams.IBuffer
    scan_data_type: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> BarcodeScannerReport: ...
    @typing.overload
    def __init__(self, scan_data_type: _winrt.UInt32, scan_data: winsdk.windows.storage.streams.IBuffer, scan_data_label: winsdk.windows.storage.streams.IBuffer) -> None: ...

class BarcodeScannerStatusUpdatedEventArgs(_winrt.Object):
    extended_status: _winrt.UInt32
    status: BarcodeScannerStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> BarcodeScannerStatusUpdatedEventArgs: ...

class BarcodeSymbologies(_winrt.Object):
    code11: _winrt.UInt32
    aus_post: _winrt.UInt32
    aztec: _winrt.UInt32
    can_post: _winrt.UInt32
    ccab: _winrt.UInt32
    ccc: _winrt.UInt32
    china_post: _winrt.UInt32
    codabar: _winrt.UInt32
    codablock128: _winrt.UInt32
    codablock_a: _winrt.UInt32
    codablock_f: _winrt.UInt32
    dutch_kix: _winrt.UInt32
    code128: _winrt.UInt32
    code16k: _winrt.UInt32
    code32: _winrt.UInt32
    code39: _winrt.UInt32
    code39_ex: _winrt.UInt32
    code49: _winrt.UInt32
    code93: _winrt.UInt32
    code93_ex: _winrt.UInt32
    data_code: _winrt.UInt32
    data_matrix: _winrt.UInt32
    us_post_net: _winrt.UInt32
    ean13: _winrt.UInt32
    ean13_add2: _winrt.UInt32
    ean13_add5: _winrt.UInt32
    ean8: _winrt.UInt32
    ean8_add2: _winrt.UInt32
    ean8_add5: _winrt.UInt32
    ean99: _winrt.UInt32
    ean99_add2: _winrt.UInt32
    ean99_add5: _winrt.UInt32
    eanv: _winrt.UInt32
    eanv_add2: _winrt.UInt32
    eanv_add5: _winrt.UInt32
    extended_base: _winrt.UInt32
    gs1128: _winrt.UInt32
    gs1128_coupon: _winrt.UInt32
    gs1_databar_type1: _winrt.UInt32
    gs1_databar_type2: _winrt.UInt32
    gs1_databar_type3: _winrt.UInt32
    han_xin: _winrt.UInt32
    info_mail: _winrt.UInt32
    isbn: _winrt.UInt32
    isbn_add5: _winrt.UInt32
    isbt: _winrt.UInt32
    ismn: _winrt.UInt32
    ismn_add2: _winrt.UInt32
    ismn_add5: _winrt.UInt32
    issn: _winrt.UInt32
    issn_add2: _winrt.UInt32
    issn_add5: _winrt.UInt32
    italian_post25: _winrt.UInt32
    italian_post39: _winrt.UInt32
    japan_post: _winrt.UInt32
    korean_post: _winrt.UInt32
    maxicode: _winrt.UInt32
    micr: _winrt.UInt32
    micro_pdf417: _winrt.UInt32
    micro_qr: _winrt.UInt32
    ms_tag: _winrt.UInt32
    msi: _winrt.UInt32
    ocr_a: _winrt.UInt32
    ocr_b: _winrt.UInt32
    pdf417: _winrt.UInt32
    plessey: _winrt.UInt32
    pzn: _winrt.UInt32
    qr: _winrt.UInt32
    sisac: _winrt.UInt32
    sweden_post: _winrt.UInt32
    telepen: _winrt.UInt32
    tf_dis: _winrt.UInt32
    tf_iata: _winrt.UInt32
    tf_ind: _winrt.UInt32
    tf_int: _winrt.UInt32
    tf_mat: _winrt.UInt32
    tf_std: _winrt.UInt32
    tlc39: _winrt.UInt32
    trioptic39: _winrt.UInt32
    ucc_ean128: _winrt.UInt32
    uk_post: _winrt.UInt32
    unknown: _winrt.UInt32
    upc_coupon: _winrt.UInt32
    upca: _winrt.UInt32
    upca_add2: _winrt.UInt32
    upca_add5: _winrt.UInt32
    upce: _winrt.UInt32
    upce_add2: _winrt.UInt32
    upce_add5: _winrt.UInt32
    us4_state_fics: _winrt.UInt32
    us_intelligent: _winrt.UInt32
    us_intelligent_pkg: _winrt.UInt32
    us_planet: _winrt.UInt32
    gs1_d_w_code: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> BarcodeSymbologies: ...
    @typing.overload
    @staticmethod
    def get_name(scan_data_type: _winrt.UInt32) -> str: ...

class BarcodeSymbologyAttributes(_winrt.Object):
    is_check_digit_validation_enabled: _winrt.Boolean
    is_check_digit_transmission_enabled: _winrt.Boolean
    decode_length_kind: BarcodeSymbologyDecodeLengthKind
    decode_length2: _winrt.UInt32
    decode_length1: _winrt.UInt32
    is_check_digit_transmission_supported: _winrt.Boolean
    is_check_digit_validation_supported: _winrt.Boolean
    is_decode_length_supported: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> BarcodeSymbologyAttributes: ...

class CashDrawer(winsdk.windows.foundation.IClosable, _winrt.Object):
    capabilities: CashDrawerCapabilities
    device_id: str
    drawer_event_source: CashDrawerEventSource
    is_drawer_open: _winrt.Boolean
    status: CashDrawerStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> CashDrawer: ...
    @typing.overload
    def check_health_async(self, level: UnifiedPosHealthCheckLevel) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    def claim_drawer_async(self) -> winsdk.windows.foundation.IAsyncOperation[ClaimedCashDrawer]: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[CashDrawer]: ...
    @typing.overload
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[CashDrawer]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...
    @typing.overload
    def get_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    def add_status_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[CashDrawer, CashDrawerStatusUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_status_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class CashDrawerCapabilities(_winrt.Object):
    is_drawer_open_sensor_available: _winrt.Boolean
    is_statistics_reporting_supported: _winrt.Boolean
    is_statistics_updating_supported: _winrt.Boolean
    is_status_multi_drawer_detect_supported: _winrt.Boolean
    is_status_reporting_supported: _winrt.Boolean
    power_reporting_type: UnifiedPosPowerReportingType
    @staticmethod
    def _from(obj: _winrt.Object) -> CashDrawerCapabilities: ...

class CashDrawerCloseAlarm(_winrt.Object):
    beep_frequency: _winrt.UInt32
    beep_duration: winsdk.windows.foundation.TimeSpan
    beep_delay: winsdk.windows.foundation.TimeSpan
    alarm_timeout: winsdk.windows.foundation.TimeSpan
    @staticmethod
    def _from(obj: _winrt.Object) -> CashDrawerCloseAlarm: ...
    @typing.overload
    def start_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def add_alarm_timeout_expired(self, handler: winsdk.windows.foundation.TypedEventHandler[CashDrawerCloseAlarm, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_alarm_timeout_expired(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class CashDrawerClosedEventArgs(ICashDrawerEventSourceEventArgs, _winrt.Object):
    cash_drawer: CashDrawer
    @staticmethod
    def _from(obj: _winrt.Object) -> CashDrawerClosedEventArgs: ...

class CashDrawerEventSource(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> CashDrawerEventSource: ...
    @typing.overload
    def add_drawer_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[CashDrawerEventSource, CashDrawerClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_drawer_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_drawer_opened(self, handler: winsdk.windows.foundation.TypedEventHandler[CashDrawerEventSource, CashDrawerOpenedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_drawer_opened(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class CashDrawerOpenedEventArgs(ICashDrawerEventSourceEventArgs, _winrt.Object):
    cash_drawer: CashDrawer
    @staticmethod
    def _from(obj: _winrt.Object) -> CashDrawerOpenedEventArgs: ...

class CashDrawerStatus(_winrt.Object):
    extended_status: _winrt.UInt32
    status_kind: CashDrawerStatusKind
    @staticmethod
    def _from(obj: _winrt.Object) -> CashDrawerStatus: ...

class CashDrawerStatusUpdatedEventArgs(_winrt.Object):
    status: CashDrawerStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> CashDrawerStatusUpdatedEventArgs: ...

class ClaimedBarcodeScanner(winsdk.windows.foundation.IClosable, _winrt.Object):
    is_disabled_on_data_received: _winrt.Boolean
    is_decode_data_enabled: _winrt.Boolean
    device_id: str
    is_enabled: _winrt.Boolean
    is_video_preview_shown_on_enable: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedBarcodeScanner: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def disable_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def enable_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def get_symbology_attributes_async(self, barcode_symbology: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[BarcodeSymbologyAttributes]: ...
    @typing.overload
    def hide_video_preview(self) -> None: ...
    @typing.overload
    def reset_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def retain_device(self) -> None: ...
    @typing.overload
    def set_active_profile_async(self, profile: str) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def set_active_symbologies_async(self, symbologies: typing.Iterable[_winrt.UInt32]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def set_symbology_attributes_async(self, barcode_symbology: _winrt.UInt32, attributes: BarcodeSymbologyAttributes) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def show_video_preview_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def start_software_trigger_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def stop_software_trigger_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def update_statistics_async(self, statistics: typing.Iterable[winsdk.windows.foundation.collections.IKeyValuePair[str, str]]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def add_data_received(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedBarcodeScanner, BarcodeScannerDataReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_data_received(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_error_occurred(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedBarcodeScanner, BarcodeScannerErrorOccurredEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_error_occurred(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_image_preview_received(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedBarcodeScanner, BarcodeScannerImagePreviewReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_image_preview_received(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_release_device_requested(self, handler: winsdk.windows.foundation.EventHandler[ClaimedBarcodeScanner]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_release_device_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_trigger_pressed(self, handler: winsdk.windows.foundation.EventHandler[ClaimedBarcodeScanner]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_trigger_pressed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_trigger_released(self, handler: winsdk.windows.foundation.EventHandler[ClaimedBarcodeScanner]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_trigger_released(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedBarcodeScanner, ClaimedBarcodeScannerClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ClaimedBarcodeScannerClosedEventArgs(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedBarcodeScannerClosedEventArgs: ...

class ClaimedCashDrawer(winsdk.windows.foundation.IClosable, _winrt.Object):
    close_alarm: CashDrawerCloseAlarm
    device_id: str
    is_drawer_open: _winrt.Boolean
    is_enabled: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedCashDrawer: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def disable_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def enable_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def open_drawer_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def reset_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def retain_device_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def update_statistics_async(self, statistics: typing.Iterable[winsdk.windows.foundation.collections.IKeyValuePair[str, str]]) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def add_release_device_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedCashDrawer, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_release_device_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedCashDrawer, ClaimedCashDrawerClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ClaimedCashDrawerClosedEventArgs(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedCashDrawerClosedEventArgs: ...

class ClaimedJournalPrinter(ICommonClaimedPosPrinterStation, _winrt.Object):
    line_spacing: _winrt.UInt32
    line_height: _winrt.UInt32
    is_letter_quality: _winrt.Boolean
    color_cartridge: PosPrinterColorCartridge
    characters_per_line: _winrt.UInt32
    is_cartridge_empty: _winrt.Boolean
    is_cartridge_removed: _winrt.Boolean
    is_cover_open: _winrt.Boolean
    is_head_cleaning: _winrt.Boolean
    is_paper_empty: _winrt.Boolean
    is_paper_near_end: _winrt.Boolean
    is_ready_to_print: _winrt.Boolean
    line_width: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedJournalPrinter: ...
    @typing.overload
    def create_job(self) -> JournalPrintJob: ...
    @typing.overload
    def validate_data(self, data: str) -> _winrt.Boolean: ...

class ClaimedLineDisplay(winsdk.windows.foundation.IClosable, _winrt.Object):
    capabilities: LineDisplayCapabilities
    default_window: LineDisplayWindow
    device_control_description: str
    device_control_version: str
    device_id: str
    device_service_version: str
    physical_device_description: str
    physical_device_name: str
    custom_glyphs: LineDisplayCustomGlyphs
    max_bitmap_size_in_pixels: winsdk.windows.foundation.Size
    supported_character_sets: winsdk.windows.foundation.collections.IVectorView[_winrt.Int32]
    supported_screen_sizes_in_characters: winsdk.windows.foundation.collections.IVectorView[winsdk.windows.foundation.Size]
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedLineDisplay: ...
    @typing.overload
    def check_health_async(self, level: UnifiedPosHealthCheckLevel) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    def check_power_status_async(self) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayPowerStatus]: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[ClaimedLineDisplay]: ...
    @typing.overload
    def get_attributes(self) -> LineDisplayAttributes: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...
    @typing.overload
    def get_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    def retain_device(self) -> None: ...
    @typing.overload
    def try_clear_descriptors_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_create_window_async(self, viewport: winsdk.windows.foundation.Rect, window_size: winsdk.windows.foundation.Size) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayWindow]: ...
    @typing.overload
    def try_set_descriptor_async(self, descriptor: _winrt.UInt32, descriptor_state: LineDisplayDescriptorState) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_store_storage_file_bitmap_async(self, bitmap: winsdk.windows.storage.StorageFile) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayStoredBitmap]: ...
    @typing.overload
    def try_store_storage_file_bitmap_async(self, bitmap: winsdk.windows.storage.StorageFile, horizontal_alignment: LineDisplayHorizontalAlignment, vertical_alignment: LineDisplayVerticalAlignment) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayStoredBitmap]: ...
    @typing.overload
    def try_store_storage_file_bitmap_async(self, bitmap: winsdk.windows.storage.StorageFile, horizontal_alignment: LineDisplayHorizontalAlignment, vertical_alignment: LineDisplayVerticalAlignment, width_in_pixels: _winrt.Int32) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayStoredBitmap]: ...
    @typing.overload
    def try_update_attributes_async(self, attributes: LineDisplayAttributes) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def add_release_device_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedLineDisplay, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_release_device_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_status_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedLineDisplay, LineDisplayStatusUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_status_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedLineDisplay, ClaimedLineDisplayClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ClaimedLineDisplayClosedEventArgs(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedLineDisplayClosedEventArgs: ...

class ClaimedMagneticStripeReader(winsdk.windows.foundation.IClosable, _winrt.Object):
    tracks_to_read: MagneticStripeReaderTrackIds
    is_transmit_sentinels_enabled: _winrt.Boolean
    is_disabled_on_data_received: _winrt.Boolean
    is_decode_data_enabled: _winrt.Boolean
    data_encryption_algorithm: _winrt.UInt32
    device_id: str
    is_device_authenticated: _winrt.Boolean
    is_enabled: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedMagneticStripeReader: ...
    @typing.overload
    def authenticate_device_async(self, response_token: typing.Sequence[_winrt.UInt8]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def de_authenticate_device_async(self, response_token: typing.Sequence[_winrt.UInt8]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def disable_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def enable_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def reset_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def retain_device(self) -> None: ...
    @typing.overload
    def retrieve_device_authentication_data_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    @typing.overload
    def set_error_reporting_type(self, value: MagneticStripeReaderErrorReportingType) -> None: ...
    @typing.overload
    def update_key_async(self, key: str, key_name: str) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def update_statistics_async(self, statistics: typing.Iterable[winsdk.windows.foundation.collections.IKeyValuePair[str, str]]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def add_aamva_card_data_received(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedMagneticStripeReader, MagneticStripeReaderAamvaCardDataReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_aamva_card_data_received(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_bank_card_data_received(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedMagneticStripeReader, MagneticStripeReaderBankCardDataReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_bank_card_data_received(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_error_occurred(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedMagneticStripeReader, MagneticStripeReaderErrorOccurredEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_error_occurred(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_release_device_requested(self, handler: winsdk.windows.foundation.EventHandler[ClaimedMagneticStripeReader]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_release_device_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_vendor_specific_data_received(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedMagneticStripeReader, MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_vendor_specific_data_received(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedMagneticStripeReader, ClaimedMagneticStripeReaderClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ClaimedMagneticStripeReaderClosedEventArgs(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedMagneticStripeReaderClosedEventArgs: ...

class ClaimedPosPrinter(winsdk.windows.foundation.IClosable, _winrt.Object):
    map_mode: PosPrinterMapMode
    is_character_set_mapping_enabled: _winrt.Boolean
    character_set: _winrt.UInt32
    device_id: str
    is_cover_open: _winrt.Boolean
    is_enabled: _winrt.Boolean
    journal: ClaimedJournalPrinter
    receipt: ClaimedReceiptPrinter
    slip: ClaimedSlipPrinter
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedPosPrinter: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def disable_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def enable_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def reset_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def retain_device_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def update_statistics_async(self, statistics: typing.Iterable[winsdk.windows.foundation.collections.IKeyValuePair[str, str]]) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def add_release_device_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedPosPrinter, PosPrinterReleaseDeviceRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_release_device_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[ClaimedPosPrinter, ClaimedPosPrinterClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ClaimedPosPrinterClosedEventArgs(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedPosPrinterClosedEventArgs: ...

class ClaimedReceiptPrinter(ICommonClaimedPosPrinterStation, _winrt.Object):
    lines_to_paper_cut: _winrt.UInt32
    page_size: winsdk.windows.foundation.Size
    print_area: winsdk.windows.foundation.Rect
    sideways_max_chars: _winrt.UInt32
    sideways_max_lines: _winrt.UInt32
    line_spacing: _winrt.UInt32
    line_height: _winrt.UInt32
    is_letter_quality: _winrt.Boolean
    color_cartridge: PosPrinterColorCartridge
    characters_per_line: _winrt.UInt32
    is_cartridge_empty: _winrt.Boolean
    is_cartridge_removed: _winrt.Boolean
    is_cover_open: _winrt.Boolean
    is_head_cleaning: _winrt.Boolean
    is_paper_empty: _winrt.Boolean
    is_paper_near_end: _winrt.Boolean
    is_ready_to_print: _winrt.Boolean
    line_width: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedReceiptPrinter: ...
    @typing.overload
    def create_job(self) -> ReceiptPrintJob: ...
    @typing.overload
    def validate_data(self, data: str) -> _winrt.Boolean: ...

class ClaimedSlipPrinter(ICommonClaimedPosPrinterStation, _winrt.Object):
    lines_near_end_to_end: _winrt.UInt32
    max_lines: _winrt.UInt32
    page_size: winsdk.windows.foundation.Size
    print_area: winsdk.windows.foundation.Rect
    print_side: PosPrinterPrintSide
    sideways_max_chars: _winrt.UInt32
    sideways_max_lines: _winrt.UInt32
    line_spacing: _winrt.UInt32
    line_height: _winrt.UInt32
    is_letter_quality: _winrt.Boolean
    color_cartridge: PosPrinterColorCartridge
    characters_per_line: _winrt.UInt32
    is_cartridge_empty: _winrt.Boolean
    is_cartridge_removed: _winrt.Boolean
    is_cover_open: _winrt.Boolean
    is_head_cleaning: _winrt.Boolean
    is_paper_empty: _winrt.Boolean
    is_paper_near_end: _winrt.Boolean
    is_ready_to_print: _winrt.Boolean
    line_width: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> ClaimedSlipPrinter: ...
    @typing.overload
    def change_print_side(self, print_side: PosPrinterPrintSide) -> None: ...
    @typing.overload
    def close_jaws(self) -> None: ...
    @typing.overload
    def create_job(self) -> SlipPrintJob: ...
    @typing.overload
    def insert_slip_async(self, timeout: winsdk.windows.foundation.TimeSpan) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def open_jaws(self) -> None: ...
    @typing.overload
    def remove_slip_async(self, timeout: winsdk.windows.foundation.TimeSpan) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def validate_data(self, data: str) -> _winrt.Boolean: ...

class JournalPrintJob(IPosPrinterJob, _winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> JournalPrintJob: ...
    @typing.overload
    def execute_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def feed_paper_by_line(self, line_count: _winrt.Int32) -> None: ...
    @typing.overload
    def feed_paper_by_map_mode_unit(self, distance: _winrt.Int32) -> None: ...
    @typing.overload
    def print(self, data: str) -> None: ...
    @typing.overload
    def print(self, data: str, print_options: PosPrinterPrintOptions) -> None: ...
    @typing.overload
    def print_line(self) -> None: ...
    @typing.overload
    def print_line(self, data: str) -> None: ...

class JournalPrinterCapabilities(ICommonPosPrintStationCapabilities, _winrt.Object):
    cartridge_sensors: PosPrinterCartridgeSensors
    color_cartridge_capabilities: PosPrinterColorCapabilities
    is_bold_supported: _winrt.Boolean
    is_double_high_double_wide_print_supported: _winrt.Boolean
    is_double_high_print_supported: _winrt.Boolean
    is_double_wide_print_supported: _winrt.Boolean
    is_dual_color_supported: _winrt.Boolean
    is_italic_supported: _winrt.Boolean
    is_paper_empty_sensor_supported: _winrt.Boolean
    is_paper_near_end_sensor_supported: _winrt.Boolean
    is_printer_present: _winrt.Boolean
    is_underline_supported: _winrt.Boolean
    supported_characters_per_line: winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]
    is_reverse_paper_feed_by_line_supported: _winrt.Boolean
    is_reverse_paper_feed_by_map_mode_unit_supported: _winrt.Boolean
    is_reverse_video_supported: _winrt.Boolean
    is_strikethrough_supported: _winrt.Boolean
    is_subscript_supported: _winrt.Boolean
    is_superscript_supported: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> JournalPrinterCapabilities: ...

class LineDisplay(winsdk.windows.foundation.IClosable, _winrt.Object):
    capabilities: LineDisplayCapabilities
    device_control_description: str
    device_control_version: str
    device_id: str
    device_service_version: str
    physical_device_description: str
    physical_device_name: str
    statistics_category_selector: LineDisplayStatisticsCategorySelector
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplay: ...
    @typing.overload
    def check_power_status_async(self) -> winsdk.windows.foundation.IAsyncOperation[LineDisplayPowerStatus]: ...
    @typing.overload
    def claim_async(self) -> winsdk.windows.foundation.IAsyncOperation[ClaimedLineDisplay]: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[LineDisplay]: ...
    @typing.overload
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[LineDisplay]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...

class LineDisplayAttributes(_winrt.Object):
    screen_size_in_characters: winsdk.windows.foundation.Size
    is_power_notify_enabled: _winrt.Boolean
    is_character_set_mapping_enabled: _winrt.Boolean
    current_window: LineDisplayWindow
    character_set: _winrt.Int32
    brightness: _winrt.Int32
    blink_rate: winsdk.windows.foundation.TimeSpan
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplayAttributes: ...

class LineDisplayCapabilities(_winrt.Object):
    can_blink: LineDisplayTextAttributeGranularity
    can_change_blink_rate: _winrt.Boolean
    can_change_screen_size: _winrt.Boolean
    can_display_bitmaps: _winrt.Boolean
    can_display_custom_glyphs: _winrt.Boolean
    can_map_character_sets: _winrt.Boolean
    can_read_character_at_cursor: _winrt.Boolean
    can_reverse: LineDisplayTextAttributeGranularity
    is_brightness_supported: _winrt.Boolean
    is_cursor_supported: _winrt.Boolean
    is_horizontal_marquee_supported: _winrt.Boolean
    is_inter_character_wait_supported: _winrt.Boolean
    is_statistics_reporting_supported: _winrt.Boolean
    is_statistics_updating_supported: _winrt.Boolean
    is_vertical_marquee_supported: _winrt.Boolean
    power_reporting_type: UnifiedPosPowerReportingType
    supported_descriptors: _winrt.UInt32
    supported_windows: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplayCapabilities: ...

class LineDisplayCursor(_winrt.Object):
    can_customize: _winrt.Boolean
    is_blink_supported: _winrt.Boolean
    is_block_supported: _winrt.Boolean
    is_half_block_supported: _winrt.Boolean
    is_other_supported: _winrt.Boolean
    is_reverse_supported: _winrt.Boolean
    is_underline_supported: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplayCursor: ...
    @typing.overload
    def get_attributes(self) -> LineDisplayCursorAttributes: ...
    @typing.overload
    def try_update_attributes_async(self, attributes: LineDisplayCursorAttributes) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...

class LineDisplayCursorAttributes(_winrt.Object):
    position: winsdk.windows.foundation.Point
    is_blink_enabled: _winrt.Boolean
    is_auto_advance_enabled: _winrt.Boolean
    cursor_type: LineDisplayCursorType
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplayCursorAttributes: ...

class LineDisplayCustomGlyphs(_winrt.Object):
    size_in_pixels: winsdk.windows.foundation.Size
    supported_glyph_codes: winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplayCustomGlyphs: ...
    @typing.overload
    def try_redefine_async(self, glyph_code: _winrt.UInt32, glyph_data: winsdk.windows.storage.streams.IBuffer) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...

class LineDisplayMarquee(_winrt.Object):
    scroll_wait_interval: winsdk.windows.foundation.TimeSpan
    repeat_wait_interval: winsdk.windows.foundation.TimeSpan
    format: LineDisplayMarqueeFormat
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplayMarquee: ...
    @typing.overload
    def try_start_scrolling_async(self, direction: LineDisplayScrollDirection) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_stop_scrolling_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...

class LineDisplayStatisticsCategorySelector(_winrt.Object):
    all_statistics: str
    manufacturer_statistics: str
    unified_pos_statistics: str
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplayStatisticsCategorySelector: ...

class LineDisplayStatusUpdatedEventArgs(_winrt.Object):
    status: LineDisplayPowerStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplayStatusUpdatedEventArgs: ...

class LineDisplayStoredBitmap(_winrt.Object):
    escape_sequence: str
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplayStoredBitmap: ...
    @typing.overload
    def try_delete_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...

class LineDisplayWindow(winsdk.windows.foundation.IClosable, _winrt.Object):
    inter_character_wait_interval: winsdk.windows.foundation.TimeSpan
    size_in_characters: winsdk.windows.foundation.Size
    cursor: LineDisplayCursor
    marquee: LineDisplayMarquee
    @staticmethod
    def _from(obj: _winrt.Object) -> LineDisplayWindow: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    def read_character_at_cursor_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.UInt32]: ...
    @typing.overload
    def try_clear_text_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_display_storage_file_bitmap_at_cursor_async(self, bitmap: winsdk.windows.storage.StorageFile) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_display_storage_file_bitmap_at_cursor_async(self, bitmap: winsdk.windows.storage.StorageFile, horizontal_alignment: LineDisplayHorizontalAlignment, vertical_alignment: LineDisplayVerticalAlignment) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_display_storage_file_bitmap_at_cursor_async(self, bitmap: winsdk.windows.storage.StorageFile, horizontal_alignment: LineDisplayHorizontalAlignment, vertical_alignment: LineDisplayVerticalAlignment, width_in_pixels: _winrt.Int32) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_display_storage_file_bitmap_at_point_async(self, bitmap: winsdk.windows.storage.StorageFile, offset_in_pixels: winsdk.windows.foundation.Point) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_display_storage_file_bitmap_at_point_async(self, bitmap: winsdk.windows.storage.StorageFile, offset_in_pixels: winsdk.windows.foundation.Point, width_in_pixels: _winrt.Int32) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_display_stored_bitmap_at_cursor_async(self, bitmap: LineDisplayStoredBitmap) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_display_text_async(self, text: str) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_display_text_async(self, text: str, display_attribute: LineDisplayTextAttribute) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_display_text_async(self, text: str, display_attribute: LineDisplayTextAttribute, start_position: winsdk.windows.foundation.Point) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_refresh_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_scroll_text_async(self, direction: LineDisplayScrollDirection, number_of_columns_or_rows: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...

class MagneticStripeReader(winsdk.windows.foundation.IClosable, _winrt.Object):
    capabilities: MagneticStripeReaderCapabilities
    device_authentication_protocol: MagneticStripeReaderAuthenticationProtocol
    device_id: str
    supported_card_types: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReader: ...
    @typing.overload
    def check_health_async(self, level: UnifiedPosHealthCheckLevel) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    def claim_reader_async(self) -> winsdk.windows.foundation.IAsyncOperation[ClaimedMagneticStripeReader]: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[MagneticStripeReader]: ...
    @typing.overload
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[MagneticStripeReader]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...
    @typing.overload
    def get_error_reporting_type(self) -> MagneticStripeReaderErrorReportingType: ...
    @typing.overload
    def retrieve_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    @typing.overload
    def add_status_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[MagneticStripeReader, MagneticStripeReaderStatusUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_status_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MagneticStripeReaderAamvaCardDataReceivedEventArgs(_winrt.Object):
    address: str
    birth_date: str
    city: str
    class: str
    endorsements: str
    expiration_date: str
    eye_color: str
    first_name: str
    gender: str
    hair_color: str
    height: str
    license_number: str
    postal_code: str
    report: MagneticStripeReaderReport
    restrictions: str
    state: str
    suffix: str
    surname: str
    weight: str
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReaderAamvaCardDataReceivedEventArgs: ...

class MagneticStripeReaderBankCardDataReceivedEventArgs(_winrt.Object):
    account_number: str
    expiration_date: str
    first_name: str
    middle_initial: str
    report: MagneticStripeReaderReport
    service_code: str
    suffix: str
    surname: str
    title: str
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReaderBankCardDataReceivedEventArgs: ...

class MagneticStripeReaderCapabilities(_winrt.Object):
    authentication_level: MagneticStripeReaderAuthenticationLevel
    card_authentication: str
    is_iso_supported: _winrt.Boolean
    is_jis_one_supported: _winrt.Boolean
    is_jis_two_supported: _winrt.Boolean
    is_statistics_reporting_supported: _winrt.Boolean
    is_statistics_updating_supported: _winrt.Boolean
    is_track_data_masking_supported: _winrt.Boolean
    is_transmit_sentinels_supported: _winrt.Boolean
    power_reporting_type: UnifiedPosPowerReportingType
    supported_encryption_algorithms: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReaderCapabilities: ...

class MagneticStripeReaderCardTypes(_winrt.Object):
    aamva: _winrt.UInt32
    bank: _winrt.UInt32
    extended_base: _winrt.UInt32
    unknown: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReaderCardTypes: ...

class MagneticStripeReaderEncryptionAlgorithms(_winrt.Object):
    extended_base: _winrt.UInt32
    none: _winrt.UInt32
    triple_des_dukpt: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReaderEncryptionAlgorithms: ...

class MagneticStripeReaderErrorOccurredEventArgs(_winrt.Object):
    error_data: UnifiedPosErrorData
    partial_input_data: MagneticStripeReaderReport
    track1_status: MagneticStripeReaderTrackErrorType
    track2_status: MagneticStripeReaderTrackErrorType
    track3_status: MagneticStripeReaderTrackErrorType
    track4_status: MagneticStripeReaderTrackErrorType
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReaderErrorOccurredEventArgs: ...

class MagneticStripeReaderReport(_winrt.Object):
    additional_security_information: winsdk.windows.storage.streams.IBuffer
    card_authentication_data: winsdk.windows.storage.streams.IBuffer
    card_authentication_data_length: _winrt.UInt32
    card_type: _winrt.UInt32
    properties: winsdk.windows.foundation.collections.IMapView[str, str]
    track1: MagneticStripeReaderTrackData
    track2: MagneticStripeReaderTrackData
    track3: MagneticStripeReaderTrackData
    track4: MagneticStripeReaderTrackData
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReaderReport: ...

class MagneticStripeReaderStatusUpdatedEventArgs(_winrt.Object):
    extended_status: _winrt.UInt32
    status: MagneticStripeReaderStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReaderStatusUpdatedEventArgs: ...

class MagneticStripeReaderTrackData(_winrt.Object):
    data: winsdk.windows.storage.streams.IBuffer
    discretionary_data: winsdk.windows.storage.streams.IBuffer
    encrypted_data: winsdk.windows.storage.streams.IBuffer
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReaderTrackData: ...

class MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs(_winrt.Object):
    report: MagneticStripeReaderReport
    @staticmethod
    def _from(obj: _winrt.Object) -> MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs: ...

class PosPrinter(winsdk.windows.foundation.IClosable, _winrt.Object):
    capabilities: PosPrinterCapabilities
    device_id: str
    status: PosPrinterStatus
    supported_character_sets: winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]
    supported_type_faces: winsdk.windows.foundation.collections.IVectorView[str]
    supported_barcode_symbologies: winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]
    @staticmethod
    def _from(obj: _winrt.Object) -> PosPrinter: ...
    @typing.overload
    def check_health_async(self, level: UnifiedPosHealthCheckLevel) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    def claim_printer_async(self) -> winsdk.windows.foundation.IAsyncOperation[ClaimedPosPrinter]: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    @staticmethod
    def from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[PosPrinter]: ...
    @typing.overload
    @staticmethod
    def get_default_async() -> winsdk.windows.foundation.IAsyncOperation[PosPrinter]: ...
    @typing.overload
    @staticmethod
    def get_device_selector() -> str: ...
    @typing.overload
    @staticmethod
    def get_device_selector(connection_types: PosConnectionTypes) -> str: ...
    @typing.overload
    def get_font_property(self, typeface: str) -> PosPrinterFontProperty: ...
    @typing.overload
    def get_statistics_async(self, statistics_categories: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    def add_status_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[PosPrinter, PosPrinterStatusUpdatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_status_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class PosPrinterCapabilities(_winrt.Object):
    can_map_character_set: _winrt.Boolean
    default_character_set: _winrt.UInt32
    has_cover_sensor: _winrt.Boolean
    is_statistics_reporting_supported: _winrt.Boolean
    is_statistics_updating_supported: _winrt.Boolean
    is_transaction_supported: _winrt.Boolean
    journal: JournalPrinterCapabilities
    power_reporting_type: UnifiedPosPowerReportingType
    receipt: ReceiptPrinterCapabilities
    slip: SlipPrinterCapabilities
    @staticmethod
    def _from(obj: _winrt.Object) -> PosPrinterCapabilities: ...

class PosPrinterCharacterSetIds(_winrt.Object):
    ansi: _winrt.UInt32
    ascii: _winrt.UInt32
    utf16_l_e: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> PosPrinterCharacterSetIds: ...

class PosPrinterFontProperty(_winrt.Object):
    character_sizes: winsdk.windows.foundation.collections.IVectorView[SizeUInt32]
    is_scalable_to_any_size: _winrt.Boolean
    type_face: str
    @staticmethod
    def _from(obj: _winrt.Object) -> PosPrinterFontProperty: ...

class PosPrinterPrintOptions(_winrt.Object):
    underline: _winrt.Boolean
    type_face: str
    superscript: _winrt.Boolean
    subscript: _winrt.Boolean
    strikethrough: _winrt.Boolean
    reverse_video: _winrt.Boolean
    italic: _winrt.Boolean
    double_wide: _winrt.Boolean
    double_high: _winrt.Boolean
    character_set: _winrt.UInt32
    character_height: _winrt.UInt32
    bold: _winrt.Boolean
    alignment: PosPrinterAlignment
    @staticmethod
    def _from(obj: _winrt.Object) -> PosPrinterPrintOptions: ...
    @typing.overload
    def __init__(self) -> None: ...

class PosPrinterReleaseDeviceRequestedEventArgs(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> PosPrinterReleaseDeviceRequestedEventArgs: ...

class PosPrinterStatus(_winrt.Object):
    extended_status: _winrt.UInt32
    status_kind: PosPrinterStatusKind
    @staticmethod
    def _from(obj: _winrt.Object) -> PosPrinterStatus: ...

class PosPrinterStatusUpdatedEventArgs(_winrt.Object):
    status: PosPrinterStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> PosPrinterStatusUpdatedEventArgs: ...

class ReceiptPrintJob(IReceiptOrSlipJob, IPosPrinterJob, _winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ReceiptPrintJob: ...
    @typing.overload
    def cut_paper(self) -> None: ...
    @typing.overload
    def cut_paper(self, percentage: _winrt.Double) -> None: ...
    @typing.overload
    def draw_ruled_line(self, position_list: str, line_direction: PosPrinterLineDirection, line_width: _winrt.UInt32, line_style: PosPrinterLineStyle, line_color: _winrt.UInt32) -> None: ...
    @typing.overload
    def execute_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def feed_paper_by_line(self, line_count: _winrt.Int32) -> None: ...
    @typing.overload
    def feed_paper_by_map_mode_unit(self, distance: _winrt.Int32) -> None: ...
    @typing.overload
    def mark_feed(self, kind: PosPrinterMarkFeedKind) -> None: ...
    @typing.overload
    def print(self, data: str) -> None: ...
    @typing.overload
    def print(self, data: str, print_options: PosPrinterPrintOptions) -> None: ...
    @typing.overload
    def print_barcode(self, data: str, symbology: _winrt.UInt32, height: _winrt.UInt32, width: _winrt.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def print_barcode_custom_align(self, data: str, symbology: _winrt.UInt32, height: _winrt.UInt32, width: _winrt.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment_distance: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_line(self) -> None: ...
    @typing.overload
    def print_line(self, data: str) -> None: ...
    @typing.overload
    def print_saved_bitmap(self, bitmap_number: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_barcode_rotation(self, value: PosPrinterRotation) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_print_area(self, value: winsdk.windows.foundation.Rect) -> None: ...
    @typing.overload
    def set_print_rotation(self, value: PosPrinterRotation, include_bitmaps: _winrt.Boolean) -> None: ...
    @typing.overload
    def stamp_paper(self) -> None: ...

class ReceiptPrinterCapabilities(ICommonReceiptSlipCapabilities, ICommonPosPrintStationCapabilities, _winrt.Object):
    cartridge_sensors: PosPrinterCartridgeSensors
    color_cartridge_capabilities: PosPrinterColorCapabilities
    is_bold_supported: _winrt.Boolean
    is_double_high_double_wide_print_supported: _winrt.Boolean
    is_double_high_print_supported: _winrt.Boolean
    is_double_wide_print_supported: _winrt.Boolean
    is_dual_color_supported: _winrt.Boolean
    is_italic_supported: _winrt.Boolean
    is_paper_empty_sensor_supported: _winrt.Boolean
    is_paper_near_end_sensor_supported: _winrt.Boolean
    is_printer_present: _winrt.Boolean
    is_underline_supported: _winrt.Boolean
    supported_characters_per_line: winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]
    is180_rotation_supported: _winrt.Boolean
    is_barcode_supported: _winrt.Boolean
    is_bitmap_supported: _winrt.Boolean
    is_left90_rotation_supported: _winrt.Boolean
    is_print_area_supported: _winrt.Boolean
    is_right90_rotation_supported: _winrt.Boolean
    ruled_line_capabilities: PosPrinterRuledLineCapabilities
    supported_barcode_rotations: winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]
    supported_bitmap_rotations: winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]
    can_cut_paper: _winrt.Boolean
    is_stamp_supported: _winrt.Boolean
    mark_feed_capabilities: PosPrinterMarkFeedCapabilities
    is_reverse_paper_feed_by_line_supported: _winrt.Boolean
    is_reverse_paper_feed_by_map_mode_unit_supported: _winrt.Boolean
    is_reverse_video_supported: _winrt.Boolean
    is_strikethrough_supported: _winrt.Boolean
    is_subscript_supported: _winrt.Boolean
    is_superscript_supported: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> ReceiptPrinterCapabilities: ...

class SlipPrintJob(IReceiptOrSlipJob, IPosPrinterJob, _winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> SlipPrintJob: ...
    @typing.overload
    def draw_ruled_line(self, position_list: str, line_direction: PosPrinterLineDirection, line_width: _winrt.UInt32, line_style: PosPrinterLineStyle, line_color: _winrt.UInt32) -> None: ...
    @typing.overload
    def execute_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def feed_paper_by_line(self, line_count: _winrt.Int32) -> None: ...
    @typing.overload
    def feed_paper_by_map_mode_unit(self, distance: _winrt.Int32) -> None: ...
    @typing.overload
    def print(self, data: str) -> None: ...
    @typing.overload
    def print(self, data: str, print_options: PosPrinterPrintOptions) -> None: ...
    @typing.overload
    def print_barcode(self, data: str, symbology: _winrt.UInt32, height: _winrt.UInt32, width: _winrt.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def print_barcode_custom_align(self, data: str, symbology: _winrt.UInt32, height: _winrt.UInt32, width: _winrt.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment_distance: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_line(self) -> None: ...
    @typing.overload
    def print_line(self, data: str) -> None: ...
    @typing.overload
    def print_saved_bitmap(self, bitmap_number: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_barcode_rotation(self, value: PosPrinterRotation) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_print_area(self, value: winsdk.windows.foundation.Rect) -> None: ...
    @typing.overload
    def set_print_rotation(self, value: PosPrinterRotation, include_bitmaps: _winrt.Boolean) -> None: ...

class SlipPrinterCapabilities(ICommonReceiptSlipCapabilities, ICommonPosPrintStationCapabilities, _winrt.Object):
    cartridge_sensors: PosPrinterCartridgeSensors
    color_cartridge_capabilities: PosPrinterColorCapabilities
    is_bold_supported: _winrt.Boolean
    is_double_high_double_wide_print_supported: _winrt.Boolean
    is_double_high_print_supported: _winrt.Boolean
    is_double_wide_print_supported: _winrt.Boolean
    is_dual_color_supported: _winrt.Boolean
    is_italic_supported: _winrt.Boolean
    is_paper_empty_sensor_supported: _winrt.Boolean
    is_paper_near_end_sensor_supported: _winrt.Boolean
    is_printer_present: _winrt.Boolean
    is_underline_supported: _winrt.Boolean
    supported_characters_per_line: winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]
    is180_rotation_supported: _winrt.Boolean
    is_barcode_supported: _winrt.Boolean
    is_bitmap_supported: _winrt.Boolean
    is_left90_rotation_supported: _winrt.Boolean
    is_print_area_supported: _winrt.Boolean
    is_right90_rotation_supported: _winrt.Boolean
    ruled_line_capabilities: PosPrinterRuledLineCapabilities
    supported_barcode_rotations: winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]
    supported_bitmap_rotations: winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]
    is_both_sides_printing_supported: _winrt.Boolean
    is_full_length_supported: _winrt.Boolean
    is_reverse_paper_feed_by_line_supported: _winrt.Boolean
    is_reverse_paper_feed_by_map_mode_unit_supported: _winrt.Boolean
    is_reverse_video_supported: _winrt.Boolean
    is_strikethrough_supported: _winrt.Boolean
    is_subscript_supported: _winrt.Boolean
    is_superscript_supported: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> SlipPrinterCapabilities: ...

class UnifiedPosErrorData(_winrt.Object):
    extended_reason: _winrt.UInt32
    message: str
    reason: UnifiedPosErrorReason
    severity: UnifiedPosErrorSeverity
    @staticmethod
    def _from(obj: _winrt.Object) -> UnifiedPosErrorData: ...
    @typing.overload
    def __init__(self, message: str, severity: UnifiedPosErrorSeverity, reason: UnifiedPosErrorReason, extended_reason: _winrt.UInt32) -> None: ...

class ICashDrawerEventSourceEventArgs(_winrt.Object):
    cash_drawer: CashDrawer
    @staticmethod
    def _from(obj: _winrt.Object) -> ICashDrawerEventSourceEventArgs: ...

class ICommonClaimedPosPrinterStation(_winrt.Object):
    characters_per_line: _winrt.UInt32
    color_cartridge: PosPrinterColorCartridge
    is_cartridge_empty: _winrt.Boolean
    is_cartridge_removed: _winrt.Boolean
    is_cover_open: _winrt.Boolean
    is_head_cleaning: _winrt.Boolean
    is_letter_quality: _winrt.Boolean
    is_paper_empty: _winrt.Boolean
    is_paper_near_end: _winrt.Boolean
    is_ready_to_print: _winrt.Boolean
    line_height: _winrt.UInt32
    line_spacing: _winrt.UInt32
    line_width: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> ICommonClaimedPosPrinterStation: ...
    @typing.overload
    def validate_data(self, data: str) -> _winrt.Boolean: ...

class ICommonPosPrintStationCapabilities(_winrt.Object):
    cartridge_sensors: PosPrinterCartridgeSensors
    color_cartridge_capabilities: PosPrinterColorCapabilities
    is_bold_supported: _winrt.Boolean
    is_double_high_double_wide_print_supported: _winrt.Boolean
    is_double_high_print_supported: _winrt.Boolean
    is_double_wide_print_supported: _winrt.Boolean
    is_dual_color_supported: _winrt.Boolean
    is_italic_supported: _winrt.Boolean
    is_paper_empty_sensor_supported: _winrt.Boolean
    is_paper_near_end_sensor_supported: _winrt.Boolean
    is_printer_present: _winrt.Boolean
    is_underline_supported: _winrt.Boolean
    supported_characters_per_line: winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]
    @staticmethod
    def _from(obj: _winrt.Object) -> ICommonPosPrintStationCapabilities: ...

class ICommonReceiptSlipCapabilities(ICommonPosPrintStationCapabilities, _winrt.Object):
    is180_rotation_supported: _winrt.Boolean
    is_barcode_supported: _winrt.Boolean
    is_bitmap_supported: _winrt.Boolean
    is_left90_rotation_supported: _winrt.Boolean
    is_print_area_supported: _winrt.Boolean
    is_right90_rotation_supported: _winrt.Boolean
    ruled_line_capabilities: PosPrinterRuledLineCapabilities
    supported_barcode_rotations: winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]
    supported_bitmap_rotations: winsdk.windows.foundation.collections.IVectorView[PosPrinterRotation]
    cartridge_sensors: PosPrinterCartridgeSensors
    color_cartridge_capabilities: PosPrinterColorCapabilities
    is_bold_supported: _winrt.Boolean
    is_double_high_double_wide_print_supported: _winrt.Boolean
    is_double_high_print_supported: _winrt.Boolean
    is_double_wide_print_supported: _winrt.Boolean
    is_dual_color_supported: _winrt.Boolean
    is_italic_supported: _winrt.Boolean
    is_paper_empty_sensor_supported: _winrt.Boolean
    is_paper_near_end_sensor_supported: _winrt.Boolean
    is_printer_present: _winrt.Boolean
    is_underline_supported: _winrt.Boolean
    supported_characters_per_line: winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]
    @staticmethod
    def _from(obj: _winrt.Object) -> ICommonReceiptSlipCapabilities: ...

class IPosPrinterJob(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> IPosPrinterJob: ...
    @typing.overload
    def execute_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def print(self, data: str) -> None: ...
    @typing.overload
    def print_line(self) -> None: ...
    @typing.overload
    def print_line(self, data: str) -> None: ...

class IReceiptOrSlipJob(IPosPrinterJob, _winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> IReceiptOrSlipJob: ...
    @typing.overload
    def draw_ruled_line(self, position_list: str, line_direction: PosPrinterLineDirection, line_width: _winrt.UInt32, line_style: PosPrinterLineStyle, line_color: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_barcode(self, data: str, symbology: _winrt.UInt32, height: _winrt.UInt32, width: _winrt.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def print_barcode_custom_align(self, data: str, symbology: _winrt.UInt32, height: _winrt.UInt32, width: _winrt.UInt32, text_position: PosPrinterBarcodeTextPosition, alignment_distance: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def print_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_custom_aligned_bitmap(self, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def print_saved_bitmap(self, bitmap_number: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_barcode_rotation(self, value: PosPrinterRotation) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment) -> None: ...
    @typing.overload
    def set_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment: PosPrinterAlignment, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_custom_aligned_bitmap(self, bitmap_number: _winrt.UInt32, bitmap: winsdk.windows.graphics.imaging.BitmapFrame, alignment_distance: _winrt.UInt32, width: _winrt.UInt32) -> None: ...
    @typing.overload
    def set_print_area(self, value: winsdk.windows.foundation.Rect) -> None: ...
    @typing.overload
    def set_print_rotation(self, value: PosPrinterRotation, include_bitmaps: _winrt.Boolean) -> None: ...
    @typing.overload
    def execute_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def print(self, data: str) -> None: ...
    @typing.overload
    def print_line(self) -> None: ...
    @typing.overload
    def print_line(self, data: str) -> None: ...

