# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.2

import enum
import sys
import types
import typing
import uuid

import winsdk._winrt as _winrt

try:
    import winsdk.windows.devices.display
except Exception:
    pass

try:
    import winsdk.windows.foundation
except Exception:
    pass

try:
    import winsdk.windows.foundation.collections
except Exception:
    pass

try:
    import winsdk.windows.foundation.numerics
except Exception:
    pass

try:
    import winsdk.windows.graphics
except Exception:
    pass

try:
    import winsdk.windows.graphics.directx
except Exception:
    pass

try:
    import winsdk.windows.graphics.directx.direct3d11
except Exception:
    pass

try:
    import winsdk.windows.storage.streams
except Exception:
    pass

class DisplayBitsPerChannel(enum.IntFlag):
    NONE = 0
    BPC6 = 0x1
    BPC8 = 0x2
    BPC10 = 0x4
    BPC12 = 0x8
    BPC14 = 0x10
    BPC16 = 0x20

class DisplayDeviceCapability(enum.IntEnum):
    FLIP_OVERRIDE = 0

class DisplayManagerOptions(enum.IntFlag):
    NONE = 0
    ENFORCE_SOURCE_OWNERSHIP = 0x1
    VIRTUAL_REFRESH_RATE_AWARE = 0x2

class DisplayManagerResult(enum.IntEnum):
    SUCCESS = 0
    UNKNOWN_FAILURE = 1
    TARGET_ACCESS_DENIED = 2
    TARGET_STALE = 3
    REMOTE_SESSION_NOT_SUPPORTED = 4

class DisplayModeQueryOptions(enum.IntFlag):
    NONE = 0
    ONLY_PREFERRED_RESOLUTION = 0x1

class DisplayPathScaling(enum.IntEnum):
    IDENTITY = 0
    CENTERED = 1
    STRETCHED = 2
    ASPECT_RATIO_STRETCHED = 3
    CUSTOM = 4
    DRIVER_PREFERRED = 5

class DisplayPathStatus(enum.IntEnum):
    UNKNOWN = 0
    SUCCEEDED = 1
    PENDING = 2
    FAILED = 3
    FAILED_ASYNC = 4
    INVALIDATED_ASYNC = 5

class DisplayPresentStatus(enum.IntEnum):
    SUCCESS = 0
    SOURCE_STATUS_PREVENTED_PRESENT = 1
    SCANOUT_INVALID = 2
    SOURCE_INVALID = 3
    DEVICE_INVALID = 4
    UNKNOWN_FAILURE = 5

class DisplayRotation(enum.IntEnum):
    NONE = 0
    CLOCKWISE90_DEGREES = 1
    CLOCKWISE180_DEGREES = 2
    CLOCKWISE270_DEGREES = 3

class DisplayScanoutOptions(enum.IntFlag):
    NONE = 0
    ALLOW_TEARING = 0x2

class DisplaySourceStatus(enum.IntEnum):
    ACTIVE = 0
    POWERED_OFF = 1
    INVALID = 2
    OWNED_BY_ANOTHER_DEVICE = 3
    UNOWNED = 4

class DisplayStateApplyOptions(enum.IntFlag):
    NONE = 0
    FAIL_IF_STATE_CHANGED = 0x1
    FORCE_REAPPLY = 0x2
    FORCE_MODE_ENUMERATION = 0x4

class DisplayStateFunctionalizeOptions(enum.IntFlag):
    NONE = 0
    FAIL_IF_STATE_CHANGED = 0x1
    VALIDATE_TOPOLOGY_ONLY = 0x2

class DisplayStateOperationStatus(enum.IntEnum):
    SUCCESS = 0
    PARTIAL_FAILURE = 1
    UNKNOWN_FAILURE = 2
    TARGET_OWNERSHIP_LOST = 3
    SYSTEM_STATE_CHANGED = 4
    TOO_MANY_PATHS_FOR_ADAPTER = 5
    MODES_NOT_SUPPORTED = 6
    REMOTE_SESSION_NOT_SUPPORTED = 7

class DisplayTargetPersistence(enum.IntEnum):
    NONE = 0
    BOOT_PERSISTED = 1
    TEMPORARY_PERSISTED = 2
    PATH_PERSISTED = 3

class DisplayTaskSignalKind(enum.IntEnum):
    ON_PRESENT_FLIP_AWAY = 0
    ON_PRESENT_FLIP_TO = 1

class DisplayWireFormatColorSpace(enum.IntEnum):
    B_T709 = 0
    B_T2020 = 1
    PROFILE_DEFINED_WIDE_COLOR_GAMUT = 2

class DisplayWireFormatEotf(enum.IntEnum):
    SDR = 0
    HDR_SMPTE2084 = 1

class DisplayWireFormatHdrMetadata(enum.IntEnum):
    NONE = 0
    HDR10 = 1
    HDR10_PLUS = 2
    DOLBY_VISION_LOW_LATENCY = 3

class DisplayWireFormatPixelEncoding(enum.IntEnum):
    RGB444 = 0
    YCC444 = 1
    YCC422 = 2
    YCC420 = 3
    INTENSITY = 4

class DisplayPresentationRate:
    vertical_sync_rate: winsdk.windows.foundation.numerics.Rational
    vertical_syncs_per_presentation: _winrt.Int32
    def __init__(self, vertical_sync_rate: winsdk.windows.foundation.numerics.Rational, vertical_syncs_per_presentation: _winrt.Int32) -> None: ...

class DisplayAdapter(_winrt.Object):
    device_interface_path: str
    id: winsdk.windows.graphics.DisplayAdapterId
    pci_device_id: _winrt.UInt32
    pci_revision: _winrt.UInt32
    pci_sub_system_id: _winrt.UInt32
    pci_vendor_id: _winrt.UInt32
    properties: winsdk.windows.foundation.collections.IMapView[uuid.UUID, _winrt.Object]
    source_count: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayAdapter: ...
    @typing.overload
    @staticmethod
    def from_id(id: winsdk.windows.graphics.DisplayAdapterId) -> DisplayAdapter: ...

class DisplayDevice(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayDevice: ...
    @typing.overload
    def create_periodic_fence(self, target: DisplayTarget, offset_from_v_blank: winsdk.windows.foundation.TimeSpan) -> DisplayFence: ...
    @typing.overload
    def create_primary(self, target: DisplayTarget, desc: DisplayPrimaryDescription) -> DisplaySurface: ...
    @typing.overload
    def create_scanout_source(self, target: DisplayTarget) -> DisplaySource: ...
    @typing.overload
    def create_simple_scanout(self, p_source: DisplaySource, p_surface: DisplaySurface, sub_resource_index: _winrt.UInt32, sync_interval: _winrt.UInt32) -> DisplayScanout: ...
    @typing.overload
    def create_simple_scanout_with_dirty_rects_and_options(self, source: DisplaySource, surface: DisplaySurface, subresource_index: _winrt.UInt32, sync_interval: _winrt.UInt32, dirty_rects: typing.Iterable[winsdk.windows.graphics.RectInt32], options: DisplayScanoutOptions) -> DisplayScanout: ...
    @typing.overload
    def create_task_pool(self) -> DisplayTaskPool: ...
    @typing.overload
    def is_capability_supported(self, capability: DisplayDeviceCapability) -> _winrt.Boolean: ...
    @typing.overload
    def wait_for_v_blank(self, source: DisplaySource) -> None: ...

class DisplayFence(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayFence: ...

class DisplayManager(winsdk.windows.foundation.IClosable, _winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayManager: ...
    @typing.overload
    def close(self) -> None: ...
    @typing.overload
    @staticmethod
    def create(options: DisplayManagerOptions) -> DisplayManager: ...
    @typing.overload
    def create_display_device(self, adapter: DisplayAdapter) -> DisplayDevice: ...
    @typing.overload
    def get_current_adapters(self) -> winsdk.windows.foundation.collections.IVectorView[DisplayAdapter]: ...
    @typing.overload
    def get_current_targets(self) -> winsdk.windows.foundation.collections.IVectorView[DisplayTarget]: ...
    @typing.overload
    def release_target(self, target: DisplayTarget) -> None: ...
    @typing.overload
    def start(self) -> None: ...
    @typing.overload
    def stop(self) -> None: ...
    @typing.overload
    def try_acquire_target(self, target: DisplayTarget) -> DisplayManagerResult: ...
    @typing.overload
    def try_acquire_targets_and_create_empty_state(self, targets: typing.Iterable[DisplayTarget]) -> DisplayManagerResultWithState: ...
    @typing.overload
    def try_acquire_targets_and_create_substate(self, existing_state: DisplayState, targets: typing.Iterable[DisplayTarget]) -> DisplayManagerResultWithState: ...
    @typing.overload
    def try_acquire_targets_and_read_current_state(self, targets: typing.Iterable[DisplayTarget]) -> DisplayManagerResultWithState: ...
    @typing.overload
    def try_read_current_state_for_all_targets(self) -> DisplayManagerResultWithState: ...
    @typing.overload
    def add_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[DisplayManager, DisplayManagerChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_disabled(self, handler: winsdk.windows.foundation.TypedEventHandler[DisplayManager, DisplayManagerDisabledEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_disabled(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_enabled(self, handler: winsdk.windows.foundation.TypedEventHandler[DisplayManager, DisplayManagerEnabledEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_enabled(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_paths_failed_or_invalidated(self, handler: winsdk.windows.foundation.TypedEventHandler[DisplayManager, DisplayManagerPathsFailedOrInvalidatedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_paths_failed_or_invalidated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class DisplayManagerChangedEventArgs(_winrt.Object):
    handled: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayManagerChangedEventArgs: ...
    @typing.overload
    def get_deferral(self) -> winsdk.windows.foundation.Deferral: ...

class DisplayManagerDisabledEventArgs(_winrt.Object):
    handled: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayManagerDisabledEventArgs: ...
    @typing.overload
    def get_deferral(self) -> winsdk.windows.foundation.Deferral: ...

class DisplayManagerEnabledEventArgs(_winrt.Object):
    handled: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayManagerEnabledEventArgs: ...
    @typing.overload
    def get_deferral(self) -> winsdk.windows.foundation.Deferral: ...

class DisplayManagerPathsFailedOrInvalidatedEventArgs(_winrt.Object):
    handled: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayManagerPathsFailedOrInvalidatedEventArgs: ...
    @typing.overload
    def get_deferral(self) -> winsdk.windows.foundation.Deferral: ...

class DisplayManagerResultWithState(_winrt.Object):
    error_code: DisplayManagerResult
    extended_error_code: winsdk.windows.foundation.HResult
    state: DisplayState
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayManagerResultWithState: ...

class DisplayModeInfo(_winrt.Object):
    is_interlaced: _winrt.Boolean
    is_stereo: _winrt.Boolean
    presentation_rate: DisplayPresentationRate
    properties: winsdk.windows.foundation.collections.IMapView[uuid.UUID, _winrt.Object]
    source_pixel_format: winsdk.windows.graphics.directx.DirectXPixelFormat
    source_resolution: winsdk.windows.graphics.SizeInt32
    target_resolution: winsdk.windows.graphics.SizeInt32
    physical_presentation_rate: DisplayPresentationRate
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayModeInfo: ...
    @typing.overload
    def get_wire_format_supported_bits_per_channel(self, encoding: DisplayWireFormatPixelEncoding) -> DisplayBitsPerChannel: ...
    @typing.overload
    def is_wire_format_supported(self, wire_format: DisplayWireFormat) -> _winrt.Boolean: ...

class DisplayPath(_winrt.Object):
    wire_format: DisplayWireFormat
    target_resolution: typing.Optional[winsdk.windows.graphics.SizeInt32]
    source_resolution: typing.Optional[winsdk.windows.graphics.SizeInt32]
    source_pixel_format: winsdk.windows.graphics.directx.DirectXPixelFormat
    scaling: DisplayPathScaling
    rotation: DisplayRotation
    presentation_rate: typing.Optional[DisplayPresentationRate]
    is_stereo: _winrt.Boolean
    is_interlaced: typing.Optional[_winrt.Boolean]
    properties: winsdk.windows.foundation.collections.IMap[uuid.UUID, _winrt.Object]
    status: DisplayPathStatus
    target: DisplayTarget
    view: DisplayView
    physical_presentation_rate: typing.Optional[DisplayPresentationRate]
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayPath: ...
    @typing.overload
    def apply_properties_from_mode(self, mode_result: DisplayModeInfo) -> None: ...
    @typing.overload
    def find_modes(self, flags: DisplayModeQueryOptions) -> winsdk.windows.foundation.collections.IVectorView[DisplayModeInfo]: ...

class DisplayPrimaryDescription(_winrt.Object):
    color_space: winsdk.windows.graphics.directx.DirectXColorSpace
    format: winsdk.windows.graphics.directx.DirectXPixelFormat
    height: _winrt.UInt32
    is_stereo: _winrt.Boolean
    multisample_description: winsdk.windows.graphics.directx.direct3d11.Direct3DMultisampleDescription
    properties: winsdk.windows.foundation.collections.IMapView[uuid.UUID, _winrt.Object]
    width: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayPrimaryDescription: ...
    @typing.overload
    def __init__(self, width: _winrt.UInt32, height: _winrt.UInt32, pixel_format: winsdk.windows.graphics.directx.DirectXPixelFormat, color_space: winsdk.windows.graphics.directx.DirectXColorSpace, is_stereo: _winrt.Boolean, multisample_description: winsdk.windows.graphics.directx.direct3d11.Direct3DMultisampleDescription) -> None: ...
    @typing.overload
    @staticmethod
    def create_with_properties(extra_properties: typing.Iterable[winsdk.windows.foundation.collections.IKeyValuePair[uuid.UUID, _winrt.Object]], width: _winrt.UInt32, height: _winrt.UInt32, pixel_format: winsdk.windows.graphics.directx.DirectXPixelFormat, color_space: winsdk.windows.graphics.directx.DirectXColorSpace, is_stereo: _winrt.Boolean, multisample_description: winsdk.windows.graphics.directx.direct3d11.Direct3DMultisampleDescription) -> DisplayPrimaryDescription: ...

class DisplayScanout(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayScanout: ...

class DisplaySource(_winrt.Object):
    adapter_id: winsdk.windows.graphics.DisplayAdapterId
    source_id: _winrt.UInt32
    status: DisplaySourceStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplaySource: ...
    @typing.overload
    def get_metadata(self, key: uuid.UUID) -> winsdk.windows.storage.streams.IBuffer: ...
    @typing.overload
    def add_status_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[DisplaySource, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_status_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class DisplayState(_winrt.Object):
    is_read_only: _winrt.Boolean
    is_stale: _winrt.Boolean
    properties: winsdk.windows.foundation.collections.IMap[uuid.UUID, _winrt.Object]
    targets: winsdk.windows.foundation.collections.IVectorView[DisplayTarget]
    views: winsdk.windows.foundation.collections.IVectorView[DisplayView]
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayState: ...
    @typing.overload
    def can_connect_target_to_view(self, target: DisplayTarget, view: DisplayView) -> _winrt.Boolean: ...
    @typing.overload
    def clone(self) -> DisplayState: ...
    @typing.overload
    def connect_target(self, target: DisplayTarget) -> DisplayPath: ...
    @typing.overload
    def connect_target(self, target: DisplayTarget, view: DisplayView) -> DisplayPath: ...
    @typing.overload
    def disconnect_target(self, target: DisplayTarget) -> None: ...
    @typing.overload
    def get_path_for_target(self, target: DisplayTarget) -> DisplayPath: ...
    @typing.overload
    def get_view_for_target(self, target: DisplayTarget) -> DisplayView: ...
    @typing.overload
    def try_apply(self, options: DisplayStateApplyOptions) -> DisplayStateOperationResult: ...
    @typing.overload
    def try_functionalize(self, options: DisplayStateFunctionalizeOptions) -> DisplayStateOperationResult: ...

class DisplayStateOperationResult(_winrt.Object):
    extended_error_code: winsdk.windows.foundation.HResult
    status: DisplayStateOperationStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayStateOperationResult: ...

class DisplaySurface(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplaySurface: ...

class DisplayTarget(_winrt.Object):
    adapter: DisplayAdapter
    adapter_relative_id: _winrt.UInt32
    device_interface_path: str
    is_connected: _winrt.Boolean
    is_stale: _winrt.Boolean
    is_virtual_mode_enabled: _winrt.Boolean
    is_virtual_topology_enabled: _winrt.Boolean
    monitor_persistence: DisplayTargetPersistence
    properties: winsdk.windows.foundation.collections.IMapView[uuid.UUID, _winrt.Object]
    stable_monitor_id: str
    usage_kind: winsdk.windows.devices.display.DisplayMonitorUsageKind
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayTarget: ...
    @typing.overload
    def is_equal(self, other_target: DisplayTarget) -> _winrt.Boolean: ...
    @typing.overload
    def is_same(self, other_target: DisplayTarget) -> _winrt.Boolean: ...
    @typing.overload
    def try_get_monitor(self) -> winsdk.windows.devices.display.DisplayMonitor: ...

class DisplayTask(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayTask: ...
    @typing.overload
    def set_scanout(self, scanout: DisplayScanout) -> None: ...
    @typing.overload
    def set_signal(self, signal_kind: DisplayTaskSignalKind, fence: DisplayFence) -> None: ...
    @typing.overload
    def set_wait(self, ready_fence: DisplayFence, ready_fence_value: _winrt.UInt64) -> None: ...

class DisplayTaskPool(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayTaskPool: ...
    @typing.overload
    def create_task(self) -> DisplayTask: ...
    @typing.overload
    def execute_task(self, task: DisplayTask) -> None: ...
    @typing.overload
    def try_execute_task(self, task: DisplayTask) -> DisplayTaskResult: ...

class DisplayTaskResult(_winrt.Object):
    present_id: _winrt.UInt64
    present_status: DisplayPresentStatus
    source_status: DisplaySourceStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayTaskResult: ...

class DisplayView(_winrt.Object):
    content_resolution: typing.Optional[winsdk.windows.graphics.SizeInt32]
    paths: winsdk.windows.foundation.collections.IVectorView[DisplayPath]
    properties: winsdk.windows.foundation.collections.IMap[uuid.UUID, _winrt.Object]
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayView: ...
    @typing.overload
    def set_primary_path(self, path: DisplayPath) -> None: ...

class DisplayWireFormat(_winrt.Object):
    bits_per_channel: _winrt.Int32
    color_space: DisplayWireFormatColorSpace
    eotf: DisplayWireFormatEotf
    hdr_metadata: DisplayWireFormatHdrMetadata
    pixel_encoding: DisplayWireFormatPixelEncoding
    properties: winsdk.windows.foundation.collections.IMapView[uuid.UUID, _winrt.Object]
    @staticmethod
    def _from(obj: _winrt.Object) -> DisplayWireFormat: ...
    @typing.overload
    def __init__(self, pixel_encoding: DisplayWireFormatPixelEncoding, bits_per_channel: _winrt.Int32, color_space: DisplayWireFormatColorSpace, eotf: DisplayWireFormatEotf, hdr_metadata: DisplayWireFormatHdrMetadata) -> None: ...
    @typing.overload
    @staticmethod
    def create_with_properties(extra_properties: typing.Iterable[winsdk.windows.foundation.collections.IKeyValuePair[uuid.UUID, _winrt.Object]], pixel_encoding: DisplayWireFormatPixelEncoding, bits_per_channel: _winrt.Int32, color_space: DisplayWireFormatColorSpace, eotf: DisplayWireFormatEotf, hdr_metadata: DisplayWireFormatHdrMetadata) -> DisplayWireFormat: ...

