# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.2

import enum
import sys
import types
import typing
import uuid

import winsdk._winrt as _winrt

try:
    import winsdk.windows.foundation
except Exception:
    pass

try:
    import winsdk.windows.foundation.collections
except Exception:
    pass

try:
    import winsdk.windows.media.mediaproperties
except Exception:
    pass

try:
    import winsdk.windows.security.credentials
except Exception:
    pass

try:
    import winsdk.windows.storage.streams
except Exception:
    pass

class ChatConversationThreadingKind(enum.IntEnum):
    PARTICIPANTS = 0
    CONTACT_ID = 1
    CONVERSATION_ID = 2
    CUSTOM = 3

class ChatItemKind(enum.IntEnum):
    MESSAGE = 0
    CONVERSATION = 1

class ChatMessageChangeType(enum.IntEnum):
    MESSAGE_CREATED = 0
    MESSAGE_MODIFIED = 1
    MESSAGE_DELETED = 2
    CHANGE_TRACKING_LOST = 3

class ChatMessageKind(enum.IntEnum):
    STANDARD = 0
    FILE_TRANSFER_REQUEST = 1
    TRANSPORT_CUSTOM = 2
    JOINED_CONVERSATION = 3
    LEFT_CONVERSATION = 4
    OTHER_PARTICIPANT_JOINED_CONVERSATION = 5
    OTHER_PARTICIPANT_LEFT_CONVERSATION = 6

class ChatMessageOperatorKind(enum.IntEnum):
    UNSPECIFIED = 0
    SMS = 1
    MMS = 2
    RCS = 3

class ChatMessageStatus(enum.IntEnum):
    DRAFT = 0
    SENDING = 1
    SENT = 2
    SEND_RETRY_NEEDED = 3
    SEND_FAILED = 4
    RECEIVED = 5
    RECEIVE_DOWNLOAD_NEEDED = 6
    RECEIVE_DOWNLOAD_FAILED = 7
    RECEIVE_DOWNLOADING = 8
    DELETED = 9
    DECLINED = 10
    CANCELLED = 11
    RECALLED = 12
    RECEIVE_RETRY_NEEDED = 13

class ChatMessageTransportKind(enum.IntEnum):
    TEXT = 0
    UNTRIAGED = 1
    BLOCKED = 2
    CUSTOM = 3

class ChatMessageValidationStatus(enum.IntEnum):
    VALID = 0
    NO_RECIPIENTS = 1
    INVALID_DATA = 2
    MESSAGE_TOO_LARGE = 3
    TOO_MANY_RECIPIENTS = 4
    TRANSPORT_INACTIVE = 5
    TRANSPORT_NOT_FOUND = 6
    TOO_MANY_ATTACHMENTS = 7
    INVALID_RECIPIENTS = 8
    INVALID_BODY = 9
    INVALID_OTHER = 10
    VALID_WITH_LARGE_MESSAGE = 11
    VOICE_ROAMING_RESTRICTION = 12
    DATA_ROAMING_RESTRICTION = 13

class ChatRestoreHistorySpan(enum.IntEnum):
    LAST_MONTH = 0
    LAST_YEAR = 1
    ANY_TIME = 2

class ChatStoreChangedEventKind(enum.IntEnum):
    NOTIFICATIONS_MISSED = 0
    STORE_MODIFIED = 1
    MESSAGE_CREATED = 2
    MESSAGE_MODIFIED = 3
    MESSAGE_DELETED = 4
    CONVERSATION_MODIFIED = 5
    CONVERSATION_DELETED = 6
    CONVERSATION_TRANSPORT_DELETED = 7

class ChatTransportErrorCodeCategory(enum.IntEnum):
    NONE = 0
    HTTP = 1
    NETWORK = 2
    MMS_SERVER = 3

class ChatTransportInterpretedErrorCode(enum.IntEnum):
    NONE = 0
    UNKNOWN = 1
    INVALID_RECIPIENT_ADDRESS = 2
    NETWORK_CONNECTIVITY = 3
    SERVICE_DENIED = 4
    TIMEOUT = 5

class RcsServiceKind(enum.IntEnum):
    CHAT = 0
    GROUP_CHAT = 1
    FILE_TRANSFER = 2
    CAPABILITY = 3

class ChatCapabilities(_winrt.Object):
    is_chat_capable: _winrt.Boolean
    is_file_transfer_capable: _winrt.Boolean
    is_geo_location_push_capable: _winrt.Boolean
    is_integrated_messaging_capable: _winrt.Boolean
    is_online: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatCapabilities: ...

class ChatCapabilitiesManager(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatCapabilitiesManager: ...
    @typing.overload
    @staticmethod
    def get_cached_capabilities_async(address: str) -> winsdk.windows.foundation.IAsyncOperation[ChatCapabilities]: ...
    @typing.overload
    @staticmethod
    def get_cached_capabilities_async(address: str, transport_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatCapabilities]: ...
    @typing.overload
    @staticmethod
    def get_capabilities_from_network_async(address: str) -> winsdk.windows.foundation.IAsyncOperation[ChatCapabilities]: ...
    @typing.overload
    @staticmethod
    def get_capabilities_from_network_async(address: str, transport_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatCapabilities]: ...

class ChatConversation(IChatItem, _winrt.Object):
    subject: str
    is_conversation_muted: _winrt.Boolean
    has_unread_messages: _winrt.Boolean
    id: str
    most_recent_message_id: str
    participants: winsdk.windows.foundation.collections.IVector[str]
    threading_info: ChatConversationThreadingInfo
    can_modify_participants: _winrt.Boolean
    item_kind: ChatItemKind
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatConversation: ...
    @typing.overload
    def delete_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def get_message_reader(self) -> ChatMessageReader: ...
    @typing.overload
    def mark_messages_as_read_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def mark_messages_as_read_async(self, value: winsdk.windows.foundation.DateTime) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def notify_local_participant_composing(self, transport_id: str, participant_address: str, is_composing: _winrt.Boolean) -> None: ...
    @typing.overload
    def notify_remote_participant_composing(self, transport_id: str, participant_address: str, is_composing: _winrt.Boolean) -> None: ...
    @typing.overload
    def save_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def add_remote_participant_composing_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[ChatConversation, RemoteParticipantComposingChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_remote_participant_composing_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ChatConversationReader(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatConversationReader: ...
    @typing.overload
    def read_batch_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatConversation]]: ...
    @typing.overload
    def read_batch_async(self, count: _winrt.Int32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatConversation]]: ...

class ChatConversationThreadingInfo(_winrt.Object):
    kind: ChatConversationThreadingKind
    custom: str
    conversation_id: str
    contact_id: str
    participants: winsdk.windows.foundation.collections.IVector[str]
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatConversationThreadingInfo: ...
    @typing.overload
    def __init__(self) -> None: ...

class ChatMessage(IChatItem, _winrt.Object):
    item_kind: ChatItemKind
    is_incoming: _winrt.Boolean
    is_forwarding_disabled: _winrt.Boolean
    transport_id: str
    status: ChatMessageStatus
    from: str
    body: str
    subject: str
    is_read: _winrt.Boolean
    network_timestamp: winsdk.windows.foundation.DateTime
    local_timestamp: winsdk.windows.foundation.DateTime
    recipient_send_statuses: winsdk.windows.foundation.collections.IMapView[str, ChatMessageStatus]
    recipients: winsdk.windows.foundation.collections.IVector[str]
    transport_friendly_name: str
    attachments: winsdk.windows.foundation.collections.IVector[ChatMessageAttachment]
    id: str
    is_seen: _winrt.Boolean
    message_kind: ChatMessageKind
    is_received_during_quiet_hours: _winrt.Boolean
    is_auto_reply: _winrt.Boolean
    estimated_download_size: _winrt.UInt64
    threading_info: ChatConversationThreadingInfo
    should_suppress_notification: _winrt.Boolean
    remote_id: str
    message_operator_kind: ChatMessageOperatorKind
    is_reply_disabled: _winrt.Boolean
    is_sim_message: _winrt.Boolean
    recipients_delivery_infos: winsdk.windows.foundation.collections.IVector[ChatRecipientDeliveryInfo]
    sync_id: str
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessage: ...
    @typing.overload
    def __init__(self) -> None: ...

class ChatMessageAttachment(_winrt.Object):
    text: str
    mime_type: str
    group_id: _winrt.UInt32
    data_stream_reference: winsdk.windows.storage.streams.IRandomAccessStreamReference
    transfer_progress: _winrt.Double
    thumbnail: winsdk.windows.storage.streams.IRandomAccessStreamReference
    original_file_name: str
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageAttachment: ...
    @typing.overload
    def __init__(self, mime_type: str, data_stream_reference: winsdk.windows.storage.streams.IRandomAccessStreamReference) -> None: ...

class ChatMessageBlocking(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageBlocking: ...
    @typing.overload
    @staticmethod
    def mark_message_as_blocked_async(local_chat_message_id: str, blocked: _winrt.Boolean) -> winsdk.windows.foundation.IAsyncAction: ...

class ChatMessageChange(_winrt.Object):
    change_type: ChatMessageChangeType
    message: ChatMessage
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageChange: ...

class ChatMessageChangeReader(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageChangeReader: ...
    @typing.overload
    def accept_changes(self) -> None: ...
    @typing.overload
    def accept_changes_through(self, last_change_to_acknowledge: ChatMessageChange) -> None: ...
    @typing.overload
    def read_batch_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatMessageChange]]: ...

class ChatMessageChangeTracker(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageChangeTracker: ...
    @typing.overload
    def enable(self) -> None: ...
    @typing.overload
    def get_change_reader(self) -> ChatMessageChangeReader: ...
    @typing.overload
    def reset(self) -> None: ...

class ChatMessageChangedDeferral(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageChangedDeferral: ...
    @typing.overload
    def complete(self) -> None: ...

class ChatMessageChangedEventArgs(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageChangedEventArgs: ...
    @typing.overload
    def get_deferral(self) -> ChatMessageChangedDeferral: ...

class ChatMessageManager(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageManager: ...
    @typing.overload
    @staticmethod
    def get_transport_async(transport_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatMessageTransport]: ...
    @typing.overload
    @staticmethod
    def get_transports_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatMessageTransport]]: ...
    @typing.overload
    @staticmethod
    def register_transport_async() -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    @staticmethod
    def request_store_async() -> winsdk.windows.foundation.IAsyncOperation[ChatMessageStore]: ...
    @typing.overload
    @staticmethod
    def request_sync_manager_async() -> winsdk.windows.foundation.IAsyncOperation[ChatSyncManager]: ...
    @typing.overload
    @staticmethod
    def show_compose_sms_message_async(message: ChatMessage) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def show_sms_settings() -> None: ...

class ChatMessageNotificationTriggerDetails(_winrt.Object):
    chat_message: ChatMessage
    should_display_toast: _winrt.Boolean
    should_update_action_center: _winrt.Boolean
    should_update_badge: _winrt.Boolean
    should_update_detail_text: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageNotificationTriggerDetails: ...

class ChatMessageReader(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageReader: ...
    @typing.overload
    def read_batch_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatMessage]]: ...
    @typing.overload
    def read_batch_async(self, count: _winrt.Int32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[ChatMessage]]: ...

class ChatMessageStore(_winrt.Object):
    change_tracker: ChatMessageChangeTracker
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageStore: ...
    @typing.overload
    def delete_message_async(self, local_message_id: str) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def download_message_async(self, local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def forward_message_async(self, local_chat_message_id: str, addresses: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[ChatMessage]: ...
    @typing.overload
    def get_conversation_async(self, conversation_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatConversation]: ...
    @typing.overload
    def get_conversation_async(self, conversation_id: str, transport_ids: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[ChatConversation]: ...
    @typing.overload
    def get_conversation_from_threading_info_async(self, threading_info: ChatConversationThreadingInfo) -> winsdk.windows.foundation.IAsyncOperation[ChatConversation]: ...
    @typing.overload
    def get_conversation_reader(self) -> ChatConversationReader: ...
    @typing.overload
    def get_conversation_reader(self, transport_ids: typing.Iterable[str]) -> ChatConversationReader: ...
    @typing.overload
    def get_message_async(self, local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatMessage]: ...
    @typing.overload
    def get_message_by_remote_id_async(self, transport_id: str, remote_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatMessage]: ...
    @typing.overload
    def get_message_by_sync_id_async(self, sync_id: str) -> winsdk.windows.foundation.IAsyncOperation[ChatMessage]: ...
    @typing.overload
    def get_message_reader(self) -> ChatMessageReader: ...
    @typing.overload
    def get_message_reader(self, recent_time_limit: winsdk.windows.foundation.TimeSpan) -> ChatMessageReader: ...
    @typing.overload
    def get_search_reader(self, value: ChatQueryOptions) -> ChatSearchReader: ...
    @typing.overload
    def get_unseen_count_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Int32]: ...
    @typing.overload
    def get_unseen_count_async(self, transport_ids: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Int32]: ...
    @typing.overload
    def mark_as_seen_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def mark_as_seen_async(self, transport_ids: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def mark_message_read_async(self, local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def retry_send_message_async(self, local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def save_message_async(self, chat_message: ChatMessage) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def send_message_async(self, chat_message: ChatMessage) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def try_cancel_download_message_async(self, local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_cancel_send_message_async(self, local_chat_message_id: str) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def validate_message(self, chat_message: ChatMessage) -> ChatMessageValidationResult: ...
    @typing.overload
    def add_message_changed(self, value: winsdk.windows.foundation.TypedEventHandler[ChatMessageStore, ChatMessageChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_message_changed(self, value: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    @typing.overload
    def add_store_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[ChatMessageStore, ChatMessageStoreChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_store_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ChatMessageStoreChangedEventArgs(_winrt.Object):
    id: str
    kind: ChatStoreChangedEventKind
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageStoreChangedEventArgs: ...

class ChatMessageTransport(_winrt.Object):
    is_active: _winrt.Boolean
    is_app_set_as_notification_provider: _winrt.Boolean
    transport_friendly_name: str
    transport_id: str
    configuration: ChatMessageTransportConfiguration
    transport_kind: ChatMessageTransportKind
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageTransport: ...
    @typing.overload
    def request_set_as_notification_provider_async(self) -> winsdk.windows.foundation.IAsyncAction: ...

class ChatMessageTransportConfiguration(_winrt.Object):
    extended_properties: winsdk.windows.foundation.collections.IMapView[str, _winrt.Object]
    max_attachment_count: _winrt.Int32
    max_message_size_in_kilobytes: _winrt.Int32
    max_recipient_count: _winrt.Int32
    supported_video_format: winsdk.windows.media.mediaproperties.MediaEncodingProfile
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageTransportConfiguration: ...

class ChatMessageValidationResult(_winrt.Object):
    max_part_count: typing.Optional[_winrt.UInt32]
    part_count: typing.Optional[_winrt.UInt32]
    remaining_character_count_in_part: typing.Optional[_winrt.UInt32]
    status: ChatMessageValidationStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatMessageValidationResult: ...

class ChatQueryOptions(_winrt.Object):
    search_string: str
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatQueryOptions: ...
    @typing.overload
    def __init__(self) -> None: ...

class ChatRecipientDeliveryInfo(_winrt.Object):
    transport_address: str
    read_time: typing.Optional[winsdk.windows.foundation.DateTime]
    delivery_time: typing.Optional[winsdk.windows.foundation.DateTime]
    is_error_permanent: _winrt.Boolean
    status: ChatMessageStatus
    transport_error_code: _winrt.Int32
    transport_error_code_category: ChatTransportErrorCodeCategory
    transport_interpreted_error_code: ChatTransportInterpretedErrorCode
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatRecipientDeliveryInfo: ...
    @typing.overload
    def __init__(self) -> None: ...

class ChatSearchReader(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatSearchReader: ...
    @typing.overload
    def read_batch_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[IChatItem]]: ...
    @typing.overload
    def read_batch_async(self, count: _winrt.Int32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[IChatItem]]: ...

class ChatSyncConfiguration(_winrt.Object):
    restore_history_span: ChatRestoreHistorySpan
    is_sync_enabled: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatSyncConfiguration: ...

class ChatSyncManager(_winrt.Object):
    configuration: ChatSyncConfiguration
    @staticmethod
    def _from(obj: _winrt.Object) -> ChatSyncManager: ...
    @typing.overload
    def associate_account_async(self, web_account: winsdk.windows.security.credentials.WebAccount) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def is_account_associated(self, web_account: winsdk.windows.security.credentials.WebAccount) -> _winrt.Boolean: ...
    @typing.overload
    def set_configuration_async(self, configuration: ChatSyncConfiguration) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def start_sync(self) -> None: ...
    @typing.overload
    def unassociate_account_async(self) -> winsdk.windows.foundation.IAsyncAction: ...

class RcsEndUserMessage(_winrt.Object):
    actions: winsdk.windows.foundation.collections.IVectorView[RcsEndUserMessageAction]
    is_pin_required: _winrt.Boolean
    text: str
    title: str
    transport_id: str
    @staticmethod
    def _from(obj: _winrt.Object) -> RcsEndUserMessage: ...
    @typing.overload
    def send_response_async(self, action: RcsEndUserMessageAction) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    def send_response_with_pin_async(self, action: RcsEndUserMessageAction, pin: str) -> winsdk.windows.foundation.IAsyncAction: ...

class RcsEndUserMessageAction(_winrt.Object):
    label: str
    @staticmethod
    def _from(obj: _winrt.Object) -> RcsEndUserMessageAction: ...

class RcsEndUserMessageAvailableEventArgs(_winrt.Object):
    is_message_available: _winrt.Boolean
    message: RcsEndUserMessage
    @staticmethod
    def _from(obj: _winrt.Object) -> RcsEndUserMessageAvailableEventArgs: ...

class RcsEndUserMessageAvailableTriggerDetails(_winrt.Object):
    text: str
    title: str
    @staticmethod
    def _from(obj: _winrt.Object) -> RcsEndUserMessageAvailableTriggerDetails: ...

class RcsEndUserMessageManager(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> RcsEndUserMessageManager: ...
    @typing.overload
    def add_message_available_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[RcsEndUserMessageManager, RcsEndUserMessageAvailableEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_message_available_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class RcsManager(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> RcsManager: ...
    @typing.overload
    @staticmethod
    def get_end_user_message_manager() -> RcsEndUserMessageManager: ...
    @typing.overload
    @staticmethod
    def get_transport_async(transport_id: str) -> winsdk.windows.foundation.IAsyncOperation[RcsTransport]: ...
    @typing.overload
    @staticmethod
    def get_transports_async() -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[RcsTransport]]: ...
    @typing.overload
    @staticmethod
    def leave_conversation_async(conversation: ChatConversation) -> winsdk.windows.foundation.IAsyncAction: ...
    @typing.overload
    @staticmethod
    def add_transport_list_changed(handler: winsdk.windows.foundation.EventHandler[_winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    @staticmethod
    def remove_transport_list_changed(token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class RcsServiceKindSupportedChangedEventArgs(_winrt.Object):
    service_kind: RcsServiceKind
    @staticmethod
    def _from(obj: _winrt.Object) -> RcsServiceKindSupportedChangedEventArgs: ...

class RcsTransport(_winrt.Object):
    configuration: RcsTransportConfiguration
    extended_properties: winsdk.windows.foundation.collections.IMapView[str, _winrt.Object]
    is_active: _winrt.Boolean
    transport_friendly_name: str
    transport_id: str
    @staticmethod
    def _from(obj: _winrt.Object) -> RcsTransport: ...
    @typing.overload
    def is_service_kind_supported(self, service_kind: RcsServiceKind) -> _winrt.Boolean: ...
    @typing.overload
    def is_store_and_forward_enabled(self, service_kind: RcsServiceKind) -> _winrt.Boolean: ...
    @typing.overload
    def add_service_kind_supported_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[RcsTransport, RcsServiceKindSupportedChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @typing.overload
    def remove_service_kind_supported_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class RcsTransportConfiguration(_winrt.Object):
    max_attachment_count: _winrt.Int32
    max_file_size_in_kilobytes: _winrt.Int32
    max_group_message_size_in_kilobytes: _winrt.Int32
    max_message_size_in_kilobytes: _winrt.Int32
    max_recipient_count: _winrt.Int32
    warning_file_size_in_kilobytes: _winrt.Int32
    @staticmethod
    def _from(obj: _winrt.Object) -> RcsTransportConfiguration: ...

class RemoteParticipantComposingChangedEventArgs(_winrt.Object):
    is_composing: _winrt.Boolean
    participant_address: str
    transport_id: str
    @staticmethod
    def _from(obj: _winrt.Object) -> RemoteParticipantComposingChangedEventArgs: ...

class IChatItem(_winrt.Object):
    item_kind: ChatItemKind
    @staticmethod
    def _from(obj: _winrt.Object) -> IChatItem: ...

