"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnGet = exports.toJson_CfnGetProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnGetProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnGetProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ClusterName': obj.clusterName,
        'Name': obj.name,
        'Namespace': obj.namespace,
        'JsonPath': obj.jsonPath,
        'Retries': obj.retries,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnGetProps = toJson_CfnGetProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `AWSQS::Kubernetes::Get`
 *
 * @cloudformationResource AWSQS::Kubernetes::Get
 * @stability external
 * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
 */
class CfnGet extends cdk.CfnResource {
    /**
     * Create a new `AWSQS::Kubernetes::Get`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnGet.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnGetProps(props) });
        this.props = props;
        this.attrResponse = cdk.Token.asString(this.getAtt('Response'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
    }
}
exports.CfnGet = CfnGet;
_a = JSII_RTTI_SYMBOL_1;
CfnGet[_a] = { fqn: "@cdk-cloudformation/awsqs-kubernetes-get.CfnGet", version: "1.13.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnGet.CFN_RESOURCE_TYPE_NAME = "AWSQS::Kubernetes::Get";
//# sourceMappingURL=data:application/json;base64,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