import os


def tf_set_seed(seed):
    import random

    import numpy as np
    import tensorflow as tf

    os.environ["PYTHONHASHSEED"] = "0"

    tf.random.set_seed(seed)
    np.random.seed(seed)
    random.seed(seed)

    os.environ["TF_DETERMINISTIC_OPS"] = "1"
    os.environ["TF_CUDNN_DETERMINISTIC"] = "1"

    tf.config.threading.set_inter_op_parallelism_threads(1)
    tf.config.threading.set_intra_op_parallelism_threads(1)
