import math
import pygame

pygame.font.init()

BACKGROUND_COLOUR = (255, 255, 255)
BUTTON_PANEL_COLOUR = (255, 255, 255)

BLACK = (0, 0, 0)
WHITE = (255, 255, 255)
RED = (198, 0, 0)

SIZE = 1300, 800
WIDTH, HEIGHT = SIZE

PANEL_LOCATION = (0, HEIGHT / 2)
PANEL_HEIGHT = HEIGHT / 2
PANEL_SIZE = (WIDTH, PANEL_HEIGHT)

KR_BUTTON_SIZE = 100

BUTTON_PANEL = pygame.Rect(PANEL_LOCATION, PANEL_SIZE)
# FONT = "couriernew"
FONT = "helvetica"
SUBSTRATE_FONT = "arial"

SQUARE_WIDTH = int(HEIGHT / 13)

PIECE_PADDING = int(math.ceil(3 * SQUARE_WIDTH / 100))
SYMBOL_PADDING = int(math.ceil(28 * SQUARE_WIDTH / 100))

MODULE_SPACING = 40
MODULE_PADDING = 20

GENE_PADDING = 50
GENE_LABEL_SIZE = 60
GENE_SPACING = 50
GENE_HEIGHT = 20
DOMAIN_SIZE = 30

BUTTON_COLOUR = (200, 200, 200)
BUTTON_HIGHLIGHT_COLOUR = (230, 230, 230)

GENE_COLOUR = (200, 200, 200)
GENE_HIGHLIGHT_COLOUR = (220, 220, 220)
MODULE_COLOUR = (240, 240, 240)
MODULE_HIGHLIGHT_COLOUR = (245, 245, 245)
MODULE_LINE_COLOUR = (100, 100, 100)


DOMAIN_BUTTON_SIZE = 40

BUTTON_FONT = pygame.font.SysFont(FONT, 20, bold=True)
BUTTON_TEXT_COLOUR = BLACK
SUBSTRATE_BUTTON_SIZE = 140
SUBSTRATE_BUTTONS_PER_LINE = 6
SUBSTRATE_BUTTON_PADDING = 30
SUBSTRATE_GROUP_BUTTON_SIZE = (int(WIDTH * 0.05), int(HEIGHT / 25))
SUBSTRATE_GROUP_BUTTON_PADDING = int(WIDTH * 0.02)
SUBSTRATE_GROUP_BUTTONS_PER_LINE = 6

RENDER_WINDOW_SIZE = (1000, 800)

FATTY_ACID_IMAGE_SIZE = (200, 200)

PIECE_BUTTON_WIDTH = int(HEIGHT / 6)

PIECE_BUTTON_HEIGHT = int(HEIGHT / 25)

CONDITION_SIZE = int(math.ceil(SQUARE_WIDTH / 5))

REPLACE_TEXT_FONT = pygame.font.SysFont(FONT, 14, bold=False)

REPLACE_TEXT_1 = REPLACE_TEXT_FONT.render("This file destination already exists.", True, BLACK)
REPLACE_TEXT_2 = REPLACE_TEXT_FONT.render("Are you sure you want to overwrite?", True, BLACK)

FAILED_TEXT_1 = REPLACE_TEXT_FONT.render("Failed to render cluster.", True, BLACK)
FAILED_TEXT_2 = REPLACE_TEXT_FONT.render("Check if starter units were used as elongation units.", True, BLACK)
FAILED_TEXT_3 = REPLACE_TEXT_FONT.render("Failed to render products.", True, BLACK)

