# Generated by Django 4.0.5 on 2023-08-18 10:21

import django.contrib.gis.db.models.fields
from django.db import migrations

from django.contrib.gis.geos import Point


def populate_existing_place_geopositions(apps, schema_editor):
    Place = apps.get_model('appkit', 'Place')

    for place in Place.objects.all():
        place_info = place.info
        location = place_info['geometry']['location']
        place.geoposition = Point(location['lng'], location['lat'])
        place.save()


class Migration(migrations.Migration):

    dependencies = [
        ('appkit', '0017_alter_imageattachment_image'),
    ]

    operations = [
        migrations.AddField(
            model_name='place',
            name='geoposition',
            field=django.contrib.gis.db.models.fields.PointField(blank=True, geography=True, null=True, srid=4326),
        ),

        migrations.RunPython(populate_existing_place_geopositions, reverse_code=migrations.RunPython.noop, elidable=True)
    ]
