# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Module(Model):
    """The module identity on a device.

    :param module_id: The unique identifier of the module.
    :type module_id: str
    :param managed_by: Identifies who manages this module. For instance, this
     value is \\"IotEdge\\" if the edge runtime owns this module.
    :type managed_by: str
    :param device_id: The unique identifier of the device.
    :type device_id: str
    :param generation_id: The IoT Hub generated, case-sensitive string up to
     128 characters long. This value is used to distinguish modules with the
     same moduleId, when they have been deleted and re-created.
    :type generation_id: str
    :param etag: The string representing a weak ETag for the module identity,
     as per RFC7232.
    :type etag: str
    :param connection_state: The connection state of the device. Possible
     values include: 'Disconnected', 'Connected'
    :type connection_state: str or ~protocol.models.enum
    :param connection_state_updated_time: The date and time the connection
     state was last updated.
    :type connection_state_updated_time: datetime
    :param last_activity_time: The date and time the device last connected,
     received, or sent a message.
    :type last_activity_time: datetime
    :param cloud_to_device_message_count: The number of cloud-to-module
     messages currently queued to be sent to the module.
    :type cloud_to_device_message_count: int
    :param authentication: The authentication mechanism used by the module
     when connecting to the service and edge hub.
    :type authentication: ~protocol.models.AuthenticationMechanism
    """

    _attribute_map = {
        "module_id": {"key": "moduleId", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "device_id": {"key": "deviceId", "type": "str"},
        "generation_id": {"key": "generationId", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "connection_state": {"key": "connectionState", "type": "str"},
        "connection_state_updated_time": {"key": "connectionStateUpdatedTime", "type": "iso-8601"},
        "last_activity_time": {"key": "lastActivityTime", "type": "iso-8601"},
        "cloud_to_device_message_count": {"key": "cloudToDeviceMessageCount", "type": "int"},
        "authentication": {"key": "authentication", "type": "AuthenticationMechanism"},
    }

    def __init__(self, **kwargs):
        super(Module, self).__init__(**kwargs)
        self.module_id = kwargs.get("module_id", None)
        self.managed_by = kwargs.get("managed_by", None)
        self.device_id = kwargs.get("device_id", None)
        self.generation_id = kwargs.get("generation_id", None)
        self.etag = kwargs.get("etag", None)
        self.connection_state = kwargs.get("connection_state", None)
        self.connection_state_updated_time = kwargs.get("connection_state_updated_time", None)
        self.last_activity_time = kwargs.get("last_activity_time", None)
        self.cloud_to_device_message_count = kwargs.get("cloud_to_device_message_count", None)
        self.authentication = kwargs.get("authentication", None)
