"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const envJP = {
            region: 'ap-northeast-1',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const envUS = {
            region: 'us-west-2',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        // first stack in JP
        const stackJP = new cdk.Stack(app, 'demo-stack-jp', { env: envJP });
        const topic = new sns.Topic(stackJP, 'Topic');
        new cdk.CfnOutput(stackJP, 'TopicName', { value: topic.topicName });
        // second stack in US
        const stackUS = new cdk.Stack(app, 'demo-stack-us', { env: envUS });
        // ensure the dependency
        stackUS.addDependency(stackJP);
        // get the stackJP stack outputs from stackUS
        const outputs = new _1.StackOutputs(stackUS, 'Outputs', { stack: stackJP });
        const remoteOutputValue = outputs.getAttString('TopicName');
        // the value should be exactly the same with the output value of `TopicName`
        new cdk.CfnOutput(stackUS, 'RemoteTopicName', { value: remoteOutputValue });
        this.stack = [stackJP, stackUS];
    }
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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