"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudscapeReactTsWebsiteProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const web_1 = require("projen/lib/web");
/**
 * Synthesizes a Cloudscape React Typescript Website Project.
 *
 * @pjid cloudscape-react-ts-website
 */
class CloudscapeReactTsWebsiteProject extends web_1.ReactTypeScriptProject {
    constructor(options) {
        super({
            ...options,
            defaultReleaseBranch: options.defaultReleaseBranch,
            name: options.name,
            sampleCode: false,
            readme: {
                contents: fs
                    .readFileSync(path.resolve(__dirname, "../README.md"))
                    .toString(),
            },
            gitignore: ["runtime-config.json"],
        });
        this.addDevDeps("@babel/plugin-proposal-private-property-in-object");
        this.addDeps("@cloudscape-design/global-styles", "@cloudscape-design/components", "@cloudscape-design/collection-hooks", "react-router-dom", "aws-amplify", "@aws-amplify/ui-react", "aws4fetch");
        this.testTask.reset();
        const lintTask = this.tasks.tryFind("eslint");
        lintTask && this.testTask.spawn(lintTask);
        this.testTask.exec("react-scripts test --watchAll=false --passWithNoTests");
        this.applicationName = options.applicationName ?? "Sample App";
        this.publicDir = options.publicDir ?? "public";
        const srcDir = path.resolve(__dirname, "../samples/src");
        new projen_1.SampleDir(this, this.srcdir, {
            files: {
                ...Object.fromEntries(this.buildSampleDirEntries(srcDir)),
                "config.json": JSON.stringify({
                    applicationName: this.applicationName,
                }, undefined, 2),
            },
        });
        const publicDir = path.resolve(__dirname, "../samples/public");
        new projen_1.SampleDir(this, this.publicDir, {
            sourceDir: publicDir,
            files: {
                // override index.html to pass through applicationName
                "index.html": fs
                    .readFileSync(`${publicDir}/index.html`)
                    .toString()
                    .replace("<title></title>", `<title>${this.applicationName}</title>`),
            },
        });
    }
    buildSampleDirEntries(dir, pathPrefixes = []) {
        return fs
            .readdirSync(dir, { withFileTypes: true })
            .filter((f) => f.name !== "config.json")
            .flatMap((f) => f.isDirectory()
            ? this.buildSampleDirEntries(`${dir}/${f.name}`, [
                ...pathPrefixes,
                f.name,
            ])
            : [
                [
                    `${path.join(...pathPrefixes, f.name)}`,
                    fs.readFileSync(`${dir}/${f.name}`).toString(),
                ],
            ]);
    }
}
exports.CloudscapeReactTsWebsiteProject = CloudscapeReactTsWebsiteProject;
_a = JSII_RTTI_SYMBOL_1;
CloudscapeReactTsWebsiteProject[_a] = { fqn: "@aws-prototyping-sdk/cloudscape-react-ts-website.CloudscapeReactTsWebsiteProject", version: "0.12.12" };
//# sourceMappingURL=data:application/json;base64,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