# -*- coding: utf-8 -*-
"""
| ----------------------------------------------------------------------------------------------------------------------
| Date                : March 2020
| Copyright           : © 2020 by Ann Crabbé (KU Leuven)
| Email               : acrabbe.foss@gmail.com
|
| This file is part of the Spectral Libraries QGIS plugin and python package.
|
| This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
| License as published by the Free Software Foundation, either version 3 of the License, or any later version.
|
| This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
| warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
|
| You should have received a copy of the GNU General Public License along with Foobar.  If not see www.gnu.org/licenses.
| ----------------------------------------------------------------------------------------------------------------------
"""

package_name_pip = 'spectral-libraries'
qgis_plugin_name = 'Spectral Library Tool'
read_the_docs_name = 'SpectralLibraries'

author = 'Ann Crabbé (KU Leuven); Benjamin Jakimow (HU Berlin)'
author_doc = 'Ann Crabbé (KU Leuven)'
author_email = 'acrabbe.foss@gmail.com'
author_copyright = '© 2018 - 2020 by Ann Crabbé (KU Leuven)'
short_version = '1.0'
long_version = '1.0.9'

bitbucket_home = 'https://bitbucket.org/kul-reseco/spectral-libraries'
bitbucket_src = 'https://bitbucket.org/kul-reseco/spectral-libraries/src'
bitbucket_issues = 'https://bitbucket.org/kul-reseco/spectral-libraries/issues'

read_the_docs = 'https://spectral-libraries.readthedocs.io'

keywords = ['ies', 'ear', 'masa', 'cob', 'emc', 'cres', 'square array', 'spectral library', 'remote sensing']

qgis_min_version = '3.6'

short_description = 'The Spectral Library Tool software package is both a QGIS plugin and stand-alone python package ' \
                    'that provides a suite of processing tools for multi- and hyperspectral spectral libraries.'
long_description = 'Creating spectral libraries interactively (selecting spectra from an image or using regions of ' \
                   'interest) and managing the metadata (developed by HU Berlin); Optimizing spectral libraries with ' \
                   'Iterative Endmember Selection, Ear-Masa-Cob or CRES. The software has been developed in the ' \
                   'open source environment to encourage further development of the tool.'

icon = 'images/lumos_h60.png'
qgis_category = 'Raster'

sphinx_title = 'Spectral Library Tool Documentation'
