COLUMN_DICT = {
    "nc_admission_record": ["nc_chief_complaint", "nc_present_illness_history", "nc_family_history",
                            "nc_past_medical_history", "nc_tumo_rgenetic_history", "nc_personal_history",
                            "nc_marital_history", "nc_menstrual_history", "nc_fertile_history","nc_reproductive_history",
                            "nc_allergy_history", "nc_exposure_history", "nc_mother_fertile_history", "nc_feed_history",
                            "nc_growth_history", "nc_physical_exam"],
    "nc_fist_disease_course": ["nc_case_characteristics", "nc_primary_diagnosis", "nc_primary_diagnosis_basis",
                               "nc_differential_diagnosis", "nc_diagnosis_treatment_plan"],
    "nc_daily_disease_course": ["nc_course_detail"],
    "nc_discharge_record": ["nc_discharge_condition", 'nc_diagnosis_process', 'nc_discharge_order'],
    "nc_pathology_info": ["nc_clinical_diagnosis", 'nc_gross_findings', 'nc_pathology_diagnosis'],
    "nc_death_record": ["nc_chief_complaint", 'nc_admission_condition', 'nc_diagnosis_process', 'nc_death_reason', 'nc_death_detail'],
    'nc_readmission_record': ["nc_past_admission_condition", "nc_chief_complaint", "nc_present_illness_history", 'nc_primary_diagnosis'],
    'nc_24hours_admission_discharge_info': ['nc_chief_complaint', 'nc_admission_condition', 'nc_admission_diagnosis', 'nc_diagnosis_process', 'nc_discharge_condition', 'nc_discharge_diagnosis', 'nc_discharge_order'],
    'nc_imageology_exam': ["nc_diagnosis", 'nc_imaging_findings'],
}

NAME_MAP = {
    "nc_readmission_record": "再入院记录",
    "nc_24hours_admission_discharge_info": "24小时入出院记录",
    "nc_pathology_diagnosis_name": "病理诊断名称",
    "nc_main_diagnosis_name": "出院主要诊断名称",
    "nc_other_diagnosis_name": "出院其他诊断名称",
    'nc_admission_record': '入院记录',
    "nc_past_admission_condition": "既往住院情况",
    "nc_admission_diagnosis": "入院诊断",
    "nc_discharge_diagnosis": "出院诊断",
    'nc_present_illness_history': '现病史',
    'nc_chief_complaint': '主诉',
    'nc_family_history': '家族史',
    'nc_past_medical_history': '既往疾病史',
    'nc_tumo_rgenetic_history': '肿瘤遗传史',
    'nc_personal_history': '个人史',
    'nc_marital_history': '婚育史',
    'nc_menstrual_history': '月经史',
    'nc_fertile_history': '生育史',
    'nc_reproductive_history': '哺乳史',
    'nc_allergy_history': '过敏史',
    'nc_exposure_history': '暴露史',
    'nc_mother_fertile_history': '母孕史',
    'nc_feed_history': '喂养史',
    'nc_growth_history': '发育史',
    "nc_physical_exam": '专科体格检查',
    'nc_fist_disease_course': '首次病程',
    'nc_case_characteristics': '病例特点',
    'nc_primary_diagnosis': '初步诊断',
    'nc_primary_diagnosis_basis': '初步诊断依据',
    'nc_differential_diagnosis': '鉴别诊断',
    'nc_diagnosis_treatment_plan': '诊疗方案',
    'nc_daily_disease_course': '病程记录',
    'nc_course_detail': '病程详细记录',
    'nc_discharge_record': '出院记录',
    'nc_discharge_condition': '出院情况',
    'nc_diagnosis_process': '诊疗过程',
    'nc_discharge_order': '出院医嘱',
    "nc_pathology_info": "病理记录",
    "nc_clinical_diagnosis": "临床诊断",
    "nc_gross_findings": "大体所见",
    "nc_pathology_diagnosis": "病理诊断",
    "nc_death_record": "死亡记录",
    "nc_admission_condition": "入院情况",
    "nc_death_reason": "死亡原因",
    "nc_death_detail": "死亡详细记录",
    "nc_diagnosis": "诊断",
    "nc_imaging_findings": "影像表现",
    "nc_discharge_diagnosis_info": "出院主要诊断",
    "nc_discharge_other_diagnosis": "出院其他诊断",
    "nc_pathology_diagnosis_info": "出院病理诊断",
    "nc_imageology_exam": "影像学检查"
}

# ICCC3疾病编码和名称对应关系
ICCC3_CODE_NAME_DICT = {
    'Ⅰ.a1': ['前体细胞白血病',  '急性Pre-B淋巴细胞白血病',
             '急性前体B淋巴细胞白血病', '急性Pro-B淋巴细胞白血病', '急性早前T淋巴细胞白血病', '急性前B淋巴细胞白血病',
             '急性祖-B淋巴细胞白血病', '急性非成熟B淋巴细胞白血病', '急性B淋巴母细胞性白血病',
             'B淋巴母细胞性白血病', 'T淋巴母细胞/白血病', '急性PreB淋巴细胞白血病',
             '急性Pre-B淋巴细胞白血L2型低危病', '急性pre-B淋巴细胞性白血病', '急性T淋巴母细胞白血病', '急性早前B淋巴细胞白血病',
             '急性B淋巴母细胞白血病', 'B淋巴母细胞白血病', '急非成熟B淋巴细胞白血病L1型', '急非成熟B淋巴细胞白血病',
             '急性Pre-B细胞淋巴细胞白血病', 'T淋巴母细胞白血病', '急性前体B细胞性淋巴细胞白血病', '前B急性淋巴细胞白血病',
             'T淋巴母细胞白细胞／淋巴瘤', '幼稚细胞', '原始幼稚细胞', '前体B细胞急性淋巴细胞白血病', '前体T细胞急性淋巴细胞白血病',
             '原始淋巴细胞', '前B细胞急性淋巴细胞白血病', 'B淋巴母细胞白血病/淋巴瘤', 'T淋巴母细胞白血病/淋巴瘤',
             'T淋巴母细胞白雪病/淋巴瘤', 'B淋母细胞白血病/淋巴瘤'],
    'Ⅰ.a2': ['成熟的B细胞白血病', '急性成熟B淋巴细胞白血病', '成熟B淋巴细胞白血病', '成熟B细胞白血病', '急性成熟B细胞白血病'],
    'Ⅰ.a3': ['成熟的T细胞和NK细胞白血病'],
    'Ⅰ.a4': ['淋巴样白血病，NOS', "急性淋巴细胞白血病", "ALL", "急性淋巴细胞白细胞"],
    'Ⅰ.b': ['急性髓样白血病', '急性髓系白血病', '急性早幼粒细胞白血病', '急性髓细胞白血病', '原始粒细胞白血病', '急性单核细胞白血病',
            '急性粒-单核细胞白血病', '急性非淋巴细胞白血病', '急性髓细胞性白血病', '髓系肉瘤', '粒细胞肉瘤', '髓细胞肉瘤',
            '急性巨核细胞白血病', '急性早幼粒白血病', '急性髓系细胞白血病', '急性髓性白血病', '急性非淋巴细胞性白血病',
            '急性非淋巴性白血病M2型', '急性非淋巴性白血病', '急性非淋巴细胞型白血病', '急性巨核母细胞白血病', '急性单核细胞母细胞白血病',
            '前骨髓细胞白血病', '急性前骨髓细胞白血病', '急性骨髓单核细胞白血病', '骨髓单核细胞白血病并骨髓内嗜酸性粒细胞增生',
            '急性早幼粒细胞性白血病', '急性非淋巴性白血病M3a', '急性粒单核细胞系白血病', '急髓白血病', '急性髓系细胞性白血病',
            '急性粒细胞性白血病', '急性粒细胞性白血病(M2a型)', '急性巨核细胞性白血病', '急性粒细胞白血病（M2型）',
            '急性早有粒细胞白血病', '急性粒细胞白血病', '巨核细胞白血病（M7）', '巨核细胞白血病(M7型', '急性非淋巴细胞白细胞白血病',
            '急性非淋巴细胞性白血病M2型', '髓系白血病', '急性粒-单细胞白血病', '髓肉瘤', '急性粒单核细胞白血病', '急性单核细胞性白血病',
            '髓系幼稚细胞', '急性红白血病'],
    'Ⅰ.c': ['慢性骨髓增生性疾病', '慢性骨髓增殖性疾病', '慢性粒细胞性白血病', '慢性髓系白血病', '慢性粒细胞白血病'],
    'Ⅰ.d': ['骨髓增生异常综合症和其他骨髓增生性疾患', '幼年粒单核细胞白血病', '幼年型粒单核细胞白血病', '幼年型粒单细胞白血病',
            '幼年型粒-单核细胞白血病', '骨髓增生异常综合症', '幼年性粒单核细胞白血病', '幼年型慢性粒单核细胞白血病',
            '幼年型粒细胞单核细胞白血病'],
    'Ⅰ.e': ['未特指及其他特指的白血病', '急性混合细胞性白血病', '混合表型急性白血病', '急性混合谱系白血病', '急性混合表型白血病',
            '急性混合细胞白血病', '急性未分化细胞白血病', '急性白血病', '急性白血病（混合型）', 'MLL阳性急性白血病（混合型）', '急性混合型白血病',
            '混合型急性白血病', '真性红细胞增多症'],
    'Ⅱ.a': ['霍奇金淋巴瘤', '结节硬化型霍奇金淋巴瘤', '经典型霍奇金淋巴瘤', '霍奇金淋巴瘤(混合细胞型)', '霍奇金病', '霍齐金淋巴瘤',
            '混合细胞型霍奇金淋巴瘤', '结节硬化型经典霍奇金淋巴瘤', '经典霍启金淋巴瘤', '经典霍奇金淋巴瘤', '经典型霍奇金氏淋巴瘤',
            '结节性硬化型霍奇金病', '经典型霍奇金淋巴瘤混合细胞型'],
    'Ⅱ.b1': ['前体细胞淋巴瘤', 'T淋巴母细胞淋巴瘤', 'B淋巴母细胞淋巴瘤', '睾丸非霍奇金B淋巴母细胞淋巴瘤',
             'T淋巴母细胞型淋巴瘤', 'B淋巴母细胞型淋巴瘤', '早前T淋巴母细胞型淋巴瘤', 'B淋巴母细胞瘤性淋巴瘤', 'B淋巴母细胞性淋巴瘤',
             '前体T细胞淋巴母细胞性淋巴瘤', 'T淋巴母细胞性淋巴瘤', '前体T细胞淋巴母细胞淋巴性淋巴瘤', '前T细胞性淋巴母细胞淋巴瘤',
             '前体T淋巴母细胞性淋巴瘤', 'T细胞淋巴母细胞淋巴瘤', 'T细胞性淋巴母细胞淋巴瘤'
             '非霍奇金淋巴瘤（T淋巴母细胞型）', '非霍奇金淋巴瘤（T淋巴母细胞性淋巴瘤)', '非霍奇金淋巴瘤（T淋巴母细胞瘤）',
             'T细胞性非霍奇金淋巴瘤', '前驱T淋巴母细胞淋巴瘤', '早前T淋巴母细胞性淋巴瘤', '淋巴母细胞淋巴瘤，T细胞型',
             '非霍奇金淋巴瘤(B淋巴母细胞性', '非霍奇金淋巴瘤(T淋巴母细胞', '非霍奇金淋巴瘤(T淋巴母', 'T-淋巴母细胞淋巴瘤',
             '非霍奇金淋巴瘤（B淋母型）', 'T淋巴母细胞瘤型', '非霍奇金淋巴瘤（T淋巴母细胞性',
             'T淋巴母细胞淋巴瘤/白血病', '非霍奇金淋巴瘤(B淋巴母细胞型)', '非霍奇金淋巴瘤(B淋巴母细胞淋巴瘤/白血病)', 'B细胞性淋巴母细胞淋巴瘤',
             'T系淋巴母细胞淋巴瘤', 'T细胞性淋巴母细胞淋巴瘤', '淋巴母细胞淋巴瘤', 'T淋巴母细胞瘤', 'B淋巴母细胞瘤',
             'B淋巴细胞母细胞淋巴瘤', '前体B细胞·淋巴母细胞瘤', 'T细胞母细胞淋巴瘤/白血病', 'T淋巴母淋巴瘤',
             'T淋巴母细胞淋巴瘤白血病', '非霍奇金淋巴瘤（淋巴母细胞淋巴瘤，T细胞型', 'B细胞性淋巴母细胞淋巴瘤/白血病',
              'T细胞性淋巴母细胞瘤', 'T细胞母淋巴瘤', '急性T淋巴性淋巴母细胞性淋巴瘤',
             'T淋巴性淋巴母细胞性淋巴瘤', 'T细胞性淋巴母细胞性淋巴瘤', 'B细胞性淋巴母细胞性淋巴瘤', 'T细胞淋巴母淋巴瘤',
             '急性T淋巴细胞母细胞淋巴瘤', 'B细胞淋巴母细胞型淋巴瘤', 'T淋巴细胞母细胞淋巴瘤', 'T淋母淋巴瘤',
             '非霍奇金淋巴瘤（早前T淋巴母细胞型）', '早前T淋巴母细胞型', "髓样肉瘤"],
    'Ⅱ.b2': ['成熟的B细胞淋巴瘤（伯基特淋巴瘤除外）', '弥漫性大B细胞淋巴瘤（DLBCL），NOS', '弥漫性大B细胞淋巴瘤', 'DLBCL', '淋巴结边缘区淋巴瘤',
             '大B细胞淋巴瘤', '高级别B细胞淋巴瘤，NOS', '非霍奇金淋巴瘤(成熟B细胞型）, 非霍奇金淋巴瘤（成熟B细胞来源）',
             '非霍奇金淋巴瘤（成熟B细胞型）', '成熟B细胞淋巴瘤', '弥漫大B细胞淋巴瘤', '弥漫大B淋巴瘤', '弥漫大B细胞型', '成熟B细胞型',
             '弥漫性大B细胞型', '非霍奇金淋巴瘤(成熟B', '阳性大B细胞型', '非霍奇金淋巴瘤(弥漫大B', '非霍奇金淋巴瘤(弥漫性大B细胞',
             '非霍奇金淋巴瘤(B细胞型)(成熟B细胞', '弥漫大B细胞性淋巴瘤', '非霍奇金淋巴瘤(弥漫大B细胞', '小肠恶性淋巴瘤(弥漫大B）',
             '滤泡性淋巴瘤', 'EBV阳性MALT淋巴瘤',  '(成熟B)淋巴瘤', '胃粘膜相关淋巴组织淋巴瘤', '粘膜相关淋巴组织结外边缘区淋巴瘤',
             '非霍奇金淋巴瘤（滤泡淋巴瘤）', '非霍奇金淋巴瘤（滤泡型）', 'EB病毒阳性弥漫大B细胞淋巴瘤', '淋巴瘤样肉芽肿', 'Castleman病',
             '大B细胞性淋巴瘤', '非霍奇金淋巴瘤（ALK阳性大B细胞淋巴瘤）', '非霍奇金淋巴瘤（ALK阳性大B细胞型）'],
    'Ⅱ.b3': ['周围T细胞淋巴瘤', '成熟的T细胞和NK细胞淋巴瘤', '成熟的T细胞淋巴瘤', '成熟的NK细胞淋巴瘤', '间变性大细胞淋巴瘤', '外周T细胞淋巴瘤', '间变性大细胞型',
             '间变大细胞淋巴瘤', '间变大细胞性型', '间变大细胞型', '间变大细胞性', '间变型大细胞淋巴瘤', 'EBV阳性系统性NK细胞/T细胞性淋巴瘤',
             'NK/T细胞淋巴瘤，鼻型', '非霍奇金淋巴瘤(EBV阳性的NK/T细胞型)', '非霍奇金淋巴瘤(ALK阳性间变大细胞型)', '皮下脂膜炎样T细胞淋巴瘤',
             '间变性大细胞性淋巴瘤', 'EBV相关淋巴细胞增殖性疾病', '渐变性大细胞淋巴瘤', 'NK-T细胞淋巴瘤', 'NK/T细胞淋巴瘤',
             '系统性EBV阳性T细胞淋巴瘤', 'EBV阳性T细胞淋巴瘤', '间变性弥漫大细胞淋巴瘤', 'NK/T-细胞淋巴瘤', 'EBV淋巴细胞增殖性疾病',
             'EBV阳性相关性T细胞淋巴瘤', 'ALK+间变大淋巴细胞瘤', 'EBV阳性T细胞瘤', '熟T细胞淋巴瘤',
             '非霍奇金淋巴瘤（皮下脂膜炎样T细胞淋巴瘤', '皮肤T细胞淋巴瘤'],
    'Ⅱ.b4': ['非霍奇金淋巴瘤, NOS', '非霍奇金淋巴瘤（B细胞型）', '非霍奇金淋巴瘤(B细胞型)', '非霍奇金淋巴瘤 B细胞型', 'B细胞非霍奇金淋巴瘤',
             '非霍奇金淋巴瘤(B细胞型', '非霍奇金淋巴瘤'],
    'Ⅱ.c': ['伯基特淋巴瘤', '非霍奇金淋巴瘤（伯基特型）', 'Burkitt淋巴瘤', '非霍奇金淋巴瘤（Burkitt',
            '非霍奇金淋巴瘤(伯基特型)', '非霍奇金淋巴瘤(Burkitt', 'Burrkitt淋巴瘤',
            'Burikitt淋巴瘤', 'Burrkit淋巴瘤', 'Burkitt 淋巴瘤', '腹腔Burkitt 淋巴瘤', '伯基特瘤', '基特淋巴瘤',
            '腹部Burkkit淋巴瘤', 'Burkkit淋巴瘤', 'Burkittt淋巴瘤', '伯基特样淋巴瘤', '非霍奇金淋巴瘤（伯基特白血病）',
            'Burkitt淋巴瘤/白血病', 'burkit淋巴瘤', 'Burkitt白血病', 'buekitt白血病', '伯基特白血病', '伯基特样白血病',
            'Burkitt 白血病', '伯基特细胞白血病', 'Burkitt淋巴细胞白血病'],
    'Ⅱ.d': ['其他多种类型淋巴网状细胞肿瘤', '朗格汉斯细胞组织细胞增多症', '真性组织细胞淋巴瘤', '朗格汉斯细胞组织细胞增生症', "Langerhans细胞组织细胞增生症",
            '滤泡树突状细胞肉瘤', '细胞类型不确定的树突细胞肿瘤', '朗格汉斯细胞组织增多症', '母细胞性浆细胞样树突细胞瘤',
            '母细胞性浆细胞样树突状细胞肿瘤', '组织细胞肉瘤', '朗格汉斯组织细胞增生症', '朗格罕细胞组织细胞增生症',
            '朗格汉细胞组织细胞增生症', '郎格罕细胞组织细胞增生症', '母细胞性浆细胞样树突细胞肿瘤', '母细胞性浆样树突细胞肿瘤',
            '母细胞性浆细胞样树状突细胞肿瘤', '母细胞浆细胞样树突细胞肿瘤', '嗜酸性肉芽肿'],
    'Ⅱ.e': ['未特指的淋巴瘤', 'T淋巴细胞和髓系混合型淋巴母细胞淋巴瘤'],
    'Ⅲ.a1': ['室管膜瘤', '枕叶间变性室管膜瘤', '左侧颞叶室管膜肿瘤',
             '室管膜母细胞瘤', '脑室膜瘤', '室管瘤', '室管膜上瘤', '室管膜下瘤', '室管膜癌', '管膜瘤', '室管膜细胞瘤'],
    'Ⅲ.a2': ['脉络丛肿瘤', '脉络丛癌', '非典型脉络丛乳头状瘤', '脉络丛乳头状癌', '脉络丛乳突状癌', '脉络丛乳头状瘤', '脉络从乳头状癌'],
    'Ⅲ.b': ['毛细胞星形细胞瘤', '星形细胞瘤', '小脑星型细胞肿瘤', '星型胶质细胞瘤', '脊索样胶质瘤', '星形母细胞瘤', '胶质母细胞瘤', '弥漫性中线胶质瘤', '毛细胞星型细胞瘤',
            '星型细胞瘤', '额叶胶母细胞瘤', '弥漫型中线胶质瘤', '右颞叶高级别弥漫型细胞肿瘤', '弥漫星形胶质细胞瘤', '毛细胞型星形细胞瘤',
            '星型胶质瘤', '弥漫型中性胶质瘤', '中线型胶质瘤', '毛细胞型星形细胞胶质瘤', '毛细胞星形胶质瘤',
            '脑干弥漫中线胶质瘤', '毛粘液样型星形细胞瘤', '毛黏液样型星形细胞瘤', '弥漫型星型细胞肿瘤',
            '右颞岛叶儿童高级别胶质瘤IDH野生型', '颞岛叶儿童高级别胶质瘤IDH野生型', '颅窝弥漫性胶质瘤',
            '星形胶质细胞瘤', '毛细胞型星形胶质细胞瘤', '星形胶质细胞肿瘤', '弥漫型星形胶质细胞瘤', '星形细胞胶质瘤', '星形胶质瘤',
            '星性细胞瘤', '弥漫型星性细胞瘤', '星星细胞瘤', '视路胶质瘤', '视神经胶质瘤'],
    'Ⅲ.c1': ['髓母细胞瘤', '第四脑室髓母细胞膜瘤', '髄母细胞瘤', '小脑随母细胞瘤', '随母细胞瘤', '第四脑室经典型髓母细胞瘤'],
    'Ⅲ.c2': ['原始神经外胚层肿瘤（PNET）', '原始神经外胚叶肿瘤（PNET）',
             '（右枕叶）胚胎性肿瘤', '骶椎体、骶椎椎管内尤文肉瘤/原始神经外胚层肿瘤', '右额岛叶中枢神经系统胚胎性肿瘤',
             '中枢神经系统胚胎型肿瘤', '中枢系统多发性胚胎性肿瘤', '右额岛叶胚胎性肿瘤', '（左额叶）胚胎性肿瘤',
             '中枢神经系统原始神经外胚层瘤', '中枢神经胚胎性肿瘤', '右侧额叶胚胎性肿瘤', '额叶胚胎性肿瘤', '脑干胚胎性肿瘤',
             '右侧枕叶胚胎性肿瘤', '枕叶胚胎性肿瘤', '脑干恶性肿瘤胚胎性肿瘤', '中枢神经系统胚胎瘤', '原始神经外胚叶瘤', '中枢原始神经外胚叶肿瘤', '颌窦原始神经外胚层肿瘤'],
    'Ⅲ.c3': ['髓上皮瘤', '髓上皮样瘤', '胚胎发育不良神经上皮瘤', '胚胎发育不良性神经上皮肿瘤', '胚胎发育不良性神经上皮性瘤'],
    'Ⅲ.c4': ['非典型畸胎瘤/横纹肌样瘤', '非典型畸胎样/横纹肌样肿瘤', '非典型畸胎瘤/横纹肌样肿瘤', '非典型畸胎样/横纹肌样瘤',
             '非典型畸胎样瘤/横纹肌样肿瘤', '脑干非典型畸胎样横纹肌样瘤', '非典型畸胎样/横纹样瘤', '非典型畸胎瘤样/横纹肌样肿瘤',
             '右颞顶枕叶非典型畸胎瘤样/横纹肌样肿瘤', '非典型畸胎样横纹肌样瘤', '非典型性畸胎样横纹肌样瘤', '不典型畸胎样/横纹样肿瘤'],
    'Ⅲ.d1': ['少突神经胶质细胞瘤', '少突胶质细胞瘤', '（右额颞叶）符合间变型少突胶质细胞瘤'],
    'Ⅲ.d2': ['低级别胶质瘤', '高级别胶质瘤', '混合型和未特指的神经胶质细胞瘤', '脑干胶质瘤', '三脑室胶质瘤', '弥漫型低级别胶质瘤，NOS', '弥漫性胶质瘤', '高级别胶质瘤',
             '弥漫性高级别胶质瘤', '弥漫内生型胶质瘤', '弥漫性低级别胶质瘤', '胶质神经元肿瘤', '桥脑右份胶质瘤'],
    'Ⅲ.d3': ['来源不明的神经上皮胶质细胞瘤', '神经上皮瘤', '神经上皮性瘤', '神经上皮肿瘤'],
    'Ⅲ.e1': ['垂体腺瘤和垂体癌', '垂体腺瘤', '垂体癌'],
    'Ⅲ.e2': ['鞍区肿瘤（颅咽管瘤）', '颅咽管瘤', '颅咽管癌'],
    'Ⅲ.e3': ['松果体实质肿瘤', '松果体母细胞瘤', '松果体乳头状肿瘤', '松果体实质瘤', '松果体实质细胞瘤', 'Pineoblastoma'],
    'Ⅲ.e4': ['神经元肿瘤及神经元与神经胶质混合性肿瘤', '颅内胶质神经元混合性肿瘤', '胶质神经元混合性肿瘤', 'DNET', '节细胞胶质瘤'],
    'Ⅲ.e5': ['脑（脊）膜瘤', '脑膜瘤', '脊膜瘤', '脑膜癌', '脊膜癌'],
    'Ⅲ.f': ['未特指的颅内和椎管内肿瘤', '腰椎椎管梭形细胞瘤', '中枢神经系统胚胎性肿瘤', '脑胶质肉瘤'],
    'Ⅳ.a': ['神经母细胞瘤和神经节神经母细胞瘤', '神经母细胞瘤', '神母', '神经母肿瘤', 'INSS', 'INRG', 'INRGSS', '神经节细胞瘤uFH型',
            '腹膜后细胞性神经节细胞瘤', '(左侧)腹膜后恶性肿瘤(节母', '腹膜后恶性肿瘤(经母细胞瘤活检术', '神修母细胞瘤',
            '神经母西细胞瘤', '神经母细胞肿瘤', '节细胞神经瘤', '神经节母细胞瘤', '腹膜后神经细胞瘤', '节细胞型神经母细胞淋巴瘤',
            '（骶前）外周神经母细胞性肿瘤', '外周神经母细胞性肿瘤', '经母细胞瘤', '纵隔经母细胞瘤', '节细胞神经母细胞瘤',
            '节细胞性神经瘤', '节母细胞瘤', '神经节神经母细', '神经节细胞瘤', '神经性母细胞瘤', '神经母细瘤', '神经母细胞细胞瘤',
            '神经母细胞性肿瘤', '神经母细胞母细胞瘤', '神经母神经瘤', '肾上腺神经母细胞瘤'],
    'Ⅳ.b': ['其他周围神经细胞肿瘤', '腹膜后副神经节瘤', '左侧腹膜后恶性副神经节瘤', '腹膜后恶性副神经节瘤', '腹膜后副神经节肿瘤',
            '副神经节瘤', '腹腔恶性副神经节瘤', '嗜铬细胞瘤', '副神经节瘤'],
    'Ⅴ': ['视网膜母细胞瘤', '视母', '视网膜恶性肿瘤', '视网膜细胞瘤', '视网膜膜细胞瘤', '视网膜母细胞肿瘤', '视网膜瘤', '视网母细胞瘤',
          '视网膜恶性母细胞瘤'],
    'Ⅵ.a1': ['肾母细胞瘤', '肾母', '肾脏母细胞瘤'],
    'Ⅵ.a2': ['横纹肌样肾肿瘤', '肾横纹肌样瘤', '肾恶性横纹肌样瘤', '右侧肾脏横纹肌样瘤', '肾脏横纹肌样瘤'],
    'Ⅵ.a3': ['肾肉瘤', '左肾软组织肉瘤', '肾透明细胞肉瘤', '肾脏透明细胞肉瘤', '肾透明母细胞瘤', '肾透明细胞瘤', '透明细胞肉瘤（左肾）',
             '透明细胞肉瘤（右肾）', '（左肾）透明细胞肉瘤', '（右肾）透明细胞肉瘤', '肾透明细胞癌', '肾透明肉瘤' 
             '肾透明膜肉瘤', '肾透明母细胞肉瘤', '肾透明细肉瘤', '左侧肾透明细胞肉细胞瘤',
             '右侧肾透明细胞肉细胞瘤', '肾透明细胞肉细胞瘤', '（左侧肾脏肿物）透明细胞肉瘤', '（右侧肾脏肿物）透明细胞肉瘤'],
    'Ⅵ.b': ['肾癌', '肾细胞癌'],
    'Ⅵ.c': ['未特指的恶性肾肿瘤'],
    'Ⅶ.a1': ['肝母细胞瘤', '肝母', '肝脏母细胞瘤', '肝叶母细胞瘤', '肝左母细母细胞瘤', '肝右母细母细胞瘤'],
    'Ⅶ.a2': ['横纹肌样肝肿瘤', '肝横纹肌样瘤'],
    'Ⅶ.a3': ['肝胚胎性肉瘤', '肝脏胚胎性肉瘤', '肝脏胚胎性未分化性肉瘤', '肝胚胎性未分化肉瘤', '肝脏未分化肉瘤（胚胎型）',
             '肝脏胚胎性未分化肉瘤', '肝未分化胚胎性肉瘤', '肝脏未分化胚胎性肉瘤', '肝右叶未分化胚胎性肉瘤', '肝右叶胚胎性肉瘤',
             '肝左叶胚胎性肉瘤', '肝脏胚胎型未分化肉瘤', '肝脏胚胎性未分化型肉瘤', '肝脏未分化胚胎型肉瘤', '肝脏未分化肉瘤',
             '肝未分化肉瘤'],
    'Ⅶ.b': ['肝癌', '肝细胞癌', '肝内胆管癌'],
    'Ⅶ.c': ['未特指的恶性肝肿瘤'],
    'Ⅷ.a': ['骨肉瘤', '左股骨远端肉瘤', '左侧肱骨近端骨肉瘤', '股骨旁骨肉瘤', '股骨远端肉瘤', '股骨旁肉瘤', '肱骨近端肉瘤',
            '胫骨远端多形性未分化肉瘤', ' 胫骨恶性肿瘤 (多形性未分化肉瘤)', '胫骨远端瘤', '股骨骨巨细胞瘤', '股骨骨肉瘤',
            '胫骨骨母细胞性骨肉瘤'],
    'Ⅷ.b': ['软骨肉瘤', '右侧股骨软骨瘤', '左侧股骨软骨瘤', '股骨软骨瘤', '胫骨软骨瘤', '股骨软骨母细胞型肉瘤', '软骨母细胞瘤',
            '股骨近端软骨瘤', '软骨瘤'],
    'Ⅷ.c1': ['骨的尤因肉瘤和Askin瘤', '骨的尤因肉瘤', '骨的Askin瘤', '股骨近端尤文肉瘤', '右锁骨、右桡骨远端尤因肉瘤',
             '右侧股骨远端尤文肉瘤', '右侧股骨近端尤文式肉瘤', '右颌下尤文肉瘤', '右侧肩胛骨尤文肉瘤', '右侧股骨尤因肉瘤',
             '左下颌尤文肉瘤', '左肩胛骨尤文肉瘤', '左侧肩胛骨肿物（尤因肉瘤', '骶骨尤因肉瘤', '左桡骨中上段尤文氏肉瘤',
             '左肱骨远端尤文氏肉瘤', '骨尤因肉瘤', '骨尤文肉瘤',
             '骨尤文氏肉瘤', '骨Askin瘤', '右胫骨尤文肉瘤', '右股骨远端尤文肉瘤', '右股骨远端尤因肉瘤',
             '左胫骨尤文肉瘤', '右侧髂骨翼尤文肉瘤', '左髂骨尤文肉瘤', '右侧锁骨、桡骨尤文肉瘤', '肱骨上段尤文氏肉瘤', '腰椎尤文肉瘤',
             '左桡骨远端尤文肉瘤', '右桡骨远端尤文肉瘤', '桡骨远端尤文肉瘤', '骶尾椎尤文肉瘤', '股骨尤文氏瘤', '股骨中段尤文肉瘤',
             '股骨下段尤文氏肉瘤', '（左侧下颌骨）尤文肉瘤', '（右侧下颌骨）尤文肉瘤', '股骨远端尤因肉瘤',
             '髋关节尤因肉瘤', '椎体尤因肉瘤', '股骨近端尤因肉瘤', '耻骨、坐骨、髋臼尤文肉瘤', '股骨上段尤文肉瘤', '股骨远端尤文肉瘤',
             '胫骨骨母细胞瘤性骨肉瘤', '股骨近段尤文肉瘤', '胫骨尤文肉瘤', '股骨远端尤文氏肉瘤', '骨外尤因肉瘤',
             '股骨上段尤文氏肉瘤'],
    'Ⅷ.c2': ['骨的周围神经外胚层肿瘤'],
    'Ⅷ.d1': ['骨恶性纤维肿瘤', '骨纤维瘤', '前颅底骨化纤维瘤', '骨化纤维瘤', '股骨远端纤维肉瘤'],
    'Ⅷ.d2': ['恶性脊索瘤', '脊索恶性肿瘤', '脊索瘤'],
    'Ⅷ.d3': ['牙源性恶性肿瘤', '牙癌', '成釉细胞瘤'],
    'Ⅷ.d4': ['其他多种类型的恶性骨肿瘤'],
    'Ⅷ.e': ['未特指的恶性骨肿瘤'],
    'Ⅸ.a': ['横纹肌肉瘤', '横纹肌瘤', '胚胎型横纹肌肉', '胚胎性横纹肌肉', '盆腔横纹肌肉', '有横纹肌分化的恶性肿瘤', '盆腔横纹肉瘤',
            '膀胱横纹胚胎性肌肉瘤', '横纹胚胎性肌肉瘤', '胚胎性横纹肌肉瘤', '横文肌肉瘤', '腺泡状横纹肌肉瘤', '横纹肌肉瘤腺泡型', '横纹肌样瘤（颅内）'],
    'Ⅸ.b1': ['纤维母细胞和肌纤维母细胞瘤', '炎性肌纤维母细胞瘤', '纤维母细胞瘤', '肌纤维母细胞瘤', '肌纤维母细胞性肿瘤',
             '右侧腋下低度恶性肌纤维母细胞性肉瘤', '左上臂低度恶性肌纤维母细胞肉瘤', '右侧大阴唇巨细胞纤维母细胞瘤',
             '右侧腹股沟纤维母细胞瘤', '肌纤维母细胞肉瘤', '纤维母细胞肿瘤', '先天性纤维肉瘤', '纤维母细胞性肉瘤',
             '婴儿型纤维肉瘤', '婴儿纤维肉瘤', '婴儿性纤维肉瘤', '纤维母细胞性肿瘤', '纤维粘液样肉瘤', '左小腿纤维瘤病', '左侧小腿纤维瘤病'],
    'Ⅸ.b2': ['神经鞘肿瘤', '神经鞘瘤', '恶性外周神经鞘膜瘤', '恶性蝾螈瘤', '颈部恶性外周神经鞘瘤', '左大腿恶性神经鞘瘤',
             '左侧三叉神经恶性蝾螈瘤', '三叉神经恶性蝾螈瘤', '恶性神经鞘瘤', '恶性外周神经鞘瘤', '神经鞘瘤', '神经鞘膜瘤'],
    'Ⅸ.b3': ['其他纤维瘤性肿瘤'],
    'Ⅸ.c': ['卡波西肉瘤'],
    'Ⅸ.d1': ['软组织的尤因肉瘤和Askin瘤', '大腿尤文氏肉瘤', '右侧鼻腔、鼻窦骨外尤因肉瘤', '头皮尤文肉瘤', '尤文氏肉瘤（右侧大腿）',
             '左侧胸腔尤文氏肉瘤', '右侧胸腔尤文氏肉瘤', '胸腔尤文氏肉瘤', '左大腿尤文肉瘤', '大腿尤文肉瘤', '胸腔尤文式肉瘤',
             '上颌窦尤文氏肉瘤', '纵膈尤文肉瘤', '左背部尤文肉瘤', '左纵隔尤文肉瘤', '喉尤文肉瘤', '右上臂尤文肉瘤', '左小腿EWing肉瘤',
             '右后纵隔尤文肉瘤', '纵隔尤文肉瘤', '腹膜后尤文氏肉瘤', '胸壁尤文肉瘤', '鼻腔鼻窦尤文肉瘤', '右前臂尤文氏肉瘤',
             '腹膜后尤文肉瘤', '腹股沟尤文肉瘤', '胸腔尤文肉瘤', '肩背部尤文肉瘤', '鼻腔尤文氏肉瘤', '纵隔尤因肉瘤',
             '纵隔尤文氏瘤', '颈部尤文肉瘤', '颈部尤文样瘤', '右上肢尤文氏肉瘤', '颅内尤文肉瘤'],
    'Ⅸ.d2': ['软组织的周围神经外胚层肿瘤 （pPNET）', '胸壁原始神经外胚瘤', '外周原始神经外胚层肿瘤'],
    'Ⅸ.d3': ['肝、肾外横纹肌样瘤', '肝外横纹肌样瘤', '肾外横纹肌样瘤', '上肢恶性横纹肌样瘤', '咽旁间隙横纹肌样瘤', '左下肢横纹肌样瘤',
             '（右肾上腺）INI-1缺失性肿瘤', '右腋下横纹肌样瘤', '盆腔肾外恶性横纹肌样瘤', '胸腔恶性横纹肌样瘤', '椎管横纹肌样瘤',
             '左侧小脑横纹肌样瘤', '盆底、右侧臀部、右大腿恶性横纹肌样瘤', '肾外恶性横纹肌样瘤', '胸椎横纹肌样瘤', '颈部恶性横纹肌样瘤'],
    'Ⅸ.d4': ['脂肪肉瘤', '右大腿脂肪母细胞瘤', '脂肪瘤'],
    'Ⅸ.d5': ['纤维组织细胞肿瘤', '隆突性皮肤纤维肉瘤', '胸壁纤维肉瘤', '纤维组织细胞瘤'],
    'Ⅸ.d6': ['平滑肌肉瘤'],
    'Ⅸ.d7': ['滑膜肉瘤', '软组织透明细胞肉瘤', '左前臂透明细胞肉瘤', '左膝前软组织透明细胞肉瘤', '右前臂软组织透明细胞肉瘤',
             '左膝前透明细胞肉瘤'],
    'Ⅸ.d8': ['血管肿瘤', '血管瘤', '肝血管肉瘤', '血管肉瘤', '血管内皮瘤', '右上胸壁卡波希血管内皮瘤', '卡波希血管内皮瘤'],
    'Ⅸ.d9': ['软组织的骨化和软骨化肿瘤'],
    'Ⅸ.d10': ['腺泡状软组织肉瘤'],
    'Ⅸ.d11': ['婴儿原始粘液样间叶性肿瘤', '其他多种类型软组织肉瘤', '盆腔骶尾中枢原始神经外胚叶肿瘤部梭形细胞间叶源性肿瘤', '间叶源性肿瘤', '腹膜后促纤维增生性小圆细胞肿瘤',
               '颈部婴儿原始粘液样间叶性肿瘤', '未分化树突细胞瘤', '未定型树突状细胞瘤', '左下腹间叶源性恶性肿瘤', '间叶源性恶性肿瘤'],
    'Ⅸ.e': ['未特指的软组织肉瘤', '小圆细胞未分化肉瘤', '左侧臀部软组织未分化肉瘤', '软组织未分化肉瘤', '腹膜后未分化肉瘤', '肾未分化肉瘤',
            '上皮样细胞肉瘤', '膀胱上皮样肉瘤', '腹膜后上皮样肉瘤', '盆腔骶尾部上皮样肉瘤', '右大腿根部上皮样肉瘤', '上皮样纤维肉瘤'],
    'Ⅹ.a1': ['颅内和椎管内生殖细胞瘤', '(三脑室)生殖细胞瘤', '（鞍区）生殖细胞瘤', '鞍区生殖细胞瘤', '松果体生殖细胞瘤', '基底节区生殖细胞瘤',
             '颅内生殖细胞瘤', '松果体区生殖细胞瘤', '左侧额叶、侧脑室占位性病变：生殖细胞瘤肿瘤', '中枢恶性生殖细胞瘤',
             '松果体、鞍上池、右侧基底节区生殖细胞瘤', '鞍区松果体生殖细胞瘤', '松果体生殖细胞肿瘤', '鞍上池生殖细胞肿瘤',
             '基底区单纯性生殖细胞瘤', '三脑室生殖细胞瘤', '下丘脑生殖细胞肿瘤', '左侧额叶、侧脑室生殖细胞瘤',
             '鞍上区、松果体区生殖细胞肿瘤', '蝶鞍上生殖细胞瘤', '鞍区生殖细胞肿瘤', '右侧基底节生殖细胞瘤', '基底节生殖细胞瘤',
             '颅内恶性生殖细胞瘤', '基底节区生殖细胞肿瘤', '下丘脑生殖细胞瘤', '鞍上、松果体区生殖细胞肿瘤', '颅内非生殖细胞源性生殖细胞瘤',
             '室间孔生殖细胞瘤', '<基底节区>生殖细胞肿瘤', '颅脑生殖细胞瘤', '腰椎管内生殖细胞瘤', '基底节区-海马区生殖细胞瘤',
             '松果体恶性肿瘤：生殖细胞瘤', '鞍区及松果体生殖瘤', '松果体、三脑室底生殖细胞瘤', '延髓生殖细胞瘤', '（左侧丘脑）生殖细胞瘤',
             '（右侧丘脑）生殖细胞瘤', '丘脑）生殖细胞瘤', '丘脑生殖细胞瘤', '松果体区精原细胞瘤', '双侧丘脑、右侧海马旁回生殖细胞源性肿瘤',
             '松果体单纯性生殖细胞瘤', '松果体区单纯性生殖细胞瘤', '脑室生殖细胞瘤', '脑室混合生殖细胞瘤', '侧脑室混合生殖细胞瘤',
             '基底节，生殖细胞瘤', '（基底节）生殖细胞瘤', '松果体及第三脑室区域生殖细胞瘤', '四脑室生殖细胞瘤', '（松果体）生殖细胞瘤',
             '脑室旁精原细胞瘤', '侧脑室生殖细胞瘤', '脑干、丘脑生殖细胞瘤', '大脑半球生殖细胞肿瘤', '脑半球生殖细胞肿瘤',
             '颅内恶性生殖细胞肿瘤', '中枢神经系统生殖细胞瘤', '中枢神经系统生殖细胞肿瘤', '脑室生殖细胞', '基底节区生殖细胞源性肿瘤',
             '基底节生殖细胞肿瘤', '鞍区生细胞瘤', '鞍区无性细胞瘤', '鞍区及松果体恶性生殖细胞肿瘤', '鞍区恶性生殖细胞肿瘤',
             '松果体恶性生殖细胞肿瘤', '左脑绑脑半球生殖细胞肿瘤', '椎管内）恶性生殖细胞肿瘤', '中枢生殖细胞瘤',
             '鞍区、中脑被盖区生殖细胞瘤', '颅内生殖细胞肿瘤', '（左额）生殖细胞瘤', '（右额）生殖细胞瘤', '基底节区>生殖细胞肿瘤',
             '脑生殖细胞恶性肿瘤', '颅内生殖细胞恶性肿瘤', '松果体区恶性生殖细胞瘤', '松果体去生殖细胞瘤',
             '垂体生殖细胞瘤', '基底节左）生殖细胞瘤', '鞍上恶性生殖细胞瘤', '第三脑室无性细胞瘤', '脑室无性细胞瘤', '松果体恶性生殖细胞瘤',
             '鞍上生殖细胞肿瘤', '脑室）生殖细胞瘤', '第三脑室、基底节区、丘脑、下丘脑脑干生殖细胞瘤', '鞍上生殖细胞瘤',
             '小脑蚓部生殖细胞肿瘤', '松果体区生殖细胞来源肿瘤', '(基底节)生殖细胞瘤', '鞍区生殖细胞来源瘤', '（颅内）生殖细胞瘤',
             '颅内纯生殖细胞瘤', '中枢恶性生殖细胞肿瘤'],
    'Ⅹ.a2': ['颅内和椎管内畸胎瘤', '（三脑室）未成熟畸胎瘤', '（三脑室后）不成熟型畸胎瘤', '鞍区畸胎瘤', '颅内畸胎瘤',
             '三脑室后部未成熟畸胎瘤', '松果体未成熟畸胎瘤', '颅内未成熟畸胎瘤', '颅内未成熟性畸胎瘤', '三脑室畸胎瘤',
             '颅内未成熟的畸胎瘤', '“小脑”不成熟性畸胎瘤', '（三脑室、松果体）囊实性成熟畸胎瘤', '松果体畸胎瘤术',
             '（松果体肿物）囊实性未成熟性畸胎瘤', '松果体畸胎瘤',  '中枢神经系统畸胎瘤'],
    'Ⅹ.a3': ['颅内和椎管内胚胎性癌', '颅内胚胎性肿瘤', '四脑室胚胎性肿瘤', '后颅窝胚胎性肿瘤', '颅窝胚胎性肿瘤', '（松果体）考虑胚胎性肿瘤',
             '额叶巨大胚胎性肿瘤', '颅内胚胎性癌', '中枢神经系统胚胎性癌', '中枢神经系统胚胎肿瘤', '三脑室胚胎性癌', '脑室胚胎性癌',
             '颅内、椎管胚胎性肿瘤', '椎管胚胎性癌', '基底节区胚胎性癌', '左顶叶多层菊形团胚胎性肿瘤'],
    'Ⅹ.a4': ['颅内和椎管内卵黄囊瘤', '小脑卵黄囊瘤', '脑卵黄囊瘤', '椎管内卵黄囊瘤', '中枢神经系统卵黄囊瘤',
             '松果体区卵黄囊瘤', '基底节区卵黄囊瘤', '颅内卵黄瘤', '左额顶部卵黄囊瘤', '颅内卵黄囊瘤', '第三脑室内胚窦瘤', '脑室内胚窦瘤',
             '松果体卵黄囊瘤'],
    'Ⅹ.a5': ['颅内和椎管内绒毛膜癌', '松果体区绒毛膜癌', '颅内绒毛膜癌', '中枢神经系统绒毛膜癌', '椎管内绒毛膜癌'],
    'Ⅹ.a6': ['颅内非生殖细胞瘤性生殖细胞肿瘤', '颅内和椎管内混合性肿瘤', '（鞍区）混合性生殖细胞肿瘤', '鞍区混合型生殖细胞瘤', '松果体区混合性生殖细胞肿瘤',
             '松果体混合性生殖细胞肿瘤', '颅内混合性生殖细胞瘤', '鞍区三脑室混合型生殖细胞瘤',
             '脑鞍区及松果体区混合性生殖细胞瘤', '松果体恶性混合性生殖细胞瘤', '鞍区、三脑室混合型生殖细胞肿瘤',
             '左颞叶含有生殖细胞瘤成份的畸胎瘤', '松果体混合型生殖细胞瘤', '左侧侧脑室混合型生殖细胞瘤', '右侧侧脑室混合型生殖细胞瘤',
             '脑室混合型生殖细胞瘤', '松果体区混合性生殖细胞瘤', '鞍上区生殖细胞瘤', '松果体混合性生殖细胞瘤',
             '松果体肿瘤（混合型生殖细胞瘤', '（松果体肿瘤）混合性生殖细胞肿瘤', '（第三脑室后部）恶性混合生殖细胞肿瘤',
             '基底节区混合性生殖细胞肿瘤', '鞍区、右侧基底节区、三脑室混合性生殖细胞肿瘤', '脑恶性肿瘤:混合性生殖细胞瘤',
             '鞍上池混合性生殖细胞瘤', '颅内混合性生殖细胞肿瘤', '基底节区及丘脑混合性生殖细胞肿瘤', '左额混有生殖细胞瘤成份畸胎瘤',
             '松果体混合型生殖细胞肿瘤', '（鞍区）混合性生殖细胞瘤', '鞍区混合性生殖细胞瘤', '基底节区混合生殖细胞瘤',
             '松果体区）恶性混合性生殖细胞肿瘤', '三脑室后部)混合性生殖细胞瘤', '颅内混合型生殖细胞肿瘤', '垂体脑混合性生殖细胞瘤',
             '鞍区混合性生殖细胞肿瘤', '鞍区混合生殖细胞肿瘤', '松果体区恶性混合性生殖细胞瘤', '松果体区混合性恶性生殖细胞肿瘤',
             '松果体）恶心混合性生殖细胞瘤', '松果体）恶性混合生殖细胞肿瘤', '脑混合性生殖细胞瘤', '（松果体）恶性混合性生殖细胞肿瘤',
             '脑室混合性生殖细胞瘤', '颅窝生殖细胞瘤', '松果体区恶性混合型生殖细胞肿瘤', '松果体混合生殖细胞瘤', '三脑室后部混合生殖细胞瘤',
             '脑室后部混合生殖细胞瘤', '（松果体）恶性混合性生殖细胞瘤', '(松果体)恶性混合性生殖细胞瘤', '颅内混合生殖细胞肿瘤',
             '基底节-丘脑区混合性生殖细胞肿瘤', '(鞍区)混合型生殖细胞瘤', '(鞍区)混合性生殖细胞瘤', '松果体区混合生殖细胞瘤',
             '鞍区混合型生殖瘤', '椎管内）混合性生殖细胞肿瘤', '颅内生殖细胞肿瘤（恶性混合性）'],
    'Ⅹ.b1': ['颅外和性腺外部位的恶性生殖细胞瘤', '骶尾部恶性生殖细胞瘤', '（骶尾部）恶性生殖细胞肿瘤', '纵膈精原细胞瘤',
             '骶尾部恶性肿瘤（生殖细胞瘤', '骶尾部恶性生殖细胞肿瘤', '纵隔精原细胞瘤', '纵隔生殖细胞肿瘤', '胸腔恶性生殖细胞源性肿瘤',
             '后纵膈生殖细胞肿瘤', '纵隔恶性生殖细胞瘤', '右侧附件无性细胞瘤', '骶尾部生殖细胞恶性肿瘤', '盆腔无性细胞瘤',
             '骶尾部恶性生殖肿瘤', '骶尾部-盆腔恶性生殖细胞肿瘤', '纵膈恶性生殖细胞瘤', '纵隔恶性生殖细胞肿瘤', '腹部恶性生殖细胞瘤',
             '骶尾部生殖细胞瘤', '腹部恶性生殖细胞肿瘤', '盆腔恶性生殖细胞肿瘤', '纵膈生殖细胞肿瘤', '腹膜后恶性生殖细胞瘤',
             '腹膜恶性生殖细胞瘤', '骶尾部生殖细胞肿瘤', '腹膜后生殖细胞肿瘤', '腹腔恶性生殖细胞肿瘤', '髋关节生殖细胞瘤',
             '纵隔生殖细胞恶性肿瘤', '颅外性腺外生殖细胞肿瘤', '性腺外生殖细胞瘤', '腹腔恶性肿瘤：无性细胞瘤', '腹膜后恶性生殖细胞肿瘤',
             '骶尾部恶性肿瘤：生殖细胞瘤', '盆腔恶性肿瘤：无性细胞瘤', '前纵隔恶性肿瘤 (恶性生殖细胞肿瘤)', '盆腔生殖细胞来源恶性肿瘤',
             '纵隔生殖细胞瘤', '纵膈精源细胞瘤', '纵膈生殖细胞瘤', '盆腔生殖细胞瘤', '阴囊恶性生殖细胞肿瘤', '腹腔无性细胞瘤',
             '纵膈恶性生殖细胞肿瘤', '腹腔生殖细胞肿瘤', '（右前纵膈）恶性生殖细胞瘤', '纵膈）恶性生殖细胞瘤', '左纵隔）生殖细胞肿瘤',
             '右纵隔）生殖细胞肿瘤', '纵隔）生殖细胞肿瘤', '胸腺生殖细胞瘤', '纵膈精原细胞恶性肿瘤', '腹部生殖细胞肿瘤',
             '（骶尾部）恶性生殖细胞瘤', '颅外恶性生殖细胞肿瘤', '盆腔无形细胞瘤', '（骶尾部肿物）生殖细胞肿瘤', '腹腔恶性生殖细胞瘤',
             '（左纵膈）生殖细胞肿瘤', '（右纵膈）生殖细胞肿瘤', '纵隔生殖细胞源性肿瘤', '（纵隔）恶性生殖细胞瘤', '骶前生殖细胞瘤',
             '骶尾部生殖细胞来源恶性肿瘤', '右前纵膈）恶性生殖细胞瘤'],
    'Ⅹ.b2': ['颅外和性腺外部位的恶性畸胎瘤', '骶尾部畸胎瘤', '骶尾部恶性畸胎瘤', '纵隔未成熟畸胎瘤', '腹膜未成熟畸胎瘤',
             '腹膜后未成熟畸胎瘤', '（右腹膜后）囊实性未成熟畸胎瘤', '腹膜后囊实性未成熟畸胎瘤', '胃不成熟性畸胎瘤',
             '右腹部不成熟性畸胎瘤', '（左侧腹膜后）未成熟畸胎瘤', '（盆腔）未成熟畸胎瘤', '（骶尾部包块）未成熟畸胎瘤',
             '腹部肿瘤畸胎瘤', '（左侧胸腔）未成熟畸胎瘤', '（右侧胸腔）未成熟畸胎瘤', '左侧胸腔畸胎瘤', '右侧胸腔畸胎瘤',
             '纵隔巨大未成熟畸胎瘤', '骶尾部恶性肿瘤(恶性畸胎瘤', '左侧腹膜后）结合形态学和免疫组化，符合未成熟畸胎瘤',
             '右侧纵隔未成熟畸胎瘤', '右纵隔畸胎瘤', '骶尾部未成熟畸胎瘤', '右纵隔、胸腔未成熟畸胎瘤', '腹膜后畸胎瘤', '右侧腹膜后畸胎瘤',
             '左侧腹膜后畸胎瘤', '骶尾部未分化恶性畸胎瘤', '胸腺不成熟畸胎瘤', '纵膈畸胎瘤', '纵隔胸腺畸胎瘤', '盆腔骶尾部未成熟型畸胎瘤',
             '腹部畸胎瘤', '盆腔未成熟畸胎瘤', '右侧胸腔未成熟畸胎瘤', '胸腔未成熟畸胎瘤',
             '腹腔畸胎瘤', '盆腔未成熟型畸胎瘤', '胃壁未成熟畸胎瘤', '腹腔恶性肿瘤：未成熟畸胎瘤', '纵隔畸胎瘤', '腹膜后未成熟性畸胎瘤',
             '腹膜后恶性畸胎瘤', '“腹部”不成熟性畸胎瘤', '“腹膜后”不成熟性畸胎瘤', '（腹膜后）未成熟畸胎瘤', '（纵隔）不成熟性畸胎瘤',
             '腹膜后恶性肿瘤(未成熟畸胎瘤', '盆腔恶性肿瘤：未成熟畸胎瘤', '（胸腔）未成熟畸胎瘤',
             '（腹部） 结合临床、形态及免疫组化结果，符合未成熟性畸胎瘤', '<左侧纵膈肿瘤>未成熟性畸胎瘤', '<右侧纵膈肿瘤>未成熟性畸胎瘤',
             '纵膈恶性肿瘤：不成熟畸胎瘤', '畸胎瘤(胃畸胎瘤术后，未成熟型', '恶性畸胎瘤(腹膜后', '腹膜后恶性肿瘤（不成熟性囊性畸胎瘤',
             '（右前纵隔）胸腺未成熟型畸胎瘤', '（纵膈）畸胎瘤', '（纵膈）未成熟畸胎瘤',
             '（右前纵膈）病理结果提示符合未成熟型畸胎瘤', '纵隔“未成熟畸胎瘤”', '腹部恶性肿瘤：不成熟畸胎瘤', '胃恶性肿瘤（未成熟畸胎瘤',
             '腹膜后”囊实性未成熟型畸胎瘤', '盆腔恶性畸胎瘤', '腹膜畸胎瘤', '附件畸胎瘤', '胸腔畸胎瘤', '盆腔畸胎瘤', '胃畸胎瘤',
             '纵隔恶性畸胎瘤', '附件包块）畸胎瘤', '骶尾部Ⅳ期畸胎瘤', '骶部畸胎瘤', '腹膜后巨大畸胎瘤', '（左附件）畸胎瘤',
             '（右附件）畸胎瘤', '纵膈）畸胎瘤', '腹腔恶性畸胎瘤', '胃部畸胎瘤'],
    'Ⅹ.b3': ['颅外和性腺外部位的胚胎性癌', '盆腔胚胎性癌', '（胸12-骶1髓内）胚胎性肿瘤'],
    'Ⅹ.b4': ['颅外和性腺外部位的卵黄囊瘤', '骶尾部卵黄囊瘤', '腹膜后卵黄囊瘤', '盆腔卵黄囊瘤', '纵隔卵黄囊瘤', '骶尾部恶性卵黄囊瘤',
             '骶尾部内胚窦瘤', '胸腔卵黄囊瘤', '（前纵膈）卵黄囊瘤', '腹膜后恶性肿瘤：卵黄囊瘤', '盆腔骶尾部卵黄囊瘤', '阴道卵黄囊瘤',
             '骶尾部恶性肿瘤（卵黄囊瘤）', '左颈部卵黄囊瘤', '纵膈卵黄囊瘤', '颈部卵黄囊瘤', '盆腔内胚窦瘤',
             '腹部卵黄囊瘤', '（阴道）卵黄囊瘤', '性腺外卵黄囊瘤', '性腺外卵黄囊瘤：盆底、骶尾部型', '骶尾部恶性肿瘤（卵黄囊瘤',
             '纵隔恶性肿瘤非精源细胞瘤（卵黄囊瘤）',  '纵膈恶性肿瘤（卵黄囊瘤', '盆腔腹膜后、腹股沟卵黄囊瘤', '骶尾部恶性肿瘤(卵黄囊瘤',
             '阴道内胚窦瘤', '胸腺内胚窦瘤', '骶尾部肿物：卵黄囊瘤', '盆腔肿瘤(卵黄囊瘤', '盆腔恶性肿瘤（卵黄囊瘤',
             '阴道恶性肿瘤(III期，内胚窦癌', '腹部恶性肿瘤（卵黄囊瘤）', '骶尾部恶性肿瘤：卵黄囊瘤',
             '腹部恶性肿瘤(卵黄囊瘤', '阴道內胚窦瘤', '前列腺卵黄囊瘤', '左侧附件卵黄囊瘤', '右侧附件卵黄囊瘤', '附件卵黄囊瘤',
             '盆腔内胚窦癌', '阴囊卵黄囊瘤', '（左侧翼腭窝）内胚窦瘤', '（右侧翼腭窝）内胚窦瘤', '腭窝）内胚窦瘤', '阴道内胚窦癌',
             '腹膜后内胚窦癌', '左侧腹盆腔、腹股沟卵黄囊瘤', '右侧腹盆腔、腹股沟卵黄囊瘤', '盆腔、腹股沟卵黄囊瘤', '阴茎卵黄囊瘤',
             '（骶尾部）卵黄囊瘤', '子宫阴道卵黄囊瘤', '子宫卵黄囊瘤', '（右侧咽旁）卵黄囊瘤',
             '（子宫）卵黄囊瘤', '腹膜后恶性卵黄囊瘤', '股沟卵黄囊瘤', '侧腹股沟卵黄囊瘤', '肝脏卵黄囊瘤',
             '腹膜黄囊黄囊瘤', '盆腔恶性内胚窦癌', '腹腔卵黄囊瘤', '（左侧翼腭窝）卵黄囊瘤', '（右侧翼腭窝）卵黄囊瘤',
             '（双侧翼腭窝）卵黄囊瘤', '腹壁卵黄囊瘤', '（肝左叶）内胚窦瘤', '（肝右叶）内胚窦瘤', '（肝叶）内胚窦瘤', '子宫阴道恶性卵黄囊瘤',
             '子宫恶性卵黄囊瘤', '阴道恶性卵黄囊瘤', '骶尾部內胚窦瘤', '阴道卵黄瘤', '盆腔卵黄瘤瘤', '附件区卵黄囊瘤',
             '阴茎及膀胱颈卵黄囊瘤', '纵膈内胚窦瘤', '盆腔内骶尾椎前方卵黄囊瘤', '腹壁内胚窦瘤', '骶尾部卵黄管囊瘤', '骶尾部卵黄瘤',
             '盆腔骶前卵黄囊瘤', '翼鄂窝）内胚窦瘤', '纵隔内胚窦瘤', '翼颚窝）内胚窦瘤', '盆腔骶尾部前方卵黄囊瘤', '腹膜内胚窦癌',
             '腹膜后巨大卵黄囊瘤', '会阴部卵黄囊瘤', '翼腭窝）卵黄囊瘤', '卵黄囊瘤（阴道）', '胰腺卵黄囊瘤', '（胰腺）卵黄囊瘤'],
    'Ⅹ.b5': ['颅外和性腺外部位的绒毛膜癌', '纵隔绒毛膜癌', '侵袭性葡萄胎', '(肝)绒毛膜癌', '肝绒毛膜癌'],
    'Ⅹ.b6': ['颅外和性腺外的其他特指和未特指的恶性混合生殖细胞肿瘤', '骶尾部恶性混合生殖细胞瘤', '盆腔骶尾部恶性混合生殖细胞肿瘤',
             '腹腔混合性生殖细胞瘤', '（右腹膜后）恶性混合型生殖细胞肿瘤', '纵隔恶性混合性生殖细胞肿瘤', '盆腔恶性混合性生殖细胞肿瘤',
             '腹膜后恶性混合性生殖细胞瘤', '骶尾部混合性生殖细胞肿瘤', '右纵隔混合性生殖细胞肿瘤', '纵隔混合性生殖细胞肿瘤',
             '纵膈恶性混合生殖细胞肿瘤', '纵隔混合型生殖细胞肿瘤', '骶尾部混合性生殖细胞恶性肿瘤', '纵膈混合性生殖细胞肿瘤',
             '盆腔混合性生殖细胞肿瘤', '纵隔恶性混合生殖细胞肿瘤', '右前纵隔恶性混合生殖细胞肿瘤', '盆腔骶尾部混合生殖细胞瘤',
             '盆腔混合性生殖细胞瘤', '骶尾部恶性混合性生殖细胞瘤', '骶尾部混合性生殖细胞瘤', '盆腔、腰骶部恶性混合性生殖细胞瘤',
             '纵隔恶性肿瘤（混合型生殖细胞瘤', '腹膜后肿瘤(混合性生殖细胞瘤', '盆腔恶性肿瘤(混合型生殖细胞瘤',
             '纵隔恶性肿瘤 cT1bN0M0 I期,混合性生殖细胞瘤', '（右前纵隔）恶性混合性生殖细胞肿瘤',
             '混合性生殖细胞瘤(骶尾部', '（腹膜后）恶性混合性生殖细胞瘤', '（腹膜后）恶性混合性生殖细胞肿瘤',
             '骶尾部恶性肿瘤：混合性生殖细胞肿瘤', '（骶尾部、右侧盆腔）符合恶性混合性生殖细胞肿瘤',
             '“左侧腹膜后”恶性混合性生殖细胞肿瘤', '恶性混合性生殖细胞肿瘤（卵黄囊瘤+畸胎瘤）',
             '骶尾部混合型生殖细胞瘤', '纵隔混合生殖细胞肿瘤', '骶尾部混合生殖细胞肿瘤',
             '胸腺恶性混合性生殖细胞肿瘤', '骶尾部恶性混合型生殖细胞瘤', '纵隔恶性混合生殖细肿胞瘤', '骶尾部恶性混合型生殖细胞肿瘤',
             '骶尾部肿物）混合性生殖细胞肿瘤', '骶尾部混合性恶性生殖细胞肿瘤', '盆腔内混合性生殖细胞瘤', '腹部混合性生殖细胞肿瘤',
             '骶尾部恶性混合性生殖细胞肿瘤', '腹膜后恶性混合型生殖细胞瘤', '骶尾部恶性混合生殖细胞肿瘤', '骶尾部混合型生殖细胞恶性肿瘤',
             '腹膜后混合性恶性生殖细胞瘤', '（骶尾部肿物）恶性混合性生殖细胞肿瘤', '骶尾部混合型生殖细胞肿瘤'],
    'Ⅹ.c1': ['恶性性腺生殖细胞瘤', '睾丸生殖细胞瘤', '卵巢恶性生殖细胞瘤', '卵巢无性细胞瘤', '卵巢恶性生殖细胞肿瘤', '卵巢生殖细胞瘤',
             '睾丸恶性生殖细胞瘤', '卵巢生殖细胞肿瘤', '卵巢肿瘤无性细胞瘤', '右侧卵巢恶性生殖源性肿瘤', '卵巢恶性生殖源性肿瘤',
             '左侧卵巢恶性生殖源性肿瘤', '左侧睾丸非精原细胞瘤', '左侧卵巢无性生殖细胞瘤', '右侧睾丸非精原细胞瘤', '右侧卵巢无性生殖细胞瘤',
             '卵巢无性生殖细胞瘤', '睾丸非精原细胞瘤', '卵巢恶性肿瘤(生殖细胞肿瘤)', '卵巢恶性肿瘤：生殖细胞瘤',
             '卵巢恶性肿瘤（IIIC期，无性细胞癌）', '睾丸精原细胞瘤', '（左侧卵巢）无性细胞瘤', '（右侧卵巢）无性细胞瘤',
             '（双侧卵巢）无性细胞瘤', '卵巢无性细胞肿瘤', '卵巢生殖细胞源性恶性肿瘤', '左侧卵巢无性生殖细胞肿瘤', '右侧卵巢无性生殖细胞肿瘤',
             '卵巢无性生殖细胞肿瘤', '睾丸非精原细胞癌', '卵巢生殖细胞恶性肿瘤', '（左侧卵巢、输卵管）生殖细胞肿瘤',
             '（左侧睾丸肿瘤）生殖细胞来源肿瘤', '（右侧睾丸肿瘤）生殖细胞来源肿瘤', '睾丸恶性生殖细胞肿瘤', '（左侧卵巢）生殖细胞肿瘤',
             '（右侧卵巢）生殖细胞肿瘤'],
    'Ⅹ.c2': ['恶性性腺畸胎瘤', '卵巢未成熟畸胎瘤', '卵巢囊实性不成熟型畸胎瘤', '卵巢囊实性未成熟型畸胎瘤', '卵巢未成熟性畸胎瘤',
             '卵巢”不成熟性畸胎瘤', '卵巢畸胎瘤', '（卵巢）未成熟畸胎瘤', '卵巢囊性未成熟性畸胎瘤', '（卵巢）未成熟性畸胎瘤', '卵巢不成熟型畸胎瘤',
             '卵巢非成熟畸胎瘤', '睾丸不成熟畸胎瘤', '睾丸畸胎瘤', '卵巢不成熟畸胎瘤', '卵巢不成熟性畸胎瘤', '卵巢未成熟型畸胎瘤',
             '（左侧卵巢）未成熟性畸胎瘤', '（右侧卵巢）未成熟性畸胎瘤', '卵巢恶性畸胎瘤', '左侧睾丸未成熟畸胎瘤', '右侧睾丸未成熟畸胎瘤',
             '睾丸未成熟畸胎瘤', '卵巢非成熟性畸胎瘤', '左侧卵巢非成熟性畸胎瘤', '右侧卵巢非成熟性畸胎瘤', '睾丸不成熟性畸胎瘤',
             '卵巢恶性肿瘤：不成熟畸胎瘤', '（左侧睾丸）未成熟畸胎瘤', '（左卵巢）未成熟畸胎瘤',
             '（右睾丸） 结合临床、形态及免疫组化结果，符合未成熟性畸胎瘤', '（右侧睾丸）未成熟畸胎瘤',
             '睾丸囊实性未成熟型畸胎瘤', '睾丸囊实性不成熟型畸胎瘤', '（右卵巢）囊实性不成熟型畸胎瘤',
             '（左卵巢）囊实性未成熟型畸胎瘤', '（右卵巢）囊实性未成熟型畸胎瘤', '卵巢恶性肿瘤（未成熟性畸胎瘤）',
             '卵巢恶性肿瘤：未成熟畸胎瘤', '（右侧卵巢包块冰对及冰剩标本）畸胎瘤', '卵巢恶性肿瘤（未成熟性畸胎瘤', '卵巢为未成熟性畸胎瘤',
             '卵巢巨大畸胎瘤', '（左卵巢肿物）未成熟型畸胎瘤', '（右卵巢肿物）未成熟型畸胎瘤', '睾丸肿物畸胎瘤', '（左侧卵巢）畸胎瘤',
             '右侧卵巢）畸胎瘤'],
    'Ⅹ.c3': ['性腺胚胎性癌', '右侧卵巢胚胎性癌', '卵巢胚胎性癌', '睾丸胚胎性癌'],
    'Ⅹ.c4': ['性腺卵黄囊瘤', '卵巢卵黄囊瘤', '睾丸卵黄囊瘤', '睾丸内胚窦瘤', '卵巢恶性肿瘤 内胚窦瘤',
             '(右侧)睾丸肿瘤(卵黄囊瘤术后)', '卵巢内胚窦瘤', '（右侧睾丸）卵黄囊瘤',
             '卵巢內胚窦瘤', '（左睾丸）卵黄囊瘤', '（右睾丸）卵黄囊瘤', '（睾丸）卵黄囊瘤', '右侧睾丸卵黄瘤', '睾丸卵黄瘤',
             '(左侧)睾丸肿瘤(卵黄囊瘤)', '睾丸肿瘤(卵黄囊瘤)', '睾丸肿瘤(右侧,卵黄囊瘤',
             '右侧卵巢恶性卵黄囊瘤', '左侧卵巢恶性卵黄囊瘤', '卵巢恶性卵黄囊瘤', '卵巢恶性肿瘤（卵黄囊瘤', '内胚窦瘤(骶前骶尾',
             '睾丸肿瘤(卵黄囊肿瘤', '睾丸肿瘤(右侧，卵黄囊瘤', '睾丸恶性肿瘤(卵黄囊瘤', '卵巢恶性肿瘤(卵黄囊瘤', '睾丸肿瘤(卵黄囊瘤',
             '卵巢肿瘤(卵黄囊瘤', '睾丸恶性肿瘤（卵黄囊瘤', '睾丸肿瘤：卵黄囊瘤', '（左侧睾丸）内胚窦瘤', '（右侧睾丸）内胚窦瘤',
             '左卵巢黄囊瘤', '右卵巢黄囊瘤', '睾丸內胚窦瘤', '隐睾内胚窦瘤', '卵巢输卵管卵黄囊瘤', '卵巢恶性肿瘤 卵黄囊瘤',
             '卵巢）卵黄囊瘤', '卵巢卵黄瘤', '卵巢内胚胎窦瘤', '（左侧睾丸）卵黄囊瘤', '睾内胚窦瘤'],
    'Ⅹ.c5': ['性腺绒毛膜癌', '左侧卵巢、输卵管绒毛膜癌', '右侧卵巢绒癌', '卵巢绒毛膜癌', '左侧卵巢绒毛膜癌', '卵巢绒癌', '卵巢恶性绒毛膜癌'],
    'Ⅹ.c6': ['恶性性腺混合性肿瘤', '卵巢混合性生殖细胞瘤', '睾丸混合型生殖细胞肿瘤', '卵巢混合性生殖细胞肿瘤', '卵巢恶性混合性生殖细胞瘤',
             '卵巢恶性肿瘤：混合性生殖细胞瘤', '卵巢恶性混合性增殖细胞肿瘤', '右侧卵巢恶性混合性生殖细胞肿瘤', '卵巢恶性混合性生殖细胞肿瘤',
             '卵巢混合型生殖细胞肿瘤', '卵巢恶性混合生殖细胞肿瘤', '左卵巢恶性混合型畸胎瘤', '右卵巢恶性混合型畸胎瘤',
             '卵巢恶性混合型畸胎瘤', '（右侧睾丸）恶性混合生殖细胞肿瘤', '（左侧睾丸）恶性混合生殖细胞肿瘤', '左睾丸混合性生殖细胞肿瘤',
             '睾丸混合性生殖细胞肿瘤', '左睾丸恶性混合性生殖细胞肿瘤', '睾丸恶性混合性生殖细胞肿瘤',
             '睾丸恶性肿瘤术后化疗后 pT1N2M0 IIB期,混合性生殖细胞瘤', '卵巢恶性混合瘤(卵黄囊瘤及未成熟性畸胎瘤',
             '双侧卵巢恶性混合瘤(卵黄囊瘤及未成熟性畸胎瘤', '卵巢恶性混合瘤', '卵巢混合型恶性肿瘤', '卵巢恶性肿瘤：混合型生殖细胞瘤',
             '卵巢肿瘤：混合性生殖细胞瘤', '卵巢恶性混合性生殖瘤', '卵巢恶性混合型生殖细胞瘤', '睾丸混合性生殖细胞瘤',
             '卵巢混合性生殖细胞恶性肿瘤', '卵巢混合生殖细胞肿瘤', '睾丸）混合性生殖细胞肿瘤', '卵巢恶性混合型生殖细胞肿瘤',
             '卵巢内恶性混合型生殖细胞瘤', '睾丸恶性混合型生殖细胞肿瘤', '卵巢混合型恶性生殖细胞肿瘤',
             '卵巢恶性混合性生殖细胞性肿瘤', '卵巢混合性恶性生殖细胞肿瘤', '卵巢恶性肿瘤混合型生殖细胞肿瘤'],
    'Ⅹ.c7': ['恶性性腺母细胞瘤', '性腺母细胞瘤'],
    'Ⅹ.d': ['性腺癌', '卵巢高分化粘液腺癌', '右侧卵巢粘液性癌', '卵巢高分化粘液性乳头状腺癌', '卵巢粘液性囊腺癌', '卵巢交界性粘液性囊腺瘤',
            '卵巢交界性囊腺瘤', '卵巢粘液性囊腺瘤', '卵巢黏液性囊腺瘤', '卵巢高分化黏液腺癌', '卵巢粘液腺癌', '卵巢黏液性上皮内癌',
            '卵巢中高分化粘液腺癌', '卵巢交界性浆液性囊腺瘤', '卵巢交界性浆液性肿瘤', '卵巢颗粒细胞瘤', '左侧卵巢幼年性颗粒细胞瘤',
            '右侧卵巢幼年型粒层细胞瘤', '右侧卵巢幼年性颗粒细胞瘤', '卵巢幼年型颗粒细胞瘤', '卵巢囊性幼年粒层细胞瘤',
            '卵巢幼年性颗粒细胞瘤', '双卵巢交界性浆液性囊腺瘤', '双侧卵巢交界性浆液性囊腺瘤', '卵巢高分化黏液性癌', '卵巢粘液癌',
            '卵巢粘液性癌', '卵巢幼年型粒层细胞瘤', '卵巢黏液性癌', '卵巢黏液腺癌', '卵巢幼年性粒层细胞瘤', '幼年型颗粒细胞瘤', '左侧卵巢浆粘液性癌'],
    'Ⅹ.e': ['其他和未特指的恶性性腺肿瘤', '精索恶性间质细胞肿瘤', '左卵巢睾丸母细胞瘤', '卵巢高级别浆液性癌', '精索恶性间质细胞瘤',
            '卵巢睾丸母细胞瘤', '卵巢性索间质细胞瘤', '卵巢性索间质肿瘤', '卵巢性索-间质细胞肿瘤', '卵巢性索间质瘤', '卵巢支持细胞-间质细胞瘤', '左卵巢低分化支持间质细胞瘤'],
    'Ⅺ.a': ['肾上腺皮质癌', '肾上腺皮质腺癌', '肾上腺皮质恶性肿瘤', '恶性肾上腺皮质肿瘤'],
    'Ⅺ.b': ['甲状腺癌', '甲状腺乳头状癌', '甲状腺髓样癌', '甲状腺滤泡癌', '甲状腺高分化肿瘤', '甲状腺恶性肿瘤', '甲癌',
            '双叶甲状腺滤泡状癌', '甲状腺滤泡性肿瘤', '甲状腺滤泡状癌', '甲状腺右叶腺', '甲状腺左侧叶癌', '甲状腺右侧叶癌',
            '甲状腺乳头状瘤', '甲状腺乳头状肿瘤', '甲状腺峡部乳头状癌', '甲状腺滤泡性癌', '甲状腺微小浸润性滤泡状癌', '甲状腺乳突状癌',
            '甲状腺腺瘤', '甲状腺及峡部乳头状癌', '甲状腺左叶乳头状癌', '甲状腺右叶乳头状癌', '甲状腺弥漫性乳头状癌', '甲状腺左侧叶乳头状癌',
            '甲状腺右侧叶乳头状癌', '甲状腺家乳头状癌', '甲状腺滤泡性乳头状癌', '甲状腺多发乳头状癌'],
    'Ⅺ.c': ['鼻咽癌', '鼻咽恶性肿瘤', '鼻咽非角化性癌', '鼻咽未分化型非角化性癌', '鼻咽部恶性肿瘤', '鼻咽鳞状细胞癌', '鼻咽非角化型未分化癌',
            '鼻咽非角化性鳞状细胞癌', '（鼻咽部）低分化癌', '鼻咽非角化型鳞癌', '鼻咽全腔未分化型非角化癌', '鼻咽非角化型癌',
            '鼻咽非角化型未分化性癌', '鼻咽部未分化型非角化癌', '鼻咽部非角化型鳞状细胞癌'],
    'Ⅺ.d': ['恶性黑色素瘤', '黑色素细胞瘤'],
    'Ⅺ.e': ['皮肤癌', '皮脂腺癌', '臀部皮肤混合瘤', '头皮鳞状细胞癌', '头皮鳞癌'],
    'Ⅺ.f1': ['唾液腺癌', '双侧颌下腺腺泡细胞癌', '左腮腺癌', '左侧腮腺恶性肿瘤', '右腮腺淋巴上皮癌', '腺腺泡细胞癌', '腮腺恶性肿瘤',
             '腮腺癌', '左颌下腺癌', '右颌下腺癌', '颌下腺癌', '腮腺上皮-肌上皮癌',  '泪腺腺样囊性癌',
             '左颌下腺黏液表皮样癌', '右颌下腺黏液表皮样癌', '颌下腺黏液表皮样癌', '腮腺淋巴上皮瘤样癌', '颌下腺混合瘤',
             '腮腺高分化表皮样癌', '眼眶泪腺腺样囊腺癌', '腮腺黏液表皮样癌'],
    'Ⅺ.f2': ['结肠癌和直肠癌', '结肠癌', '直肠癌', '降结肠中-低分化腺癌', '降结肠腺癌', '结肠粘液腺癌', '结肠腺癌', '直肠粘液腺癌',
             '横结肠腺癌', '右半结肠印戒细胞癌', '结肠印戒细胞癌', '直肠腺癌', '降结肠中低分化腺癌', '结肠恶性肿瘤', '回盲腺癌',
             '回盲部恶性肿瘤', '回盲部腺癌', '结肠脾曲黏液腺癌', '结肠黏液腺癌', '横结肠印戒细胞癌', '升结肠银戒细胞癌',
             '升结肠印戒细胞癌', '肠印戒细胞癌', '升结肠高中分化腺癌', '结肠低分化腺癌', '肠低分化腺癌', '横结肠中-低分化腺癌', '升结肠肿瘤'],
    'Ⅺ.f3': ['阑尾癌', '阑尾神经内分泌瘤', '（阑尾）神经内分泌肿瘤'],
    'Ⅺ.f4': ['肺癌', '气管肺粘液表皮样癌', '肺黏液表皮样癌', '主支气管粘液表皮癌', '支气管黏液表皮样癌', '左肺下叶黏液表皮样癌',
             '右肺下叶黏液表皮样癌', '肺下叶黏液表皮样癌', '左肺叶支气管黏液表皮样癌', '右肺叶支气管黏液表皮样癌', '肺叶支气管黏液表皮样癌',
             '左上肺结节早癌', '右上肺结节早癌', '肺结节早癌', '肺中线癌', '肺腺癌', '支气管粘液表皮样癌', '主气管粘液表皮样癌'],
    'Ⅺ.f5': ['胸腺癌', '胸腺淋巴上皮瘤样癌', '胸腺瘤'],
    'Ⅺ.f6': ['乳腺癌', '左乳癌', '右乳癌', '乳癌', '左乳腺癌', '右乳腺癌', '左侧乳腺癌', '右侧乳腺癌', '（左侧）乳腺癌',
             '（右侧）乳腺癌', '左乳房恶性叶状肿瘤', '右乳房恶性叶状肿瘤', '乳房恶性叶状肿瘤'],
    'Ⅺ.f7': ['宫颈癌', '宫颈透明细胞癌'],
    'Ⅺ.f8': ['膀胱癌'],
    'Ⅺ.f9': ['眼癌', '眼眶腺样囊性癌'],
    'Ⅺ.f10': ['其他特指部位的癌症', '胰腺实性-假乳头状瘤', '右侧颌面部腺样囊性癌',
              '鼻腔腺样囊性癌', '胰腺神经内分泌肿瘤', '右侧喉乳头状瘤', '喉乳头状瘤', '鼻腔鼻窦癌', '颌下腺腺样囊性癌', '颌面部腺样囊性癌',
              '贲门鳞状细胞癌', '气道粘液表皮样癌'],
    'Ⅺ.f11': ['未特指部位的癌症', '面部鳞状细胞恶性肿瘤', '颈部黏液表皮样癌', '汗腺瘤', '促结缔组织增生性小圆细胞瘤'],
    'Ⅻ.a1': ['恶性胃肠道间质性瘤'],
    'Ⅻ.a2': ['胰母细胞瘤', '胰母'],
    'Ⅻ.a3': ['肺母细胞瘤和胸膜肺母细胞瘤', '肺母细胞瘤', '胸膜肺母细胞瘤', '肺母'],
    'Ⅻ.a4': ['其他复杂混合性的和间质性的肿瘤', '子宫腺肉瘤', '卵巢环状小管性索肿瘤', '卵巢混合性性索-间质肿瘤',
             '卵巢低分化支持-间质细胞肿瘤', '低级别子宫内膜间质肉瘤', '卵巢Sertoli-Leydig细胞瘤'],
    'Ⅻ.a5': ['间皮瘤', '恶性间皮瘤', '卵巢低分化支持-间皮细胞肿瘤'],
    'Ⅻ.a6': ['其他特指的恶性肿瘤'],
    'Ⅻ.b': ['其他未特指的恶性肿瘤', 'BCOR重组性肉瘤', '胰腺肿瘤']
}

# 标准分期字典
STANDARD_KEYWORD_MAP = {
    'O期': {'0期', 'O期'},
    'Ⅰ期': {'1期', 'I期', 'Ⅰ期', '一期', '分期I', '分期Ⅰ', '分期 I', '分期 Ⅰ', '分期为I', '分期为Ⅰ', 'PRETEXT I',
            'PRETEXT Ⅰ', 'PRETEXTI', 'PRETEXTⅠ', 'PRETEXT-I', 'PRETEXT-Ⅰ', 'PRETEXT/POST-TEXT I', 'PRETEXT/POST-TEXT Ⅰ',
            'I 期', 'Ⅰ 期', '分期I期', '分期Ⅰ期', '分期 I期', '分期 Ⅰ期', '分期为I期', '分期为Ⅰ期', 'Ｉ期', 'ＩＣ期', 'Ι期', 'COG I期'
            'COG Evans分期I期', 'COGI期', 'GOC I期', 'COG Evans分期Ⅰ期', 'PRETEXT分期I期'},
    'Ⅱ期': {'2期', 'II期', 'Ⅱ期', '二期', 'IⅠ期', 'ⅠI期', '分期II', '分期Ⅱ', '分期 II', '分期 Ⅱ', '分期为II', '分期为Ⅱ',
            'PRETEXT II', 'PRETEXT Ⅱ', 'PRETEXTII', 'PRETEXTⅡ', 'PRETEXT-II', 'PRETEXT-Ⅱ', 'PRETEXT/POST-TEXT II',
            'PRETEXT/POST-TEXT Ⅱ', 'II 期', 'Ⅱ 期', '分期II期', '分期Ⅱ期', '分期 II期', '分期 Ⅱ期', '分期为II期', '分期为Ⅱ期','ⅡS期', 'Ⅱ）期', 'IIA分期',
            'INSS Ii期', 'pretext II期', 'PRETEXT Ⅱ期', 'PRETEXT分期 II期', 'TNM分期II期', 'PRETEXT II期', 'PRETEXT II 期', 'PRETEXTII期', 'COG Evans分期Ⅱ期'
             'Ii期', 'PRETEXT 2期', 'COG II期', 'POST-TEXT Ⅱ期', 'pretext分期为II期', 'COG分期：Ⅱ期', 'stage II期', 'PRETXT分期Ⅱ期', 'PRETEXT分期II期'},
    'Ⅲ期': {'3期', 'III期', 'Ⅲ期', '三期', 'ⅠII期', 'IⅠI期', 'IIⅠ期', 'IⅠⅠ期', 'ⅠIⅠ期', 'ⅠⅠI期', '分期III', '分期Ⅲ',
            '分期 III', '分期 Ⅲ', '分期为III', '分期为Ⅲ', 'PRETEXT III', 'PRETEXT Ⅲ', 'PRETEXTIII', 'PRETEXTⅢ',
            'PRETEXT-III', 'PRETEXT-Ⅲ', 'PRETEXT/POST-TEXT III', 'PRETEXT/POST-TEXT Ⅲ', 'III 期', 'Ⅲ 期', '分期III期',
            '分期Ⅲ期', '分期 III期', '分期 Ⅲ期', '分期为III期', '分期为Ⅲ期', 'IIIS期', 'ⅢS期', 'IIIBS期', 'IIIAS期', 'III）期', '分期改为IIIS期', 'Ⅲ)期', 'PRETEXT III期',
            'Pretext III期', 'CCG III期', 'pretext III期', 'PRETEXT Ⅲ期', 'PRETEX分期III期', 'PRETEXTⅢ期', 'IRSS III期', 'TNM分期：3期', 'POSTTEXTIII期', 'IRS分期：III期'
            'PRETXT分期Ⅲ期', 'III 1期', 'IRS分期Ⅲ期', 'PRETXT分期III期', 'stageIII', 'COGⅢ期', 'INSS III期', 'PRETEXTIII期', 'COG Evans分期Ⅲ期', 'PRETESTIII期',
            'IRS分期 Ⅲ期', 'pretext Ⅲ期', 'COGIII期', 'pretextIII期'},
    'Ⅳ期': {'4期', 'IV期', 'Ⅳ期', '四期', 'IⅤ期', 'ⅠV期', '', '分期IV', '分期Ⅳ', '分期 IV', '分期 Ⅳ', '分期为IV',
            '分期为Ⅳ', 'PRETEXT IV', 'PRETEXT Ⅳ', 'PRETEXTIV', 'PRETEXTⅣ', 'PRETEXT-IV', 'PRETEXT-Ⅳ',
            'PRETEXT/POST-TEXT IV','PRETEXT/POST-TEXT Ⅳ', 'IV 期', 'Ⅳ 期', '分期IV期', '分期Ⅳ期', '分期 IV期', '分期 Ⅳ期',
            '分期为IV期', '分期为Ⅳ期', 'ⅣEX期', 'IVS&期', 'IVAX期', 'ⅣBS期', 'IVBS期', 'IV）期', 'IV高期', 'ＩＶ期', 'Iv期', 'INSS IV期', 'POSTEXT IV期',
            'PRETEXT IV期', 'stage IV期', 'INSS Iv期', 'Evans IV期', 'INSSIV期', 'COG IV期', 'Pretext IV期', 'COG Evans分IV期', 'COG Evans分期IV期', 'IV1期'
            'IRS IV期', 'PRETEXTⅣ期', 'INSS IV 期', 'PRETEXTIV期', 'PRE-TEXT IV期', 'PRETEXT Iv期'},
    'Ⅴ期': {'5期', 'V期', 'Ⅴ期', '五期', '分期V', '分期Ⅴ', '分期 V', '分期 Ⅴ', '分期为V', '分期为Ⅴ', 'PRETEXT V', 'PRETEXT Ⅴ', 'PRETEXTV',
            'PRETEXTⅤ', 'PRETEXT-V', 'PRETEXT-Ⅴ', 'PRETEXT/POST-TEXT V', 'PRETEXT/POST-TEXT Ⅴ',
            'V 期','Ⅴ 期', '分期V期', '分期Ⅴ期', '分期 V期', '分期 Ⅴ期', '分期为V期', '分期为Ⅴ期'},
    'Ⅰ-Ⅱ期': {},
    'Ⅱ-Ⅲ期': {},
    'Ⅲ-Ⅳ期': {},
    'Ⅰ-Ⅲ期': {},
    'A期': {'A期', 'GROUP A', 'GROUPA', 'A 期', 'IIRCA', 'IIRC A期'},
    'B期': {'B期', 'GROUP B', 'GROUPB', 'B 期', 'IIRCB'},
    'C期': {'C期', 'GROUP C', 'GROUPC', 'C 期', 'IIRCC'},
    'D期': {'D期', 'GROUP D', 'GROUPD', 'D 期', 'IIRCD'},
    'E期': {'E期', 'GROUP E', 'GROUPE', 'E 期', 'IIRCE', 'IIRC-E期', 'II-RC-E期', 'II RC-E期', 'IIRC E期', 'ⅡRC-E'},
    'A-B期': {'A/B期', 'A//B期'},
    'B-C期': {},
    'D-E期': {'D→E期'},
   'Ⅰ级': {'I级', 'WHO 1级', 'WHO1级', 'WHO  1级', 'Ⅰ级', 'WHO Ⅰ级', 'WHO I级', 'WHOⅠ级', 'WHOI级', 'WHO分型：Ⅰ级',
            'WHO分型：I级', 'WHO分级：Ⅰ级', 'WHO分级：I级', 'WHO分级：1级', 'WHO分级：1 级', 'WHO分型Ⅰ级', 'WHO分型I级',
            'WHO分级Ⅰ级', 'WHO分级I级', 'WHO分型 Ⅰ级', 'WHO分型 I级', 'WHO分级 Ⅰ级', 'WHO分级 I级', 'WHO分级 1级',
            'WHO分级  1级', 'WHO 1 级', 'WHO-1级', 'WHO分型：1级', 'WHO分型1级', 'WHO组织学分级：1级', 'WHO级别：1级',
            'WHO分级1级', 'WHO 分级1级', 'WHO，1级', 'WHO：1级', 'WHOI', 'WHOⅠ', 'WHO I', 'WHO Ⅰ', 'WHO  I', 'WHO  Ⅰ',
            'WHO分型：Ⅰ 级', 'WHO分型：I 级', 'WHO分级：Ⅰ 级', 'WHO分级：I 级', 'Ⅰ 级', 'I 级', 'WHO分型 1级', 'Ⅰ）级', 'WHO一级', 'WHO I 级'
            'WHO-I级', 'WHO-Ⅰ级'},
    'Ⅱ级': {'II级', 'WHO 2级', 'WHO2级', 'WHO  2级', 'Ⅱ级', 'WHO Ⅱ级', 'WHO II级', 'WHOⅡ级', 'WHOII级', 'WHO分型：Ⅱ级',
            'WHO分型：II级', 'WHO分级：Ⅱ级', 'WHO分级：II级', 'WHO分级：2级', 'WHO分级：2 级', 'WHO分型Ⅱ级', 'WHO分型II级',
            'WHO分级Ⅱ级', 'WHO分级II级', 'WHO分型 Ⅱ级', 'WHO分型 II级', 'WHO分级 Ⅱ级', 'WHO分级 II级', 'WHO分级 2级',
            'WHO分级  2级', 'WHO 2 级', 'WHO-2级', 'WHO分型：2级', 'WHO分型2级', 'WHO组织学分级：2级', 'WHO级别：2级',
            'WHO分级2级', 'WHO 分级2级', 'WHO，2级', 'WHO：2级', 'WHOII', 'WHOⅡ', 'WHO II', 'WHO Ⅱ', 'WHO  II', 'WHO  Ⅱ',
            'WHO分型：Ⅱ 级', 'WHO分型：II 级', 'WHO分级：Ⅱ 级', 'WHO分级：II 级', 'Ⅱ 级', 'II 级', 'WHO分型 2级', 'WHO,2级', 'WHO II 级',
            'WHO Ii级', 'WHO-Ⅱ级', 'Fuhurman分级II级', 'WHOIi级'},
    'Ⅲ级': {'III级', 'WHO 3级', 'WHO3级', 'WHO  3级', 'Ⅲ级', 'WHO Ⅲ级', 'WHO III级', 'WHOⅢ级', 'WHOIII级',
            'WHO分型：Ⅲ级', 'WHO分型：III级', 'WHO分级：Ⅲ级', 'WHO分级：III级', 'WHO分级：3级', 'WHO分级：3 级', 'WHO分型Ⅲ级',
            'WHO分型III级', 'WHO分级Ⅲ级', 'WHO分级III级', 'WHO分型 Ⅲ级', 'WHO分型 III级', 'WHO分级 Ⅲ级', 'WHO分级 III级', 'WHO分级 3级',
            'WHO分级  3级', 'WHO 3 级', 'WHO-3级', 'WHO分型：3级', 'WHO分型3级', 'WHO组织学分级：3级', 'WHO级别：3级',
            'WHO分级3级', 'WHO 分级3级', 'WHO，3级', 'WHO：3级', 'WHOIII', 'WHOⅢ', 'WHO III', 'WHO Ⅲ', 'WHO  III',
            'WHO  Ⅲ', 'WHO分型：Ⅲ 级', 'WHO分型：III 级', 'WHO分级：Ⅲ 级', 'WHO分级：III 级', 'Ⅲ 级', 'III 级',
            'WHO分型 3级', 'WHO 3级', 'WHO,3级', 'WHO三级', 'Edmondson-Steiner分级III级', 'WHO III期', 'WTO III级', 'WHO-III级'},
    'Ⅳ级': {'IV级', 'WHO 4级', 'WHO4级', 'WHO  4级', 'Ⅳ级', 'WHO Ⅳ级', 'WHO IV级', 'WHO IV级', 'WHOⅣ级', 'WHOIV级',
            'WHO分型：Ⅳ级', 'WHO分型：IV级', 'WHO分级：Ⅳ级', 'WHO分级：IV级', 'WHO分级：4级', 'WHO分级：4 级', 'WHO分型Ⅳ级',
            'WHO分型IV级', 'WHO分级Ⅳ级', 'WHO分级IV级', 'WHO分型 Ⅳ级', 'WHO分型 IV级', 'WHO分级 Ⅳ级', 'WHO分级 IV级',
            'WHO分级 4级', 'WHO分级  4级', 'WHO 4 级', 'WHO-4级', 'WHO分型：4级', 'WHO分型4级', 'WHO组织学分级：4级',
            'WHO级别：4级', 'WHO分级4级', 'WHO 分级4级', 'WHO，4级', 'WHO：4级', 'WHOIV', 'WHOⅣ', 'WHO IV', 'WHO Ⅳ',
            'WHO  IV', 'WHO  Ⅳ', 'WHO分型：Ⅳ 级', 'WHO分型：IV 级', 'WHO分级：Ⅳ 级', 'WHO分级：IV 级', 'Ⅳ 级', 'IV 级',
            'WHO分型 4级', '四级', 'WHO,4级', 'WHO分型Ⅳ型', 'WHO分型，IV型', 'IVJ级', 'I-V-级', 'WHO4型', 'WHO Iv级', 'WHO IV期', 'WHOIV 级',
            'WH0IV级', 'who IV级', 'WHO-Ⅳ级', 'WHO型：Ⅳ级', 'WHO：IV级', 'WHO+Ⅳ级'},
    'Ⅴ级': {'V级', 'Ⅴ级', 'WHO Ⅴ级', 'WHO V级', 'WHOⅤ级', 'WHOV级', 'WHO分型：Ⅴ级', 'WHO分型：V级', 'WHO分级：Ⅴ级',
            'WHO分级：V级', 'WHO分级：5级', 'WHO分级：5 级', 'WHO分型Ⅴ级', 'WHO分型V级', 'WHO分级Ⅴ级', 'WHO分级V级',
            'WHO分型 Ⅴ级', 'WHO分型 V级', 'WHO分级 Ⅴ级', 'WHO分级 V级', 'WHO分级 5级', 'WHO分级  5级', 'WHOV', 'WHOⅤ',
            'WHO V', 'WHO Ⅴ', 'WHO  V', 'WHO  Ⅴ', 'WHO分型：Ⅴ 级,', 'WHO分型：V 级', 'WHO分级：Ⅴ 级', 'WHO分级：V 级',
            'Ⅴ 级', 'V 级', 'WHO分型 5级'},
    'Ⅰ-Ⅱ级': {'WHO1-II级'},
    'ⅠA1期': {'IA1期', 'ⅠA1期', 'Ia1期'},
    'ⅠA2期': {'IA2期', 'ⅠA2期'},
    'ⅠA期': {'1A期', 'I A期', 'IA期', 'ⅠA期', '一A期', '分期IA', '分期IA期', 'Ia期', 'Ⅰa期'},
    'ⅠB1期': {'IB1期', 'ⅠB1期', '1B期'},
    'ⅠB2期': {'IB2期', 'ⅠB2期'},
    'ⅠB3期': {'IB3期', 'ⅠB3期'},
    'ⅠB期': {'1B期', 'I B期', 'IB期', 'ⅠB期', '一B期', '分期IB', 'ⅠB 期', '分期IB期', 'Ib期', 'Evans Ib期', 'stage Ib', 'COG Evans Ib期', 'Ⅰb期', 'COGEvans分期Ib期'},
    'ⅠC期': {'Ic期'},
    'ⅠE期': {'1E期', 'IE期', 'ⅠE期', '一E期'},
    'ⅡA1期': {'IIA1期', 'ⅡA1期'},
    'ⅡA2期': {'IIA2期', 'ⅡA2期'},
    'ⅡA期': {'2A期', 'IIA期', 'ⅡA期', '二A期', '分期ⅡA', 'II A 期', '分期为IIA', '分期为ⅡA', 'II A期', '分期ⅡA期', '分期为IIA期',
             '分期为ⅡA期', 'Ⅱ A期', 'IIa期', 'PRETEXT Ⅱa期'},
    'ⅡB期': {'2B期', 'IIB期', 'ⅡB期', '二B期', '分期IIB', 'II B 期', '分期为ⅡB', '分期为IIB', 'II B期', '分期IIB期', '分期为IIB期',
             '分期为ⅡB期', 'Ⅱ B期', 'ⅡB期', 'IIB 期', '2b期', 'Ⅱb期', 'IIb期', 'pretext分期 IIb'},
    'ⅡC期': {'2C期', 'IIC期', 'ⅡC期', '二C期', 'Ⅱc期'},
    'ⅡE期': {'2E期', 'IIE期', 'ⅡE期', '二E期'},
    'ⅢA期': {'3A期', 'IIIA期', 'ⅢA期', '三A期', 'IIIa期', 'III-a期'},
    'ⅢB期': {'3B期', 'IIIB期', 'ⅢB期', '三B期', '分期IIIB', '分期ⅢB', '分期 IIIB', '分期 ⅢB', '分期IIIB期', '分期ⅢB期',
             '分期 IIIB期', '分期 ⅢB期', 'III B期', 'Ⅲb期', 'Ⅲ B期', 'IIIb期'},
    'ⅢC1期': {'IIIC1期', 'ⅢC1期', 'IIIC1P期'},
    'ⅢC2期': {'IIIC2期', 'ⅢC2期'},
    'ⅢC期': {'3C期', 'IIIC期', 'ⅢC期', '三C期', 'Ⅲc期', 'IIIc期', 'III c期'},
    'ⅣA期': {'4A期', 'IVA期', 'ⅣA期', '四A期''IV A期', 'IV A 期', '分期IVA期', '分期为IVA期', 'Ⅳa期', 'Iva期', 'IVa 期'},
    'ⅣB期': {'4B期', 'IVB期', 'ⅣB期', '四B期', 'IV B期', 'IV B 期', '分期IVB期', '分期为IVB期', 'IVb期', 'pretex分期为ⅣB期', 'Ⅳb期'},
    'ⅣC期': {'4C期', 'IVC期', 'ⅣC期', '四C期', 'IV C期', 'IV C 期', '分期IVC期', '分期为IVC期', 'IVc期'},
    'ⅣS期': {'4S期', 'IVS期', 'ⅣS期', '四S期', 'IV S期', 'IV S 期', '分期IVS期', '分期为IVS期', 'IV-S期', 'Ⅳ-S期', 'IVs期', '4s期'},
    '加速期': {'加速期'},
    '急变期': {'急变期'},
    '急性期': {'急性期'},
    '慢性期': {'慢性期'},
    'M4期': {},
    'L1型': {'L-1型', 'L1(PRE-B)型', 'L1）型'},
    'L2型': {'L2COMMON-B型', 'L2)型', 'L2COMMONB型', 'L2）型'},
    'L3型': {'L3COMMON-B型', 'L3）型'},
    'M0型': {},
    'M1型': {'MI型'},
    'M2型': {'M2A型', 'M2）型', 'MA2型', 'M2A1型', 'M2B型', 'M2A）型'},
    'M3型': {'M3B型', 'M3A型', 'M3）型'},
    'M4型': {'M4B型', 'M4E0型', 'M4EO型', 'M4C型', 'M4A型', 'M4）型'},
    'M5型': {'M5A型', 'M5B型', 'M5）型'},
    'M7型': {}
}
