# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class QualityAudit(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        QualityAudit - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'user': 'User',
            'job_id': 'str',
            'action': 'str',
            'level': 'str',
            'entity': 'AuditEntity',
            'changes': 'list[Change]',
            'timestamp': 'str',
            'status': 'str',
            'entity_type': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'user': 'user',
            'job_id': 'jobId',
            'action': 'action',
            'level': 'level',
            'entity': 'entity',
            'changes': 'changes',
            'timestamp': 'timestamp',
            'status': 'status',
            'entity_type': 'entityType',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._user = None
        self._job_id = None
        self._action = None
        self._level = None
        self._entity = None
        self._changes = None
        self._timestamp = None
        self._status = None
        self._entity_type = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this QualityAudit.
        The globally unique identifier for the object.

        :return: The id of this QualityAudit.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this QualityAudit.
        The globally unique identifier for the object.

        :param id: The id of this QualityAudit.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this QualityAudit.


        :return: The name of this QualityAudit.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this QualityAudit.


        :param name: The name of this QualityAudit.
        :type: str
        """
        
        self._name = name

    @property
    def user(self):
        """
        Gets the user of this QualityAudit.


        :return: The user of this QualityAudit.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this QualityAudit.


        :param user: The user of this QualityAudit.
        :type: User
        """
        
        self._user = user

    @property
    def job_id(self):
        """
        Gets the job_id of this QualityAudit.


        :return: The job_id of this QualityAudit.
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """
        Sets the job_id of this QualityAudit.


        :param job_id: The job_id of this QualityAudit.
        :type: str
        """
        
        self._job_id = job_id

    @property
    def action(self):
        """
        Gets the action of this QualityAudit.


        :return: The action of this QualityAudit.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this QualityAudit.


        :param action: The action of this QualityAudit.
        :type: str
        """
        
        self._action = action

    @property
    def level(self):
        """
        Gets the level of this QualityAudit.


        :return: The level of this QualityAudit.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this QualityAudit.


        :param level: The level of this QualityAudit.
        :type: str
        """
        
        self._level = level

    @property
    def entity(self):
        """
        Gets the entity of this QualityAudit.


        :return: The entity of this QualityAudit.
        :rtype: AuditEntity
        """
        return self._entity

    @entity.setter
    def entity(self, entity):
        """
        Sets the entity of this QualityAudit.


        :param entity: The entity of this QualityAudit.
        :type: AuditEntity
        """
        
        self._entity = entity

    @property
    def changes(self):
        """
        Gets the changes of this QualityAudit.


        :return: The changes of this QualityAudit.
        :rtype: list[Change]
        """
        return self._changes

    @changes.setter
    def changes(self, changes):
        """
        Sets the changes of this QualityAudit.


        :param changes: The changes of this QualityAudit.
        :type: list[Change]
        """
        
        self._changes = changes

    @property
    def timestamp(self):
        """
        Gets the timestamp of this QualityAudit.


        :return: The timestamp of this QualityAudit.
        :rtype: str
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this QualityAudit.


        :param timestamp: The timestamp of this QualityAudit.
        :type: str
        """
        
        self._timestamp = timestamp

    @property
    def status(self):
        """
        Gets the status of this QualityAudit.


        :return: The status of this QualityAudit.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this QualityAudit.


        :param status: The status of this QualityAudit.
        :type: str
        """
        
        self._status = status

    @property
    def entity_type(self):
        """
        Gets the entity_type of this QualityAudit.


        :return: The entity_type of this QualityAudit.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this QualityAudit.


        :param entity_type: The entity_type of this QualityAudit.
        :type: str
        """
        
        self._entity_type = entity_type

    @property
    def self_uri(self):
        """
        Gets the self_uri of this QualityAudit.
        The URI for this object

        :return: The self_uri of this QualityAudit.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this QualityAudit.
        The URI for this object

        :param self_uri: The self_uri of this QualityAudit.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

