"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketApi = exports.WebSocketApiKeySelectionExpression = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
const route_1 = require("./route");
/**
 * Represents the currently available API Key Selection Expressions
 */
class WebSocketApiKeySelectionExpression {
    /**
     * @param customApiKeySelector The expression used by API Gateway
     */
    constructor(customApiKeySelector) {
        this.customApiKeySelector = customApiKeySelector;
    }
}
exports.WebSocketApiKeySelectionExpression = WebSocketApiKeySelectionExpression;
_a = JSII_RTTI_SYMBOL_1;
WebSocketApiKeySelectionExpression[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketApiKeySelectionExpression", version: "2.13.0-alpha.0" };
/**
 * The API will extract the key value from the `x-api-key` header in the user request.
 */
WebSocketApiKeySelectionExpression.HEADER_X_API_KEY = new WebSocketApiKeySelectionExpression('$request.header.x-api-key');
/**
  * The API will extract the key value from the `usageIdentifierKey` attribute in the `context` map,
  * returned by the Lambda Authorizer.
  * See https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
  */
WebSocketApiKeySelectionExpression.AUTHORIZER_USAGE_IDENTIFIER_KEY = new WebSocketApiKeySelectionExpression('$context.authorizer.usageIdentifierKey');
/**
 * Create a new API Gateway WebSocket API endpoint.
 * @resource AWS::ApiGatewayV2::Api
 */
class WebSocketApi extends base_1.ApiBase {
    constructor(scope, id, props) {
        var _c, _d, _e;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketApiProps(props);
        this.webSocketApiName = (_c = props === null || props === void 0 ? void 0 : props.apiName) !== null && _c !== void 0 ? _c : id;
        const resource = new aws_apigatewayv2_1.CfnApi(this, 'Resource', {
            name: this.webSocketApiName,
            apiKeySelectionExpression: (_d = props === null || props === void 0 ? void 0 : props.apiKeySelectionExpression) === null || _d === void 0 ? void 0 : _d.customApiKeySelector,
            protocolType: 'WEBSOCKET',
            description: props === null || props === void 0 ? void 0 : props.description,
            routeSelectionExpression: (_e = props === null || props === void 0 ? void 0 : props.routeSelectionExpression) !== null && _e !== void 0 ? _e : '$request.body.action',
        });
        this.apiId = resource.ref;
        this.apiEndpoint = resource.attrApiEndpoint;
        if (props === null || props === void 0 ? void 0 : props.connectRouteOptions) {
            this.addRoute('$connect', props.connectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.disconnectRouteOptions) {
            this.addRoute('$disconnect', props.disconnectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.defaultRouteOptions) {
            this.addRoute('$default', props.defaultRouteOptions);
        }
    }
    /**
     * Add a new route
     */
    addRoute(routeKey, options) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteOptions(options);
        return new route_1.WebSocketRoute(this, `${routeKey}-Route`, {
            webSocketApi: this,
            routeKey,
            ...options,
        });
    }
    /**
     * Grant access to the API Gateway management API for this WebSocket API to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     */
    grantManageConnections(identity) {
        const arn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'execute-api',
            resource: this.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/*/*/@connections/*`],
        });
    }
}
exports.WebSocketApi = WebSocketApi;
_b = JSII_RTTI_SYMBOL_1;
WebSocketApi[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketApi", version: "2.13.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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