"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcLink = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Define a new VPC Link
 * Specifies an API Gateway VPC link for a HTTP API to access resources in an Amazon Virtual Private Cloud (VPC).
 */
class VpcLink extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.subnets = new Array();
        this.securityGroups = new Array();
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_VpcLinkProps(props);
        this.vpc = props.vpc;
        const cfnResource = new aws_apigatewayv2_1.CfnVpcLink(this, 'Resource', {
            name: props.vpcLinkName || aws_cdk_lib_1.Lazy.string({ produce: () => aws_cdk_lib_1.Names.uniqueId(this) }),
            subnetIds: aws_cdk_lib_1.Lazy.list({ produce: () => this.renderSubnets() }),
            securityGroupIds: aws_cdk_lib_1.Lazy.list({ produce: () => this.renderSecurityGroups() }),
        });
        this.vpcLinkId = cfnResource.ref;
        const { subnets } = props.vpc.selectSubnets((_b = props.subnets) !== null && _b !== void 0 ? _b : { subnetType: ec2.SubnetType.PRIVATE });
        this.addSubnets(...subnets);
        if (props.securityGroups) {
            this.addSecurityGroups(...props.securityGroups);
        }
    }
    /**
     * Import a VPC Link by specifying its attributes.
     */
    static fromVpcLinkAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_VpcLinkAttributes(attrs);
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.vpcLinkId = attrs.vpcLinkId;
                this.vpc = attrs.vpc;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds the provided subnets to the vpc link
     *
     * @param subnets
     */
    addSubnets(...subnets) {
        this.subnets.push(...subnets);
    }
    /**
     * Adds the provided security groups to the vpc link
     *
     * @param groups
     */
    addSecurityGroups(...groups) {
        this.securityGroups.push(...groups);
    }
    renderSubnets() {
        return this.subnets.map(subnet => subnet.subnetId);
    }
    renderSecurityGroups() {
        return this.securityGroups.map(sg => sg.securityGroupId);
    }
}
exports.VpcLink = VpcLink;
_a = JSII_RTTI_SYMBOL_1;
VpcLink[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.VpcLink", version: "2.13.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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