"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApi = exports.CorsHttpMethod = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
const route_1 = require("./route");
const stage_1 = require("./stage");
const vpc_link_1 = require("./vpc-link");
/**
 * Supported CORS HTTP methods
 */
var CorsHttpMethod;
(function (CorsHttpMethod) {
    /** HTTP ANY */
    CorsHttpMethod["ANY"] = "*";
    /** HTTP DELETE */
    CorsHttpMethod["DELETE"] = "DELETE";
    /** HTTP GET */
    CorsHttpMethod["GET"] = "GET";
    /** HTTP HEAD */
    CorsHttpMethod["HEAD"] = "HEAD";
    /** HTTP OPTIONS */
    CorsHttpMethod["OPTIONS"] = "OPTIONS";
    /** HTTP PATCH */
    CorsHttpMethod["PATCH"] = "PATCH";
    /** HTTP POST */
    CorsHttpMethod["POST"] = "POST";
    /** HTTP PUT */
    CorsHttpMethod["PUT"] = "PUT";
})(CorsHttpMethod = exports.CorsHttpMethod || (exports.CorsHttpMethod = {}));
class HttpApiBase extends base_1.ApiBase {
    constructor() {
        super(...arguments);
        this.vpcLinks = {};
    }
    metricClientError(props) {
        return this.metric('4xx', { statistic: 'Sum', ...props });
    }
    metricServerError(props) {
        return this.metric('5xx', { statistic: 'Sum', ...props });
    }
    metricDataProcessed(props) {
        return this.metric('DataProcessed', { statistic: 'Sum', ...props });
    }
    metricCount(props) {
        return this.metric('Count', { statistic: 'SampleCount', ...props });
    }
    metricIntegrationLatency(props) {
        return this.metric('IntegrationLatency', props);
    }
    metricLatency(props) {
        return this.metric('Latency', props);
    }
    addVpcLink(options) {
        const { vpcId } = options.vpc;
        if (vpcId in this.vpcLinks) {
            return this.vpcLinks[vpcId];
        }
        const count = Object.keys(this.vpcLinks).length + 1;
        const vpcLink = new vpc_link_1.VpcLink(this, `VpcLink-${count}`, options);
        this.vpcLinks[vpcId] = vpcLink;
        return vpcLink;
    }
}
/**
 * Create a new API Gateway HTTP API endpoint.
 * @resource AWS::ApiGatewayV2::Api
 */
class HttpApi extends HttpApiBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpApiProps(props);
        this.httpApiName = (_b = props === null || props === void 0 ? void 0 : props.apiName) !== null && _b !== void 0 ? _b : id;
        this.disableExecuteApiEndpoint = props === null || props === void 0 ? void 0 : props.disableExecuteApiEndpoint;
        let corsConfiguration;
        if (props === null || props === void 0 ? void 0 : props.corsPreflight) {
            const cors = props.corsPreflight;
            if (cors.allowOrigins && cors.allowOrigins.includes('*') && cors.allowCredentials) {
                throw new Error("CORS preflight - allowCredentials is not supported when allowOrigin is '*'");
            }
            const { allowCredentials, allowHeaders, allowMethods, allowOrigins, exposeHeaders, maxAge, } = props.corsPreflight;
            corsConfiguration = {
                allowCredentials,
                allowHeaders,
                allowMethods,
                allowOrigins,
                exposeHeaders,
                maxAge: maxAge === null || maxAge === void 0 ? void 0 : maxAge.toSeconds(),
            };
        }
        const apiProps = {
            name: this.httpApiName,
            protocolType: 'HTTP',
            corsConfiguration,
            description: props === null || props === void 0 ? void 0 : props.description,
            disableExecuteApiEndpoint: this.disableExecuteApiEndpoint,
        };
        const resource = new aws_apigatewayv2_1.CfnApi(this, 'Resource', apiProps);
        this.apiId = resource.ref;
        this.httpApiId = resource.ref;
        this._apiEndpoint = resource.attrApiEndpoint;
        this.defaultAuthorizer = props === null || props === void 0 ? void 0 : props.defaultAuthorizer;
        this.defaultAuthorizationScopes = props === null || props === void 0 ? void 0 : props.defaultAuthorizationScopes;
        if (props === null || props === void 0 ? void 0 : props.defaultIntegration) {
            new route_1.HttpRoute(this, 'DefaultRoute', {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.DEFAULT,
                integration: props.defaultIntegration,
                authorizer: props.defaultAuthorizer,
                authorizationScopes: props.defaultAuthorizationScopes,
            });
        }
        if ((props === null || props === void 0 ? void 0 : props.createDefaultStage) === undefined || props.createDefaultStage === true) {
            this.defaultStage = new stage_1.HttpStage(this, 'DefaultStage', {
                httpApi: this,
                autoDeploy: true,
                domainMapping: props === null || props === void 0 ? void 0 : props.defaultDomainMapping,
            });
            // to ensure the domain is ready before creating the default stage
            if (props === null || props === void 0 ? void 0 : props.defaultDomainMapping) {
                this.defaultStage.node.addDependency(props.defaultDomainMapping.domainName);
            }
        }
        if ((props === null || props === void 0 ? void 0 : props.createDefaultStage) === false && props.defaultDomainMapping) {
            throw new Error('defaultDomainMapping not supported with createDefaultStage disabled');
        }
    }
    /**
     * Import an existing HTTP API into this CDK app.
     */
    static fromHttpApiAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpApiAttributes(attrs);
        class Import extends HttpApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.httpApiId;
                this.httpApiId = attrs.httpApiId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported HttpApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Get the default endpoint for this API.
     */
    get apiEndpoint() {
        if (this.disableExecuteApiEndpoint) {
            throw new Error('apiEndpoint is not accessible when disableExecuteApiEndpoint is set to true.');
        }
        return this._apiEndpoint;
    }
    /**
     * Get the URL to the default stage of this API.
     * Returns `undefined` if `createDefaultStage` is unset.
     */
    get url() {
        return this.defaultStage ? this.defaultStage.url : undefined;
    }
    /**
     * Add a new stage.
     */
    addStage(id, options) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpStageOptions(options);
        const stage = new stage_1.HttpStage(this, id, {
            httpApi: this,
            ...options,
        });
        return stage;
    }
    /**
     * Add multiple routes that uses the same configuration. The routes all go to the same path, but for different
     * methods.
     */
    addRoutes(options) {
        var _b;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_AddRoutesOptions(options);
        const methods = (_b = options.methods) !== null && _b !== void 0 ? _b : [route_1.HttpMethod.ANY];
        return methods.map((method) => {
            var _b, _c;
            const authorizationScopes = (_b = options.authorizationScopes) !== null && _b !== void 0 ? _b : this.defaultAuthorizationScopes;
            return new route_1.HttpRoute(this, `${method}${options.path}`, {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.with(options.path, method),
                integration: options.integration,
                authorizer: (_c = options.authorizer) !== null && _c !== void 0 ? _c : this.defaultAuthorizer,
                authorizationScopes,
            });
        });
    }
}
exports.HttpApi = HttpApi;
_a = JSII_RTTI_SYMBOL_1;
HttpApi[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpApi", version: "2.13.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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