# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['gino', 'gino.dialects', 'gino.ext']

package_data = \
{'': ['*']}

install_requires = \
['SQLAlchemy>=1.2,<2.0', 'asyncpg>=0.18,<1.0']

extras_require = \
{':python_version < "3.7"': ['contextvars>=2.4,<3.0'],
 ':python_version < "3.8"': ['importlib_metadata>=1.3.0,<2.0.0'],
 'starlette:python_version >= "3.6" and python_version < "4.0"': ['gino-starlette>=0.1.1,<0.2.0']}

entry_points = \
{'sqlalchemy.dialects': ['asyncpg = gino.dialects.asyncpg:AsyncpgDialect',
                         'postgresql.asyncpg = '
                         'gino.dialects.asyncpg:AsyncpgDialect']}

setup_kwargs = {
    'name': 'gino',
    'version': '1.0.0rc3',
    'description': 'GINO Is Not ORM - a Python asyncio ORM on SQLAlchemy core.',
    'long_description': '====\nGINO\n====\n\n.. image:: https://img.shields.io/pypi/v/gino?logo=python&logoColor=white\n        :alt: PyPI Release Version\n        :target: https://pypi.python.org/pypi/gino\n\n.. image:: https://img.shields.io/github/workflow/status/python-gino/gino/test?label=test&logo=github\n        :alt: GitHub Workflow Status for tests\n        :target: https://github.com/python-gino/gino/actions?query=workflow%3Atest\n\n.. image:: https://img.shields.io/github/workflow/status/python-gino/gino/docs?label=docs&logo=github\n        :alt: GitHub Workflow Status for docs\n        :target: https://python-gino.org/docs/\n\n.. image:: https://img.shields.io/codacy/coverage/b6a59cdf5ca64eab9104928d4f9bbb97?logo=codacy\n        :alt: Codacy coverage\n        :target: https://app.codacy.com/gh/python-gino/gino/dashboard\n\n.. image:: https://img.shields.io/badge/Dependabot-active-brightgreen?logo=dependabot\n        :target: https://app.dependabot.com/accounts/python-gino/projects/129260\n        :alt: Dependabot\n\n.. image:: https://img.shields.io/gitter/room/python-gino/Lobby?logo=gitter\n        :target: https://gitter.im/python-gino/Lobby\n        :alt: Gitter chat\n\n\nGINO - GINO Is Not ORM - is a lightweight asynchronous ORM built on top of\nSQLAlchemy_ core for Python asyncio_. Now (early 2020) GINO supports only one\ndialect asyncpg_.\n\n* Free software: BSD license\n* Requires: Python 3.5\n\n\nDocumentation\n-------------\n\n* English_\n* Chinese_\n\n\nFeatures\n--------\n\n* Robust SQLAlchemy-asyncpg bi-translator with no hard hack\n* Asynchronous SQLAlchemy-alike engine and connection\n* Asynchronous dialect API\n* Asynchronous-friendly CRUD objective models\n* Well-considered contextual connection and transaction management\n* Reusing native SQLAlchemy core to build queries with grammar sugars\n* Support Sanic_, Tornado_, aiohttp_ and Quart_\n* Rich PostgreSQL JSONB support\n\n\nInstallation\n------------\n\n.. code-block:: console\n\n    pip install gino\n\n\nShowcase\n--------\n\n.. code-block:: python\n\n   import asyncio\n   from gino import Gino\n\n   db = Gino()\n\n\n   class User(db.Model):\n       __tablename__ = \'users\'\n\n       id = db.Column(db.Integer(), primary_key=True)\n       nickname = db.Column(db.Unicode(), default=\'noname\')\n\n\n   async def main():\n       await db.set_bind(\'postgresql://localhost/gino\')\n\n       # Create tables\n       await db.gino.create_all()\n\n       # Create object, `id` is assigned by database\n       u1 = await User.create(nickname=\'fantix\')\n       print(u1.id, u1.nickname)  # 1 fantix\n\n       # Returns all user objects with "d" in their nicknames\n       users = await User.query.where(User.nickname.contains(\'d\')).gino.all()\n       print(users)  # [<User object>, <User object>]\n\n       # Find one user object, None if not found\n       user = await User.query.where(User.nickname == \'daisy\').gino.first()\n       print(user)  # <User object> or None\n\n       # Execute complex statement and return command status\n       status, result = await User.update.values(\n           nickname=\'No.\' + db.cast(User.id, db.Unicode),\n       ).where(\n           User.id > 10,\n       ).gino.status()\n       print(status)  # UPDATE 8\n\n       # Iterate over the results of a large query in a transaction as required\n       async with db.transaction():\n           async for u in User.query.order_by(User.id).gino.iterate():\n               print(u.id, u.nickname)\n\n\n   asyncio.get_event_loop().run_until_complete(main())\n\n\nAbout The Name\n--------------\n\nAbout the name GINO Is Not ORM - because I don\'t really like ORM (smile). GINO\ndoes perform the Object-Relational Mapping work under the\n`Data Mapper Pattern`_, but it is just not a traditional ORM. The Objects in\nGINO are completely stateless from database - they are pure plain Python\nobjects in memory. Changing their attribute values does not make them "dirty" -\nor in a different way of thinking they are always "dirty". Any access to\ndatabase must be explicitly executed. Using GINO is more like making up SQL\nclauses with Models and Objects, executing them to make changes in database, or\nloading data from database and wrapping the results with Objects again. Objects\nare just row data containers, you are still dealing with SQL which is\nrepresented by Models and SQLAlchemy core grammars. Besides if you don\'t like\nORM at all, you can use GINO without ORM:\n\n.. code-block:: python\n\n    from gino import Gino\n\n    db = Gino()\n\n    user = db.Table(\n        \'users\', db,\n        db.Column(\'id\', db.BigInteger(), primary_key=True),\n        db.Column(\'nickname\', db.Unicode()),\n    )\n\n    async def main():\n        async with db.with_bind(\'postgresql://localhost/gino\'):\n            users = await db.select([user]).gino.all()\n            print(users)\n\n\n    import asyncio\n\n    asyncio.get_event_loop().run_until_complete(main())\n\n\nContribute\n----------\n\nThere are a few tasks in GitHub issues marked as ``help wanted``. Please feel\nfree to take any of them and pull requests are greatly welcome.\n\nTo run tests:\n\n.. code-block:: console\n\n   $ make install test\n\nFor the tests to be run, a database has to be available (please read more in CONTRIBUTING.rst)\n\nMeanwhile, these are also very much appreciated:\n\n* Just use it, tap the star and spread the love :)\n* Tell me about your story: gino@decentfox.com\n* Report_ a bug/issue, or request for new features\n* `Hire me`_ or `hire us`_ for your work (coding, consulting, troubleshooting)\n* `Become a patron`_\n\n\nProjects using GINO\n-------------------\n\n* AintQ_ - asyncio task queue on PostgreSQL\n* ExchangeratesAPI_ - Foreign exchange rates API with currency conversion\n\n\nCredits\n-------\n\nCredit goes to all contributors listed or not listed in the AUTHORS file. This\nproject is inspired by asyncpgsa_, peewee-async_ and asyncorm_. asyncpg_ and\nSQLAlchemy_ as the dependencies did most of the heavy lifting. This package was\ncreated with Cookiecutter_ and the `audreyr/cookiecutter-pypackage`_ project\ntemplate.\n\nSpecial thanks to my wife Daisy and her outsourcing company `DecentFoX Studio`_,\nfor offering me the opportunity to build this project. We are open for global\nsoftware project outsourcing on Python, iOS and Android development. And we are\nhiring_!\n\nGINO is developed proudly with |PyCharm|.\n\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _`audreyr/cookiecutter-pypackage`: https://github.com/audreyr/cookiecutter-pypackage\n.. _SQLAlchemy: https://www.sqlalchemy.org/\n.. _asyncpg: https://github.com/MagicStack/asyncpg\n.. _PostgreSQL: https://www.postgresql.org/\n.. _asyncio: https://docs.python.org/3/library/asyncio.html\n.. _Alembic: https://bitbucket.org/zzzeek/alembic\n.. _Sanic: https://github.com/channelcat/sanic\n.. _asyncpgsa: https://github.com/CanopyTax/asyncpgsa\n.. _peewee-async: https://github.com/05bit/peewee-async\n.. _asyncorm: https://github.com/monobot/asyncorm\n.. _Tornado: http://www.tornadoweb.org/\n.. _Quart: https://gitlab.com/pgjones/quart/\n.. _English: https://python-gino.org/docs/en/\n.. _Chinese: https://python-gino.org/docs/zh/\n.. _DecentFoX Studio: https://decentfox.com/\n.. _`Data Mapper Pattern`: https://en.wikipedia.org/wiki/Data_mapper_pattern\n.. _aiohttp: https://github.com/aio-libs/aiohttp\n.. _Report: https://github.com/python-gino/gino/issues\n.. _`Hire me`: https://www.linkedin.com/in/fantix/\n.. _`hire us`: https://decentfox.com/\n.. _`Become a patron`: https://www.patreon.com/fantixking\n.. _hiring: https://www.zhipin.com/gongsi/c6e283cf57f2d9361nF92NS7GA~~.html\n.. _contextvars: https://github.com/MagicStack/contextvars\n.. _replaced: https://github.com/MagicStack/contextvars/issues/2\n.. _`Python 3.7`: https://docs.python.org/3.7/library/contextvars.html\n.. _AintQ: https://github.com/fantix/aintq\n.. _ExchangeratesAPI: https://github.com/madisvain/exchangeratesapi\n.. |PyCharm| image:: ./docs/images/pycharm.svg\n        :height: 20px\n        :target: https://www.jetbrains.com/?from=GINO\n',
    'author': 'Fantix King',
    'author_email': 'fantix.king@gmail.com',
    'maintainer': 'Tony Wang',
    'maintainer_email': 'wwwjfy@gmail.com',
    'url': 'https://python-gino.org',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
