# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/runModels_helperFunctions.ipynb.

# %% auto 0
__all__ = ['tunePredictSave', 'loadDataToContinue', 'getCostsNV', 'foo']

# %% ../nbs/runModels_helperFunctions.ipynb 3
import pandas as pd
import numpy as np

from lightgbm import LGBMRegressor
from sklearn.ensemble import RandomForestRegressor
from sklearn.model_selection import RandomizedSearchCV

from dddex.levelSetKDEx_univariate import LevelSetKDEx, LevelSetKDEx_NN
from dddex.wSAA import RandomForestWSAA, SampleAverageApproximation
from dddex.crossValidation import QuantileCrossValidation, QuantileCrossValidationLSx, groupedTimeSeriesSplit
from dddex.utils import generateFinalOutput

import wandb
import os
import re
import ipdb
import pickle

# %% ../nbs/runModels_helperFunctions.ipynb 5
def tunePredictSave(quantileEstimator,
                    SLTuning,
                    combinedCV,
                    model,
                    estimatorName):
    
    runName = model + "_" + estimatorName
    runName = runName + "_" + "combinedCV" if combinedCV else runName
    runName = runName + "_" + "SLTuning" if SLTuning else runName
    
    config = {'isModellingRun': True,
              'model': model,
              'estimator': estimatorName,
              'weightsByDistance': weightsByDistance,
              'combinedCV': combinedCV,
              'SLTuning': SLTuning,
              'kFolds': kFolds,
              'nIter': nIter}
    
    run = wandb.init(project = project, name = runName, job_type = "modelling", config = config)
    
    #---
    
    if combinedCV:
        
        if estimatorName == 'LGBM':
            paramGridEstimator = paramGridLGBM
        else:
            paramGridEstimator = paramGridRF
            
        LSxCV = QuantileCrossValidationLSx(estimatorLSx = quantileEstimator, 
                                           cvFolds = cvFolds,
                                           parameterGridLSx = binSizeGrid,
                                           parameterGridEstimator = paramGridEstimator,
                                           randomSearchEstimator = True,
                                           nIterEstimator = nIter,
                                           probs = probs,
                                           refitPerProb = SLTuning,
                                           n_jobs = len(cvFolds))
        
        paramsEstimatorForOutput = {}
        
    else:
        
        if model == 'WSAA':
            paramGrid = paramGridRF
            randomSearch = True
            paramsEstimatorForOutput = {}
        else:
            paramGrid = binSizeGrid
            randomSearch = False
            
            if estimatorName == 'LGBM':
                paramsEstimatorForOutput = paramsLGBM
            else:
                paramsEstimatorForOutput = paramsRF
            
        LSxCV = QuantileCrossValidation(estimator = quantileEstimator, 
                                        cvFolds = cvFolds,
                                        parameterGrid = paramGrid,
                                        randomSearch = randomSearch,
                                        nIter = nIter,
                                        probs = probs,
                                        refitPerProb = SLTuning,
                                        n_jobs = len(cvFolds))

    LSxCV.fit(X = XTrain, 
              y = yTrain)
    
    #---
    
    if SLTuning:
        
        resList = list()

        for prob in probs:   

            quantilesDf = LSxCV.bestEstimator_perProb[prob].predict(X = XTest, 
                                                                    probs = prob, 
                                                                    outputAsDf = True, 
                                                                    scalingList = scalingList)

            quantilesDf.columns = ["quantile_" + str(int(prob * 1000))]

            resDf = generateFinalOutput(dataOriginal = data,
                                        dataDecisions = quantilesDf,
                                        targetVariable = 'demand',
                                        mergeOn = None,
                                        variablesToAdd = ['dayIndex', 'date', 'scalingValue'],
                                        scaleBy = 'scalingValue',
                                        includeTraining = False,
                                        longFormat = True,
                                        **paramsEstimatorForOutput,
                                        **LSxCV.bestParams_perProb[prob])

            resList.append(resDf)

        resDf = pd.concat(resList, axis = 0)
    
    else:
        
        quantilesDf = LSxCV.bestEstimator.predict(X = XTest, 
                                                  probs = probs, 
                                                  outputAsDf = True, 
                                                  scalingList = scalingList)

        quantilesDf.columns = colnamesQuantile

        resDf = generateFinalOutput(dataOriginal = data, 
                                    dataDecisions = quantilesDf, 
                                    targetVariable = 'demand', 
                                    mergeOn = None, 
                                    variablesToAdd = ['dayIndex', 'date', 'scalingValue'], 
                                    scaleBy = 'scalingValue', 
                                    includeTraining = False, 
                                    sortBy = ['id', 'dayIndex'],
                                    longFormat = True,
                                    **paramsEstimatorForOutput,
                                    **LSxCV.bestParams)
    
    #---
    
    costsPerID, costsPerSL = getCostsNV(resDf = resDf,
                                        costsPerID_SAA = costsPerID_SAA)
    
    wandb.log(costsPerSL)

    with decisionsArtifact.new_file(runName + ".plk", mode = "wb") as file:
        resDf.to_pickle(file)

    with costsArtifact.new_file(runName + ".plk", mode = "wb") as file:
        costsPerID.to_pickle(file)
    
    wandb.finish()
    
    # return resDf, costsPerID, costsPerSL

# %% ../nbs/runModels_helperFunctions.ipynb 7
def loadDataToContinue():
    
    run = wandb.init(project = project, job_type = "loadData")
    
    #---

    rawArtifact = run.use_artifact('predictorData:latest')
    predictorData = rawArtifact.download()

    pathLGBM = os.path.join(predictorData, "paramsLGBM.plk")

    with open(pathLGBM, 'rb') as file:
        paramsLGBM = pickle.load(file)

    pathLGBM = os.path.join(predictorData, "LGBM.plk")
    with open(pathLGBM, 'rb') as file:
        estimatorLGBM = pickle.load(file)

    pathRF = os.path.join(predictorData, "RF.plk")
    with open(pathRF, 'rb') as file:
        estimatorRF = pickle.load(file)

    #---

    rawArtifact = run.use_artifact('costsSAA:latest')
    costsSAAData = rawArtifact.download()

    pathCostsSAA = os.path.join(costsSAAData, "costsPerID_SAA.plk")
    costsPerID_SAA = pd.read_pickle(pathCostsSAA)
    
    #---
    
    return estimatorLGBM, estimatorRF, costsPerID_SAA

# %% ../nbs/runModels_helperFunctions.ipynb 9
def getCostsNV(resDf,
               costsPerID_SAA = None):
    
    serviceLevels = np.array([int(re.findall('[0-9]+', decisionType)[0]) / 1000 for decisionType in resDf['decisionType']])
    # serviceLevels = resDf['decisionType'] * 10
    
    errors = resDf['actuals'] - resDf['decisions']
    resDf['costs'] = np.where(errors >= 0, errors * serviceLevels, np.abs(errors) * (1 - serviceLevels))

    costsPerID = resDf.groupby(['id', 'decisionType'], sort = False)['costs'].sum()
    
    if not costsPerID_SAA is None:
        costsPerID = costsPerID / costsPerID_SAA
    
    costsPerSL = costsPerID.reset_index().groupby(['decisionType'], sort = False)['costs'].mean()
    costsPerSL = costsPerSL.to_dict()
    
    return costsPerID, costsPerSL

# %% ../nbs/runModels_helperFunctions.ipynb 10
def foo(): pass
