# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src/python'}

packages = \
['serenity_sdk']

package_data = \
{'': ['*']}

install_requires = \
['azure-identity>=1.10.0,<2.0.0',
 'bidict>=0.22.0,<0.23.0',
 'fire>=0.4.0,<0.5.0',
 'pandas>=1.5.0,<2.0.0',
 'pyhumps>=3.7.3,<4.0.0',
 'requests>=2.28.1,<3.0.0']

setup_kwargs = {
    'name': 'serenity.sdk.python',
    'version': '0.8.21',
    'description': 'Python SDK for the Serenity digital asset risk API',
    'long_description': "## Serenity SDK - Python\n\n### Introduction\n\nThe Serenity digital asset risk platform exposes all functionality via an API -- currently REST only.\n\nAlthough it's possible to call the API with simple HTTP client code in most any modern language, there\nare conventions that need to be followed -- especially for authentication and authorization -- and to\nmake it easier we have provided this lightweight SDK.\n\n### Installation\n\nInstallation for Python 3.x users is very simple using pip:\n\n```plain\npip install serenity.sdk.python\n```\n\n### Maintainer setup\n\nIf you are checking in code for ```serenity.sdk.python``` you may wish to run ```setup.sh``` to install\nappropriate pre-commit and pre-push git hooks in your local repo. Once you run setup you will also\nget a Python virtual environment in ```.venv``` generated by Poetry; if using VSCode, you should select\nthis as your IDE's virtual environment.\n\n### Learning more\n\nAt this time the API and its documentation are only available to members of our private beta, via\ntheir personal Serenity Developer Portal, e.g. https://developer.$client.cloudwall.network.",
    'author': 'Cloudwall Support',
    'author_email': 'support@cloudwall.tech',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4',
}


setup(**setup_kwargs)
