# Generated by Django 3.0.3 on 2020-07-10 08:40

import uuid

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import swapper
from django.db import migrations, models

from ..configuration import get_chart_configuration_choices


class Migration(migrations.Migration):

    dependencies = [('monitoring', '0012_rename_graph_chart')]

    operations = [
        migrations.RenameModel(old_name='Chart', new_name='Graph'),
        migrations.RenameModel(old_name='AlertSettings', new_name='Threshold'),
        migrations.CreateModel(
            name='Chart',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'configuration',
                    models.CharField(
                        choices=get_chart_configuration_choices(),
                        max_length=16,
                        null=True,
                    ),
                ),
                (
                    'metric',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name('monitoring', 'Metric'),
                    ),
                ),
            ],
            options={
                'abstract': False,
                'swappable': swapper.swappable_setting('monitoring', 'Chart'),
            },
        ),
        migrations.CreateModel(
            name='AlertSettings',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'operator',
                    models.CharField(
                        choices=[('<', 'less than'), ('>', 'greater than')],
                        max_length=1,
                    ),
                ),
                ('value', models.FloatField(help_text='threshold value')),
                (
                    'seconds',
                    models.PositiveIntegerField(
                        default=0,
                        help_text='for how long should the value be crossed before an alert is '
                        'sent? The maximum allowed is 604800 seconds (7 days)',
                        validators=[django.core.validators.MaxValueValidator(604800)],
                    ),
                ),
                (
                    'metric',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name('monitoring', 'Metric'),
                    ),
                ),
            ],
            options={
                'verbose_name': 'Alert settings',
                'verbose_name_plural': 'Alert settings',
                'abstract': False,
                'swappable': swapper.swappable_setting('monitoring', 'AlertSettings'),
            },
        ),
    ]
