# auto generated by update_py.py

import ctypes

from tlclient.linker.utility import bytify

from .constant import SubscribeTopic


class FrameHeaderStatus(object):
    NORMAL = 0
    HAS_NEXT = 1
    IS_BUFFER = 10


class FrameHeader(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('status', ctypes.c_byte),
        ('msg_type', ctypes.c_short),
        ('length', ctypes.c_size_t),
        ('nano', ctypes.c_int64),
        ('source', ctypes.c_int),
        ('req_id', ctypes.c_int64),
        ('err_id', ctypes.c_int),
        ('topic', ctypes.c_short),
    ]


class MemBufferHeader(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('status', ctypes.c_byte),
        ('frame_num', ctypes.c_int64),
        ('length', ctypes.c_int64),
        ('topic', ctypes.c_short),
    ]


class MemBuffer:

    HEADER_LENGTH = ctypes.sizeof(MemBufferHeader)

    def __init__(self, length=None, buffer=None):
        if buffer is None:
            # init from new
            self._len = self.HEADER_LENGTH + length
            self._buffer = bytearray(self._len)
            self._header = MemBufferHeader()
            self._header.length = 0
            self.init()
        else:
            if not isinstance(buffer, bytearray):
                self._buffer = bytearray(buffer)
            else:
                self._buffer = buffer
            self._tmp_header = bytes(self._buffer[:self.HEADER_LENGTH])
            self._header = ctypes.cast(ctypes.c_char_p(self._tmp_header), ctypes.POINTER(MemBufferHeader)).contents
            self._len = self._header.length

    def init(self):
        self._header.status = FrameHeaderStatus.IS_BUFFER
        self._header.frame_num = 0
        self._header.length = self.cur_frame_idx = self.HEADER_LENGTH
        self._header.topic = SubscribeTopic.UNEXPECTED

    def get_length(self):
        return self._len

    def get_actual_length(self):
        return self._header.length

    def get_frame_num(self):
        return self._header.frame_num

    def get_subscribe_topic(self):
        return self._header.topic

    def set_subscribe_topic(self, topic):
        self._header.topic = topic

    def append(self, start_idx, frame):
        end_idx = start_idx + frame.get_length()
        self._buffer[start_idx: end_idx] = frame.buf[:frame.get_length()]
        self.cur_frame_idx = start_idx
        self._buffer[start_idx] = FrameHeaderStatus.HAS_NEXT
        self._header.frame_num += 1
        self._header.length = end_idx
        return end_idx

    def finalize(self):
        self._buffer[self.cur_frame_idx] = FrameHeaderStatus.NORMAL
        header_buffer = (ctypes.c_char * self.HEADER_LENGTH).from_buffer(self._header)
        self._buffer[:self.HEADER_LENGTH] = header_buffer[:self.HEADER_LENGTH]


class Frame:

    SIZE_OF_HEADER = ctypes.sizeof(FrameHeader)

    def __init__(self, recv_s=None):
        if recv_s is None:
            self.frame = FrameHeader()
            self._data_addr = None
            self.buf_s = None
        else:
            self.parse_str(recv_s)

    def parse_str(self, s: bytes):
        if not isinstance(s, bytes):
            self.buf_s = bytes(s)
        else:
            self.buf_s = s
        self.frame = ctypes.cast(ctypes.c_char_p(self.buf_s), ctypes.POINTER(FrameHeader)).contents
        self._data_addr = ctypes.addressof(self.frame) + self.SIZE_OF_HEADER

    # getters
    def get_status(self):
        return self.frame.status

    def get_length(self):
        return self.frame.length

    def get_msg_type(self):
        return self.frame.msg_type

    def get_nano(self):
        return self.frame.nano

    def get_source(self):
        return self.frame.source

    def size(self):
        return self.get_length()

    def get_req_id(self):
        return self.frame.req_id

    def get_err_id(self):
        return self.frame.err_id

    def get_subscribe_topic(self):
        return self.frame.topic

    # setters
    def set_status(self, s):
        self.frame.status = s

    def set_length(self, l):
        self.frame.length = l

    def set_data_length(self, dl):
        self.frame.length = dl + self.get_header_length()

    def set_msg_type(self, m):
        self.frame.msg_type = m

    def set_nano(self, n):
        self.frame.nano = n

    def set_source(self, s):
        self.frame.source = s

    def set_req_id(self, rid):
        self.frame.req_id = rid

    def set_err_id(self, eid):
        self.frame.err_id = eid

    def set_subscribe_topic(self, topic):
        self.frame.topic = topic

    # get data
    def get_header_length(self):
        return self.SIZE_OF_HEADER

    def get_data_length(self):
        return self.get_length() - self.get_header_length()

    def get_data_ptr(self):
        return self._data_addr

    def get_frame_ptr(self):
        return ctypes.addressof(self.frame)

    # set data
    def set_data(self, ctype_obj, length=None):
        if isinstance(ctype_obj, str):
            self.set_string(ctype_obj)
            return
        length = None or ctypes.sizeof(ctype_obj)
        self.set_data_length(length)
        self.buf = bytearray(self.frame)
        self.buf.extend((ctypes.c_char * length).from_buffer(ctype_obj))
        self.parse_str(self.buf)

    # complex
    def get_string(self):
        if self._data_addr == None:
            return None
        # return ctypes.cast(self._data_addr, ctypes.c_char_p).value
        return self.buf_s[self.SIZE_OF_HEADER:self.frame.length]

    def get_int64(self):
        if self._data_addr == None:
            return None
        return ctypes.cast(self._data_addr, ctypes.POINTER(ctypes.c_int64)).value

    def set_string(self, s):
        self.set_data_length(len(s))
        self.buf = bytearray(self.frame)
        self.buf.extend(bytify(s))
        self.parse_str(self.buf)

    def get_obj(self, CAST_TYPE):
        return ctypes.cast(self.get_data_ptr(), ctypes.POINTER(CAST_TYPE)).contents
